﻿(function(window,dom){
var vodScreen,
mystream=window.MYSTREAM=window.MYSTREAM||{},
domFocus=dom.FOCUS,
scrollList,
timeoutId=null;
vodScreen={
SCREEN_STATE:{
CLOSED:0,
OPENING:1,
OPENED:2,
CLOSING:3,
PRVZERO:4
},
FIX_TEXTS:null,
screenState:0,
focus:null,
focusIndex:0,
prvListNum:0,
closeCallback:null,
contents:null,
detail:null,
element:{
mainScreen:null,
pvrListArea:null,
detailArea:null,
focusElement:null,
scrollBox:null,
thumnail:null,
release:null,
loading:null
},
init:function(callback){
this.closeCallback=callback;
this.FIX_TEXTS={
RELEASE:LANG('LT_RELEASE'),
DURATION:LANG('LT_DURATION'),
WATCH:LANG('LT_WATCH')
};
return this;},
thumnailEvent:function(content,event){
if(event.type==='error'){
DEBUG.console(DEBUG.LVL.VERBOSE,'thmnail load error');
event.target.onerror=null;
event.target.src=content.getDefaultImagePath();}else {
DEBUG.console(DEBUG.LVL.VERBOSE,'thmnail loaded');
event.target.onload=null;
event.target.onerror=null;
event.target.parentNode.classList.add('enable');
if(event.target.naturalWidth>event.target.naturalHeight){
event.target.classList.add('ImgSizeChange');}
}
},
logoEvent:function(name,event){
if(event.type==='error'){
DEBUG.console(DEBUG.LVL.VERBOSE,'logo load error');
event.target.onerror=null;
event.target.onload=null;
var parent=event.target.parentNode;
parent.removeChild(event.target);
var eleLogo=dom.createElement('div',{className:'vodPrvLogo'});
eleLogo.textContent=name||'';
eleLogo.classList.add('enable');
parent.classList.add('vodString');
parent.appendChild(eleLogo);}else {
DEBUG.console(DEBUG.LVL.VERBOSE,'logo loaded');
var parent=event.target.parentNode;
event.target.onload=null;
event.target.onerror=null;
parent.classList.add('logoImg');
event.target.classList.add('enable');}
},
makePrvList:function(List){
DEBUG.console(DEBUG.LVL.VERBOSE,'makePrvList');
DEBUG.console(DEBUG.LVL.VERBOSE,JSON.stringify(List));
var that=this,elePvrListArea,listNum=0,i=0,eleFocus,focusElementList=[];
elePvrListArea=dom.createElement('div',{id:'vodPrvListArea'});
listNum=List.providers.length;
if(listNum>3){
listNum=3;}
if(listNum===1){
elePvrListArea.classList.add('vodList0');}else if(listNum===2){
elePvrListArea.classList.add('vodList1');}else {
elePvrListArea.classList.add('vodList2');}
for(i=0;i<listNum;i++){
var eleList=dom.createElement('div',{className:'vodPrvList'});
var eleLogoArea=dom.createElement('div',{className:'vodPrvLogoArea'});
var eleLogoWrap=dom.createElement('div',{className:'vodPrvLogoWrap'});
var eleButtonArea=dom.createElement('div',{className:'vodButtonArea'});
var eleButtonWrap=dom.createElement('div',{className:'vodButtonWrap'});
var eleButtonLabel=dom.createElement('div',{className:'vodButtonLabel'});
if(List.providers[i].providerLogo){
var eleLogo=dom.createElement('img',{className:'vodPrvLogo'});
eleLogo.src=List.providers[i].providerLogo;
eleLogo.onload=that.logoEvent.bind(null,List.providers[i].providerName);
eleLogo.onerror=that.logoEvent.bind(null,List.providers[i].providerName);}else {
var eleLogo=dom.createElement('div',{className:'vodPrvLogo'});
eleLogo.textContent=List.providers[i].providerName||'';
eleLogo.classList.add('enable');
eleLogoWrap.classList.add('vodString');}
eleButtonLabel.textContent=that.FIX_TEXTS.WATCH;
eleLogoWrap.appendChild(eleLogo);
eleLogoArea.appendChild(eleLogoWrap);
eleButtonWrap.appendChild(eleButtonLabel);
eleButtonArea.appendChild(eleButtonWrap);
eleList.appendChild(eleLogoArea);
eleList.appendChild(eleButtonArea);
elePvrListArea.appendChild(eleList);
if(i!==0){
eleButtonWrap.classList.add('vodDisable');}
focusElementList.push(eleButtonWrap);}
if(listNum!==0){
that.element.pvrListArea.appendChild(elePvrListArea);
that.prvListNum=listNum;
that.element.focusElement=focusElementList;
eleFocus=dom.createElement('div',{id:'vodFocus',className:'cmn_focus'});
eleFocus.style.zIndex='5';
that.element.mainScreen.appendChild(eleFocus);
that.focus=new domFocus.Focus(eleFocus);
setTimeout(function(){
if(that.screenState===that.SCREEN_STATE.OPENING){
that.focus.set(focusElementList[0]);
that.screenState=that.SCREEN_STATE.OPENED;}
},300);}else {
that.screenState=that.SCREEN_STATE.PRVZERO;}
if(that.element.loading){
that.element.loading.parentNode.removeChild(that.element.loading);
that.element.loading=null;}
if(that.forceCloseCallback){
that.close();
return;}
},
makeDetail:function(detail){
DEBUG.console(DEBUG.LVL.VERBOSE,'makeDetail');
var that=this,scrollBox,eleDetailArea;
clearTimeout(timeoutId);
timeoutId=null;
that.detail=detail;
that.scrollBox=new mystream.ScrollBox();
eleDetailArea=that.scrollBox.createElement('vodSynopsis');
that.element.detailArea.appendChild(eleDetailArea);
if(detail){
that.scrollBox.setText(detail.detail||'').setMoveValue().update();}else {
that.scrollBox.setText('').setMoveValue().update();
that.screenState=vodScreen.SCREEN_STATE.PRVZERO;
if(that.element.loading){
that.element.loading.parentNode.removeChild(that.element.loading);
that.element.loading=null;}
return;}
that.makePrvList(detail);},
open:function(content){
DEBUG.console(DEBUG.LVL.VERBOSE,'open setting menu');
DEBUG.console(DEBUG.LVL.VERBOSE,JSON.stringify(content));
var that=this,eleScreen,eleLeftFrame,eleRightFrame,eleImgArea,eleImgWrap,eleImg,eleSelectAreaWrap,
eleLeftBlankArea,eleRightBlankArea,eleDetailWrap,eleDetail,eleDetailTop,eleDetailMid,eleDetailButtom,
eleTitle,eleSmallStringArea,eleColOneArea,eleRelease,eleColTwoArea,eleDuration,
eleReleaseWrap,eleDetailWrap,release,calcDuration,eleVodCirtain,eleCircle,
eleLabelRelease,eleLabelDuration,eleSpritRelease,eleSpritDuration;
that.screenState=that.SCREEN_STATE.OPENING;
eleScreen=dom.createElement('div',{id:'vodScreen'});
eleLeftFrame=dom.createElement('div',{id:'vodLeftFrame'});
eleRightFrame=dom.createElement('div',{id:'vodRightFrame'});
eleVodCirtain=dom.createElement('div',{id:'vodCurtain'});
eleCircle=mystream.createLoadingIcon('vodCircle');
eleLeftBlankArea=dom.createElement('div',{id:'vodLeftBlankArea',className:'vodBlankArea'});
eleRightBlankArea=dom.createElement('div',{id:'vodRightBlankArea',className:'vodBlankArea'});
eleImgArea=dom.createElement('div',{id:'vodImgArea'});
eleImgWrap=dom.createElement('div',{id:'vodImgWrap'});
eleImg=dom.createElement('img',{id:'vodImg'});
if(content.attr.thumnail1){
eleImg.src=content.attr.thumnail1;}else {
eleImg.src=content.getDefaultImagePath();}
that.element.thumnail=eleImg;
eleImg.onload=that.thumnailEvent.bind(null,content);
eleImg.onerror=that.thumnailEvent.bind(null,content);
eleSelectAreaWrap=dom.createElement('div',{id:'vodSelectAreaWrap'});
eleDetailWrap=dom.createElement('div',{id:'vodDetailWrap'});
eleDetail=dom.createElement('div',{id:'vodDetailArea'});
eleDetailTop=dom.createElement('div',{id:'vodDetailTop'});
eleDetailMid=dom.createElement('div',{id:'vodDetailMid'});
eleDetailButtom=dom.createElement('div',{id:'vodDetailButtom'});
eleTitle=dom.createElement('div',{id:'vodTitle'});
eleSmallStringArea=dom.createElement('div',{id:'vodSmallStringArea'});
eleReleaseWrap=dom.createElement('div',{id:'vodReleaseWrap'});
eleDurationWrap=dom.createElement('div',{id:'vodDurationWrap'});
eleColOneArea=dom.createElement('div',{id:'vodColOneArea'});
eleRelease=dom.createElement('div',{id:'vodRelease'});
eleColTwoArea=dom.createElement('div',{id:'vodColTwoArea'});
eleDuration=dom.createElement('div',{id:'vodDuration'});
eleLabelRelease=dom.createElement('div',{id:'vodLabelRelease'});
eleLabelDuration=dom.createElement('div',{id:'vodLabelDuration'});
eleSpritRelease=dom.createElement('div',{id:'vodSpritRelease'});
eleSpritDuration=dom.createElement('div',{id:'vodSpritDuration'});
eleTitle.textContent=content.attr.title||'';
eleLabelRelease.textContent=that.FIX_TEXTS.RELEASE;
eleLabelDuration.textContent=that.FIX_TEXTS.DURATION;
eleSpritRelease.textContent=':';
eleSpritDuration.textContent=':';
if(content.attr.duration){
calcDuration=mystream.formatSeconds(content.attr.duration,'hh:mm:ss');
eleDuration.textContent=calcDuration;}else {
eleColTwoArea.classList.add('durationDisable');}
eleReleaseWrap.appendChild(eleLabelRelease);
eleReleaseWrap.appendChild(eleSpritRelease);
eleReleaseWrap.appendChild(eleRelease);
eleDurationWrap.appendChild(eleLabelDuration);
eleDurationWrap.appendChild(eleSpritDuration);
eleDurationWrap.appendChild(eleDuration);
eleColOneArea.appendChild(eleReleaseWrap);
eleColTwoArea.appendChild(eleDurationWrap);
eleSmallStringArea.appendChild(eleColOneArea);
eleSmallStringArea.appendChild(eleColTwoArea);
eleDetailTop.appendChild(eleTitle);
eleDetailTop.appendChild(eleSmallStringArea);
eleImgWrap.appendChild(eleImg);
eleImgArea.appendChild(eleImgWrap);
eleLeftFrame.appendChild(eleLeftBlankArea);
eleLeftFrame.appendChild(eleImgArea);
eleLeftFrame.appendChild(eleSelectAreaWrap);
eleRightFrame.appendChild(eleRightBlankArea);
eleDetail.appendChild(eleDetailTop);
eleDetail.appendChild(eleDetailMid);
eleDetail.appendChild(eleDetailButtom);
eleDetailWrap.appendChild(eleDetail);
eleRightFrame.appendChild(eleDetailWrap);
eleScreen.appendChild(eleLeftFrame);
eleScreen.appendChild(eleRightFrame);
eleVodCirtain.appendChild(eleCircle);
eleScreen.appendChild(eleVodCirtain);
if(content.attr.time){
release=mystream.formatDateOfMedia(new Date(content.attr.time*1000),true);
eleRelease.textContent=release;}else {
eleColOneArea.classList.add('releaseDisable');
eleColTwoArea.classList.add('releaseDisable');}
that.contents=content;
that.element.mainScreen=eleScreen;
that.element.pvrListArea=eleDetailMid;
that.element.detailArea=eleDetailButtom;
that.element.release=eleRelease;
that.element.loading=eleVodCirtain;
document.body.appendChild(eleScreen);
timeoutId=setTimeout(function(){
clearTimeout(timeoutId);
timeoutId=null;
if(that.element.loading){
that.element.loading.parentNode.removeChild(that.element.loading);
that.element.loading=null;}
},60000);
return this;},
close:function(){
DEBUG.console(DEBUG.LVL.INFO,'vodScreen.close');
var that=this,eleScreen;
if(that.screenState!==that.SCREEN_STATE.OPENED&&
that.screenState!==that.SCREEN_STATE.OPENING&&
that.screenState!==that.SCREEN_STATE.PRVZERO
){
return;}
that.screenState=that.SCREEN_STATE.CLOSING;
if(that.focus){
that.focus.destroy();}
that.focus=null;
if(that.scrollBox){
that.scrollBox.destroy();}
if(that.element.loading){
that.element.loading.parentNode.removeChild(that.element.loading);
that.element.loading=null;}
that.scrollBox=null;
that.detail=null;
that.element.mainScreen.parentNode.removeChild(that.element.mainScreen);
that.element.mainScreen=null;
that.element.pvrListArea=null;
that.element.detailArea=null;
that.element.focusElement=null;
that.element.scrollBox=null;
that.element.release=null;
that.focusIndex=0;
that.prvListNum=0;
that.contents=null;
if(timeoutId){
clearTimeout(timeoutId);}
timeoutId=null;
that.screenState=that.SCREEN_STATE.CLOSED;
that.closeCallback();},
keyDownHandler:function(event){
var that=this,i=0;
switch(this.screenState){
case this.SCREEN_STATE.OPENED:
if(event.keyCode===KeyEvent.DOM_VK_LEFT){
if(that.prvListNum===1){
return;}else {
if(that.focusIndex===0){
that.focusIndex=that.prvListNum-1;
that.focus.move(that.element.focusElement[that.focusIndex]);
for(i=0;i<that.prvListNum;i++){
if(i===that.focusIndex){
that.element.focusElement[i].classList.remove('vodDisable');}else {
that.element.focusElement[i].classList.add('vodDisable');}
}
}else {
that.focusIndex-=1;
that.focus.move(that.element.focusElement[that.focusIndex]);
for(i=0;i<that.prvListNum;i++){
if(i===that.focusIndex){
that.element.focusElement[i].classList.remove('vodDisable');}else {
that.element.focusElement[i].classList.add('vodDisable');}
}
}
}
}else if(event.keyCode===KeyEvent.DOM_VK_RIGHT){
if(that.prvListNum===1){
return;}else {
if(that.focusIndex===that.prvListNum-1){
that.focusIndex=0;
that.focus.move(that.element.focusElement[that.focusIndex]);
for(i=0;i<that.prvListNum;i++){
if(i===that.focusIndex){
that.element.focusElement[i].classList.remove('vodDisable');}else {
that.element.focusElement[i].classList.add('vodDisable');}
}
}else {
that.focusIndex+=1;
that.focus.move(that.element.focusElement[that.focusIndex]);
for(i=0;i<that.prvListNum;i++){
if(i===that.focusIndex){
that.element.focusElement[i].classList.remove('vodDisable');}else {
that.element.focusElement[i].classList.add('vodDisable');}
}
}
}
}else if(event.keyCode==KeyEvent.DOM_VK_BACK_SPACE){
that.close();}else if(event.keyCode==KeyEvent.DOM_VK_UP){
that.scrollBox.scrollUp();}else if(event.keyCode==KeyEvent.DOM_VK_DOWN){
that.scrollBox.scrollDown();}else if(event.keyCode==KeyEvent.DOM_VK_RETURN){
that.launchVod();}
break;
case that.SCREEN_STATE.OPENING:
case that.SCREEN_STATE.PRVZERO:
if(event.keyCode==KeyEvent.DOM_VK_BACK_SPACE){
that.close();}
break;
default:
}
},
launchVod:function(){
DEBUG.console(DEBUG.LVL.INFO,'LaunchVod '+
'title: '+this.detail.title+
' providerName: '+this.detail.providers[this.focusIndex].providerName+
' providerId: '+this.detail.providers[this.focusIndex].providerId+
' productId: '+this.detail.providers[this.focusIndex].productId+
' appUrl: '+this.detail.providers[this.focusIndex].appUrl);
var data=this.contents;
data.providerId=this.detail.providers[this.focusIndex].providerId;
data.appUrl=this.detail.providers[this.focusIndex].appUrl;
data.productId=this.detail.providers[this.focusIndex].productId;
mystream.app_launcher.launch_application(data);}
};
mystream.VOD_SCREEN=vodScreen;}(window,DOMUTIL));
