(function(window,dom){
var ScrollList,
mystream=window.MYSTREAM=window.MYSTREAM||{},
domFocus=dom.FOCUS;
ScrollList=function(callback){
this.eles=null;
this.currentState=this.STATE.NONE;
this.viewListIndex=0;
this.selectIndex=0;
this.lastSelectIndex=-1;
this.list=null;
this.listCount=0;
this.callback=callback;
this.focus=null;
this.transEndHandler=null;
this.attr={id:'id',name:'name'};};
ScrollList.prototype.MAX_SIZE=4;
ScrollList.prototype.STATE=ScrollList.STATE={
NONE:0,
WAITING:1,
READY:2,
SCROLLING:3
};
ScrollList.prototype.create=function(id,head,parent,focus,attr){
var options,eleScreen,eleBox,eleHead,eleList,eleArrowUp,
eleArrowDown,eleLoadingIcon;
if(attr){
this.attr.id=attr.id;
this.attr.name=attr.name;}
if(!parent){
parent=document.body;}
options={className:'scrollListScreen'};
if(id){
options.id=id;}
eleScreen=dom.createElement('div',options);
eleBox=dom.createElement('div',{className:'scrollListBox'});
eleHead=dom.createElement('p',{className:'scrollListHead'});
eleArrowUp=dom.createElement('div',{className:'scrollListArrow up'});
eleArrowDown=dom.createElement('div',{className:'scrollListArrow down'});
eleList=dom.createElement('div',{className:'scrollListList'});
eleHead.textContent=head||'';
eleBox.appendChild(eleHead);
eleBox.appendChild(eleArrowUp);
eleBox.appendChild(eleList);
eleBox.appendChild(eleArrowDown);
eleScreen.appendChild(eleBox);
eleLoadingIcon=mystream.createLoadingIcon('scrollListLoading');
eleScreen.appendChild(eleLoadingIcon);
parent.appendChild(eleScreen);
this.focus=focus;
this.currentState=this.STATE.WAITING;
this.eles={
screen:eleScreen,
list:eleList,
arrowUp:eleArrowUp,
arrowDown:eleArrowDown
};
return this;};
ScrollList.prototype.createList=function(list,selectedId){
DEBUG.console(DEBUG.LVL.INFO,'createList');
var that=this,i,max,listIndex=0,focusIndex=0,
eleTemplate,eleValue,df=document.createDocumentFragment(),
eleScrollList=this.eles.list,eleLoadingIcon,
attrId=this.attr.id,attrName=this.attr.name;
eleTemplate=dom.createElement('p',{className:'scrollListValue'});
eleScrollList.innerHTML='';
this.list=list;
this.listCount=list.length;
if(selectedId!==undefined&&
typeof selectedId==='number'&&selectedId>=0){
for(i=0;i<this.listCount;i+=1){
if(this.list[i][attrId]===selectedId){
this.lastSelectIndex=i;
this.selectIndex=i;
break;}
}
}
if(this.list.length<=this.MAX_SIZE){
this.viewListIndex=0;}else if(this.list.length>this.MAX_SIZE&&
this.selectIndex>this.listCount-this.MAX_SIZE){
this.viewListIndex=this.listCount-this.MAX_SIZE;}else {
this.viewListIndex=this.selectIndex;}
listIndex=this.viewListIndex;
for(i=0;i<this.MAX_SIZE+2;i+=1){
eleValue=eleTemplate.cloneNode(false);
eleValue.id='scrollListValue'+i;
if(listIndex>0&&this.list[listIndex-1]){
eleValue.textContent=this.list[listIndex-1][attrName];
if(listIndex-1===this.lastSelectIndex){
eleValue.classList.add('select');}
}
df.appendChild(eleValue);
listIndex+=1;}
eleScrollList.appendChild(df);
this.transEndHandler=function(event){
dom.stopEvent(event);
if(that.currentState===that.STATE.SCROLLING){
that.currentState=that.STATE.READY;}
};
eleScrollList.addEventListener(dom.eventName.transitionend,this.transEndHandler,false);
this.setArrowStyle();
focusIndex=this.selectIndex-this.viewListIndex;
this.focus.set(eleScrollList.children[focusIndex+1]);
if(this.STATE.WAITING){
eleLoadingIcon=document.getElementById('scrollListLoading');
if(eleLoadingIcon){
eleLoadingIcon.parentNode.removeChild(eleLoadingIcon);}
}
this.currentState=this.STATE.READY;
return this;};
ScrollList.prototype.setArrowStyle=function(){
var eleArrowUp,eleArrowDown;
if(!this.eles){
return this;}
eleArrowUp=this.eles.arrowUp;
eleArrowDown=this.eles.arrowDown;
if(this.viewListIndex>0){
eleArrowUp.classList.add('active');}else {
eleArrowUp.classList.remove('active');}
if(this.viewListIndex+this.MAX_SIZE<this.listCount){
eleArrowDown.classList.add('active');}else {
eleArrowDown.classList.remove('active');}
return this;};
ScrollList.prototype.moveFocus=function(direction){
var info,eleValue,eleScrollList,focusIndex,
attrName=this.attr.name;
if(this.currentState!=this.STATE.READY||
this.focus.currentState===domFocus.STATE.OFF){
return this;}
focusIndex=this.selectIndex-this.viewListIndex;
if(direction>0){if(this.selectIndex>=this.listCount-1){
return this;}
this.selectIndex+=1;
if(focusIndex<this.MAX_SIZE-1){
focusIndex=this.selectIndex-this.viewListIndex;
this.focus.move(this.eles.list.children[focusIndex+1]);}else {
this.currentState=this.STATE.SCROLLING;
this.viewListIndex+=1;
eleValue=this.eles.list.firstChild;
info=this.list[this.selectIndex+1];
eleValue.textContent=(info)?info[attrName]:'';
if(this.selectIndex+1===this.lastSelectIndex){
eleValue.classList.add('select');}else {
eleValue.classList.remove('select');}
this.eles.list.appendChild(eleValue);}
}else {if(this.selectIndex===0){
return this;}
this.selectIndex-=1;
if(focusIndex>0){
focusIndex=this.selectIndex-this.viewListIndex;
this.focus.move(this.eles.list.children[focusIndex+1]);}else {
this.currentState=this.STATE.SCROLLING;
this.viewListIndex-=1;
eleValue=this.eles.list.lastChild;
info=this.list[this.selectIndex-1];
eleValue.textContent=(info)?info[attrName]:'';
if(this.selectIndex-1===this.lastSelectIndex){
eleValue.classList.add('select');}else {
eleValue.classList.remove('select');}
this.eles.list.insertBefore(eleValue,this.eles.list.firstChild);}
}
this.setArrowStyle();
return this;};
ScrollList.prototype.destroy=function(){
var eleScreen;
if(this.currentState===this.STATE.NONE){
return this;}
eleScreen=document.getElementById(this.id);
this.eles.list.removeEventListener(dom.eventName.transitionend,
this.transEndHandler,false);
this.eles.list=null;
this.eles.arrowUp=null;
this.eles.arrowDown=null;
this.eles.screen.parentNode.removeChild(this.eles.screen);
this.eles.screen=null;
this.eles=null;
this.list=null;
this.listCount=0;
this.selectIndex=0;
this.lastSelectIndex=-1;
this.currentState=this.STATE.NONE;
this.callback=null;
if(this.focus){
this.focus.off();}
this.focus=null;
this.attr={id:'id',name:'name'};
return this;};
ScrollList.prototype.keyDownHandler=function(event){
var info=null;
switch(event.keyCode){
case KeyEvent.DOM_VK_UP:
case KeyEvent.DOM_VK_DOWN:
this.moveFocus((event.keyCode===KeyEvent.DOM_VK_UP)?-1:1);
break;
case KeyEvent.DOM_VK_RETURN:
if(this.currentState===this.STATE.READY){
if(this.callback){
if(this.list&&this.list[this.selectIndex]){
info=this.list[this.selectIndex];}
this.callback('select',info);}
}
break;
case KeyEvent.DOM_VK_LEFT:
case KeyEvent.DOM_VK_BACK_SPACE:
if(this.currentState===this.STATE.READY||
this.currentState===this.STATE.WAITING){
if(this.callback){
this.callback('close',null);}
}
break;
default:
}
};
mystream.SCROLL_LIST=ScrollList;}(window,DOMUTIL));
