(function(window){
var mystream=window.MYSTREAM=window.MYSTREAM||{},
contentManager,
getIconFilePath,
getDefaultImagePath,
checkTvService,
ws_contents_req,
ws_pending_req=null,
ws_pending_msg=null,ws_is_connected=0,
REQUEST_TYPE={
RECOMMEND:'Recommend',
POPULAR:'Popular',
FAVORITE:'Favorite',
SEARCH:'Search',
INFO:'Info',
SERVICE_PROVIDER:'ServiceProvider',
SETTINGS:'Settings',
DETAIL:'Detail'
},
ERR_CODE={
ETHER_ERR:1,
TIMEOUT:2,
OTHER:3
},
CONTENT={
TV:1,
PICTURE:2,
VIDEO:3,
AUDIO:4,
TEXT:5,
OTHER:6
},
KIND={
ONAIR:'OnAir',
RECORDED:'Recorded',
SD:'SD',
USB:'USB',
YOUTUBE:'YouTube',
VOD:'VOD',
DIGA:'DIGA',
ACTVILA:'Actvila',
SAMBA:'Samba',
MEMO:'Memo',
FILE:'File',
BOOKMARK:'Bookmark',
STB:'STB',
WASU:'Wasu'
},
ICON_PATH={
BOOKMARK:'bookmark.png',
DLNA:'dlna.png',
INPUT:'input.png',
MEMO:'memo.png',
MUSIC:'music.png',
PHOTO:'photo.png',
RECORDED:'recorded.png',
TV_CABLE:'tv_cab.png',
TV_SATELLITE:'tv_sat.png',
TV_TERR_ANA:'tv_terrA.png',
TV_TERR_DIGI:'tv_terrD.png',
TV_DVB_IP:'tv_dvb_ip.png',
VOD:'vod.png',
VIDEO:'video.png',
VIDEO_MEMO:'videomemo.png',
VOICE_MEMO:'voice.png',
YOUTUBE:'youtube.png',
DIGA:'diga.png',
ACTVILA:'actvila.png',
STB:'stb.png',
WASU:'wasu.png',
DEFAULT_AUDIO:'def_audio.png',
DEFAULT_OTHER:'def_other.png',
DEFAULT_PICTURE:'def_picture.png',
DEFAULT_TV:'def_tv.png',
DEFAULT_TV_FUTURE:'def_tv_future.png',
DEFAULT_VIDEO:'def_video.png'
};
getIconFilePath=function(content,prefix){
var path=null,scheme;
switch(content.kind){
case KIND.YOUTUBE:
path=ICON_PATH.YOUTUBE;
break;
case KIND.ONAIR:
if(content.attr.content===CONTENT.TV&&content.attr.src){
scheme=content.attr.src.slice(0,content.attr.src.indexOf(':'));
switch(scheme){
case 'dvb-t':
case 'isdb-t':
path=ICON_PATH.TV_TERR_DIGI;
break;
case 'ana':
path=ICON_PATH.TV_TERR_ANA;
break;
case 'dvb-c':
case 'ana-c':
path=ICON_PATH.TV_CABLE;
break;
case 'dvb-s':
case 'freesat':
case 'isdb-s':
path=ICON_PATH.TV_SATELLITE;
break;
case 'dvb-ip':
path=ICON_PATH.TV_DVB_IP;
break;
default:
}
}else if(content.attr.content===CONTENT.OTHER){
path=ICON_PATH.INPUT;}
break;
case KIND.VOD:
path=ICON_PATH.VOD;
break;
case KIND.RECORDED:
path=ICON_PATH.RECORDED;
break;
case KIND.SD:
case KIND.USB:
case KIND.SAMBA:
switch(content.attr.content){
case CONTENT.PICTURE:
path=ICON_PATH.PHOTO;
break;
case CONTENT.VIDEO:
path=ICON_PATH.VIDEO;
break;
case CONTENT.AUDIO:
path=ICON_PATH.MUSIC;
break;
default:
}
break;
case KIND.DIGA:
path=ICON_PATH.DIGA;
break;
case KIND.ACTVILA:
path=ICON_PATH.ACTVILA;
break;
case KIND.STB:
path=ICON_PATH.STB;
break;
case KIND.MEMO:
switch(content.attr.content){
case CONTENT.VIDEO:
path=ICON_PATH.VIDEO_MEMO;
break;
case CONTENT.AUDIO:
path=ICON_PATH.VOICE_MEMO;
break;
default:
path=ICON_PATH.MEMO;}
break;
case KIND.BOOKMARK:
path=ICON_PATH.BOOKMARK;
break;
case KIND.WASU:
path=ICON_PATH.WASU;
break;
default:
}
if(path!==null&&prefix){
path=prefix+path;}
return path;};
getDefaultImagePath=function(content,prefix){
var path=null;
switch(content.attr.content){
case CONTENT.TV:
if(checkTvService(content)==='future'){
path=ICON_PATH.DEFAULT_TV_FUTURE;}else {
path=ICON_PATH.DEFAULT_TV;}
break;
case CONTENT.PICTURE:
path=ICON_PATH.DEFAULT_PICTURE;
break;
case CONTENT.VIDEO:
path=ICON_PATH.DEFAULT_VIDEO;
break;
case CONTENT.AUDIO:
path=ICON_PATH.DEFAULT_AUDIO;
break;
case CONTENT.OTHER:
path=ICON_PATH.DEFAULT_OTHER;
break;
default:
path=ICON_PATH.DEFAULT_OTHER;}
if(path!==null&&prefix){
path=prefix+path;}
return path;};
checkTvService=function(content){
var result='other';
if(content.attr.content===CONTENT.TV){
var dt=new Date();
if(content.attr.time&&content.attr.time>0){
var start=content.attr.time;
var nowTime=dt.getTime()/1000;
if(start>nowTime){
result='future';}else {
if(content.attr.duration>=0){
var end=start+content.attr.duration;
if(end<nowTime){
result='past';}else {
result='live';}
}else {
result='live';}
}
}else {
result='live';}
}
return result;};
function get_appropriate_ws_url(){
return 'ws://localhost:57681';}
var WsContentsReq_connect=function(){
DEBUG.console(DEBUG.LVL.WARN,'Websocket connect');
if(typeof MozWebSocket!='undefined'){
ws_contents_req=new MozWebSocket(get_appropriate_ws_url(),'contents-req-protocol');}else {
ws_contents_req=new WebSocket(get_appropriate_ws_url(),'contents-req-protocol');}
try{
ws_contents_req.onopen=function(){
DEBUG.console(DEBUG.LVL.WARN,'Websocket open');
ws_is_connected=1;
if(ws_pending_req!=null){
contentManager.getContents(ws_pending_req);
ws_pending_req=null;}
};
ws_contents_req.onmessage=function got_packet(msg){
DEBUG.console(DEBUG.LVL.WARN,'Websocket message:');
DEBUG.console(DEBUG.LVL.VERBOSE,'  data=\n\t'+msg.data);
var getContent=JSON.parse(msg.data);
if('resultType' in getContent)DEBUG.console(DEBUG.LVL.INFO,'  resultType='+getContent.resultType);
if('reqId' in getContent)DEBUG.console(DEBUG.LVL.INFO,'  reqId='+getContent.reqId);
if('type' in getContent)DEBUG.console(DEBUG.LVL.INFO,'  type='+getContent.type);
if('status' in getContent)DEBUG.console(DEBUG.LVL.INFO,'  status='+getContent.status);
if('info' in getContent)DEBUG.console(DEBUG.LVL.INFO,'  info.length='+getContent.info.length);
if(contentManager.callback){
contentManager.callback(getContent);}else {
ws_pending_msg=getContent;}
};
ws_contents_req.onclose=function(ev){
DEBUG.console(DEBUG.LVL.WARN,'Websocket close');
ws_is_connected=0;
WsContentsReq_connect();};}catch(exception){
DEBUG.console(DEBUG.LVL.ERROR,exception);}
};
contentManager={
REQUEST_TYPE:REQUEST_TYPE,
ERR_CODE:ERR_CODE,
CONTENT:CONTENT,
KIND:KIND,
ICON_PATH:ICON_PATH,
getIconFilePath:getIconFilePath,
getDefaultImagePath:getDefaultImagePath,
checkTvService:checkTvService,
callback:null,
getContents:function(requestInfo){
var jsonString;
var obj;
if(typeof requestInfo=='string'){
obj=JSON.parse(requestInfo);}else {
obj=requestInfo;}
jsonString=JSON.stringify(obj);
DEBUG.console(DEBUG.LVL.WARN,'Websocket getcontents:\n\t'+jsonString);
if(ws_is_connected){
ws_contents_req.send(jsonString);}else {
ws_pending_req=jsonString;}
return obj;},
send:function(message){
return this.getContents(message);},
addCallback:function(callback){
this.callback=callback;
if(ws_pending_msg){
this.callback(ws_pending_msg);
ws_pending_msg=null;}
return this;},
compareContent:function(content1,content2){
var attr1,attr2;
if(content1.kind!==content2.kind||
content1.attr===undefined||
content2.attr===undefined){
return false;}
attr1=content1.attr;
attr2=content2.attr;
if(attr1.src!==undefined&&attr1.src===attr2.src&&
attr1.time!==undefined&&attr1.time===attr2.time&&
attr1.duration!==undefined&&attr1.duration===attr2.duration){
return true;}
return false;}
};
WsContentsReq_connect();
mystream.CONTENT_MANAGER=contentManager;
window.MYSTREAMCONTENTS=mystream.CONTENT_MANAGER;}(window));
