(function(exports){
'use strict';
var CLASS_FADE_IN='cmn_fade_in',
CLASS_FADE_OUT='cmn_fade_out',
CLASS_MOVE='cmn_move',
CLASS_ON='cmn_on',
event_name={},
dom_style_name={},
css_name={},
char_list={'<':'&lt;','>':'&gt;','&':'&amp;','"':'&quot;'},
domStyleHyphenFormat,
domStyleNonHyphenFormat,
domSetStyles,
domCreateElement,
domGetOffset,
domEscapeTag,
domStopEvent,
domAddTransitionEndCallback,
domAddAnimationEndCallback,
domChangeSvgFillColor,
domPreloadImages,
domCheckStrByte,
toHyphenStyleChar,
toNonHyphenStyleChar,
setStyleProperties,
setTransitionProperties,
clearTransitionProperties,
escapeChar,
FOCUS_STATE={
OFF:0,
ON:1,
FADING_IN:2,
FADING_OUT:3,
MOVING:4
},
Focus;
(function(){
var style_property_list=['transition','animation','transform'],
prefix_list=[
{dom:'webkit',css:'-webkit-'},
{dom:'Moz',css:'-moz-'},
{dom:'ms',css:'-ms-'},
{dom:'O',css:'-o-'}
],
style_prefix_list=['-webkit-','-moz-','-ms-','-o-'],
prefix_length=prefix_list.length,
i,
setStylePropertyName,
temp_ele=document.createElement('div');
setStylePropertyName=function(property_name){
var first_upper_case;
if(temp_ele.style[property_name]!==undefined){
css_name[property_name]=dom_style_name[property_name]=property_name;}else {
first_upper_case =property_name.charAt(0).toUpperCase()+property_name.slice(1);
for(i=0;i<prefix_length;i+=1){
if(temp_ele.style[prefix_list[i].dom+first_upper_case]!==undefined){
dom_style_name[property_name]=prefix_list[i].dom+first_upper_case;
css_name[property_name]=prefix_list[i].css+property_name;
break;}
}
}
};
style_property_list.forEach(setStylePropertyName);
event_name.transitionend=(dom_style_name.transition==='transition')?
'transitionend':dom_style_name.transition+'End';
event_name.animationend=(dom_style_name.animation==='animation')?
'animationend':dom_style_name.animation+'End';}());
toHyphenStyleChar=function(match){
return '-'+match.toLowerCase();};
toNonHyphenStyleChar=function(match){
return match.slice(-1).toUpperCase();};
setStyleProperties=function(target,properties,get_name_list){
var setStyleProperty,
property_name_list=Object.keys(properties);
setStyleProperty=function(property_name,index,list){
target.style[property_name]=properties[property_name];
list[index]=domStyleHyphenFormat(property_name);};
property_name_list.forEach(setStyleProperty);
return property_name_list;};
setTransitionProperties=function(target,properties,transition_name){
var setTransProperty,
property_name_list=Object.keys(properties);
setTransProperty=function(property_name){
switch(property_name){
case 'property':
target.style[transition_name+'Property']=properties[property_name];
break;
case 'duration':
target.style[transition_name+'Duration']=(typeof properties[property_name]==='string')?
properties[property_name]:
properties[property_name]+'ms';
break;
case 'timingFunction':
target.style[transition_name+'TimingFunction']=properties[property_name];
break;
case 'delay':
target.style[transition_name+'Delay']=(typeof properties[property_name]==='string')?
properties[property_name]:
properties[property_name]+'ms';
break;
default:
}
};
property_name_list.forEach(setTransProperty);};
clearTransitionProperties=function(target,properties,transition_name){
var property_name;
for(property_name in properties){
if(properties.hasOwnProperty(property_name)){
switch(property_name){
case 'property':
target.style[transition_name+'Property']=null;
break;
case 'duration':
target.style[transition_name+'Duration']=null;
break;
case 'timingFunction':
target.style[transition_name+'TimingFunction']=null;
break;
case 'delay':
target.style[transition_name+'Delay']=null;
break;
default:
}
}
}
};
escapeChar=function(c){
return char_list[c];};
domStyleHyphenFormat=function(property_name){
return property_name.replace(/[A-Z]/g,toHyphenStyleChar);};
domStyleNonHyphenFormat=function(property_name){
return property_name.replace(/(-[a-z])/g,toNonHyphenStyleChar);};
domSetStyles=function(target,properties){
var i,
property_name_list=Object.keys(properties),
max=property_name_list.length;
for(i=0;i<max;i+=1){
target.style[property_name_list[i]]=properties[property_name_list[i]];}
};
domCreateElement=function(tag_name,options){
var i,
max,
option_name,
class_name_list,
ele=document.createElement(tag_name);
if(!options){
return ele;}
for(option_name in options){
if(options.hasOwnProperty(option_name)){
switch(option_name){
case 'id':
ele.id=options[option_name];
break;
case 'className':
ele.className=options[option_name];
break;
case 'classList':
class_name_list=options[option_name];
for(i=0,max=class_name_list.length;i<max;i+=1){
ele.classList.add(class_name_list[i]);}
break;
default:
ele.setAttribute(option_name,options[option_name]);}
}
}
return ele;};
domGetOffset=function(target){
var rect=target.getBoundingClientRect(),
x=(window.pageXOffset!==undefined)?window.pageXOffset:
(document.documentElement||document.body.parentNode||document.body).scrollLeft,
y=(window.pageYOffset!==undefined)?window.pageYOffset:
(document.documentElement||document.body.parentNode||document.body).scrollTop;
return {top:rect.top+y,left:rect.left+x};};
domAddTransitionEndCallback=function(target,check_property,callback,options){
var check_property_list,end_property_list=[],transEndHandler,otherTarget=false;
if(check_property){
check_property_list=(typeof check_property==='string')?
[check_property]:check_property;}else {
check_property_list=[];}
if(options){
if(options.otherTarget){
otherTarget=true;}
}
transEndHandler=function(event){
if(!otherTarget&&event.target!==this){
return;}
event.stopPropagation();
if(check_property_list.indexOf(event.propertyName)>=0&&
end_property_list.indexOf(event.propertyName)<0){
end_property_list.push(event.propertyName);}
if(end_property_list.length>=check_property_list.length){
this.removeEventListener(event_name.transitionend,transEndHandler,false);
callback();}
};
callback=callback.bind(target);
target.addEventListener(event_name.transitionend,transEndHandler,false);};
domAddAnimationEndCallback=function(target,animation_name,callback,options){
var otherTarget=false,aniEndHandler;
if(options){
if(options.otherTarget){
otherTarget=true;}
}
aniEndHandler=function(event){
if((!otherTarget&&event.target!==this)||
(animation_name&&event.animationName!==animation_name)){
return;}
event.stopPropagation();
this.removeEventListener(event_name.animationend,aniEndHandler,false);
callback();};
callback=callback.bind(target);
target.addEventListener(event_name.animationend,aniEndHandler,false);};
domEscapeTag=function(text){
return text.replace(/[<>&"]/g,escapeChar);};
domStopEvent=function(event){
event.stopPropagation();
event.preventDefault();};
domChangeSvgFillColor=function(svg_objects,color){
var i,j,i_max,j_max,elements;
for(i=0,i_max=svg_objects.length;i<i_max;i+=1){
elements=svg_objects[i].contentDocument.querySelectorAll('*[fill]');
for(j=0,j_max=elements.length;j<j_max;j+=1){
elements[j].setAttribute('fill',color);}
}
};
domPreloadImages=function(src_list){
var i,max;
for(i=0,max=src_list.length;i<max;i+=1){
(new Image()).src=src_list[i];}
};
domCheckStrByte=function(str,start,len){
var i,sb='',cnt=0,bytes=0,tmpStr='';
try{
for(i=start;i<str.length-(str.match(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g)||[]).length-start;i++){
tmpStr=str.substring(i,i+1);
bytes=encodeURIComponent(tmpStr).replace(/%../g,'x').length;
if(cnt+bytes>len){
break;}else {
sb+=tmpStr;
cnt=cnt+bytes;}
}
}catch(e){}
return sb.toString();};
Focus=function(element,init_state){
var that=this;
this.ele=element;
this.currentState=init_state||FOCUS_STATE.OFF;
this.eventListener=function(event){
var callback;
if(event.target!==this){
return;}
event.stopPropagation();
switch(that.currentState){
case FOCUS_STATE.FADING_IN:
if(that.ele.classList.contains(CLASS_FADE_IN)){
that.currentState=FOCUS_STATE.ON;}
break;
case FOCUS_STATE.FADING_OUT:
if(that.ele.classList.contains(CLASS_FADE_OUT)){
that.currentState=FOCUS_STATE.OFF;}
break;
case FOCUS_STATE.MOVING:
if(that.ele.classList.contains(CLASS_MOVE)){
that.currentState=FOCUS_STATE.ON;}
break;
default:
}
if(that.callback){
callback=that.callback;
that.callback=null;
callback();}
};
this.ele.addEventListener(event_name.transitionend,this.eventListener,false);
this.callback=null;};
Focus.prototype.set=function(target){
var offset=domGetOffset(target),
width=target.clientWidth,
height=target.clientHeight,
style=window.getComputedStyle(target,''),
border_top=parseInt(style.borderTopWidth,10),
border_left=parseInt(style.borderLeftWidth,10),
transform=style[css_name.transform],
i,max,remove_class_list=[CLASS_FADE_IN,CLASS_FADE_OUT,CLASS_MOVE];
this.callback=null;
this.currentState=FOCUS_STATE.ON;
for(i=0,max=remove_class_list.length;i<max;i+=1){
this.ele.classList.remove(remove_class_list[i]);}
this.ele.classList.add(CLASS_ON);
this.ele.style.left=(offset.left+border_left)+'px';
this.ele.style.top=(offset.top+border_top)+'px';
this.ele.style.width=width+'px';
this.ele.style.height=height+'px';
this.ele.style[css_name.transform]=transform;
return this;};
Focus.prototype.move=function(target,callback){
var that=this,
offset=domGetOffset(target),
width=target.clientWidth,
height=target.clientHeight,
style=getComputedStyle(target,''),
border_top=parseInt(style.borderTopWidth,10),
border_left=parseInt(style.borderLeftWidth,10),
transform=style[css_name.transform],
i,max,remove_class_list=[CLASS_FADE_IN,CLASS_FADE_OUT,CLASS_ON];
this.callback=null;
if(callback&&typeof callback==='function'){
this.callback=callback;}
this.currentState=FOCUS_STATE.MOVING;
this.ele.classList.add(CLASS_MOVE);
for(i=0,max=remove_class_list.length;i<max;i+=1){
this.ele.classList.remove(remove_class_list[i]);}
this.ele.style.left=(offset.left+border_left)+'px';
this.ele.style.top=(offset.top+border_top)+'px';
this.ele.style.width=width+'px';
this.ele.style.height=height+'px';
this.ele.style[css_name.transform]=transform;
return this;};
Focus.prototype.fadeIn=function(callback){
var that=this,
i,max,remove_class_list=[CLASS_FADE_OUT,CLASS_MOVE,CLASS_ON];
this.callback=null;
if(callback&&typeof callback==='function'){
this.callback=callback;}
this.currentState=FOCUS_STATE.FADING_IN;
this.ele.classList.add(CLASS_FADE_IN);
for(i=0,max=remove_class_list.length;i<max;i+=1){
this.ele.classList.remove(remove_class_list[i]);}
return this;};
Focus.prototype.fadeOut=function(callback){
var that=this,
i,max,remove_class_list=[CLASS_FADE_IN,CLASS_MOVE,CLASS_ON];
this.callback=null;
if(callback&&typeof callback==='function'){
this.callback=callback;}
this.currentState=FOCUS_STATE.FADING_OUT;
this.ele.classList.add(CLASS_FADE_OUT);
for(i=0,max=remove_class_list.length;i<max;i+=1){
this.ele.classList.remove(remove_class_list[i]);}
return this;};
Focus.prototype.off=function(){
var that=this,
i,max,remove_class_list=[CLASS_FADE_IN,CLASS_FADE_OUT,CLASS_MOVE,CLASS_ON];
this.callback=null;
this.currentState=FOCUS_STATE.OFF;
for(i=0,max=remove_class_list.length;i<max;i+=1){
this.ele.classList.remove(remove_class_list[i]);}
return this;};
Focus.prototype.on=function(){
var that=this,
i,max,remove_class_list=[CLASS_FADE_IN,CLASS_FADE_OUT,CLASS_MOVE];
this.callback=null;
this.currentState=FOCUS_STATE.ON;
this.ele.classList.add(CLASS_ON);
for(i=0,max=remove_class_list.length;i<max;i+=1){
this.ele.classList.remove(remove_class_list[i]);}
return this;};
Focus.prototype.isEffecting=function(){
return (
this.currentState===FOCUS_STATE.FADING_IN||
this.currentState===FOCUS_STATE.FADING_OUT||
this.currentState===FOCUS_STATE.MOVING
);};
Focus.prototype.destroy=function(){
this.ele.removeEventListener(event_name.transitionend,this.eventListener,false);
this.ele.parentNode.removeChild(this.ele);
this.ele=null;
this.callback=null;};
exports.DOMUTIL={
domStyleName:dom_style_name,
eventName:event_name,
cssName:css_name,
createElement:domCreateElement,
getOffset:domGetOffset,
styleHyphenFormat:domStyleHyphenFormat,
styleNonHyphenFormat:domStyleNonHyphenFormat,
setStyles:domSetStyles,
addTransitionEndCallback:domAddTransitionEndCallback,
addAnimationEndCallback:domAddAnimationEndCallback,
escapeTag:domEscapeTag,
stopEvent:domStopEvent,
changeSvgFillColor:domChangeSvgFillColor,
preloadImages:domPreloadImages,
checkStrByte:domCheckStrByte,
FOCUS:{
STATE:FOCUS_STATE,
Focus:Focus
}
};}(window));
