
'use strict';
FDP.KBD=FDP.KBD||{};
FDP.KBD.mngLayouts={
getLayout:function(lang){
var layouts=FDP.KBD.mngLayouts.layouts;
if(typeof lang==='string'){
for(var i=0;i<layouts.length;i++){
if(layouts[i].label==lang){
lang=i;
break;}
}
}
if(typeof lang==='string'){
console.log('not found '+lang);}
return layouts[lang];},
getUpperCase:function(lang){
var layouts=FDP.KBD.mngLayouts.upperCase;
if(typeof lang==='string'){
for(var i=0;i<layouts.length;i++){
if(layouts[i].label==lang){
lang=i;
break;}
}
}
if(typeof lang==='string'){
console.log('not found '+lang);}
return layouts[lang];},
convLayoutKeyArys:function(keys,num){
var keyArys=[];
var row=0;
var keyParts;
var i;
var rowMax=30;
for(row=0;row<rowMax;row++){
keyParts=keys.slice(row*num,(row+1)*num);
if(keyParts.length>0){
keyArys.push(keyParts);}else {
break;}
}
return keyArys;}
};
FDP.KBD.mngLayouts.layouts=[
{label:'english',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z',' ','0','1','2','3','4','5','6','7','8','9','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','(',')','+','-','.','*','_']},
{label:'polish',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ą','Ć','Ę','Ł','Ń','Ó','Ś','Ý','Ź','Ż',' ','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ą','ć','ę','ł','ń','ó','ś','ý','ź','ż','(',')','+','-',
'0','1','2','3','4','5','6','7','8','9','.','*','_']},
{label:'czech',
width:21,
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Á','Č','É','Ě','Í','Ř','Š','Ť','Ů','Ú','Ý','Ž',' ','!',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','á','č','é','ě','í','ř','š','ť','ů','ú','ý','ž',':','#',
'0','1','2','3','4','5','6','7','8','9','(',')','+','-','.','*','_']},
{label:'russian',
width:21,
keys:['А','Б','В','Г','Д','Е','Ж','З','И','Й','К','Л','М','Н','О','П','Р','С','Т','У','Ф',
'Х','Ц','Ч','Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я','0','1','2','3','4','5','6','7','8','9',
'а','б','в','г','д','е','ж','з','и','й','к','л','м','н','о','п','р','с','т','у','ф',
'х','ц','ч','ш','щ','ъ','ы','ь','э','ю','я',' ','!',':','#','(',')','+','-','.','*',
'_']},
{label:'romanian',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Á','Â','Ă','É','Î','Í','Ö','Ó','Ş','Ţ','Ü',' ','!',':',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','á','â','ă','é','î','í','ö','ó','ş','ţ','ü','#','(',')',
'0','1','2','3','4','5','6','7','8','9','+','-','.','*','_']},
{label:'servian',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Č','Ć','Đ','Ë','Š','Ś','Ý','Ž','Ź','Ż',' ','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','č','ć','đ','ë','š','ś','ý','ž','ź','ż','(',')','+','-',
'0','1','2','3','4','5','6','7','8','9','.','*','_']},
{label:'greek',
keys:['Α','Β','Γ','Δ','Ε','Ζ','Η','Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο','Π','Ρ','Σ','Τ','Υ',
'Φ','Χ','Ψ','Ω','0','1','2','3','4','5','6','7','8','9',' ','!',':','#','(',')',
'α','β','γ','δ','ε','ζ','η','θ','ι','κ','λ','μ','ν','ξ','ο','π','ρ','σ','τ','υ',
'φ','χ','ψ','ω','+','-','.','*','_']},
{label:'slovak',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Á','Č','É','Ě','Í','Ĺ','Ň','Ó','Ř','Š','Ť','Ú','Ý','Ž',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','á','č','é','ě','í','ĺ','ň','ó','ř','š','ť','ú','ý','ž',
'0','1','2','3','4','5','6','7','8','9',' ','!',':','#','(',')','+','-','.','*',
'_']},
{label:'german',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ä','Ö','Ü','ß',' ','!',':','#','(',')','+','-','.','*',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ä','ö','ü','0','1','2','3','4','5','6','7','8','9','_']},
{label:'french',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','À','Â','Æ','Ç','È','É','Ê','Ë','Î','Ï','Ô','Œ','Ù','Û',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','à','â','æ','ç','è','é','ê','ë','î','ï','ô','œ','ù','û',
'0','1','2','3','4','5','6','7','8','9',' ','!',':','#','(',')','+','-','.','*',
'_']},
{label:'spanish',
width:19,
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S',
'T','U','V','W','X','Y','Z','Ñ','Ç','Á','É','Í','Ó','Ú',' ','¡','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s',
't','u','v','w','x','y','z','ñ','ç','á','é','í','ó','ú','ü','(',')','+','-',
'.','*','_','0','1','2','3','4','5','6','7','8','9']},
{label:'italian',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','À','È','É','Ì','Í','Ï','Ò','Ó','Ù','Ú',' ','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','à','è','é','ì','í','ï','ò','ó','ù','ú','(',')','+','-',
'0','1','2','3','4','5','6','7','8','9','.','*','_']},
{label:'portuguese',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Á','Â','Ã','À','Ç','É','Ê','Í','Ó','Ô','Õ','Ú',' ','!',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','á','â','ã','à','ç','é','ê','í','ó','ô','õ','ú',':','#',
'0','1','2','3','4','5','6','7','8','9','(',')','+','-','.','*','_']},
{label:'estonian',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ä','Õ','Ö','Š','Ü','Ž',' ','!',':','#','(',')','+','-',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ä','õ','ö','š','ü','ž','0','1','2','3','4','5','6','7',
'8','9','.','*','_']},
{label:'lithuanian',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ą','Č','Ę','Ė','Į','Š','Ų','Ū','Ž',' ','!',':','#','(',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ą','č','ę','ė','į','š','ų','ū','ž',')','+','-','.','*',
'0','1','2','3','4','5','6','7','8','9','_']},
{label:'latvian',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ā','Č','Ē','Ģ','Ī','Ķ','Ļ','Ņ','Š','Ū','Ž',' ','!',':',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ā','č','ē','ģ','ī','ķ','ļ','ņ','š','ū','ž','#','(',')',
'0','1','2','3','4','5','6','7','8','9','+','-','.','*','_']},
{label:'turkish',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ç','Ğ','İ','Ö','Ş','Ü',' ','!',':','#','(',')','+','-',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ç','ğ','ı','ö','ş','ü','.','*','_',
'0','1','2','3','4','5','6','7','8','9']},
{label:'danish',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Å','Æ','Ø','0','1','2','3','4','5','6','7','8','9',' ',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','å','æ','ø','!',':','#','(',')','+','-','.','*','_']},
{label:'swedish',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Å','Ä','Ö','0','1','2','3','4','5','6','7','8','9',' ',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','å','ä','ö','!',':','#','(',')','+','-','.','*','_']},
{label:'dutch',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','É','Ë','Ï','0','1','2','3','4','5','6','7','8','9',' ',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','é','ë','ï','!',':','#','(',')','+','-','.','*','_']},
{label:'upper-digits-space',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z',' ','0','1','2','3','4','5','6','7','8','9']},
{label:'lower-digits-space',
keys:['a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z',' ','0','1','2','3','4','5','6','7','8','9']},
{label:'digits',
keys:['0','1','2','3','4','5','6','7','8','9']},
{label:'english-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z',' ','0','1','2','3','4','5','6','7','8','9','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','(',')','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'polish-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ą','Ć','Ę','Ł','Ń','Ó','Ś','Ý','Ź','Ż',' ','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ą','ć','ę','ł','ń','ó','ś','ý','ź','ż','(',')','+','-',
'0','1','2','3','4','5','6','7','8','9','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'czech-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Á','Č','É','Ě','Í','Ř','Š','Ť','Ů','Ú','Ý','Ž',' ','!',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','á','č','é','ě','í','ř','š','ť','ů','ú','ý','ž',':','#',
'0','1','2','3','4','5','6','7','8','9','(',')','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'russian-full-ascii',
width:21,
keys:['А','Б','В','Г','Д','Е','Ж','З','И','Й','К','Л','М','Н','О','П','Р','С','Т','У','Ф',
'Х','Ц','Ч','Ш','Щ','Ъ','Ы','Ь','Э','Ю','Я','0','1','2','3','4','5','6','7','8','9',
'а','б','в','г','д','е','ж','з','и','й','к','л','м','н','о','п','р','с','т','у','ф',
'х','ц','ч','ш','щ','ъ','ы','ь','э','ю','я',' ','!',':','#','(',')','+','-','.','*',
'_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'romanian-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Á','Â','Ă','É','Î','Í','Ö','Ó','Ş','Ţ','Ü',' ','!',':',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','á','â','ă','é','î','í','ö','ó','ş','ţ','ü','#','(',')',
'0','1','2','3','4','5','6','7','8','9','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'servian-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Č','Ć','Đ','Ë','Š','Ś','Ý','Ž','Ź','Ż',' ','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','č','ć','đ','ë','š','ś','ý','ž','ź','ż','(',')','+','-',
'0','1','2','3','4','5','6','7','8','9','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'greek-full-ascii',
keys:['Α','Β','Γ','Δ','Ε','Ζ','Η','Θ','Ι','Κ','Λ','Μ','Ν','Ξ','Ο','Π','Ρ','Σ','Τ','Υ',
'Φ','Χ','Ψ','Ω','0','1','2','3','4','5','6','7','8','9',' ','!',':','#','(',')',
'α','β','γ','δ','ε','ζ','η','θ','ι','κ','λ','μ','ν','ξ','ο','π','ρ','σ','τ','υ',
'φ','χ','ψ','ω','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'slovak-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Á','Č','É','Ě','Í','Ĺ','Ň','Ó','Ř','Š','Ť','Ú','Ý','Ž',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','á','č','é','ě','í','ĺ','ň','ó','ř','š','ť','ú','ý','ž',
'0','1','2','3','4','5','6','7','8','9',' ','!',':','#','(',')','+','-','.','*',
'_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'german-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ä','Ö','Ü','ß',' ','!',':','#','(',')','+','-','.','*',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ä','ö','ü','0','1','2','3','4','5','6','7','8','9','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'french-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','À','Â','Æ','Ç','È','É','Ê','Ë','Î','Ï','Ô','Œ','Ù','Û',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','à','â','æ','ç','è','é','ê','ë','î','ï','ô','œ','ù','û',
'0','1','2','3','4','5','6','7','8','9',' ','!',':','#','(',')','+','-','.','*',
'_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'spanish-full-ascii',
width:19,
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S',
'T','U','V','W','X','Y','Z','Ñ','Ç','Á','É','Í','Ó','Ú',' ','¡','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s',
't','u','v','w','x','y','z','ñ','ç','á','é','í','ó','ú','ü','(',')','+','-',
'.','*','_','0','1','2','3','4','5','6','7','8','9',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'italian-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','À','È','É','Ì','Í','Ï','Ò','Ó','Ù','Ú',' ','!',':','#',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','à','è','é','ì','í','ï','ò','ó','ù','ú','(',')','+','-',
'0','1','2','3','4','5','6','7','8','9','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'portuguese-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Á','Â','Ã','À','Ç','É','Ê','Í','Ó','Ô','Õ','Ú',' ','!',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','á','â','ã','à','ç','é','ê','í','ó','ô','õ','ú',':','#',
'0','1','2','3','4','5','6','7','8','9','(',')','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'estonian-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ä','Õ','Ö','Š','Ü','Ž',' ','!',':','#','(',')','+','-',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ä','õ','ö','š','ü','ž','0','1','2','3','4','5','6','7',
'8','9','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'lithuanian-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ą','Č','Ę','Ė','Į','Š','Ų','Ū','Ž',' ','!',':','#','(',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ą','č','ę','ė','į','š','ų','ū','ž',')','+','-','.','*',
'0','1','2','3','4','5','6','7','8','9','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'latvian-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ā','Č','Ē','Ģ','Ī','Ķ','Ļ','Ņ','Š','Ū','Ž',' ','!',':',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ā','č','ē','ģ','ī','ķ','ļ','ņ','š','ū','ž','#','(',')',
'0','1','2','3','4','5','6','7','8','9','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'turkish-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Ç','Ğ','İ','Ö','Ş','Ü',' ','!',':','#','(',')','+','-',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','ç','ğ','ı','ö','ş','ü','.','*','_',
'0','1','2','3','4','5','6','7','8','9',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'danish-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Å','Æ','Ø','0','1','2','3','4','5','6','7','8','9',' ',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','å','æ','ø','!',':','#','(',')','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'swedish-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','Å','Ä','Ö','0','1','2','3','4','5','6','7','8','9',' ',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','å','ä','ö','!',':','#','(',')','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'dutch-full-ascii',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','É','Ë','Ï','0','1','2','3','4','5','6','7','8','9',' ',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','é','ë','ï','!',':','#','(',')','+','-','.','*','_',
'@','/','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`',
'^','\\']},
{label:'netbios-name',
remGuide:'rem_multi_tap_digits_netbios.png',
keys:['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
'U','V','W','X','Y','Z','0','1','2','3','4','5','6','7','8','9','!','#','$','%',
'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t',
'u','v','w','x','y','z','&','(',')','{','}','-','.','_']}
];
FDP.KBD.mngLayouts.upperCase=[
{label:'english',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'polis',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','ą','ć','Ą','Ć'
],
'3':[
'd','e','f','3','D','E','F','ę','Ę'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L','ł','Ł'
],
'6':[
'm','n','o','6','M','N','O','ń','ó','Ń','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ś','Ś'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ý','ź','ż','Ý','Ź','Ż'
],
'0':[
' ','0'
]}},
{label:'czech',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','á','č','Á','Č'
],
'3':[
'd','e','f','3','D','E','F','é','ě','É','Ě'
],
'4':[
'g','h','i','4','G','H','I','í','Í'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ř','š','Ř','Š'
],
'8':[
't','u','v','8','T','U','V','ť','ů','ú','Ť','Ů','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ý','ž','Ý','Ž'
],
'0':[
' ','0'
]}},
{label:'russian',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'2','а','б','в','г','А','Б','В','Г'
],
'3':[
'3','д','е','ж','з','Д','Е','Ж','З'
],
'4':[
'4','и','й','к','л','И','Й','К','Л'
],
'5':[
'5','м','н','о','п','М','Н','О','П'
],
'6':[
'6','р','с','т','у','Р','С','Т','У'
],
'7':[
'7','ф','х','ц','ч','Ф','Х','Ц','Ч'
],
'8':[
'8','ш','щ','ъ','ы','Ш','Щ','Ъ','Ы'
],
'9':[
'9','ь','э','ю','я','Ь','Э','Ю','Я'
],
'0':[
' ','0'
]}},
{label:'romanian',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','á','â','ă','Á','Â','Ă'
],
'3':[
'd','e','f','3','D','E','F','é','É'
],
'4':[
'g','h','i','4','G','H','I','î','í','Î','Í'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ö','ó','Ö','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ş','Ş'
],
'8':[
't','u','v','8','T','U','V','ü','ţ','Ü','Ţ'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'servian',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','č','ć','Č','Ć'
],
'3':[
'd','e','f','3','D','E','F','đ','ë','Đ','Ë'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S','š','ś','Š','Ś'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ý','ž','ź','ż','Ý','Ž','Ź','Ż'
],
'0':[
' ','0'
]}},
{label:'greek',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'2','α','β','γ','Α','Β','Γ'
],
'3':[
'3','δ','ε','ζ','Δ','Ε','Ζ'
],
'4':[
'4','η','θ','ι','Η','Θ','Ι'
],
'5':[
'5','κ','λ','μ','Κ','Λ','Μ'
],
'6':[
'6','ν','ξ','ο','Ν','Ξ','Ο'
],
'7':[
'7','π','ρ','σ','Π','Ρ','Σ'
],
'8':[
'8','τ','υ','φ','Τ','Υ','Φ'
],
'9':[
'9','χ','ψ','ω','Χ','Ψ','Ω'
],
'0':[
' ','0'
]}},
{label:'slovak',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','á','č','Á','Č'
],
'3':[
'd','e','f','3','D','E','F','é','ě','É','Ě'
],
'4':[
'g','h','i','4','G','H','I','í','Í'
],
'5':[
'j','k','l','5','J','K','L','ĺ','Ĺ'
],
'6':[
'm','n','o','6','M','N','O','ň','ó','Ň','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ř','š','Ř','Š'
],
'8':[
't','u','v','8','T','U','V','ť','ú','Ť','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ý','ž','Ý','Ž'
],
'0':[
' ','0'
]}},
{label:'german',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','ä','Ä'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ö','Ö'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ß'
],
'8':[
't','u','v','8','T','U','V','ü','Ü'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'french',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','à','â','æ','ç','À','Â','Æ','Ç'
],
'3':[
'd','e','f','3','D','E','F','è','é','ê','ë','È','É','Ê','Ë'
],
'4':[
'g','h','i','4','G','H','I','î','ï','Î','Ï'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ô','œ','Ô','Œ'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V','ù','û','Ù','Û'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'spanish',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','á','ç','Á','Ç'
],
'3':[
'd','e','f','3','D','E','F','é','É'
],
'4':[
'g','h','i','4','G','H','I','í','Í'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ñ','ó','Ñ','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V','ú','ü','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'italian',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','à','À'
],
'3':[
'd','e','f','3','D','E','F','è','é','È','É'
],
'4':[
'g','h','i','4','G','H','I','ì','í','Ì','Í'
],
'5':[
'j','k','l','5','J','K','L','ï','Ï'
],
'6':[
'm','n','o','6','M','N','O','ò','ó','Ò','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V','ù','ú','Ù','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'portuguese',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','á','â','ã','à','ç','Á','Â','Ã','À','Ç'
],
'3':[
'd','e','f','3','D','E','F','é','ê','É','Ê'
],
'4':[
'g','h','i','4','G','H','I','í','Í'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ó','ô','õ','Ó','Ô','Õ'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V','ú','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'estonian',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','ä','Ä'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','õ','ö','Õ','Ö'
],
'7':[
'p','q','r','s','7','P','Q','R','S','š','Š'
],
'8':[
't','u','v','8','T','U','V','ü','Ü'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ž','Ž'
],
'0':[
' ','0'
]}},
{label:'lithuanian',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','ą','č','Ą','Č'
],
'3':[
'd','e','f','3','D','E','F','ę','ė','Ę','Ė'
],
'4':[
'g','h','i','4','G','H','I','į','Į'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S','š','Š'
],
'8':[
't','u','v','8','T','U','V','ų','ū','Ų','Ū'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ž','Ž'
],
'0':[
' ','0'
]}},
{label:'latvian',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','ā','č','Ā','Č'
],
'3':[
'd','e','f','3','D','E','F','ē','Ē'
],
'4':[
'g','h','i','4','G','H','I','ģ','ī','Ģ','Ī'
],
'5':[
'j','k','l','5','J','K','L','ķ','ļ','Ķ','Ļ'
],
'6':[
'm','n','o','6','M','N','O','ņ','Ņ'
],
'7':[
'p','q','r','s','7','P','Q','R','S','š','Š'
],
'8':[
't','u','v','8','T','U','V','ū','Ū'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ž','Ž'
],
'0':[
' ','0'
]}},
{label:'turkish',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','ç','Ç'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I','ğ','ı','Ğ','İ'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ö','Ö'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ş','Ş'
],
'8':[
't','u','v','8','T','U','V','ü','Ü'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'danish',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','å','æ','Å','Æ'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ø','Ø'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'swedish',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C','å','ä','Å','Ä'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ö','Ö'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'dutch',
assoc:{
'1':[
'.','1','!',':','#','+','-','*','_','(',')'
],
'2':[
'a','b','c','2','A','B','C'
],
'3':[
'd','e','f','3','D','E','F','é','ë','É','Ë'
],
'4':[
'g','h','i','4','G','H','I','ï','Ï'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'upper-digits-space',
assoc:{
'1':[
'1'
],
'2':[
'A','B','C','2'
],
'3':[
'D','E','F','3'
],
'4':[
'G','H','I','4'
],
'5':[
'J','K','L','5'
],
'6':[
'M','N','O','6'
],
'7':[
'P','Q','R','S','7'
],
'8':[
'T','U','V','8'
],
'9':[
'W','X','Y','Z','9'
],
'0':[
' ','0'
]}},
{label:'lower-digits-space',
assoc:{
'1':[
'1'
],
'2':[
'a','b','c','2'
],
'3':[
'd','e','f','3'
],
'4':[
'g','h','i','4'
],
'5':[
'j','k','l','5'
],
'6':[
'm','n','o','6'
],
'7':[
'p','q','r','s','7'
],
'8':[
't','u','v','8'
],
'9':[
'w','x','y','z','9'
],
'0':[
' ','0'
]}},
{label:'digits',
assoc:{
'1':[
'1'
],
'2':[
'2'
],
'3':[
'3'
],
'4':[
'4'
],
'5':[
'5'
],
'6':[
'6'
],
'7':[
'7'
],
'8':[
'8'
],
'9':[
'9'
],
'0':[
'0'
]}},
{label:'english-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'polish-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','ą','ć','Ą','Ć'
],
'3':[
'd','e','f','3','D','E','F','ę','Ę'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L','ł','Ł'
],
'6':[
'm','n','o','6','M','N','O','ń','ó','Ń','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ś','Ś'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ý','ź','ż','Ý','Ź','Ż'
],
'0':[
' ','0'
]}},
{label:'czech-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','á','č','Á','Č'
],
'3':[
'd','e','f','3','D','E','F','é','ě','É','Ě'
],
'4':[
'g','h','i','4','G','H','I','í','Í'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ř','š','Ř','Š'
],
'8':[
't','u','v','8','T','U','V','ť','ů','ú','Ť','Ů','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ý','ž','Ý','Ž'
],
'0':[
' ','0'
]}},
{label:'russian-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'2','а','б','в','г','А','Б','В','Г'
],
'3':[
'3','д','е','ж','з','Д','Е','Ж','З'
],
'4':[
'4','и','й','к','л','И','Й','К','Л'
],
'5':[
'5','м','н','о','п','М','Н','О','П'
],
'6':[
'6','р','с','т','у','Р','С','Т','У'
],
'7':[
'7','ф','х','ц','ч','Ф','Х','Ц','Ч'
],
'8':[
'8','ш','щ','ъ','ы','Ш','Щ','Ъ','Ы'
],
'9':[
'9','ь','э','ю','я','Ь','Э','Ю','Я'
],
'0':[
' ','0'
]}},
{label:'romanian-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','á','â','ă','Á','Â','Ă'
],
'3':[
'd','e','f','3','D','E','F','é','É'
],
'4':[
'g','h','i','4','G','H','I','î','í','Î','Í'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ö','ó','Ö','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ş','Ş'
],
'8':[
't','u','v','8','T','U','V','ü','ţ','Ü','Ţ'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'servian-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','č','ć','Č','Ć'
],
'3':[
'd','e','f','3','D','E','F','đ','ë','Đ','Ë'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S','š','ś','Š','Ś'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ý','ž','ź','ż','Ý','Ž','Ź','Ż'
],
'0':[
' ','0'
]}},
{label:'greek-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'2','α','β','γ','Α','Β','Γ'
],
'3':[
'3','δ','ε','ζ','Δ','Ε','Ζ'
],
'4':[
'4','η','θ','ι','Η','Θ','Ι'
],
'5':[
'5','κ','λ','μ','Κ','Λ','Μ'
],
'6':[
'6','ν','ξ','ο','Ν','Ξ','Ο'
],
'7':[
'7','π','ρ','σ','Π','Ρ','Σ'
],
'8':[
'8','τ','υ','φ','Τ','Υ','Φ'
],
'9':[
'9','χ','ψ','ω','Χ','Ψ','Ω'
],
'0':[
' ','0'
]}},
{label:'slovak-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','á','č','Á','Č'
],
'3':[
'd','e','f','3','D','E','F','é','ě','É','Ě'
],
'4':[
'g','h','i','4','G','H','I','í','Í'
],
'5':[
'j','k','l','5','J','K','L','ĺ','Ĺ'
],
'6':[
'm','n','o','6','M','N','O','ň','ó','Ň','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ř','š','Ř','Š'
],
'8':[
't','u','v','8','T','U','V','ť','ú','Ť','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ý','ž','Ý','Ž'
],
'0':[
' ','0'
]}},
{label:'german-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','ä','Ä'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ö','Ö'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ß'
],
'8':[
't','u','v','8','T','U','V','ü','Ü'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'french-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','à','â','æ','ç','À','Â','Æ','Ç'
],
'3':[
'd','e','f','3','D','E','F','è','é','ê','ë','È','É','Ê','Ë'
],
'4':[
'g','h','i','4','G','H','I','î','ï','Î','Ï'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ô','œ','Ô','Œ'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V','ù','û','Ù','Û'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'spanish-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','á','ç','Á','Ç'
],
'3':[
'd','e','f','3','D','E','F','é','É'
],
'4':[
'g','h','i','4','G','H','I','í','Í'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ñ','ó','Ñ','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V','ú','ü','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'italian-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','à','À'
],
'3':[
'd','e','f','3','D','E','F','è','é','È','É'
],
'4':[
'g','h','i','4','G','H','I','ì','í','Ì','Í'
],
'5':[
'j','k','l','5','J','K','L','ï','Ï'
],
'6':[
'm','n','o','6','M','N','O','ò','ó','Ò','Ó'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V','ù','ú','Ù','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'portuguese-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','á','â','ã','à','ç','Á','Â','Ã','À','Ç'
],
'3':[
'd','e','f','3','D','E','F','é','ê','É','Ê'
],
'4':[
'g','h','i','4','G','H','I','í','Í'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ó','ô','õ','Ó','Ô','Õ'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V','ú','Ú'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'estonian-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','ä','Ä'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','õ','ö','Õ','Ö'
],
'7':[
'p','q','r','s','7','P','Q','R','S','š','Š'
],
'8':[
't','u','v','8','T','U','V','ü','Ü'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ž','Ž'
],
'0':[
' ','0'
]}},
{label:'lithuanian-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','ą','č','Ą','Č'
],
'3':[
'd','e','f','3','D','E','F','ę','ė','Ę','Ė'
],
'4':[
'g','h','i','4','G','H','I','į','Į'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S','š','Š'
],
'8':[
't','u','v','8','T','U','V','ų','ū','Ų','Ū'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ž','Ž'
],
'0':[
' ','0'
]}},
{label:'latvian-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','ā','č','Ā','Č'
],
'3':[
'd','e','f','3','D','E','F','ē','Ē'
],
'4':[
'g','h','i','4','G','H','I','ģ','ī','Ģ','Ī'
],
'5':[
'j','k','l','5','J','K','L','ķ','ļ','Ķ','Ļ'
],
'6':[
'm','n','o','6','M','N','O','ņ','Ņ'
],
'7':[
'p','q','r','s','7','P','Q','R','S','š','Š'
],
'8':[
't','u','v','8','T','U','V','ū','Ū'
],
'9':[
'w','x','y','z','9','W','X','Y','Z','ž','Ž'
],
'0':[
' ','0'
]}},
{label:'turkish-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','ç','Ç'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I','ğ','ı','Ğ','İ'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ö','Ö'
],
'7':[
'p','q','r','s','7','P','Q','R','S','ş','Ş'
],
'8':[
't','u','v','8','T','U','V','ü','Ü'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'danish-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','å','æ','Å','Æ'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ø','Ø'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'swedish-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C','å','ä','Å','Ä'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O','ö','Ö'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'dutch-full-ascii',
assoc:{
'1':[
'.','@','/','1','!',':','#','+','-','*','_','(',')','"',"'",'%','&','?',',',';','=','$','[',']','~','<','>','{','}','|','`','^','\\'
],
'2':[
'a','b','c','2','A','B','C'
],
'3':[
'd','e','f','3','D','E','F','é','ë','É','Ë'
],
'4':[
'g','h','i','4','G','H','I','ï','Ï'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
' ','0'
]}},
{label:'netbios-name',
assoc:{
'1':[
'.','1','!','#','$','%','(',')','{','}','-','_'
],
'2':[
'a','b','c','2','A','B','C'
],
'3':[
'd','e','f','3','D','E','F'
],
'4':[
'g','h','i','4','G','H','I'
],
'5':[
'j','k','l','5','J','K','L'
],
'6':[
'm','n','o','6','M','N','O'
],
'7':[
'p','q','r','s','7','P','Q','R','S'
],
'8':[
't','u','v','8','T','U','V'
],
'9':[
'w','x','y','z','9','W','X','Y','Z'
],
'0':[
'0'
]}}
];
