var search_settings={
PRODUCT_ID:"home",
BROWSER_PRODUCT_ID:"0077777700140002",
CSEARCH_PRODUCT_ID:"0387878700000027",
EPG_JP_PRODUCT_ID:"0387878700000002",
EPG_PAL_PRODUCT_ID:"0387878700000003",
MYSTREAM_PRODUCT_ID:"0387878700000056",
HISTORY_SIZE:5,
HISTORY_NV_SIZE:1024,NV_FILE:"se_search_word",
COL_KEYWORD_1:[110,110,110,255],
COL_KEYWORD_2:[145,145,145,255],
COL_KEYWORD_FG:[255,255,255,255],
};
var NV_PATH="/usr/local/apps_nv/data/"+search_settings.PRODUCT_ID+"/"+search_settings.NV_FILE;
var COMMON_PATH=PATH+"common/";
var IMG_PATH=PATH+"img/";
var FOCUS_SPEED=30;
function perror(e){
console.log("[JS error] "+e.fileName+":"+e.lineNumber+": "+e.name+": "+e.message);};
function findIndexOfList(obj,list){
if(!list)return -1;
return list.indexOf(obj)
}
function convertArrayToJson(text_array){
var target="{[";
for(var i=0;i<text_array.length;i++){
var val=text_array[i];
val=val.replace(/\\/g,"\\\\");
val=val.replace(/\"/g,"\\\"");
val=val.replace(/\n/g," ");
val=val.replace(/\r/g," ");
val=val.replace(/\t/g,"\\\t");
val=val.replace(/\'/g,"\\\'");
target+="\""+val+"\", ";}
target+="]}";
return target;}
function getFontSizeOfText(obj,text,min_font_size){
var w=obj.width;
var orig_size=obj.font_size;
for(var s=orig_size;s>min_font_size;s--){
var l=get_text_width(obj,text);
if(l<w){
break;}else {
obj.font_size=s;}
}
obj.font_size=orig_size;
return s;}
add_package_load_path("kbd",COMMON_PATH+"keyboard/pkg_keyboard.js");
require("textarea");
var set_cursor=function(sobj,cobj){
var old=sobj.cursor;
if(old==cobj)return;
if(old){
if(old.leave_focus)old.leave_focus(old);
old.in_cursor=false;
old.toggle_cursor=false;}
if(cobj){
if(cobj.enter_focus)cobj.enter_focus(cobj);
cobj.in_cursor=true;}
sobj.cursor=cobj;};

var TIMER_RESOLUTION=40;
function MoveTo(param){
delete_timer(this);
if(param.func)param.func(this);
this.tmp={};
this.endpos={};
this.tmp.RATE=0.6;
this.tmp.max_count=param.count?param.count:9;
if(param.rate){
this.tmp.RATE=param.rate;}
if(param.count)this.tmp.max_count=param.count;
this.endpos.x=param.x;
this.endpos.y=param.y;
this.endpos.z=param.z;
this.tmp.dx=param.x-this.translate[0];
this.tmp.dy=param.y-this.translate[1];
this.tmp.dz=param.z-this.translate[2];
this.translate[0]+=this.tmp.dx*this.tmp.RATE;
this.translate[1]+=this.tmp.dy*this.tmp.RATE;
this.translate[2]+=this.tmp.dz*this.tmp.RATE;
if(!param.angle)param.angle=0;
this.tmp.da=param.angle-this.rotation[0];
this.rotation[0]+=this.tmp.da*this.tmp.RATE

force_redraw();
append_timer(this,TIMER_RESOLUTION,function (obj,count){
obj.tmp.dx=param.x-obj.translate[0];
obj.tmp.dy=param.y-obj.translate[1];
obj.tmp.dz=param.z-obj.translate[2];
obj.translate[0]+=Math.floor(obj.tmp.dx*obj.tmp.RATE);
obj.translate[1]+=Math.floor(obj.tmp.dy*obj.tmp.RATE);
obj.translate[2]+=Math.floor(obj.tmp.dz*obj.tmp.RATE);
obj.tmp.da=param.angle-obj.rotation[0];
obj.rotation[0]+=obj.tmp.da*obj.tmp.RATE;
if(count>=obj.tmp.max_count){
delete_timer(obj);

obj.translate[0]=param.x;
obj.translate[1]=param.y;
obj.translate[2]=param.z;
obj.rotation[0]=param.angle;
if(typeof param.end_func=="function"){
param.end_func(obj);}
}
force_redraw();});}


var sft_keyboard_mask=new container({});
sft_keyboard_mask.create=function(){
this.mask=new gbox({width:1920,height:1080,color:[0,0,0,0]});
this.mask.action=function(obj){return;};
this.mask.mouseover=function(obj){return;};
this.mask.mouseout=function(obj){return;};
this.components.push(this.mask);};
sft_keyboard_mask.free=function(){
if(this.components.length==0)return;
this.components.splice(0,this.components.length);};
sft_keyboard_mask.appear=function(){
this.create();};
sft_keyboard_mask.disappear=function(){
this.free();};
var sft_keyboard=new container({visible_p:false});
sft_keyboard.create=function(){
var self=this;
require("kbd");

kbd.set_skin_info({color:"white",size:"LARGE"});
this.kb_item=kbd.create();
if(this.trg_textarea){
this.kb_item.set_trg_textarea(this.trg_textarea);
this.trg_textarea.set_reverse_text_color(COL_POINT_ONBASE);}
this.components.push(this.kb_item);
this.kb_item.set_height_change_callback(this.change_kb_height);
this.kb_item.set_done_callback(self.done_enter_action);
this.kb_item.set_cancel_callback(self.cancel_enter_action);
if(ebus&&ebus.kbd&&ebus.kbd.supported){
sobj.add_event_hook(ebus.kbd,function(){return self.usb_key_hook(arguments);});}
this.change_kb_height(this.kb_item.get_height());
this.pos_y=-540+this.height/2+0;
this.focus_out_mode=false;
this.not_appear=false;
this.moveTo=MoveTo;};
sft_keyboard.set_passwd_mode=function(){
this.kb_item.set_mode("PASSWD");};
sft_keyboard.set_input_char=function(val){
this.kb_item.change_input_char_set({type:val});};
sft_keyboard.appear=function(param){
this.trg_textarea=param.textarea;
this.done_action_cb=(param.done_cb)?param.done_cb:null;
this.cancel_action_cb=(param.cancel_cb)?param.cancel_cb:null;
this.create();
this.translate[1]=-540-this.height/2+0;
this.moveTo({x:0,y:-540+this.height/2+0,z:0.1,end_func:function(){}});
this.visible_p=true;
set_cursor(sobj,this);
if(InputDevManager.get_pointer_status())
this.set_move_mode("free");
else
this.set_move_mode("key");};
sft_keyboard.disappear=function(hook_func){
var self=this;
sobj.del_event_hook(ebus.kbd);
this.moveTo({x:0,y:-540-this.height/2,z:0,end_func:function(){
self.visible_p=false;
self.free();
self.focus_out_mode=false;
if(hook_func)
hook_func();}});};
sft_keyboard.free=function(){
if(this.components.length==0){
return;}
for(var i=0;i<this.components.length;i++){
if(this.components[i] instanceof gtext||this.components[i] instanceof gtextbox){
setf_text(this.components[i],"");}else if(this.components[i] instanceof gimage){
this.components[i].src="";}else if(this.components[i] instanceof container){
for(var j=0,max=this.components[i].components.length;j<max;j++){
if(this.components[i].components[j] instanceof gimage){
this.components[i].components[j].src="";}
}
}
if(this.components[i].free)this.components[i].free();}
this.components.splice(0,this.components.length);};
sft_keyboard.enter_focus=function(){
set_cursor(this,this.kb_item);};
sft_keyboard.leave_focus=function(){
set_cursor(this,null);};
sft_keyboard.done_enter_action=function(){
if(sft_keyboard.done_action_cb){
sft_keyboard.done_action_cb();
return;}
};
sft_keyboard.cancel_enter_action=function(){
if(sft_keyboard.cancel_action_cb){
sft_keyboard.cancel_action_cb();
return;}
};
sft_keyboard.change_kb_height=function(height){
var self=sft_keyboard;
self.height=height;
self.translate=[0,-540+self.height/2,0.1];
self.kb_item.set_translate([0,height/2,0]);
self.pos_y=self.translate[1];};
sft_keyboard.set_move_mode=function(mode){
if(ebus.mouse){
this.kb_item.set_move_mode(mode);}
};
sft_keyboard.key_hook=function(up_down,key){
var ret=false;
if((this.cursor==this.kb_item)&&(!this.focus_out_mode)){
if((key==TXK_UP)||(key==TXK_DOWN)||(key==TXK_LEFT)||(key==TXK_RIGHT)){
this.set_move_mode("key");}
ret=this.kb_item.keyhook(up_down,key);}
if(up_down!=KEY_PRESS)return true;
return ret;};
sft_keyboard.usb_key_hook=function(arg){
if(InputDevManager.get_pointer_status()){
InputDevManager.pointer_disappear();}
this.set_move_mode("key");
return this.kb_item.usb_key_hook(
arg[0],arg[1],arg[2],arg[3],arg[4],arg[5],arg[6]
);};
sft_keyboard.asr_hook=function(arg){
if(this.kb_item.asr_hook&&typeof this.kb_item.asr_hook=="function"){
this.kb_item.asr_hook(arg);}
};
var obutton=0;
var mouse_hook=function (){
var ret=false;
var button=arguments[3];
var mouse_pos_x=system.cursor_pointer.get_pos_x();
var mouse_pos_y=system.cursor_pointer.get_pos_y();
InputDevManager.pointer_appear();
if(sft_keyboard.visible_p){
sft_keyboard.kb_item.set_move_mode("free");
ret=sft_keyboard.kb_item.mouse_hook(arguments);}
obutton=button;
return ret;};
function asr_hook(stage,device,event){
if(sft_keyboard.visible_p){
sft_keyboard.asr_hook(arguments);}
}
var InputDevManager={};
InputDevManager.init=function(){
this.move_mode="key";
this.pointer_status=true;};
InputDevManager.set_move_mode=function(mode){
if(mode==this.move_mode)return;
if(mode=="free"){
this.pointer_appear();
this.move_mode="free";
this.set_free();}else if(mode=="key"){
this.pointer_disappear();
this.move_mode="key";
this.set_key();}else{
this.pointer_appear();
this.move_mode="hybrid";
this.set_hybrid();}
};
InputDevManager.get_move_mode=function(){
return this.move_mode;};
InputDevManager.pointer_appear=function(){
if(system.cursor_pointer){
system.cursor_pointer.set_timeout(0);
system.cursor_pointer.force_show();
this.set_pointer_status(true);}
};
InputDevManager.pointer_disappear=function(){
if(system.cursor_pointer){
system.cursor_pointer.set_timeout(1);
system.cursor_pointer.force_show();
this.set_pointer_status(false);}
};
InputDevManager.set_pointer_status=function(state){
this.pointer_status=state;};
InputDevManager.get_pointer_status=function(){
return this.pointer_status;};
InputDevManager.set_key=function(){};
InputDevManager.set_free=function(){};
InputDevManager.set_hybrid=function(){};
function close_kbd(){
sft_keyboard.disappear();
sft_keyboard_mask.disappear();
set_cursor(sobj,null);};
function open_kbd(mytextarea){
sft_keyboard_mask.appear();
sft_keyboard.appear(
{
textarea:mytextarea,
done_cb:function(){
kbd_done_hook();},
cancel_cb:function(){
kbd_cancel_hook();}
});};
var kbd_done_hook=function(){
var text=sc_ss.search_box.getText();
text=text||"";
close_kbd();
sc_ss.gotoCategorySelect(text);};
var kbd_cancel_hook=function(){
var text=sc_ss.search_box.getText();
text=text||"";
sc_ss.search_box.setText(text);
focus.myMoveTo(sc_ss.search_box,FOCUS_SPEED);
close_kbd();};

var focus=new Focus();
focus.setSize(1920*2,1080*2);
focus.selected=null;
focus.myMoveTo=function (next,speed){
if(next){
this.selected=next;
this.moveTo(next.focus.pos,next.focus.size,next.focus.angle,speed,next.focus.cb);}else {
console.log("no focus:"+next);}
}
function enableFocus(child,parent){
child.focus={pos:[0,0,0],size:[child.width,child.height]};
child.focus.pos=child.translate.slice(0);var p=parent;
while(p){
child.focus.pos[0]+=p.translate[0];
child.focus.pos[1]+=p.translate[1];
child.focus.pos[2]+=p.translate[2];
p=p.parent;}
}
function disableFocus(child){
child.focus=null;}
function setParent(child,parent,enable_focus){
child.parent=parent;
if(enable_focus){
enableFocus(child,parent);}
parent.components.push(child);}
function focus_moveto(pos,size,angle,speed,func){
focus.moveTo(pos,size,angle,speed,func);};
var unlock_popup=new LockPasswordPanel(
function(){var opt=unlock_popup.launch_opt;
var report=opt.report;
delete opt.report;
apputil.launch_apl(opt.product_id,opt.arg,"pass",report,null,opt.stage_symbol);
},
function(){unlock_popup.enable=false;
unlock_popup.onFocus(false);
unlock_popup.setShow(false);
focus.myMoveTo(sc_ss.category_panel.net_cat_btn[0]);},
focus_moveto
);
var confirm_popup=new Confirmpanel(Confirmpanel.prototype.OPTION_TYPE_OK,
[
function(){
confirm_popup.onFocus(false);
confirm_popup.setShow(false);
confirm_popup.enable=false;
focus.myMoveTo(sc_ss.category_panel.net_cat_btn[0]);}
],
focus_moveto);
confirm_popup.setSize(1080,420);
function launchAppliction(product_id,arg,from){
var opt={};
opt.product_id=product_id;
opt.arg=arg||"";
if(product_id==search_settings.BROWSER_PRODUCT_ID)
opt.stage_symbol="platinum_main";
var rval=apputil.launch_apl(product_id,arg,"check",{action:"search",from:from},null,opt.stage_symbol);
switch(rval){
case apputil.CODE.NETWORK_DL_CONFIRM:
transit(sc_ss,null);
break;
case apputil.CODE.NETWORK_DL_PREPARE:
confirm_popup.launch_opt=opt;
confirm_popup.setMessageText(LANG("LT_APPS_PREPARE_MESSAGE"));
confirm_popup.enable=true;
confirm_popup.setShow(true);
confirm_popup.onFocus(true);
break;
case apputil.CODE.LOCKED:
opt.report={action:"search",from:from};
unlock_popup.launch_opt=opt;
unlock_popup.enable=true;
unlock_popup.setShow(true);
unlock_popup.onFocus(true);
break;
case apputil.CODE.NETWORK_ERROR:
break;
case apputil.CODE.SUCCESS:
case apputil.CODE.ALREADY_LAUNCHED:
case apputil.CODE.DISCLAIMER:
break;
case apputil.CODE.NO_MODULE:
case apputil.CODE.NO_INFO_PLIST:
case apputil.CODE.NO_PRODUCT_ID:
case apputil.CODE.LAUNCH_ERROR:
break;
default:break;}
return true;}
function initSearchScreen(){
var base=new container({translate:[0,0,0],visible_p:false});
setParent(
new gbox({width:1920,height:1080,color:COL_BASE}),
base
);
setParent(
new gimage({width:1920,height:1080,color:COL_TEXT_SUB_ONBASE,
src:IMG_PATH+"apps_back_gradation.png",draw_type:DIRECT,blend:true}),
base
);
function show_color_map(){
var colors=[
[COL_BASE,"COL_BASE"],
[COL_BASE_A,"COL_BASE_A"],
[COL_BASE_SUB,"COL_BASE_SUB"],
[COL_BASE_SUB_A,"COL_BASE_SUB_A"],
[COL_TEXT_ONBASE,"COL_TEXT_ONBASE"],
[COL_TEXT_ONBASE_A,"COL_TEXT_ONBASE_A"],
[COL_TEXT_SUB_ONBASE,"COL_TEXT_SUB_ONBASE"],
[COL_ICON_ONBASE,"COL_ICON_ONBASE"],
[COL_BORDER_ONBASE,"COL_BORDER_ONBASE"],
[COL_BTN,"COL_BTN"],
[COL_BTN_BORDER,"COL_BTN_BORDER"],
[COL_POINT_ONBASE,"COL_POINT_ONBASE"],
[COL_WIDGET_SUB,"COL_WIDGET_SUB"],
[COL_POP,"COL_POP"],
[COL_POP_A,"COL_POP_A"],
[COL_POP_BORDER,"COL_POP_BORDER"],
[COL_POINT,"COL_POINT"],
[COL_TEXT_ONPOINT,"COL_TEXT_ONPOINT"],
[COL_TEXT_SUB_ONPOINT,"COL_TEXT_SUB_ONPOINT"],
[COL_ICON_ONPOINT,"COL_ICON_ONPOINT"],
[COL_BORDER_ONPOINT,"COL_BORDER_ONPOINT"],
[COL_FCS,"COL_FCS"],
];
for(var i=0;i<colors.length;i++){
console.log(i+": "+colors[i][0]+"\t:"+colors[i][1]);
setParent(
new gbox({width:20,height:20,color:colors[i][0],
translate:[1920/2-300,21*i,0]}),
base
);
setParent(
new gtext({width:300,text:i+": "+colors[i][0]+"\t:"+colors[i][1],font_size:15,
translate:[1920/2-150,21*i,0]}),
base
);}
}

setParent(
new gimage(
{translate:[-590,430,0],width:40,height:40,
src:IMG_PATH+"se_loupe.png",color:COL_TEXT_ONBASE,
}),
base
);
setParent(
new gtext(
{translate:[-365,430,0],width:400,height:40,
text:LANG("LT_HOME_SEARCH"),font_size:45,align:LEFT,
color:COL_TEXT_ONBASE,
}),
base
);
base.search_box=new container({translate:[0,350,0]});
var w=1250;
var h=90;
base.search_box.width=w-18;
base.search_box.height=h;
setParent(base.search_box,base,true);
base.search_box.bg=new gbox({translate:[0,0,0],width:w-14,height:h,color:search_settings.COL_KEYWORD_1}),
setParent(base.search_box.bg,base.search_box);
base.search_box.textarea=textarea.create(
{width:base.search_box.width-60,font_size:45,align:LC_TEXT_ALIGN,
passwd_mode:false,char_length_limit:100,singleline:true,unconf_margin:45,
});
base.search_box.textarea.set_text_color(search_settings.COL_KEYWORD_FG);
base.search_box.textarea.set_unconf_bg_param({
color:[235,233,215,255],force_visible:false
});
setParent(base.search_box.textarea,base.search_box);
base.search_box.no_word=new gtext(
{width:base.search_box.width-60,font_size:45,align:LC_TEXT_ALIGN,
text:LANG("LT_SE_ENTER_KEYWORD"),color:search_settings.COL_KEYWORD_FG,omitter:"...",
});
setParent(base.search_box.no_word,base.search_box);
base.search_box.text="";
base.search_box.setText=function (text){
if(!text){
this.text="";
this.textarea.set_text("");
this.no_word.visible_p=true;}else {
this.text=text;
this.textarea.set_text(text);
this.no_word.visible_p=false;}
};
base.search_box.setText();

base.search_box.getText=function (){
return this.textarea.get_text();};
base.search_box.action=function(){
if(sft_keyboard.visible_p)
return;
this.no_word.visible_p=false;
set_cursor(this,sft_keyboard.kb_item);
focus.selected=sft_keyboard;
this.textarea.set_text(this.text);
open_kbd(this.textarea);};

base.gotoCategorySelect=function(text){
base.search_box.setText(text);
if(base.search_box.text!=""){
focus.myMoveTo(base.search_box,FOCUS_SPEED);
base.history_box.addHistory(base.search_box.text);
base.history_container.visible_p=false;
base.search_box.bg.color=search_settings.COL_KEYWORD_2;
base.category_panel.visible_p=true;
focus.myMoveTo(base.category_panel.net_cat_btn[0],FOCUS_SPEED);}else {
focus.myMoveTo(base.search_box,FOCUS_SPEED);}
};

base.history_container=new container({translate:[0,180,0]});
base.history_container.width=1920;
base.history_container.height=66;
setParent(base.history_container,base);
setParent(
new gbox(
{translate:[0,180+(base.history_container.height-2)/2,0],width:1920,height:2,
color:COL_POP_BORDER,
}),
base
);
setParent(
new gbox(
{translate:[0,180-(base.history_container.height-2)/2,0],width:1920,height:2,
color:COL_POP_BORDER,
}),
base
);
setParent(
new gtext(
{translate:[-(1920-200)/2,0,0],width:200,color:COL_TEXT_ONBASE,
text:LANG("LT_SE_HISTORY"),font_size:32,align:RIGHT,
}),
base.history_container
);
setParent(
new gbox(
{translate:[-700,5-2,0],width:6,height:18,
rotation:[45,0,0,1],color:COL_TEXT_ONBASE
}),
base.history_container
);
setParent(
new gbox(
{translate:[-700,-5-2,0],width:6,height:18,
rotation:[-45,0,0,1],color:COL_TEXT_ONBASE
}),
base.history_container
);
w=250;
h=65;
base.history_trash=new container({translate:[(1920-w)/2,0,0]});
base.history_trash.width=w-20;
base.history_trash.height=h;
setParent(base.history_trash,base.history_container,true);
setParent(
new gbox(
{translate:[-w/2,0,0],width:4,height:h-6,
color:COL_BORDER_ONBASE,
}),
base.history_trash
);
setParent(
new gimage(
{translate:[-w/2+40,0,0],width:32,height:32,
src:IMG_PATH+"minus_icon.png",draw_type:DIRECT,
}),
base.history_trash
);
setParent(
new gtext(
{translate:[-w/2+80+160/2,0,0],width:160,color:COL_TEXT_ONBASE,
text:LANG("LT_DELETE"),font_size:32,align:LEFT,
}),
base.history_trash
);
base.history_trash.action=function(){
base.history_box.clearHistory();
focus.myMoveTo(base.search_box,FOCUS_SPEED);
force_redraw();};
base.history_box=new container({translate:[0,0,0]});
base.history_box.width=1320;
base.history_box.height=65;
setParent(base.history_box,base.history_container);
base.history_box.history_text=[];
var margen=20;
w=base.history_box.width/search_settings.HISTORY_SIZE-margen;
var ps=-(base.history_box.width-w)/2;
for(var i=0;i<search_settings.HISTORY_SIZE;i++){
base.history_box.history_text.push(
new gtext(
{translate:[ps+(w+margen)*i,0,0],width:w,color:COL_TEXT_ONBASE,
text:"",font_size:36,align:LC_TEXT_ALIGN,omitter:"...",
})
);
base.history_box.history_text[i].height=65;
setParent(base.history_box.history_text[i],base.history_box,true);}
base.history_box_ho_history=new gtext(
{translate:[0,0,0],width:base.history_box.width,color:COL_TEXT_ONBASE,
text:LANG("LT_SE_NO_HISTORY"),font_size:36,align:LEFT,omitter:"...",
});
setParent(base.history_box_ho_history,base.history_container);
base.history_box.initHistory=function (){
this.text=[];
try{
this.list=eval(apps_nvram.read("search_history",search_settings.PRODUCT_ID));
console.log("read nv data:"+this.list);}catch(e){
this.list=null;
console.log("read nv data: none");}
if(this.list){
if(this.list.length>0){
if(this.list.length>search_settings.HISTORY_SIZE){
this.list.splice(search_settings.HISTORY_SIZE);}
this.index=0;}
}else {
this.list=[];}
for(i=0;i<search_settings.HISTORY_SIZE;i++){
if(i<this.list.length){
setf_text(this.history_text[i],this.list[i]);
enableFocus(this,this.history_text[i]);}else {
setf_text(this.history_text[i],"");}
}
if(this.list.length==0){
base.history_box_ho_history.visible_p=true;}else {
base.history_box_ho_history.visible_p=false;}
};
base.history_box.initHistory();
base.history_box.saveHistory=function (){
if(this.list.length>0){
var write_data=convertArrayToJson(this.list);
var i=0;
for(i=0;i<this.list.length;i++){
if(write_data.length<search_settings.HISTORY_NV_SIZE){
break;}else {
this.list.splice(this.history_text.length-1,1);}
}
if(i!=0){
console.log("nvram too large, some history is cut)");}
try{
console.log("write nv data:"+write_data);
apps_nvram.write("search_history",write_data,search_settings.PRODUCT_ID);}catch(e){
console.log("write nv error, data:"+write_data);
perror(e);};}else {
apps_nvram.write("search_history","",search_settings.PRODUCT_ID);}
};
base.history_box.clearHistory=function (){
this.list=[];
this.saveHistory();
this.initHistory();};

base.history_box.addHistory=function (text){
var i=0;
if(this.list.length>0){
for(i=0;i<this.list.length;i++){
if(text==this.list[i]){
break;}
}
if(i==0){
return;}
if(i!=this.list.length){
this.list.splice(i,1);}
}
if(this.list.length>=search_settings.HISTORY_SIZE){
this.list.splice(this.list.length-1,1);}
this.list.unshift(text);
for(i=0;i<this.list.length;i++){
this.history_text[i].color[3]=255;
setf_text(this.history_text[i],this.list[i]);}
this.saveHistory();
base.history_box_ho_history.visible_p=false;};
for(var i=0;i<search_settings.HISTORY_SIZE;i++){
base.history_box.history_text[i].action=function(obj){
if(sft_keyboard.visible_p)
return;
var idx=findIndexOfList(obj,base.history_box.history_text);
set_cursor(this,sft_keyboard.kb_item);
focus.selected=sft_keyboard;
base.search_box.no_word.visible_p=false;
base.search_box.textarea.set_text(base.history_box.list[idx]);
open_kbd(base.search_box.textarea);};}
setParent(sft_keyboard_mask,base);
setParent(sft_keyboard,base);
base.search_box.keymove=function (from,key){
if(key==TXK_DOWN){
var b=base.history_box;
if(b.list.length>0){
try{
focus.myMoveTo(b.history_text[0],FOCUS_SPEED);}catch(e){
}
return true;}
}
return false;};
for(var i=0;i<search_settings.HISTORY_SIZE;i++){
base.history_box.history_text[i].keymove=function(from,key){var i=findIndexOfList(from,base.history_box.history_text);

if(i<0){
return false;}

switch(key){
case TXK_UP:
focus.myMoveTo(base.search_box,FOCUS_SPEED);
return true;
case TXK_LEFT:
if(i>0){
focus.myMoveTo(base.history_box.history_text[i-1],FOCUS_SPEED);
return true;}
break;
case TXK_RIGHT:
if(i==base.history_box.list.length-1){
focus.myMoveTo(base.history_trash,FOCUS_SPEED);}else {
focus.myMoveTo(base.history_box.history_text[i+1],FOCUS_SPEED);}
break;}
return false;};}
base.history_trash.keymove=function(from,key){
switch(key){
case TXK_UP:
focus.myMoveTo(base.search_box,FOCUS_SPEED);
return true;
case TXK_LEFT:
var b=base.history_box;
if(b.list.length>0){
focus.myMoveTo(b.history_text[b.list.length-1],FOCUS_SPEED);}else {
focus.myMoveTo(base.search_box,FOCUS_SPEED);}
return true;}
return false;};
base.category_panel=initCategoryPanel([0,-170,0]);
setParent(base.category_panel,base);
base.key_hook=function (up_down,key){
if(up_down!=KEY_PRESS)return false;
if(focus.selected==sft_keyboard){
return sft_keyboard.key_hook(up_down,key);}
switch(key){
case TXK_UP:
case TXK_DOWN:
case TXK_LEFT:
case TXK_RIGHT:
try{
if(focus.selected.keymove){
return focus.selected.keymove(focus.selected,key);}
}catch(e){
}
break;
case TXK_ENTER:
if(focus.selected.action){
return focus.selected.action(focus.selected);}
case TXK_RETURN:
try{
if(base.category_panel.visible_p){
base.category_panel.visible_p=false;
base.history_container.visible_p=true;
base.search_box.bg.color=search_settings.COL_KEYWORD_1;
focus.myMoveTo(base.search_box,FOCUS_SPEED);
return true;}
}catch(e){
}
break;}
return false;};
base.in_hook=function(prev_stage){
base.translate=[0,0,0];
if(prev_stage){
focus.setShow(false);
focus.myMoveTo(base.search_box,10000);}else {
focus.setShow(true);
focus.myMoveTo(base.search_box);}
base.visible_p=true;
focus.setShow(true);};
base.out_hook=function(next_stage){
focus.setShow(false);
};

return base;}
function initCategoryPanel(pos){
var net_cat=[];
var launch_browser=function(obj){
weblink.set({"launch_from":weblink.CODE.HOME_SEARCH,
"category":obj.launch_opt.category,
"search_engine":weblink.ENGINE_CODE.DEFAULT,
"keyword":sc_ss.search_box.text||""});
return launchAppliction(search_settings.BROWSER_PRODUCT_ID,null,obj.launch_opt.from);};
var net_cat_all={
web:{tag:"web",thumb:IMG_PATH+"se_net.png",action:launch_browser,
launch_opt:{category:1,from:"web"},title:LANG("LT_SE_NET")},
web_photo:{tag:"web_photo",thumb:IMG_PATH+"se_net_img.png",action:launch_browser,
launch_opt:{category:2,from:"web_photo"},title:LANG("LT_ASR_DIC_IMAGES")},
web_video:{tag:"web_video",thumb:IMG_PATH+"se_net_video.png",action:launch_browser,
launch_opt:{category:3,from:"web_video"},title:LANG("LT_SE_DIC_VIDEOS")},
web_news:{tag:"web_news",thumb:IMG_PATH+"se_net_news.png",action:launch_browser,
launch_opt:{category:4,from:"web_news"},title:LANG("LT_SE_NEWS")},
web_map:{tag:"web_map",thumb:IMG_PATH+"se_net_map.png",action:launch_browser,
launch_opt:{category:5,from:"web_map"},title:LANG("LT_SE_MAP")},
};
net_cat.push(net_cat_all["web"]);
net_cat.push(net_cat_all["web_photo"]);
try{
if(!system.mdl_cfg.with_mystream)
net_cat.push(net_cat_all["web_video"]);}catch(e){};
net_cat.push(net_cat_all["web_news"]);
net_cat.push(net_cat_all["web_map"]);
var spec={};
if(system.mdl_cfg.with_mystream){
spec.mst_enabled=true;
spec.mst_video_enabled=true;
if(system.mdl_cfg.epg_search_type)spec.mst_epg_enabled=true;
if(system.mdl_cfg.with_rec_search)spec.mst_rec_enabled=true;
spec.mst_media=true;}else {
spec.media=true;
if(system.mdl_cfg.with_rec_search==system.mdl_cfg.SEARCH_ENABLE)spec.rec=true;
if(system.mdl_cfg.epg_search_type==system.mdl_cfg.EPG_SEARCH_JP)spec.epg_jp=true;
if(system.mdl_cfg.epg_search_type==system.mdl_cfg.EPG_SEARCH_PAL)spec.epg_pal=true;}
var launch_app=function (obj){
try{
apps_nvram_file.write(
{filename:search_settings.NV_FILE,
data:sc_ss.search_box.text,
async:false,
product_id:search_settings.PRODUCT_ID,
});
return launchAppliction(obj.launch_opt.pid,obj.launch_opt.arg,obj.launch_opt.from);}catch(e){
perror(e);}
};
var prof_id=" ";
if(system.user_profile&&system.user_profile.supported){
try{
var uprofile=system.user_profile.get({mhc:{id:null}});
if(uprofile&&uprofile.mhc&&isNumber(uprofile.mhc.id)){
prof_id=" -U "+uprofile.mhc.id+" ";}
}catch(e){console.log("[info] can not get uprofile.mhc.id");}
}
var local_cat_all={
epg_jp:{thumb:IMG_PATH+"se_local_program.png",title:LANG("LT_SE_PROGRAM_GUIDE"),action:launch_app,
launch_opt:{pid:search_settings.EPG_JP_PRODUCT_ID,arg:"-F "+NV_PATH,from:"epg"}},
epg_pal:{thumb:IMG_PATH+"se_local_program.png",title:LANG("LT_SE_PROGRAM_GUIDE"),action:launch_app,
launch_opt:{pid:search_settings.EPG_PAL_PRODUCT_ID,arg:"-F "+NV_PATH,from:"epg"}},
rec:{thumb:IMG_PATH+"se_local_recorded.png",title:LANG("LT_SE_RECORDED_TV"),action:launch_app,
launch_opt:{pid:search_settings.CSEARCH_PRODUCT_ID,arg:"-c 1 -k "+NV_PATH,from:"rec"}},
media:{thumb:IMG_PATH+"se_local_media.png",title:LANG("LT_SE_STORED_CONTENT"),action:launch_app,
launch_opt:{pid:search_settings.CSEARCH_PRODUCT_ID,arg:"-c 2 -k "+NV_PATH,from:"media"}},

mst:{thumb:IMG_PATH+"se_mst.png",title:LANG("LT_MYSTREAM"),action:launch_app,
launch_opt:{pid:search_settings.MYSTREAM_PRODUCT_ID,
arg:"-c 1 -k "+NV_PATH+prof_id,from:"mst"}},
mst_video:{thumb:IMG_PATH+"se_mst_video.png",title:LANG("LT_SE_DIC_VIDEOS"),action:launch_app,
launch_opt:{pid:search_settings.MYSTREAM_PRODUCT_ID,
arg:"-c 2 -k "+NV_PATH+prof_id,from:"mst_video"}},
mst_epg:{thumb:IMG_PATH+"se_mst_epg.png",title:LANG("LT_SE_PROGRAM_GUIDE"),action:launch_app,
launch_opt:{pid:search_settings.MYSTREAM_PRODUCT_ID,
arg:"-c 3 -k "+NV_PATH+prof_id,from:"mst_epg"}},
mst_rec:{thumb:IMG_PATH+"se_mst_rec.png",title:LANG("LT_SE_RECORDED_TV"),action:launch_app,
launch_opt:{pid:search_settings.MYSTREAM_PRODUCT_ID,
arg:"-c 4 -k "+NV_PATH+prof_id,from:"mst_rec"}},
mst_media:{thumb:IMG_PATH+"se_mst_media.png",title:LANG("LT_SE_STORED_CONTENT"),action:launch_app,
launch_opt:{pid:search_settings.MYSTREAM_PRODUCT_ID,
arg:"-c 5 -k "+NV_PATH+prof_id,from:"mst_media"}},
};

var local_cat=[];
if(spec.epg_jp)local_cat.push(local_cat_all["epg_jp"]);
if(spec.epg_pal)local_cat.push(local_cat_all["epg_pal"]);
if(spec.rec)local_cat.push(local_cat_all["rec"]);
if(spec.media)local_cat.push(local_cat_all["media"]);
if(spec.mst_enabled)local_cat.push(local_cat_all["mst"]);
if(spec.mst_video_enabled)local_cat.push(local_cat_all["mst_video"]);
if(spec.mst_epg_enabled)local_cat.push(local_cat_all["mst_epg"]);
if(spec.mst_rec_enabled)local_cat.push(local_cat_all["mst_rec"]);
if(spec.mst_media)local_cat.push(local_cat_all["mst_media"]);

var base=new container({translate:pos,visible_p:false});
base.width=1920;
base.height=820;
base.cat_desc=new container({translate:[0,(-100+820/2),0]});
base.cat_desc.width=1920;
base.cat_desc.height=60;
setParent(
new gtext(
{translate:[0,40,0],width:base.cat_desc.width,
text:LANG("LT_SE_WHICH_USE"),font_size:36,align:CENTER,
color:COL_TEXT_ONBASE,
}),
base.cat_desc
);
setParent(base.cat_desc,base);
function create_icon(xpos,ypos,img_path,title){
var icn=new container({translate:[xpos,ypos,0]});
icn.width=160;
icn.height=160;
setParent(
new gimage(
{translate:[0,0,0],width:162,height:162,
draw_type:INSCRIBED,src:img_path
}),
icn
);
setParent(
new gtext(
{translate:[0,-icn.width/2-24,0],width:icn.width+100,
text:title,font_size:30,align:CENTER,
color:COL_TEXT_ONBASE,
}),
icn
);
return icn;}
var icon_xpos=[
[0],
[-135,135],
[-270,0,270],
[-405,-135,135,405],
[-540,-270,0,270,540],
];
base.net_cat_btn=[];
for(var i=0;i<net_cat.length;i++){
base.net_cat_btn[i]=create_icon(icon_xpos[net_cat.length-1][i],(-250+820/2),
net_cat[i].thumb,net_cat[i].title);
setParent(base.net_cat_btn[i],base,true);
base.net_cat_btn[i].launch_opt=net_cat[i].launch_opt;
base.net_cat_btn[i].action=net_cat[i].action;
base.net_cat_btn[i].keymove=function(from,key){
var idx=findIndexOfList(from,base.net_cat_btn);
switch(key){
case TXK_LEFT:
if(idx>0){
focus.myMoveTo(base.net_cat_btn[idx-1],FOCUS_SPEED);
return true;}
break;
case TXK_RIGHT:
if(idx<base.net_cat_btn.length-1){
focus.myMoveTo(base.net_cat_btn[idx+1],FOCUS_SPEED);
return true;}
break;
case TXK_DOWN:
focus.myMoveTo(base.local_cat_btn[0],FOCUS_SPEED);
return true;}
return false;};}
base.local_cat_btn=[];
for(var i=0;i<local_cat.length;i++){
base.local_cat_btn[i]=create_icon(icon_xpos[local_cat.length-1][i],(-550+820/2),
local_cat[i].thumb,local_cat[i].title);
setParent(base.local_cat_btn[i],base,true);
base.local_cat_btn[i].launch_opt=local_cat[i].launch_opt;
base.local_cat_btn[i].action=local_cat[i].action;
base.local_cat_btn[i].keymove=function(from,key){
var idx=findIndexOfList(from,base.local_cat_btn);
switch(key){
case TXK_LEFT:
if(idx>0){
focus.myMoveTo(base.local_cat_btn[idx-1],FOCUS_SPEED);
return true;}
break;
case TXK_RIGHT:
if(idx<base.local_cat_btn.length-1){
focus.myMoveTo(base.local_cat_btn[idx+1],FOCUS_SPEED);
return true;}
break;
case TXK_UP:
focus.myMoveTo(base.net_cat_btn[0],FOCUS_SPEED);
return true;}
return false;};}
var min_fontsize=28;
var tmp_min;
for(var i=0;i<local_cat.length;i++){
tmp_min=getFontSizeOfText(base.local_cat_btn[i].components[1],local_cat[i].title,12);
min_fontsize=tmp_min<min_fontsize?tmp_min:min_fontsize;}
for(var i=0;i<net_cat.length;i++){
tmp_min=getFontSizeOfText(base.net_cat_btn[i].components[1],net_cat[i].title,12);
min_fontsize=tmp_min<min_fontsize?tmp_min:min_fontsize;}
for(var i=0;i<local_cat.length;i++){
var v=base.local_cat_btn[i].components[1];
v.font_size=min_fontsize;
setf_text(v,v.text);}
for(var i=0;i<net_cat.length;i++){
var v=base.net_cat_btn[i].components[1];
v.font_size=min_fontsize;
setf_text(v,v.text);}
return base;}
var sc_ss=initSearchScreen();
var sc_cur=sc_ss;
function transit(sc_prev,sc_next){
if(sc_prev){
sc_prev.out_hook(sc_next);}
if(sc_next){
sc_cur=sc_next;
sc_next.in_hook(sc_prev);
force_redraw();}else {
try{discard_stage("search");}catch(e){};
try{discard_package("kbd");}catch(e){};
try{discard_package("textarea");}catch(e){};
on_stage("HOME");}
}
var sobj=stage({
symbol:"search",
in:[
{from:["default"],
hook:function (obj){
if(ebus.mouse){
add_event_hook(ebus.mouse,mouse_hook);
ebus.mouse.set_callback_symbol("click","action");}
if(ebus.asr)
sobj.add_event_hook(ebus.asr,asr_hook);
InputDevManager.init();
transit(null,sc_cur);
obj.translate=[0,1080,1];
sc_cur.in_hook(obj);
obj.moveTo=MoveTo;
var timer_obj={};
append_timer(timer_obj,120,function(tobj,count){
delete_timer(tobj);
obj.moveTo({x:0,y:0,z:1,rate:0.3,count:12,end_func:function(){
focus.setShow(true);
ebus.asr.set_listener(1);
complete_on_stage(obj);
LogReport.report(LogReport.OPERATE_HS,"hs.search",{action:"start",pos:"-1"});}});});
}
}
],
out:[
{to:["default"],hook:function(obj){
if(ebus.asr)
sobj.del_event_hook(ebus.asr);
obj.moveTo({x:0,y:1080,z:1,rate:0.3,count:15,end_func:function(){
complete_off_stage(obj);}});},
to:["platinum_main"],hook:function(obj){
if(ebus.asr)
sobj.del_event_hook(ebus.asr);
complete_off_stage(obj);},},
],
components:[
sc_ss,
unlock_popup,
confirm_popup,
focus,
],
key_hook:function(up_down,key){
if(up_down==KEY_PRESS){
if((key==TXK_UP)||(key==TXK_DOWN)||(key==TXK_LEFT)||(key==TXK_RIGHT)){
if(InputDevManager.get_pointer_status()){
InputDevManager.pointer_disappear();}
}
}
if(up_down!=KEY_PRESS)return false;
switch(key){
case TXK_EXIT:
case TXK_HOME:
try{discard_package("kbd");}catch(e){};
try{discard_package("textarea");}catch(e){};
return false;
break;}
if(unlock_popup.enable){
return unlock_popup.key_hook(up_down,key);}else if(confirm_popup.enable){
return confirm_popup.key_hook(up_down,key);}else {
var key_consume=false;
if(sc_cur){
key_consume=sc_cur.key_hook(up_down,key);}
if(!key_consume){
if(up_down!=KEY_PRESS)return false;
switch(key){
case TXK_RETURN:
transit(sc_ss,null);
return true;}
}
}
return false;},
});
