var APP_NAME="GUIDANCE";
var GUIDANCE_IMG_PATH=PATH+"guidance/img/";
var GUIDANCE_MSG=load_pkg_lang(PATH+"guidance/lang",APP_NAME);
var GUIDANCE_ASR_MSG=load_pkg_asr(PATH+"guidance/lang",APP_NAME);
var GUIDANCE_TIMEOUT_VAL=180000;
var console_log=function(text){
};
var country=SU_COUNTRY;
country=country.substr(0,2);
var lang=SU_LANGUAGE;
lang=lang.substr(0,2);
switch(lang){
case "bg":
case "hi":
case "th":
case "vi":
case "ar":
case "fa":
case "he":
case "mk":
var is_tts_play_enable_lang=false;
break;
default:
var is_tts_play_enable_lang=true;
break;}
switch(lang){
case "ar":
case "fa":
case "he":
var is_osd_arabic=true;
break;
default:
var is_osd_arabic=false;
break;}
var guidance_voicecmd_my_home="";
try{
guidance_voicecmd_my_home=system.voice_control.voicecmd_my_home||"";}catch(e){}
function Remoteguide(pos){
this.superClass=container;
this.superClass({
translate:pos,
components:[
this.bgimg=new gimage({visible_p:false,translate:[0,0,2],width:255,height:200,
src:GUIDANCE_IMG_PATH+"guidance_msg_back.png",draw_type:DIRECT}),
this.guide=new container({translate:[0,0,2],
components:[
this.img_home=new gimage({width:78,height:31,src:"",translate:[-10,58,2],draw_type:DIRECT}),
this.img_cursor=new gimage({width:96,height:100,src:GUIDANCE_IMG_PATH+"guidance_guide02.png",
translate:[0,0,2],draw_type:DIRECT}),
this.text_enter=new gtext({align:LEFT,font_size:28,width:200,text:GUIDANCE_MSG("LT_TUTORIAL_NEXT"),
translate:[142,38,2],color:[0,0,0,255]}),
this.text_cursor=new gtext({align:LEFT,font_size:28,width:200,text:"",
translate:[142,4,2],color:[0,0,0,255]}),
this.text_exit=new gtext({align:LEFT,font_size:28,width:200,text:GUIDANCE_MSG("LT_TUTORIAL_EXIT"),
translate:[149,-36,2],color:[0,0,0,255]}),
]}),
]});};
function Guidancepanel(type,action_func,focus_moveto){
this.superClass=container;
this.superClass({
components:[
this.bgimg=new gimage({width:1380,height:250,src:GUIDANCE_IMG_PATH+"guidance_msg_back.png",
translate:[0,0,2],rotation:[0,0,0,1],draw_type:DIRECT}),
this.message=new gtextbox({align:(is_osd_arabic?RIGHT:LEFT),
margin_leading:-2,valign:MIDDLE,font_size:38,visible_p:false,translate:[0,0,2],color:[0,0,0,255]}),
this.step=new gtext({align:(is_osd_arabic?LEFT:RIGHT),
font_size:34,visible_p:false,translate:[0,0,2],color:[0,100,100,255]}),
this.buttons=new container({visible_p:true,font_size:34,translate:[0,0,0],}),
this.remocon=new Remoteguide([(is_osd_arabic?-620:620),-30,2]),
]
});

this.visible_p=false;
this.focus_moveto=focus_moveto;
this.cursor=0;

if(type==OPTION_TYPE_NEXT){
this.btn_num=1;
this.btn_list=[new this.Button(0)];}else if(type==OPTION_TYPE_YES_NO){
this.btn_num=2;
this.btn_list=[new this.Button(-150),new this.Button(150)];}else if(type==OPTION_TYPE_YES_NO_CANCEL){
this.btn_num=3;
this.btn_list=[new this.Button(-300),new this.Button(0),new this.Button(300)];}else {
this.btn_num=0;}
for(var i=0;i<this.btn_num;i++){
if(typeof action_func[i]=="function"){
this.btn_list[i].setAction(action_func[i]);}
}
if(this.btn_num>0)
this.buttons.components.push.apply(this.buttons.components,this.btn_list);};
var OPTION_TYPE_NEXT=0;
var OPTION_TYPE_YES_NO=1;
var OPTION_TYPE_YES_NO_CANCEL=3;
Guidancepanel.prototype.width=1600;Guidancepanel.prototype.height=800;Guidancepanel.prototype.cursor=null;Guidancepanel.prototype.buttons=null;Guidancepanel.prototype.btn_list=null;Guidancepanel.prototype.btn_num=null;Guidancepanel.prototype.focus_moveto=function(){console_log("No function to move focus.");};
Guidancepanel.prototype.key_enable=true;
Guidancepanel.prototype.free=function(){
this.bgimg.src="";
setf_text(this.message,"");
setf_text(this.step,"");
for(var i=0;i<this.btn_num;i++){
this.btn_list[i].free();}
this.components.splice(0,this.components.length);};
Guidancepanel.prototype.setMessageText=function(s,step_text){
this.message_text=s;
setf_text(this.message,s);
this.message.visible_p=true;

this.step_text=step_text;
setf_text(this.step,this.step_text);
this.step.visible_p=true;};
Guidancepanel.prototype.tts_play=function(tts_play){
var s=this.message_text;
if(tts_play&&is_tts_play_enable_lang){
s=s.replace(/「/g,"");
s=s.replace(/」/g,"");
ebus.tts.play({"text":s,"force":true});}
};
Guidancepanel.prototype.setMessageTranslate=function(x,y,z){
this.message.translate[0]=x;
this.message.translate[1]=y;
this.message.translate[2]=z;};
Guidancepanel.prototype.setButtonLabel=function(b1,b2,b3){
if(this.btn_num==0)return;
if((b1)&&(this.btn_list[0])){
this.btn_list[0].setText(b1);}
if((b2)&&(this.btn_list[1])){
this.btn_list[1].setText(b2);}
if((b3)&&(this.btn_list[2])){
this.btn_list[2].setText(b3);}
};
Guidancepanel.prototype.setShow=function(b){
if(b){
this.visible_p=true;}else{
this.visible_p=false;}
force_redraw();};
Guidancepanel.prototype.isShow=function(b){
return this.visible_p;};
Guidancepanel.prototype.setTranslate=function(x,y,z){
this.translate[0]=x;
this.translate[1]=y;
this.translate[2]=z;};
Guidancepanel.prototype.getMessagePos=function(text){
var text_width=0;
var text_width_max=0;
var text_list=text.split("\n");

for(var i=0;i<text_list.length;i++){
text_width=get_text_width(this.message,text_list[i]);
if(text_width>text_width_max)
text_width_max=text_width;}

return (this.message.width-text_width_max)/2;};
Guidancepanel.prototype.getTextWidth=function(text){
var text_width=0;
var text_width_max=0;
var text_list=text.split("\n");

for(var i=0;i<text_list.length;i++){
text_width=get_text_width(this.message,text_list[i]);
if(text_width>text_width_max)
text_width_max=text_width;}

return text_width_max;};
Guidancepanel.prototype.adjustPanelSize=function(w,h,auto_adjust_width){
w=Math.floor(w);
h=Math.floor(h);
this.width=w;
this.height=h;
this.bgimg.width=w;
this.bgimg.height=h;

this.message.width=this.width-180;
var text_width=this.getTextWidth(this.message_text);
this.message.width=(text_width<800)?800:text_width;
this.width=this.message.width+180;
this.bgimg.width=this.width;

this.message.height=get_text_font_height(this.message,this.message_text)+20;
this.message.translate[0]=(is_osd_arabic?
-(this.getMessagePos(this.message_text))+10:
this.getMessagePos(this.message_text)-15);
this.message.translate[1]=this.remocon.visible_p?30:(this.btn_num==2)?40:10;
setf_text(this.message,this.message_text);

if(this.btn_num==1){
this.buttons.translate[0]=(is_osd_arabic?
-this.width/2-this.btn_list[0].width*2+180:
this.width/2-this.btn_list[0].width*2-150);
if(this.height<350)
this.buttons.translate[1]=-this.height/2+this.btn_list[0].height+5;
else
this.buttons.translate[1]=-this.height/2+this.btn_list[0].height+30;}else if(this.btn_num==2){
this.buttons.translate[0]=0;
this.buttons.translate[1]=-this.height/2+this.btn_list[0].height+60;}else {
this.buttons.translate[0]=0;
this.buttons.translate[1]=0;}

this.step.width=this.width-100;
this.step.translate[0]=-2;
this.step.translate[1]=this.height/2-this.step.font_size-4;
setf_text(this.step,this.step_text);

this.remocon.translate[0]=(is_osd_arabic?-this.width/2+140:this.width/2-210);
this.remocon.translate[1]=-this.height/2+90;

guidance.remocon.translate[0]=(is_osd_arabic?
(this.width+guidance.remocon.bgimg.width)/2:
-(this.width+guidance.remocon.bgimg.width)/2);};
Guidancepanel.prototype.onFocus=function(b,keysym){
if(b==true){
this.cursor=this.btn_num-1;
this.correctFocus();}else{
return true;}
};
Guidancepanel.prototype.key_hook=function(updown,keysym){
if(updown!=KEY_PRESS)
return false;

switch(keysym){
case TXK_RIGHT:
if(this.btn_num==0)break;
if(this.cursor==this.btn_list.length-1){
return false;}else{
this.cursor++;
this.correctFocus();
return true;}
case TXK_LEFT:
if(this.btn_num==0)break;
if(this.cursor==0){
return false;}else{
this.cursor--;
this.correctFocus();
return true;}
case TXK_ENTER:
if(this.btn_num==0)break;
try{
this.btn_list[this.cursor].action();
return true;}catch(e){
return false;}
default:
break;}
return false;};
Guidancepanel.prototype.correctFocus=function(){
var btn=this.btn_list[this.cursor];
var position=[this.translate[0]+this.buttons.translate[0]+btn.getPosition()[0],
this.translate[1]+this.buttons.translate[1]+btn.getPosition()[1],
this.translate[2]+this.buttons.translate[2]+btn.getPosition()[2]];
this.focus_moveto(position,btn.getSize(),0,42,null);};
Guidancepanel.prototype.Button=function(x){
this.superClass=container;
this.superClass({
translate:[x,0,0],
components:[
this.background=new gbox({width:this.width,height:this.height,
translate:[0,0,2],color:[100,100,100,255],
round_enable:true,round_width:10,round_height:10,}),
this.text=new gtextbox({width:this.width-10,height:this.height,
translate:[0,1,2],
valign:MIDDLE,align:CENTER,}),
]
});};
Guidancepanel.prototype.Button.prototype.width=210;
Guidancepanel.prototype.Button.prototype.height=44;
Guidancepanel.prototype.Button.prototype.background=null;Guidancepanel.prototype.Button.prototype.text=null;Guidancepanel.prototype.Button.prototype.action=function(){};Guidancepanel.prototype.Button.prototype.free=function(){
setf_text(this.text,"");
this.components.splice(0,this.components.length);};
Guidancepanel.prototype.Button.prototype.setText=function(text){
setf_text(this.text,text);
change_font_size_b(this.text);};
Guidancepanel.prototype.Button.prototype.setAction=function(action_func){
this.action=action_func;};
Guidancepanel.prototype.Button.prototype.getPosition=function(){
return this.translate;};
Guidancepanel.prototype.Button.prototype.getSize=function(){
return [this.width-4,this.height];};
var guidance=new container({visible_p:true});
guidance.bgimg=new gimage({width:1920,height:1080,src:"",rotation:[0,0,0,1],
translate:[0,0,2],draw_type:DIRECT,visible_p:false}),
guidance.arrow=new gimage({width:130,height:160,src:GUIDANCE_IMG_PATH+"guidance_arrow.png",
translate:[0,0,2],rotation:[0,0,0,1],draw_type:DIRECT,visible_p:false}),
guidance.mask_window=new gbox({width:500,height:100,color:[0,0,0,0],
translate:[-780,520,2.1],visible_p:false,depth_test:true});
guidance.mask=new gbox({width:1920,height:1080,color:[0,0,0,150],
translate:[0,0,2],visible_p:false,depth_test:true});
guidance.func_image=new container({visible_p:false,width:800,height:474,
components:[
new gimage({translate:[0,50,0],width:800,height:474,draw_type:DIRECT,
src:GUIDANCE_IMG_PATH+"guidance_voice_ctrl_touchpad.png"}),
new gtext({translate:[150,195,0],color:[0,0,0,255],
width:320,align:CENTER,font_size:28,
text:guidance_voicecmd_my_home})]});
guidance.remocon=new Remoteguide([(is_osd_arabic?800:-800),-392,2]);
guidance.remocon.bgimg.visible_p=true;
exit_action_func=function(){
guidance.exit_msg_panel.setShow(false);
if(is_initial_guidance){
if(is_force_fulltv)
guidance.startup_ui_obj.launchTVforTutorial(false);

guidance.scenario=guidance_scenario_exit;
guidance.current_step=0;

if((guidance.startup_ui_obj.UI_MODE==guidance.startup_ui_obj.MY_SCREEN)&&
((is_tv_centric&&guidance.get_screen_pos()==0)||
(not_is_tv_centric&&guidance.get_screen_pos()==1)||
(guidance.scenario[guidance.current_step][0]=="mes_return_home_selection"))){
guidance.next_run_scenario();}
else
{
if(is_tv_centric)
guidance.startup_ui_obj.jumpTemplateScreen("tv",function(){guidance.next_run_scenario()});
else
guidance.startup_ui_obj.jumpFirstScreen(function(){guidance.next_run_scenario()});}
}else {
if(guidance.startup_ui_obj.UI_MODE!=guidance.startup_ui_obj.MY_SCREEN)
guidance.send_key(TXK_HOME);
guidance.term_request(0);}
};
cancel_action_func=function(){
guidance.exit_msg_panel.setShow(false);
guidance.run_scenario();};
focus_moveto_func=function(){
if(this.cursor==0){
this.btn_list[0].background.color=[255,204,0,200];
this.btn_list[0].text.color=[0,0,0,255];
this.btn_list[1].background.color=[100,100,100,255];
this.btn_list[1].text.color=[255,255,255,255];}else {
this.btn_list[0].background.color=[100,100,100,255];
this.btn_list[0].text.color=[255,255,255,255];
this.btn_list[1].background.color=[255,204,0,200];
this.btn_list[1].text.color=[0,0,0,255];}
force_redraw();};
guidance.next_action_func=function(){
delete_timer(this);
append_timer(this,250,this.next_run_scenario);};
guidance.msg_panel=new Guidancepanel(OPTION_TYPE_NEXT,[this.next_action_func],null);
guidance.msg_panel.cursor=0;
guidance.msg_panel.btn_list[0].background.color=[255,204,0,200];
guidance.msg_panel.btn_list[0].text.color=[0,0,0,255];
AnimationGraphics.apply(guidance.msg_panel.message);
AnimationGraphics.apply(guidance.msg_panel);
guidance.exit_msg_panel=new Guidancepanel(OPTION_TYPE_YES_NO,
[exit_action_func,cancel_action_func],
focus_moveto_func);
guidance.components.push(guidance.bgimg,
guidance.mask_window,
guidance.mask,
guidance.arrow,
guidance.func_image,
guidance.remocon,
guidance.msg_panel,
guidance.exit_msg_panel);
guidance.mask_window.blink=function (){
this.visible_p=(this.visible_p?false:true);
force_redraw();};
guidance.next_run_scenario=function (){
var prev_event_type=this.scenario[this.current_step][3];

this.prev_step=this.current_step;
this.current_step++;

if((prev_event_type=="message-next")||
(prev_event_type=="message-recognition")||
(prev_event_type=="message-home")||
(prev_event_type=="message-lr-ok")||
(prev_event_type=="message-udlr-ok"))
this.current_msg_step++;

for(var i=this.current_step;i<this.scenario.length;i++){
if(this.scenario[i][1]&&this.scenario[i][2]){
this.current_step=i;
break;}
}
if(this.current_step>=this.scenario.length){
this.term_request(1);
return;}

this.delete_all_timer();
this.run_scenario();};
guidance.send_key=function (keysym){
IS_SENDING_SCENARIO_KEY=true;
this.startup_ui_obj.key_hook(KEY_DOWN,keysym);
this.startup_ui_obj.key_hook(KEY_PRESS,keysym);
this.startup_ui_obj.key_hook(KEY_UP,keysym);
IS_SENDING_SCENARIO_KEY=false;};
guidance.get_screen_pos=function (){
var info=this.startup_ui_obj.interface2Tutorial.getScreenInfo();
return info.pos;};
var return_home_retry_counter=0;
guidance.return_home_timer=function (){
var info=this.startup_ui_obj.interface2Tutorial.getScreenInfo();

delete_timer(this);

if(return_home_retry_counter>5){
this.term_request(0);
return;}
if(this.startup_ui_obj.UI_MODE==this.startup_ui_obj.MY_SCREEN){
append_timer(this,2000,this.next_run_scenario);
return;}

return_home_retry_counter++;
append_timer(this,2000,this.return_home_timer);};
guidance.get_bookmark_pos_x=function (){
var pos_x=0;
http_request({url:"file:///usr/local/application/0077777700140002/gadget/guidance/"+
(system.mdl_cfg.with_browser_with_tv?
"guidance_browse_with_tv.json":"guidance_browse.json"),
sync:true,method:"GET",
onload:function(status,header,body){
try{
if(status==200){
browser_setting=eval(body);
pos_x=browser_setting.add_bookmark_pos_x;}else{
console.log("Cannot find guidance_browse json.");}
}catch(e){
console.log(e.message);}
}
});
return pos_x;};
guidance.set_masking=function (masking){
switch(masking)
{
case "fullmask":
this.mask_window.translate[0]=0;
this.mask_window.translate[1]=0;
this.mask_window.width=1920;
this.mask_window.height=1080;
this.mask_window.visible_p=false;
this.mask.visible_p=true;
this.arrow.visible_p=false;
break;
case "without_home_selection":
this.mask_window.translate[0]=0;
this.mask_window.translate[1]=155;
this.mask_window.width=1920;
this.mask_window.height=800;
this.mask_window.visible_p=true;
this.mask.visible_p=true;
this.arrow.visible_p=false;
break;
case "without_help":
if(country=="JP"){
this.mask_window.translate[0]=600;
this.mask_window.width=300;
this.arrow.translate[0]=600;}else {
this.mask_window.translate[0]=640;
this.mask_window.width=250;
this.arrow.translate[0]=640;}
this.mask_window.translate[1]=530;
this.mask_window.height=100;
this.mask_window.visible_p=false;
this.mask.visible_p=true;
this.arrow.translate[1]=415;
this.arrow.visible_p=true;
append_timer(this.mask_window,500,this.mask_window.blink);
break;
case "without_apps":
if(country=="JP"){
this.mask_window.translate[0]=-10;
this.arrow.translate[0]=-10;}else {
this.mask_window.translate[0]=20;
this.arrow.translate[0]=20;}
this.mask_window.translate[1]=520;
this.mask_window.width=250;
this.mask_window.height=100;
this.mask_window.visible_p=false;
this.mask.visible_p=true;
this.arrow.translate[1]=415;
this.arrow.visible_p=true;
append_timer(this.mask_window,500,this.mask_window.blink);
break;
case "without_registered_bookmark":
this.mask_window.translate[0]=664;
this.mask_window.translate[1]=325;
this.mask_window.width=430;
this.mask_window.height=305;
this.mask_window.visible_p=false;
this.mask.visible_p=true;
this.arrow.visible_p=false;
append_timer(this.mask_window,500,this.mask_window.blink);
break;
case "without_registered_bookmark_4k":
this.mask_window.translate[0]=664;
this.mask_window.translate[1]=215;
this.mask_window.width=430;
this.mask_window.height=530;
this.mask_window.visible_p=false;
this.mask.visible_p=true;
this.arrow.visible_p=false;
append_timer(this.mask_window,500,this.mask_window.blink);
break;
case "without_bookmark_plus":
var bookmark_pos_x=this.get_bookmark_pos_x();
this.mask_window.translate[0]=bookmark_pos_x;
this.mask_window.translate[1]=535;
this.mask_window.width=80;
this.mask_window.height=150;
this.mask_window.visible_p=false;
this.mask.visible_p=true;
this.arrow.translate[0]=bookmark_pos_x;
this.arrow.translate[1]=390;
this.arrow.visible_p=true;
append_timer(this.mask_window,500,this.mask_window.blink);
break;
case "mask-clear":
default:
this.mask.visible_p=false;
this.mask_window.visible_p=false;
this.arrow.visible_p=false;
break;}
};
guidance.run_scenario=function (){
var event_name=this.scenario[this.current_step][0];
var event_type=this.scenario[this.current_step][3];
var duration=this.scenario[this.current_step][4];
var keysym=this.scenario[this.current_step][5];
var msg_text=this.scenario[this.current_step][6];
var msg_text_cn=this.scenario[this.current_step][7];
var sel_text=this.scenario[this.current_step][8];
var msg_pos=this.scenario[this.current_step][9];
var masking=this.scenario[this.current_step][10];
var effect=this.scenario[this.prev_step][11];

if(country=="CN"&&(msg_text_cn.substr(0,2)=="LT"))
msg_text=msg_text_cn;

console_log("[STEP]:"+this.current_step+" : "+
event_type+" : "+duration+" : "+keysym+" : "+msg_text+" : "+
sel_text+" : "+msg_pos+" : "+masking+" : "+effect);

ebus.tts.stop();
delete_timer(this.msg_panel);
delete_timer(this.mask_window);
this.remocon.visible_p=false;
this.func_image.visible_p=false;

if(effect=="clear-message")
this.msg_panel.setShow(false);

this.set_masking(masking);

force_redraw();

switch(event_type)
{
case "message-opening":
case "message-closing":
case "message-next-closing":
case "message-next":
case "message-recognition":
case "message-home":
case "message-lr-ok":
case "message-udlr-ok":

if((event_type=="message-opening")||
(event_type=="message-closing")||
(event_type=="message-next-closing")){
guidance.msg_panel.key_enable=true;}else {
guidance.msg_panel.key_enable=false;
append_timer(guidance.msg_panel,2000,function(){guidance.msg_panel.key_enable=true;});}

var textMsg=GUIDANCE_MSG(msg_text);
if(event_type=="message-recognition"){
textMsg=textMsg.replace("%s",guidance_voicecmd_my_home);}
this.msg_panel.setMessageText(textMsg,
((event_type=="message-opening"||
event_type=="message-closing"||
event_type=="message-next-closing")?"":
(this.current_msg_step+"/"+this.total_msg_step)));

if(event_type=="message-next"||
event_type=="message-recognition"||
event_type=="message-next-closing"){
this.msg_panel.setButtonLabel(GUIDANCE_MSG("LT_TUTORIAL_NEXT"));
this.msg_panel.btn_list[0].translate[0]=400;
this.msg_panel.btn_list[0].visible_p=true;
this.msg_panel.message.translate[1]=10;}else {
this.msg_panel.setButtonLabel("");
this.msg_panel.btn_list[0].visible_p=false;
this.msg_panel.message.translate[1]=0;}

if(event_type=="message-opening"){
this.msg_panel.remocon.visible_p=true;
this.remocon.visible_p=false;}else if(event_type=="message-home"){
this.msg_panel.remocon.visible_p=false;
this.remocon.visible_p=true;
this.remocon.guide.translate[0]=0;
this.remocon.guide.translate[1]=-10;
this.remocon.img_home.src=this.startup_ui_obj.HOME_KEY;
if(this.startup_ui_obj.HOME_KEY_LAYOUT=="LOWER"){
this.remocon.img_cursor.translate[1]=25;
this.remocon.img_home.width=64;
this.remocon.img_home.height=25;
this.remocon.img_home.translate[1]=-35;}else if(this.startup_ui_obj.HOME_KEY_LAYOUT=="SIDE"){
this.remocon.img_home.width=62;this.remocon.img_home.height=24;
this.remocon.img_home.translate=[35,30,6];
this.remocon.img_home.rotation=[60,0,0,-1];}else {
this.remocon.img_cursor.translate[1]=0;}
this.remocon.img_cursor.src=GUIDANCE_IMG_PATH+"guidance_guide01.png";
setf_text(this.remocon.text_enter,"");
setf_text(this.remocon.text_cursor,"");
setf_text(this.remocon.text_exit,"");}else if(event_type=="message-lr-ok"){
this.msg_panel.remocon.visible_p=false;
this.remocon.visible_p=true;
var text_width=get_text_width(this.remocon.text_cursor,GUIDANCE_MSG("LT_MHS_TUTORIAL_SELECT"));
this.remocon.guide.translate[0]=-(text_width/2);
this.remocon.guide.translate[1]=-5;
this.remocon.img_home.src="";
this.remocon.img_cursor.translate[1]=0;
this.remocon.img_cursor.src=GUIDANCE_IMG_PATH+"guidance_guide03.png";
setf_text(this.remocon.text_enter,GUIDANCE_MSG("LT_MHS_TUTORIAL_OK"));
setf_text(this.remocon.text_cursor,GUIDANCE_MSG("LT_MHS_TUTORIAL_SELECT"));
setf_text(this.remocon.text_exit,"");}else if(event_type=="message-udlr-ok"){
this.msg_panel.remocon.visible_p=false;
this.remocon.visible_p=true;
var text_width=get_text_width(this.remocon.text_cursor,GUIDANCE_MSG("LT_MHS_TUTORIAL_SELECT"));
this.remocon.guide.translate[0]=-(text_width/2);
this.remocon.guide.translate[1]=-5;
this.remocon.img_home.src="";
this.remocon.img_cursor.translate[1]=0;
this.remocon.img_cursor.src=GUIDANCE_IMG_PATH+"guidance_guide04.png";
setf_text(this.remocon.text_enter,GUIDANCE_MSG("LT_MHS_TUTORIAL_OK"));
setf_text(this.remocon.text_cursor,GUIDANCE_MSG("LT_MHS_TUTORIAL_SELECT"));
setf_text(this.remocon.text_exit,"");}else {
this.msg_panel.remocon.visible_p=false;
this.remocon.visible_p=false;}

if(event_type=="message-recognition"){
this.func_image.visible_p=true;}

switch(msg_pos){
case "center":
this.msg_panel.setTranslate(0,0,2);
this.msg_panel.adjustPanelSize(1200,350);
break;
case "lower_center":
this.msg_panel.setTranslate(0,-200,2);
this.msg_panel.adjustPanelSize(1350,300);
break;
case "lower_large":
this.msg_panel.setTranslate(0,-380,2);
this.msg_panel.adjustPanelSize(1500,300);
break;
case "lower":
default:
this.msg_panel.setTranslate(0,-400,2);
this.msg_panel.adjustPanelSize(1350,275);
break;}

this.msg_panel.message.visible_p=true;
this.msg_panel.message.color[3]=0;
this.msg_panel.message.transparentTo(255,1000,
function (){
guidance.msg_panel.tts_play(true);
if(event_name=="mes_training_operation_home")
guidance.startup_ui_obj.focusNoTVGadget();});
this.msg_panel.setShow(true);
break;

case "fulltv-on":
is_force_fulltv=true;
this.startup_ui_obj.launchTVforTutorial(true);
break;
case "fulltv-off":
is_force_fulltv=false;
this.startup_ui_obj.launchTVforTutorial(false);
break;

case "browser-on":
this.bgimg.src="file:///usr/local/application/0077777700140002/gadget/guidance/"+
(system.mdl_cfg.with_browser_with_tv?
"guidance_browse_with_tv.jpg":"guidance_browse.jpg");
this.bgimg.visible_p=true;
break;
case "browser-off":
this.bgimg.src="";
this.bgimg.visible_p=false;
break;

case "key":
this.send_key(keysym);
break;

case "wait":
break;

case "exit":
default:
this.term_request(1);
return;}

if(duration==0)
append_timer(this,GUIDANCE_TIMEOUT_VAL,function(){guidance.term_request(0)});
else
append_timer(this,duration,this.next_run_scenario);};
guidance.key_hook=function(up_down,keysym){
if(!(this.is_mode_on()&&this.is_user_key()))
return false;

if(up_down!=KEY_PRESS)
return true;

if(this.scenario[this.current_step][4]==0)append_timer(this,GUIDANCE_TIMEOUT_VAL,function(){guidance.term_request(0)});

if(this.exit_msg_panel.visible_p){
this.exit_msg_panel.key_hook(up_down,keysym);
return true;}

if(this.msg_panel.visible_p||
this.remocon.visible_p){
var event_type=this.scenario[this.current_step][3];
var event_name=this.scenario[this.current_step][0];

if((this.msg_panel.key_enable==false)&&
(keysym!=TXK_RETURN)&&(keysym!=TXK_EXIT))
return true;

switch(keysym){
case TXK_RETURN:
case TXK_EXIT:
if((event_type!="message-closing")&&
(event_type!="message-next-closing")&&
(guidance.scenario!=guidance_scenario_exit))
this.show_exit_msg_panel();
break;
case TXK_ENTER:
if(event_name=="mes_training_operation_home"){
this.mask.width=1920;
this.mask.height=1080;
this.mask.translate[0]=0;
this.mask.translate[1]=0;
if(this.startup_ui_obj.isTVGadget()){
system.effect_sound.play(5);
this.next_run_scenario();}else {
system.effect_sound.play(7);
ebus.tts.stop();
if(country=="CN")
this.msg_panel.setMessageText(GUIDANCE_MSG("LT_MHS_TUTORIAL_MSG_05_CN"),"",true);
else
this.msg_panel.setMessageText(GUIDANCE_MSG("LT_MHS_TUTORIAL_MSG_05"),"",true);
this.msg_panel.setShow(true);
this.msg_panel.message.transparentTo(255,500,function (){guidance.msg_panel.tts_play(true);});}
}else if(event_name=="mes_training_operation_home_selection"){
this.mask.width=1920;
this.mask.height=1080;
this.mask.translate[0]=0;
this.mask.translate[1]=0;
system.effect_sound.play(5);
this.next_run_scenario();}else if(event_name=="mes_training_operation_fulltv_selection"){
this.mask.width=1920;
this.mask.height=1080;
this.mask.translate[0]=0;
this.mask.translate[1]=0;
if(this.startup_ui_obj.isTVScreen()){
system.effect_sound.play(5);
this.next_run_scenario();}else {
system.effect_sound.play(7);
ebus.tts.stop();
this.msg_panel.setMessageText(GUIDANCE_MSG("LT_MHS_TUTORIAL_MSG_14"),"",true);
this.msg_panel.setShow(true);
this.msg_panel.message.transparentTo(255,500,function (){guidance.msg_panel.tts_play(true);});}
}else if(event_name=="mes_training_operation_xumo_selection"){
this.mask.width=1920;
this.mask.height=1080;
this.mask.translate[0]=0;
this.mask.translate[1]=0;
if(this.startup_ui_obj.isXumoScreen()){
system.effect_sound.play(5);
this.next_run_scenario();}else {
system.effect_sound.play(7);
ebus.tts.stop();
this.msg_panel.setMessageText(GUIDANCE_MSG("LT_MHS_TUTORIAL_MSG_16"),"",true);
this.msg_panel.setShow(true);
this.msg_panel.message.transparentTo(255,500,function (){guidance.msg_panel.tts_play(true);});}
}else {
if(event_type=="message-opening"||
event_type=="message-closing"||
event_type=="message-next-closing"||
event_type=="message-next"||
event_type=="message-recognition"||
event_type=="message-udlr-ok"||
event_type=="message-lr-ok"){
this.next_run_scenario();}
}
break;
case TXK_HOME:
if(event_type=="message-home")
this.next_run_scenario();
break;
case TXK_LEFT:
case TXK_RIGHT:
case TXK_UP:
case TXK_DOWN:
if((event_name=="mes_training_operation_home")||
((event_name=="mes_training_operation_fulltv_selection")||
(event_name=="mes_training_operation_xumo_selection")||
(event_name=="mes_training_operation_home_selection"))&&
(keysym==TXK_LEFT||keysym==TXK_RIGHT)){
this.mask.width=300;
this.mask.height=250;
this.mask.translate[0]=this.remocon.translate[0];
this.mask.translate[1]=-390;
this.msg_panel.setShow(false);
this.send_key(keysym);}else {
if(event_type=="message-udlr-ok"||
(event_type=="message-lr-ok")&&(keysym==TXK_LEFT||keysym==TXK_RIGHT))
this.send_key(keysym);}
break;
default:
break;}
return true;}

return true;};
guidance.get_total_step=function(){
var total=0;
for(var i=0;i<this.scenario.length;i++){
if(this.scenario[i][1]&&
this.scenario[i][2]&&
((this.scenario[i][3]=="message-next")||
(this.scenario[i][3]=="message-recognition")||
(this.scenario[i][3]=="message-home")||
(this.scenario[i][3]=="message-lr-ok")||
(this.scenario[i][3]=="message-udlr-ok"))){
total++;}
}
return total;};
guidance.check_bookmark_exist=function(){
var tmp=null;
var nvram_file_list=apps_nvram_file.list({product_id:"home"});
if((nvram_file_list)&&(nvram_file_list.indexOf("Bookmark")!=-1)){
tmp=apps_nvram_file.read({"filename":"Bookmark",async:false,
finished:function(){},product_id:"home"});}
if(tmp){
tmp=sysutil.tconv.binary_to_string(tmp);
this.bookmark_data=eval(tmp);
if(this.bookmark_data.bookmarkpanel.length==0)
return false;
else
return true;}else{
return false;}
};
var GUIDANCE_MODE=false;
var IS_SENDING_SCENARIO_KEY=false;
var is_tv_centric=false;
var not_is_tv_centric=true;
var is_force_fulltv=false;
var is_initial_guidance=false;
var is_fullscreen_tv=false;
var not_is_fullscreen_tv=true;
var is_bookmark_exist=true;
var not_is_screen_4k=true;
var is_screen_4k=false;
var is_recognition_with_camera=false;
var is_recognition_without_camera=false;
var has_xumo_screen=false;
var not_has_xumo_screen=true;
guidance.start=function(obj,ev,info){
var screen_order=obj.getScreenOrder();
var screen_info=[];

console_log(" [GUIDANCE] start");
GUIDANCE_MODE=true;
IS_SENDING_SCENARIO_KEY=false;

for(var i=0;i<screen_order.length;i++)
screen_info[i]=obj.getScreenInfo(screen_order[i]);

is_fullscreen_tv=info.is_tv;
not_is_fullscreen_tv=!is_fullscreen_tv;

if(lang=="ja"){
is_tv_centric=true;
not_is_tv_centric=!is_tv_centric;}
if(obj.hasXumoScreen()){
has_xumo_screen=true;
not_has_xumo_screen=false;}
if(system.screen&&(system.screen.view_width==3840&&system.screen.view_height==2160)){
is_screen_4k=true;
not_is_screen_4k=false;}
if(system.mdl_cfg.with_multi_profile){
if(system.mdl_cfg.with_inner_camera)
is_recognition_with_camera=true;
else
is_recognition_without_camera=true;}
if(ev==system.guidance.LAUNCH_INITIAL){
is_initial_guidance=true;
not_is_initial_guidance=!is_initial_guidance;}else {
is_initial_guidance=false;
not_is_initial_guidance=!is_initial_guidance;}

load(PATH+"guidance/guidance_scenario.js");

switch(ev){
case system.guidance.LAUNCH_INITIAL:
case system.guidance.LAUNCH_USER_HOMESCREEN:
this.scenario=guidance_scenario;
break;
case system.guidance.LAUNCH_USER_BOOKMARK:
is_bookmark_exist=this.check_bookmark_exist();
this.scenario=guidance_scenario_bookmark;
break;
default:
this.scenario=guidance_scenario;
break;}

this.step_text=false;
this.total_msg_step=this.get_total_step();
this.current_msg_step=1;
this.prev_step=0;
this.current_step=0;
this.startup_ui_obj=obj;
this.visible_p=true;
this.bgimg.visible_p=false;
this.mask.visible_p=false;
this.msg_panel.setShow(false);
this.run_scenario();

return true;};
guidance.term_request=function (status){
if(is_force_fulltv)
this.startup_ui_obj.launchTVforTutorial(false);

ebus.tts.stop();
this.delete_all_timer();
this.msg_panel.cursor=0;
this.msg_panel.btn_list[0].background.color=[255,204,0,200];
this.msg_panel.btn_list[0].text.color=[0,0,0,255];
this.bgimg.visible_p=false;
this.mask.visible_p=false;
this.msg_panel.setShow(false);
system.guidance.terminate_request(status);};
guidance.stop=function(){
console_log(" [GUIDANCE] stop");
if(!GUIDANCE_MODE)
return;

GUIDANCE_MODE=false;
GUIDANCE_MSG="";
ebus.tts.stop();
this.delete_all_timer();
this.bgimg.visible_p=false;
this.mask.visible_p=false;
this.remocon.visible_p=false;
this.msg_panel.setShow(false);
this.visible_p=false;};
guidance.show_exit_msg_panel=function(){
delete_timer(this.msg_panel);
delete_timer(this.mask_window);
this.msg_panel.setShow(false);
this.remocon.visible_p=false;
this.func_image.visible_p=false;
this.mask_window.visible_p=false;
this.mask.translate[0]=0;
this.mask.translate[1]=0;
this.mask.width=1920;
this.mask.height=1080;
this.mask.visible_p=true;
this.exit_msg_panel.cursor=1;
this.exit_msg_panel.btn_list[0].background.color=[100,100,100,255];
this.exit_msg_panel.btn_list[0].text.color=[255,255,255,255];
this.exit_msg_panel.btn_list[1].background.color=[255,204,0,200];
this.exit_msg_panel.btn_list[1].text.color=[0,0,0,255];
this.exit_msg_panel.remocon.visible_p=false;
this.exit_msg_panel.setMessageText(GUIDANCE_MSG("LT_DO_YOU_EXIT"),"",true);
this.exit_msg_panel.setTranslate(0,0,2);
this.exit_msg_panel.setButtonLabel(GUIDANCE_MSG("LT_YES"),GUIDANCE_MSG("LT_NO"));
this.exit_msg_panel.adjustPanelSize(900,350);
this.exit_msg_panel.setShow(true);
this.msg_panel.message.transparentTo(255,500,function (){guidance.exit_msg_panel.tts_play(true);});};
guidance.delete_all_timer=function(){
delete_timer(this);
delete_timer(this.msg_panel);
delete_timer(this.mask_window);};
guidance.is_mode_on=function(){
return GUIDANCE_MODE;};
guidance.is_user_key=function(){
if(IS_SENDING_SCENARIO_KEY)
return false;
return true;};
