(defvar dms-area 'pal)(defvar psi-play-sym 'psi-enc)

(defvar open-sesami nil)

(defvar pmt-version nil)

(defvar tuner-power nil)(defvar audio-liveview-pid -1)(defvar last-video-pid -1)(defvar last-audio-pid -1)(defvar last-sttl-pid -1)(defvar last-ci-slot-no 0)(defvar audio-choice-num 0)(defvar subtitle-choice-num 0)(defvar teletext-choice-num 0)(defvar video-track-list nil)(defvar audio-track-list nil)(defvar subtitle-track-list nil)(defvar subtitle-track-num 0)(defvar teletext-track-list nil)(defvar teletext-track-num 0)(defvar teletext-sttl-choice-num 0)(defvar teletext-sttl-choice-list nil)(defvar scramble-p nil)(defvar is-obfuscate-svc nil)

(defvar preferred-audio nil)(defvar preferred-subtitle nil)(defvar preferred-subtitle-type 0)(defvar preferred-teletext nil)(defvar preferred-common-lang nil)(defvar preferred-audio-type nil)

(defvar dish-param-list (list nil nil nil nil))

(defvar cur-calist nil)(defvar calist-max 8)(defvar calist-vpid nil)(defvar calist-apid nil)

(defvar mon1tuner-prio 2)

(defvar tsport-ci-switch-done nil)

(defvar is-aus nil)(defvar is-uk nil)(defvar is-nz nil)(defvar is-china nil)(defvar is-hk nil)(defvar is-cont nil)(defvar is-nordic nil)(defvar is-hungary nil)(defvar is-finland nil)(defvar is-brazil nil)

(defvar with-ttx-sttl nil)(defvar with-dvb-sttl t)(defvar with-last-sttl nil)(defvar use-ttx-sttl-digital nil)(defvar with-sort-sttl-list nil)(defvar with-he-aac nil)(defvar with-ac3 nil)(defvar with-ac3-plus nil)(defvar with-hd nil)(defvar with-ad nil)(defvar with-freesat nil)(defvar with-dvb-s-cont nil)(defvar with-usb-hdd-rec nil)(defvar with-latin-parental nil)(defvar with-si-copy-control nil)(defvar ci-bypass-ctrl nil)(defvar with-dvb-ci nil)(defvar with-dual-ci nil)

(defvar unlock-file nil)(defvar current-network nil)

(defvar STTL_NONE_PREF -1)(defvar STTL_DVB_PREF 0)(defvar STTL_TELETEXT_PREF 1)(defvar PREFERRED_TYPE 0)(defvar INFERIOR_TYPE 1)(defvar EEP_SUBT_TYPE_NORMAL 0)(defvar EEP_SUBT_TYPE_IMPAIRED 1)(defvar dvb-sttl-msg 0)(defvar vbi-sttl-msg 0)(defvar subt-reset -1)(defvar subt-pid -1)(defvar subt-lang "")(defvar subt-pid-ttx -1)(defvar selected-subt STTL_NONE_PREF)

(defvar pmt-parental-age 0)(defvar pmt-country-parental-code "---")(defvar old-pmt-parental-age 0)

(defvar pmt-rec-ctrl-data nil)(defvar eit-rec-ctrl-data nil)(defvar sdt-rec-ctrl-data nil)

(defvar use-sad nil)(defvar ad-enable nil)

(defvar need-check-stuner-available nil)(defvar stuner-connect-status (list nil nil))

(defvar input-id 1)(defvar selected-tuner-no 0)

(defmacro get-default-video (lst)
`(car ,lst))(defmacro get-default-audio (lst)
`(car ,lst))

(defmacro ad-by-multiaudio-p (track)
`(if (and use-sad (eq 1 (get-track-audio-sad-found ,track)))(and (eq 1 (get-track-audio-sad-mix-type ,track))(eq 1 (get-track-audio-sad-ed-class ,track))(or (eq 3 (get-track-audio-type ,track))(if (eq current-network 3)(eq 0 (get-track-audio-type ,track)))))(and (string-equal "NAR" (get-track-audio-lang ,track))(or (eq 0 (get-track-audio-type ,track))(eq 3 (get-track-audio-type ,track))))))

(defun set-eit-rec-ctrl-data (data)(setf eit-rec-ctrl-data data)(when (and request-pids (not pmt-rec-ctrl-data))(eval-rec-partial-stream 'cp)))

(defun set-sdt-rec-ctrl-data (data)(setf sdt-rec-ctrl-data data)(when (and request-pids (not pmt-rec-ctrl-data) (not eit-rec-ctrl-data))(eval-rec-partial-stream 'cp)))

(defmacro dual-mono-p (sym)
`(and (device-open-p ,sym) (eq (audio-channel ,sym) 7)))

(defmacro get-track-pid (track)
`(first ,track))(defmacro get-track-tag (track)
`(second ,track))(defmacro get-track-stype (track)
`(first (third ,track)))(defmacro get-track-video-pcr (track)
`(second (third ,track)))(defmacro get-track-pmt-video-codec (track)
`(third ,track))(defmacro get-track-ppmt-video-codec (track)
`(first (third ,track)))(defmacro get-track-video-level (track)
`(fourth ,track))(defmacro get-track-audio-format (track)
`(first (third ,track)))(defmacro get-track-audio-lang (track)
`(second (third ,track)))(defmacro get-track-audio-type (track)
`(third (third ,track)))(defmacro get-track-audio-dualmode (track)
`(fourth (third ,track)))(defmacro set-track-audio-dualmode (track val)
`(setf (nth 3 (nth 2 ,track)) ,val))(defmacro get-track-audio-adpid (track)
`(fifth (third ,track)))(defmacro set-track-audio-adpid (track val)
`(setf (nth 4 (nth 2 ,track)) ,val))(defmacro get-track-audio-aac-type (track)
`(sixth (third ,track)))(defun copy-audio-track (track)(list (get-track-pid track) (get-track-tag track)(list (get-track-audio-format track)(copy-string (get-track-audio-lang track))(get-track-audio-type track)(get-track-audio-dualmode track)(get-track-audio-adpid track))))(defmacro get-track-subtitle-lang (track)
`(first (third ,track)))(defmacro get-track-subtitle-type (track)
`(second (third ,track)))(defmacro get-track-subtitle-composition-id (track)
`(third (third ,track)))(defmacro get-track-subtitle-ancillary-id (track)
`(fourth (third ,track)))(defmacro get-track-teletext-lang (track)
`(first (third ,track)))(defmacro get-track-teletext-type (track)
`(second (third ,track)))(defmacro get-track-teletext-magazine-number (track)
`(third (third ,track)))(defmacro get-track-teletext-page-number (track)
`(fourth (third ,track)))(defmacro tag2pid (tag lst)
`(first (find-if #'(lambda (x)(eq ,tag (second x)))
,lst)))(defmacro pid2track (pid lst)
`(find-if #'(lambda (x)(eq ,pid (first x)))
,lst))(defmacro get-track-audio-sad-found (track)
`(first (fourth ,track)))(defmacro get-track-audio-sad-lang-present (track)
`(second (fourth ,track)))(defmacro get-track-audio-sad-lang (track)
`(third (fourth ,track)))(defmacro get-track-audio-sad-lang-if-avail (track)
`(if (and use-sad
(eq 1 (get-track-audio-sad-found ,track))(eq 1 (get-track-audio-sad-lang-present ,track)))(get-track-audio-sad-lang ,track)(get-track-audio-lang ,track)))(defmacro get-track-audio-sad-mix-type (track)
`(fourth (fourth ,track)))(defmacro get-track-audio-sad-ed-class (track)
`(fifth (fourth ,track)))

(defun get-codec-priority (codec level)(if (eq codec #x24)
-1
(if (eq codec #x1b)(+ 1 level)
0)))(defvar video-choice-num 10)(defun append-video-track (track lst)(when (or (not video-choice-num) (< (length lst) video-choice-num))(let ((pos nil))(setf pos (position-if #'(lambda (x)(> (get-codec-priority (get-track-pmt-video-codec track) (get-track-video-level track))(get-codec-priority (get-track-pmt-video-codec x) (get-track-video-level x))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(progn
(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track))))))


(defun create-audio-choice-list (sym alist)(let ((new-list nil) (dual-pid nil))(when (and (eq (get-audio-result sym) 'DECODE_SUCCESS)(dual-mono-p sym))(setf dual-pid (get-audio-pid sym)))(mapcar #'(lambda (x)(if (not (eq (get-track-pid x) dual-pid))(if new-list
(append-audio-track x new-list)(setf new-list (cons x nil)))(setf track (copy-audio-track x))(set-track-audio-dualmode track 0)(if new-list
(append-audio-track track new-list)(setf new-list (cons track nil)))(setf track (copy-audio-track x))(set-track-audio-dualmode track 1)(append-audio-track track new-list)(setf track (copy-audio-track x))(set-track-audio-dualmode track 2)(append-audio-track track new-list)))
alist)
new-list))(defun send-video-choice-list (lst)(setf video-choice-list lst))(defun send-audio-choice-list (lst)(setf audio-choice-list lst))(defun send-subtitle-choice-list (lst)(setf subtitle-choice-list lst))(defun send-teletext-choice-list (lst)(setf teletext-choice-list lst))(defun child-lock-p (key)(and (eq (svl-get-data (get-signal-source-svl key) 'child_lock) 1)(not open-sesami)))(defun tv-service-p (key)(eq (svl-get-data (get-signal-source-svl key) 'stype) 1))(defun with-dvb-sat-p ()(or with-freesat with-dvb-s-cont))(defun tv-or-radio-service-p (key)(or (eq (svl-get-data (get-signal-source-svl key) 'stype) 1)(eq (svl-get-data (get-signal-source-svl key) 'stype) 2)))

(defun set-open-sesami (on-off)(setf open-sesami (if (eq on-off 0) nil t))(my-select-channel)(make-event 'new-reserve))

(defvar tuning-tuner 'tuner)(defun set-tuning-tuner (dev)(setf tuning-tuner dev))(defun get-tuning-tuner ()
tuning-tuner)(defmacro which-tuner (tsl-key)
`(if (and (or with-freesat with-dvb-s-cont)(eq (tsl-get-data ,tsl-key 'ntype) 1))
'stuner
'tuner))(defun my-select-channel ()(if (tsl-equal (get-tuning-tsl-key) (get-tuner-tsl-key (get-tuning-tuner)))(if (eq (get-tuning-svcid) (get-psi-svcid 'psi))(progn
(make-event 'psi-update))(set-psi-valid 'psi nil)(set-psi-error 'psi nil)(make-event 'psi-invalid)(search-svcid-in-pat (get-tuning-svcid))(make-event 'service-change))(set-psi-valid 'psi nil)(set-psi-error 'psi nil)(make-event 'psi-invalid)(make-event 'tuner-req)))

(defun subtitle-choice ()(let ((subt-index 0) (track nil) (subt-reset nil))(if (not with-dvb-sttl)
nil
(when with-ttx-sttl
(setf dvb-sttl-msg t))(setf subtitle-track-num (length subtitle-track-list))(if (<= subtitle-track-num subtitle-choice-num)(if (= subtitle-track-num 0)(progn
(setf subt-pid -1)(setf subt-lang -1))(setf subtitle-choice-list subtitle-track-list)(when with-sort-sttl-list
(sc-sort-sttl-list))(if (not with-ttx-sttl)(progn
(unless use-ttx-sttl-digital
(setf selected-subt STTL_DVB_PREF))(when with-last-sttl
(when (= subt-pid -1)(setf subt-pid last-sttl-pid)))(if (or (= subt-pid -1)(= subt-reset -1))(setf subt-index 0)(setf subt-index (position-if #'(lambda (trk)(= subt-pid (first trk)))
subtitle-choice-list))(unless subt-index
(setf subt-index 0)))

(setf track (nth subt-index subtitle-choice-list))(setf subt-pid (first track)))))))))

(defun teletext-choice ()(setf teletext-track-num (length teletext-track-list))(when with-ttx-sttl
(setf teletext-sttl-choice-num 0)(setf vbi-sttl-msg 1))(when is-aus
(setf teletext-sttl-choice-num 0)(setf subt-pid-ttx -1))(if (<= teletext-track-num teletext-choice-num)(when (/= teletext-choice-num 0)(setf teletext-choice-list teletext-track-list)(when (or with-ttx-sttl is-aus)(mapcar #'(lambda (trk)(when (or (= (nth 1 (third trk)) 2)(= (nth 1 (third trk)) 5))(if teletext-sttl-choice-list
(setf-cdr (last teletext-sttl-choice-list) (cons trk nil))(setf teletext-sttl-choice-list (cons trk nil)))))
teletext-choice-list)(setf teletext-sttl-choice-num (length teletext-sttl-choice-list)))

(when is-aus
(setf selected-subt STTL_TELETEXT_PREF)(setf subt-pid-ttx (first (first teletext-sttl-choice-list)))))))

(defvar second-pref-lang-detected STTL_NONE_PREF)(defvar pref-type-detected STTL_NONE_PREF)(defvar pref-lang-index -1)(defun check-only-hard-hearing-sttl (pref-subt-lang pref-subt-2-lang)(let ((ret nil) (only-hard-hearing t))(when (and is-nordic
(or (= current-network 1)(= current-network 5)))(when (= preferred-subtitle-type EEP_SUBT_TYPE_NORMAL)(when (find-if #'(lambda (x)(or (< (nth 1 (third x)) #x20)(> (nth 1 (third x)) #x24)))
subtitle-choice-list)(setf only-hard-hearing nil))

(when only-hard-hearing
(when (find-if #'(lambda (x)(/= (nth 1 (third x)) #x05))
teletext-sttl-choice-list)(setf only-hard-hearing nil))(when only-hard-hearing
(setf ret STTL_NONE_PREF)))))
ret))

(defun check-pref-lang-found-sttl (pref-subt-lang pref-subt-2-lang)(let ((ret nil) (preferred-lang-found nil))(when (and is-nordic
(or (= current-network 5)(and (= current-network 1) is-finland)))(when (or (check-language-list pref-subt-lang subtitle-choice-list)(check-language-list pref-subt-2-lang subtitle-choiec-list ))(setf preferred-lang-found t))(unless preferred-lang-found
(when (or (check-language-list pref-subt-lang teletext-sttl-choice-list)(check-language-list pref-subt-2-lang teletext-sttl-choice-list))(setf preferred-lang-found t))(unless preferred-lang-found
(setf ret STTL_NONE_PREF))))
ret))

(defun check-pref-lang-dvb-sttl (pref-subt-lang pref-subt-2-lang)(let ((ret nil))(when (> subtitle-track-num 0)(setf pref-lang-index (get-subtitle-choice-list-index PREFERRED_TYPE))(when pref-lang-index
(setf pref-type-detected STTL_DVB_PREF)(setf sttl-index pref-lang-index)(when (check-language pref-subt-lang (get-track-subtitle-lang (nth pref-lang-index subtitle-choice-list)))(setf ret STTL_DVB_PREF))(when (and (not ret)(check-language pref-subt-2-lang) (get-track-subtitle-lang (nth pref-lang-index subtitle-choice-list)))(setf second-pref-lang-detected STTL_DVB_PREF))))
ret))

(defun check-pref-lang-teletext-sttl (pref-subt-lang pref-subt-2-lang)(let ((ret nil))(when (> teletext-sttl-choice-num 0)(setf pref-lang-index (get-teletext-sttl-choice-list-index PREFERRED_TYPE))(when pref-lang-index
(when (= pref-type-detected STTL_NONE_PREF)(setf pref-type-detected STTL_TELETEXT_PREF)(setf sttl-index pref-lang-index))(when (check-language pref-subt-lang (get-track-teletext-lang (nth pref-lang-index teletext-sttl-choice-list)))(setf sttl-index pref-lang-index)(setf ret STTL_TELETEXT_PREF))(when (and (not ret)(check-language pref-subt-2-lang) (get-track-teletext-lang (nth pref-lang-index teletext-sttl-choice-list)))(when (/= second-pref-lang-detected STTL_DVB_PREF)(setf second-pref-lang-detected STTL_TELETEXT_PREF)(setf sttl-index pref-lang-index)))))
ret))

(defun check-second-pref-lang-detected (pref-subt-lang pref-subt-2-lang)(let ((ret nil))(if (= second-pref-lang-detected STTL_DVB_PREF)(setf ret STTL_DVB_PREF)(if (= second-pref-lang-detected STTL_TELETEXT_PREF)(setf ret STTL_TELETEXT_PREF)))
ret))

(defun check-inferior-type-lang-dvb-sttl (pref-subt-lang pref-subt-2-lang)(let ((ret nil))(when (> subtitle-track-num 0)(setf pref-lang-index (get-subtitle-choice-list-index INFERIOR_TYPE))(when pref-lang-index
(when (check-language pref-subt-lang (get-track-subtitle-lang (nth pref-lang-index subtitle-choice-list)))(setf sttl-index pref-lang-index)(setf ret STTL_DVB_PREF))(when (and (not ret)(check-language pref-subt-2-lang (get-track-subtitle-lang (nth pref-lang-index subtitle-choice-list))))(setf second-pref-lang-detected STTL_DVB_PREF)(setf sttl-index pref-lang-index))))
ret))

(defun check-inferior-type-lang-teletext-sttl (pref-subt-lang pref-subt-2-lang)(let ((ret nil))(when (> teletext-sttl-choice-num 0)(setf pref-lang-index (get-teletext-sttl-choice-list-index INFERIOR_TYPE))(when pref-lang-index
(when (check-language pref-subt-lang (get-track-teletext-lang (nth pref-lang-index teletext-sttl-choice-list)))(setf sttl-index pref-lang-index)(setf ret STTL_TELETEXT_PREF))(when (and (not ret)(check-language pref-subt-2-lang (get-track-teletext-lang (nth pref-lang-index teletext-sttl-choice-list))))(when (/= second-pref-lang-detected STTL_DVB_PREF)(setf second-pref-lang-detected STTL_TELETEXT_PREF)(setf sttl-index pref-lang-index)))))
ret))

(defun check-sttl-type (pref-subt-lang pref-subt-2-lang)(let ((ret nil))(if (= second-pref-lang-detected STTL_DVB_PREF)(setf ret STTL_DVB_PREF)(if (= second-pref-lang-detected STTL_TELETEXT_PREF)(setf ret STTL_TELETEXT_PREF)(if (= pref-type-detected STTL_DVB_PREF)(setf ret STTL_DVB_PREF)(if (= pref-type-detected STTL_TELETEXT_PREF)(setf ret STTL_TELETEXT_PREF)))))

(unless ret
(setf sttl-index 0)(if (and (= subtitle-track-num 0)(> teletext-sttl-choice-num 0))(setf ret STTL_TELETEXT_PREF)(setf ret STTL_DVB_PREF)))
ret))

(defun sc-check-pref-kind-sttl ()(let ((pref-subt-lang (first preferred-subtitle))(pref-subt-2-lang (second preferred-subtitle))(func nil)(func-list (list
'check-only-hard-hearing-sttl
'check-pref-lang-found-sttl
'check-pref-lang-dvb-sttl
'check-pref-lang-teletext-sttl
'check-second-pref-lang-detected
'check-inferior-type-lang-dvb-sttl
'check-inferior-type-lang-teletext-sttl
'check-sttl-type))(ret nil))(setf second-pref-lang-detected STTL_NONE_PREF)(setf pref-type-detected STTL_NONE_PREF)(setf pref-lang-index -1)(if (and (= subtitle-track-num 0)(= teletext-sttl-choice-num 0))(setf ret STTL_NONE_PREF)(do ((f-lst func-list (cdr f-lst)))((or ret (null f-lst)))(setf func (car f-lst))(setf ret (funcall func pref-subt-lang pref-subt-2-lang))))
ret))

(defvar sttl-index 0)(defun sc-check-launch-sttl ()(let ((pid-teletext -1) (preferred-sub nil))(setf sttl-index 0)(if (and (= teletext-sttl-choice-num 0) (= subtitle-track-num 0))(setf selected-subt STTL_NONE_PREF)(setf preferred-sub (sc-check-pref-kind-sttl))(cond ((= preferred-sub STTL_TELETEXT_PREF)(setf selected-subt STTL_TELETEXT_PREF)(setf subt-pid-ttx
(first (nth sttl-index teletext-sttl-choice-list))))((and (= preferred-sub STTL_DVB_PREF)(> subtitle-track-num 0))(setf selected-subt STTL_DVB_PREF)(setf subt-pid (first (nth sttl-index subtitle-choice-list))))((and is-nordic
(or (= current-network 1)(= current-network 5)))(setf selected-subt STTL_NONE_PREF))))))


(defun check-language (pref-lang-list lang)(find-if #'(lambda (pref-lang)(string= pref-lang lang)) pref-lang-list))

(defun check-language-list (pref-lang-list track-list)(find-if #'(lambda (track)(check-language pref-lang-list (first (third track))))
track-list))

(defun get-subtitle-choice-list-index (type)(position-if
#'(lambda (track)(let ((subt-type (nth 1 (third track))))(if (= type PREFERRED_TYPE)(when (or (and (= preferred-subtitle-type EEP_SUBT_TYPE_NORMAL)(>= subt-type #x10)(<= subt-type #x1F))(and (= preferred-subtitle-type EEP_SUBT_TYPE_IMPAIRED)(>= subt-type #x20)(<= subt-type #x2F)))
t)(if (= type INFERIOR_TYPE)(when (or (and (= preferred-subtitle-type EEP_SUBT_TYPE_NORMAL)(>= subt-type #x20)(<= subt-type #x2F))(and (= preferred-subtitle-type EEP_SUBT_TYPE_IMPAIRED)(>= subt-type #x10)(<= subt-type #x1F)))
t)
nil))))
subtitle-choice-list))

(defun get-teletext-sttl-choice-list-index (type)(position-if
#'(lambda (track)(let ((subt-type (nth 1 (third track))))(if (= type PREFERRED_TYPE)(when (or (and (= preferred-subtitle-type EEP_SUBT_TYPE_NORMAL)(= subt-type #x02))(and (= preferred-subtitle-type EEP_SUBT_TYPE_IMPAIRED)(= subt-type #x05)))
t)(if (= type INFERIOR_TYPE)(when (or (and (= preferred-subtitle-type EEP_SUBT_TYPE_NORMAL)(= subt-type #x05))(and (= preferred-subtitle-type EEP_SUBT_TYPE_IMPAIRED)(= subt-type #x02)))
t)
nil))))
teletext-sttl-choice-list))

(defun sc-sort-sttl-list ()(let ((reverse-order nil)(sttl-copy nil)(sort-swap t)(current-lang ""))(when (= preferred-subtitle-type EEP_SUBT_TYPE_IMPAIRED)(setf reverse-order t))

(do ((count1 0 (1+ count1)))((>= count1 subtitle-track-num))(when (not (string= current-lang (get-track-subtitle-lang
(nth count1 subtitle-choice-list))))(setf current-lang (get-track-subtitle-lang
(nth count1 subtitle-choice-list)))(setf sort-swap t)(do (nil)((not sort-swap))(setf sort-swap nil)(do ((count2 (1+ count1) (1+ count2)))((>= count2 subtitle-choice-num))(when (and (string= (get-track-subtitle-lang (nth count2 subtitle-choice-list))
current-lang)(not (string= (get-track-subtitle-lang (nth count2 subtitle-choice-list))(get-track-subtitle-lang (nth (1- count2) subtitle-choice-list)))))(setf sttl-copy (nth count2 subtitle-choice-list))(setf (nth count2 subtitle-choice-list)(nth (- count2 1) subtitle-choice-list))(setf (nth (- count2 1) subtitle-choice-list) sttl-copy)(setf sort-swap t))))))

(setf current-lang "")(do ((count1 0 (1+ count1)))((>= count1 subtitle-track-num))(when (not (string= current-lang
(get-track-subtitle-lang (nth count1 subtitle-choice-list))))(setf current-lang (get-track-subtitle-lang (nth count1 subtitle-choice-list)))(setf sort-swap t)(do (nil)((not sort-swap))(setf sort-swap nil)(do ((count2 (1+ count1) (1+ count2)))((>= count2 subtitle-choice-num))(when (and (string= (get-track-subtitle-lang (nth count2 subtitle-choice-list))(get-track-subtitle-lang (nth (1- count2) subtitle-choice-list)))(sc-sort-sttl-decide (get-track-subtitle-type (nth (1- count2) subtitle-choice-list))(get-track-subtitle-type (nth count2 subtitle-choice-list))
reverse-order))(setf sttl-copy (nth count2 subtitle-choice-list))(setf (nth count2 subtitle-choice-list)(nth (- count2 1) subtitle-choice-list))(setf (nth (- count2 1) subtitle-choice-list) sttl-copy)(setf sort-swap t))))))))

(defun sc-sort-sttl-decide (sub1 sub2 reverse)(let ((s1 nil)(s2 nil))(setf s1 (if (/= (logand sub1 #x20) 0) 2 0))(setf s2 (if (/= (logand sub2 #x20) 0) 2 0))(when (= s1 s2)(setf s1 (if (< sub1 sub2) 0 1))(setf s2 (if (< sub2 sub1) 0 1)))(if reverse
(< s1 s2)(> s1 s2))))

(defun send-pmt-parental (rating code)(unless (eq old-pmt-parental-age rating)(send-event SC_RES_PARENTAL 8 rating code)(setf old-pmt-parental-age rating)))

(defun detect-rating-country-code (code length data)(let ((country-code)(rating))(when (and (> length 0) data)(setf country-code (copy-string "---"))(setf-char country-code 0 (nth 0 data ))(setf-char country-code 1 (nth 1 data ))(setf-char country-code 2 (nth 2 data ))(setf rating (logand (nth 3 data) #x0f))

(when (string-equal code country-code)(setf pmt-parental-country-code country-code)(setf pmt-parental-age rating))(detect-rating-country-code code (- length 4) (nthcdr 4 data)))))

(defun set-preferred-audio (pref)(setf preferred-audio pref)(send-audio-choice-list (create-audio-choice-list 'audio audio-track-list)))(defun set-preferred-audio-format (format)(setf preferred-audio-format (case format
('mpeg
(list #x03 #x04))('he-aac
(list #x11))('ac3
(list #x81))('ac3-plus
(list #x82))(otherwise
nil)))(send-audio-choice-list (create-audio-choice-list 'audio audio-track-list)))

(defun set-hd-feature (on-off)(setf with-hd on-off)(make-event 'psi-update))

(defun set-preferred-common-lang (alist slist)(let ((alang-group) (slang-group) (cmn-lang))(if (not (and alist slist))(setf preferred-common-lang nil)(setf alang-group
(find-if #'(lambda (x)(find-if #'(lambda (y)(find-if #'(lambda (z)(string-equal (get-track-audio-lang z) y))
alist))
x))
preferred-audio))(setf slang-group
(find-if #'(lambda (x)(find-if #'(lambda (y)(find-if #'(lambda (z)(string-equal (get-track-subtitle-lang z) y))
slist))
x))
preferred-subtitle))(setf preferred-common-lang
(if (and alang-group slang-group)
nil
(if (find-if #'(lambda (y)(find-if #'(lambda (z)(string-equal (get-track-subtitle-lang z) y))
slist))
alang-group)
alang-group
(if (find-if #'(lambda (y)(find-if #'(lambda (z)(string-equal (get-track-audio-lang z) y))
alist))
slang-group)
slang-group
(if (or alang-group slang-group)
nil
(setf cmn-lang
(get-track-audio-lang
(find-if #'(lambda (x)(find-if #'(lambda (y)(string-equal (get-track-subtitle-lang y) (get-track-audio-lang x)))
slist))
alist)))(if cmn-lang
(list cmn-lang)
nil)))))))))

(defun set-preferred-subtitle (pref)(let ((slist nil))(setf preferred-subtitle pref)(when is-nz
(set-preferred-common-lang audio-track-list subtitle-track-list))(when (and subtitle-track-list
(assoc (get-audio-pid 'audio) audio-track-list))(mapcar #'(lambda (x)(if slist
(append-subtitle-track x slist)(setf slist (cons x nil))))
subtitle-track-list)(send-subtitle-choice-list current-network slist 0))))

(defun set-preferred-teletext (pref)(let ((tlist nil))(setf preferred-teletext pref)(when teletext-track-list
(mapcar #'(lambda (x)(if tlist
(append-teletext-track x tlist)(setf tlist (cons x nil))))
teletext-track-list)(send-teletext-choice-list current-network tlist))))

(defvar content-management nil)(defun set-content-management (val)(unless (eq content-management val)(when (device-open-p 'cp)(setf content-management val)(eval-rec-partial-stream 'cp))(when dms-content-flag
(setf overwrite-enc-eemi (and val 0))(make-event 'encode-req))))

(defun get-partial-eemi (cp-sym partial-sym)(let ((eemi (cp-ref-pid-e-emi cp-sym nil)))(if (null eemi)
0
eemi)))

(defun eval-rec-partial-stream (cp-sym)(let ((pids nil) (emi) (content-emi nil) (video nil) (vtype nil)(audio nil) (atype nil) (track nil))(when (eq (cp-create cp-sym
:psi 'psi
:src (get-cp-src cp-sym)
:dst (get-cp-dst cp-sym)
:info (get-cp-stream-info cp-sym)
:type 1
:request 0
:content-management content-management)
t)(cp-set cp-sym 'partial)(mapcar #'(lambda (z)(if with-si-copy-control
(progn
(setf emi (if pmt-rec-ctrl-data
pmt-rec-ctrl-data
(if eit-rec-ctrl-data
eit-rec-ctrl-data
(if sdt-rec-ctrl-data
sdt-rec-ctrl-data
0)))))(setf emi (cp-ref-pid cp-sym (car z))))(if (or (not emi) (eq emi 3))
nil
(setf content-emi (if (or (eq content-emi 3) (eq emi 3))
3
(if (or (eq content-emi 2) (eq emi 2))
2
(if (or (eq content-emi 1) (eq emi 1))
1
0))))(when (and (not video) (eq (second z) 'video))(setf video (first z)))(if (and (transcode-transfer-p)
liveview-audio-info)(progn
(setf track (find-if #'(lambda (x)(eq (get-liveview-pid liveview-audio-info) (get-track-pid x)))
audio-track-list))(unless track
(setf track (car audio-track-list))))(setf track (car audio-track-list)))(when (and (not audio)(eq (first z) (get-track-pid track))(eq (second z) 'audio))(setf audio (get-track-pid track)))(if pids
(setf-cdr (last pids) (cons (car z) nil))(setf pids (cons (car z) nil)))))
request-pids)(send-no-copy (or (not content-emi)(= 3 content-emi)))(unless (and video audio)(setf pids nil))

(when (and is-obfuscate-svc
(equal (tsl-get-data (get-tuning-tsl-key) 'ntype 'ya_nid)
'(1 #x3b)))(let* ((svl-key
(svl-create-key "SVL"
:onid (tsl-get-data (get-tuning-tsl-key) 'onid)
:tsid (tsl-get-data (get-tuning-tsl-key) 'tsid)
:svcid (get-tuning-svcid)
:physical_ch (tsl-get-data (get-tuning-tsl-key) 'physical_ch)))(svc-type (svl-get-data svl-key 'stype)))(if (find svc-type (list #x16 #x19))(progn
(setf vtype #x1b)(setf atype #x81))(if (find svc-type (list #x01 #x02 #x0c))(progn
(setf vtype #x02)(setf atype #x03))))))

(when (transcode-transfer-p)(section-open 'pmt-enc)(section-filter 'pmt-enc
:type "version"
:source 'tsport
:pid (get-section-pid 'pmt)
:length (get-section-length 'pmt)
:filter (get-section-filter 'pmt)
:mask (get-section-mask 'pmt)
:elength (get-section-elength 'pmt)
:efilter (get-section-efilter 'pmt)
:emask (get-section-emask 'pmt))(section-read-data 'pmt-enc 'pmt)(psi-validate 'psi-enc 'pmt-enc)(set-video-pid 'video video)(when vtype
(set-video-codec 'video vtype))(set-video-pcr 'video request-pcr)(audio-attr 'audio (if (eq (get-video-codec 'video) #x1b)
'avc
(if (eq (get-video-codec 'video) #x24)
'hevd
'mpeg2)))(set-audio-pid 'audio audio)(set-audio-pcr 'audio request-pcr)(set-audio-format 'audio atype)(set-encode-video-pid video)(set-encode-audio-pid audio))

(request-partial request-pcr video vtype audio atype content-emi
(cp-ref-dtcp cp-sym) pids req-transcode-mode))))

(defun get-audio-type-priority (type)(if (eq type 0)
0
(if (eq type 1)
1
2)))

(defun get-audio-type-priority-ad (track)(let ((type (get-track-audio-type track)))(if (and use-nar-ad
(string-equal "NAR" (get-track-audio-lang track))(or (eq type 0) (eq type 3)))
0
(if (and use-sad
(eq (get-track-audio-sad-found track) 1)(eq (get-track-audio-sad-mix-type track) 1)(eq (get-track-audio-sad-ed-class track) 1))
0
(if (and use-visual-impaired-ad
(eq type 3))
0
(+ (get-audio-type-priority type) 1))))))


(defun get-audio-type-preferred-priority (preferred track)(let ((type (get-track-audio-type track)))(if (eq type preferred)(if (eq type #x03)(if (eq (get-track-audio-sad-found track) 1)(if (eq (get-track-audio-sad-mix-type track) 1)
0
(+ (get-audio-type-priority type) 1))
0)
0)(+ (get-audio-type-priority type) 1))))


(defun get-aac-priority (aac-type)(if (eq aac-type #x05)
0
1))

(defun get-audio-primary-tag-priority (tag)(if (= tag #x10)
0
1))

(defun get-format-priority-he-aac (format-type)(if (= format-type #x11)
0
1))

(defun get-preferred-priority (preferred lang)(let ((pri))(setf pri (position-if #'(lambda (x)(find-if #'(lambda (y)(string-equal lang y))
x))
preferred))(if pri
pri
(length preferred))))

(defun get-preferred-priority-nar (preferred lang)(let ((preferred-tmp preferred))(unless (and use-sad
(eq (get-track-audio-sad-found track) 1)(eq (get-track-audio-sad-lang-present track) 1))(setf preferred-tmp (cons '("nar") preferred-tmp)))(get-preferred-priority preferred-tmp lang)))

(defun get-lang-priority (preferred lang type)(let ((preferred-tmp nil))(mapcar #'(lambda (x)(setf preferred-tmp (cons x preferred-tmp))(if (find-if #'(lambda (y)(string-equal "eng" y))
x)(setf preferred-tmp (cons '("und") preferred-tmp))))
preferred)(get-preferred-priority (reverse preferred-tmp) lang))

)

(defun get-format-priority (preferred format)(let* ((mpeg-list        (list #x03 #x04))(srch-format      (if (member format mpeg-list) #x03 format))(prio-format-list (if (or is-nz (and is-aus with-hd))(if (member #x11 preferred)(list #x82 #x11 #x03 #x81)(list #x82 #x81 #x11 #x03))(if is-nordic
(list #x11 #x82 #x81 #x03)(list #x82 #x11 #x81 #x03))))(prio-format      (position srch-format prio-format-list)))(if (member format preferred)
0
(1+ prio-format))))

(defun get-format-with-aaclv-priority (format aac-pr)(let* ((srch-format (if (member format (list #x03 #x04)) #x03 format))(srch-list (cons srch-format (cons aac-pr nil)))(prio-format (position-if #'(lambda (x)(and (eq (car x) (car srch-list))(eq (car (cdr x)) (car (cdr srch-list)))))
preferred-audio-format-list)))
prio-format))

(defun get-subtitle-type-priority (type)(if (eq type #x10)
0
(if (eq type #x11)
1
(if (eq type #x12)
2
(if (eq type #x13)
3
4)))))

(defun append-audio-track (track lst)(if (eq is-uk t)(progn
(when (or (not audio-choice-num) (< (length lst) audio-choice-num))(let ((pos nil) (und (list (list "und"))) (nar (list (list "nar"))))(do ((loopcount 0 (+ loopcount 1)))((> loopcount (- (length lst) 1)) loopcount)(if (= 0 (get-preferred-priority preferred-audio (get-track-audio-lang (nth loopcount lst))))(setf und nil)))(if (or (and (eq with-freesat t) (eq current-network 4))(eq current-network 1))(setf nar nil))(if (and (eq current-network 3) (ad-by-multiaudio-p track))(if ad-enable
(setf pos (position-if #'(lambda (x)(or (and (not (ad-by-multiaudio-p x))(or (= (get-preferred-priority preferred-audio (get-track-audio-sad-lang-if-avail track))(get-preferred-priority preferred-audio (get-track-audio-sad-lang-if-avail x)))(< (get-preferred-priority nar (get-track-audio-sad-lang-if-avail track))(get-preferred-priority nar (get-track-audio-sad-lang-if-avail x)))))(when (ad-by-multiaudio-p x)(or (< (get-preferred-priority nar (get-track-audio-sad-lang-if-avail track))(get-preferred-priority nar (get-track-audio-sad-lang-if-avail x)))(when (= (get-preferred-priority nar (get-track-audio-sad-lang-if-avail track))(get-preferred-priority nar (get-track-audio-sad-lang-if-avail x)))(< (get-format-priority preferred-audio-format (get-track-audio-format track))(get-format-priority preferred-audio-format (get-track-audio-format x))))))))
lst))(setf pos (position-if #'(lambda (x)(when (ad-by-multiaudio-p x)(< (get-preferred-priority preferred-audio (get-track-audio-sad-lang-if-avail track))(get-preferred-priority preferred-audio (get-track-audio-sad-lang-if-avail x)))))
lst)))(setf pos (position-if #'(lambda (x)(or (and (not ad-enable) (ad-by-multiaudio-p x))(and (not (ad-by-multiaudio-p x))(or (< (get-lang-priority preferred-audio (get-track-audio-sad-lang-if-avail track) (get-track-audio-type track))(get-lang-priority preferred-audio (get-track-audio-sad-lang-if-avail x) (get-track-audio-type x)))(when (= (get-lang-priority preferred-audio (get-track-audio-sad-lang-if-avail track) (get-track-audio-type track))(get-lang-priority preferred-audio (get-track-audio-sad-lang-if-avail x) (get-track-audio-type x)))(or (< (get-audio-type-priority (get-track-audio-type track))(get-audio-type-priority (get-track-audio-type x)))(and (= (get-audio-type-priority (get-track-audio-type track))(get-audio-type-priority (get-track-audio-type x)))(< (get-format-priority preferred-audio-format (get-track-audio-format track))(get-format-priority preferred-audio-format (get-track-audio-format x))))))))))
lst)))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track)))))(if is-nz
(when (or (not audio-choice-num) (< (length lst) audio-choice-num))(let ((pos nil) (preferred-lang preferred-audio))(when preferred-common-lang
(setf preferred-lang (cons preferred-common-lang preferred-audio)))(if ad-enable
(setf pos (position-if #'(lambda (x)(or (< (get-preferred-priority preferred-lang (get-track-audio-sad-lang-if-avail track))(get-preferred-priority preferred-lang (get-track-audio-sad-lang-if-avail x)))(when (= (get-preferred-priority preferred-lang (get-track-audio-sad-lang-if-avail track))(get-preferred-priority preferred-lang (get-track-audio-sad-lang-if-avail x)))(or (< (get-audio-type-priority-ad track)(get-audio-type-priority-ad x))(and (= (get-audio-type-priority-ad track)(get-audio-type-priority-ad x))(< (get-format-priority preferred-audio-format (get-track-audio-format track))(get-format-priority preferred-audio-format (get-track-audio-format x))))))))
lst))(setf pos (position-if #'(lambda (x)(or (< (get-audio-type-priority (get-track-audio-type track))(get-audio-type-priority (get-track-audio-type x)))(when (= (get-audio-type-priority (get-track-audio-type track))(get-audio-type-priority (get-track-audio-type x)))(or (< (get-preferred-priority preferred-lang (get-track-audio-lang track))(get-preferred-priority preferred-lang (get-track-audio-lang x)))(and (= (get-preferred-priority preferred-lang (get-track-audio-lang track))(get-preferred-priority preferred-lang (get-track-audio-lang x)))(< (get-format-priority preferred-audio-format (get-track-audio-format track))(get-format-priority preferred-audio-format (get-track-audio-format x))))))))
lst)))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track))))(if (and (or is-nordic is-hungary) (not is-finland))(when (or (not audio-choice-num) (< (length lst) audio-choice-num))(let ((pos nil))(if (and (eq current-network 1) ad-enable)(setf pos (position-if #'(lambda (x)(or (< (get-preferred-priority-nar preferred-audio (get-track-audio-sad-lang-if-avail track))(get-preferred-priority-nar preferred-audio (get-track-audio-sad-lang-if-avail x)))(when (= (get-preferred-priority-nar preferred-audio (get-track-audio-sad-lang-if-avail track))(get-preferred-priority-nar preferred-audio (get-track-audio-sad-lang-if-avail x)))(or (< (get-audio-type-priority-ad track)(get-audio-type-priority-ad x))(when (= (get-audio-type-priority-ad track)(get-audio-type-priority-ad x))(or (< (get-format-with-aaclv-priority (get-track-audio-format track)(if (= (get-track-audio-format track) #x11)(get-aac-priority (get-track-audio-aac-type track)) 1))(get-format-with-aaclv-priority (get-track-audio-format x)(if (= (get-track-audio-format x) #x11)(get-aac-priority (get-track-audio-aac-type x)) 1)))))))))
lst))(setf pos (position-if #'(lambda (x)(or (< (get-preferred-priority preferred-audio (get-track-audio-lang track))(get-preferred-priority preferred-audio (get-track-audio-lang x)))(when (= (get-preferred-priority preferred-audio (get-track-audio-lang track))(get-preferred-priority preferred-audio (get-track-audio-lang x)))(or (< (get-audio-type-preferred-priority preferred-audio-type track)(get-audio-type-preferred-priority preferred-audio-type x))(when (= (get-audio-type-preferred-priority preferred-audio-type track)(get-audio-type-preferred-priority preferred-audio-type x))(or (< (get-format-with-aaclv-priority (get-track-audio-format track)(if (= (get-track-audio-format track) #x11)(get-aac-priority (get-track-audio-aac-type track)) 1))(get-format-with-aaclv-priority (get-track-audio-format x)(if (= (get-track-audio-format x) #x11)(get-aac-priority (get-track-audio-aac-type x)) 1)))))))))
lst)))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track))))(if is-finland
(when (or (not audio-choice-num) (< (length lst) audio-choice-num))(let ((pos nil))(setf pos (position-if #'(lambda (x)(or (< (get-audio-type-preferred-priority preferred-audio-type track)(get-audio-type-preferred-priority preferred-audio-type x))(when (= (get-audio-type-preferred-priority preferred-audio-type track)(get-audio-type-preferred-priority preferred-audio-type x))(or (< (get-preferred-priority preferred-audio (get-track-audio-lang track))(get-preferred-priority preferred-audio (get-track-audio-lang x)))(when (= (get-preferred-priority preferred-audio (get-track-audio-lang track))(get-preferred-priority preferred-audio (get-track-audio-lang x)))(or (< (get-format-with-aaclv-priority (get-track-audio-format track)(if (= (get-track-audio-format track) #x11)(get-aac-priority (get-track-audio-aac-type track)) 1))(get-format-with-aaclv-priority (get-track-audio-format x)(if (= (get-track-audio-format x) #x11)(get-aac-priority (get-track-audio-aac-type x)) 1)))))))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track))))(if is-cont
(when (or (not audio-choice-num) (< (length lst) audio-choice-num))(let ((pos nil))(setf pos (position-if #'(lambda (x)(or (< (get-preferred-priority preferred-audio (get-track-audio-lang track))(get-preferred-priority preferred-audio (get-track-audio-lang x)))(when (= (get-preferred-priority preferred-audio (get-track-audio-lang track))(get-preferred-priority preferred-audio (get-track-audio-lang x)))(or (< (get-audio-type-priority (get-track-audio-type track))(get-audio-type-priority (get-track-audio-type x)))(when (= (get-audio-type-priority (get-track-audio-type track))(get-audio-type-priority (get-track-audio-type x)))(or (< (get-format-priority preferred-audio-format (get-track-audio-format track))(get-format-priority preferred-audio-format (get-track-audio-format x)))(and (= (get-format-priority preferred-audio-format (get-track-audio-format track))(get-format-priority preferred-audio-format (get-track-audio-format x)))(= (get-track-audio-format track) #x11)(< (get-aac-priority (get-track-audio-aac-type track))(get-aac-priority (get-track-audio-aac-type x))))))))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track))))(if is-brazil
(when (or (not audio-choice-num) (< (length lst) audio-choice-num))(let ((pos nil))(setf pos (position-if #'(lambda (x)(or (< (get-audio-primary-tag-priority (get-track-tag track))(get-audio-primary-tag-priority (get-track-tag x)))(and (= (get-audio-primary-tag-priority (get-track-tag track))(get-audio-primary-tag-priority (get-track-tag x)))(< (get-format-priority-he-aac (get-track-audio-format track))(get-format-priority-he-aac (get-track-audio-format x))))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track))))(when (or (not audio-choice-num) (< (length lst) audio-choice-num))(let ((pos nil))(setf pos (position-if #'(lambda (x)(or (< (get-preferred-priority preferred-audio (get-track-audio-lang track))(get-preferred-priority preferred-audio (get-track-audio-lang x)))(when (= (get-preferred-priority preferred-audio (get-track-audio-lang track))(get-preferred-priority preferred-audio (get-track-audio-lang x)))(or (< (get-format-priority preferred-audio-format (get-track-audio-format track))(get-format-priority preferred-audio-format (get-track-audio-format x)))(and (= (get-format-priority preferred-audio-format (get-track-audio-format track))(get-format-priority preferred-audio-format (get-track-audio-format x)))(< (get-audio-type-priority (get-track-audio-type track))(get-audio-type-priority (get-track-audio-type x))))))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track)))))))))))

(defun append-subtitle-track (track lst)(if (eq is-uk t)(progn
(when (or (not subtitle-choice-num) (< (length lst) subtitle-choice-num))(let ((pos nil) (und (list (list "und"))))(do ((loopcount 0 (+ loopcount 1)))((> loopcount (- (length lst) 1)) loopcount)(if (= 0 (get-preferred-priority preferred-subtitle (get-track-subtitle-lang (nth loopcount lst))))(setf und nil)))(setf pos (position-if #'(lambda (x)(or	 (< (get-preferred-priority preferred-subtitle (get-track-subtitle-lang track))(get-preferred-priority preferred-subtitle (get-track-subtitle-lang x)))(< (get-preferred-priority und (get-track-subtitle-lang track))(get-preferred-priority und (get-track-subtitle-lang x)))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track)))))(if (eq is-nz t)(progn
(when (or (not subtitle-choice-num) (< (length lst) subtitle-choice-num))(let ((pos nil) (preferred-lang preferred-subtitle))(when preferred-common-lang
(setf preferred-lang (cons preferred-common-lang preferred-subtitle)))(setf pos (position-if #'(lambda (x)(or	(< (get-preferred-priority preferred-lang (get-track-subtitle-lang track))(get-preferred-priority preferred-lang (get-track-subtitle-lang x)))(and (= (get-preferred-priority preferred-lang (get-track-subtitle-lang track))(get-preferred-priority preferred-lang (get-track-subtitle-lang x)))(< (get-subtitle-type-priority (get-track-subtitle-type track))(get-subtitle-type-priority (get-track-subtitle-type x))))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track)))))(when (or (not subtitle-choice-num) (< (length lst) subtitle-choice-num))(let ((pos nil))(setf pos (position-if #'(lambda (x)(< (get-preferred-priority preferred-subtitle (get-track-subtitle-lang track))(get-preferred-priority preferred-subtitle (get-track-subtitle-lang x))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track)))))))

(defun append-teletext-track (track lst)(when (or (not teletext-choice-num) (< (length lst) teletext-choice-num))(let ((pos nil))(setf pos (position-if #'(lambda (x)(< (get-preferred-priority preferred-teletext (get-track-teletext-lang track))(get-preferred-priority preferred-teletext (get-track-teletext-lang x))))
lst))(if (not pos)(setf-cdr (last lst) (cons track nil))(setf-nthcdr pos lst (cons (nth pos lst) (nthcdr (1+ pos) lst)))(setf-nth pos lst track)))))

(defmacro add-lst-tail (src-lst add-lst)
`(when ,add-lst
(if ,src-lst
(nconc ,src-lst ,add-lst)(setf ,src-lst ,add-lst))))

(defun cut-list (lst num)(let ((olst nil) (len))(setf len (length lst))(when (> num len)(setf num len))(do ((pos 0 (+ pos 1)))((>= pos num))(if olst
(setf-cdr (last olst) (cons (nth pos lst) nil))(setf olst (cons (nth pos lst) nil))))
olst))

(defun sort-calist (lst vpid apid)(let ((plst nil)(slst nil))(mapcar #'(lambda (n)(if (or (= vpid (first n))(= apid (first n)))(if plst
(setf-cdr (last plst) (cons n nil))(setf plst (cons n nil)))(if slst
(setf-cdr (last slst) (cons n nil))(setf slst (cons n nil)))))
lst)(add-lst-tail plst slst)
plst))

(defun pmt-parser (pmt key)(when (get-psi-svcid 'psi)(unless (eq (get-tuning-svcid) (get-psi-svcid 'psi))(set-tuning-svcid (get-psi-svcid 'psi))(unless (eq (get-tuning-svcid)(svl-get-data (get-signal-source-svl key) 'svcid))(set-signal-source-svl key nil))))(setf subt-pid -1)(setf subt-pid-ttx -1)(setf dvb-sttl-msg 0)(setf vbi-sttl-msg 0)(setf video-track-list nil)(setf audio-track-list nil)(send-teletext-choice-list nil)(send-subtitle-choice-list nil)(setf subtitle-track-list nil)(setf teletext-track-list nil)(setf teletext-sttl-choice-list nil)(setf subtitle-track-num 0)(setf teletext-sttl-choice-num 0)(setf pmt-parental-age 0)(setf pmt-parental-country-code "---")(setf pmt-rec-ctrl-data nil)(setf cur-calist nil)(setf calist-vpid nil)(setf calist-apid nil)

(if (not pmt)(progn
(send-no-copy nil)(send-video-choice-list nil)(send-audio-choice-list nil)(set-eit-for-sit-filter nil nil nil)(set-sdt-for-sit-filter nil nil nil)(set-video-pid 'video-mon nil)(when (transcode-transfer-p)(set-encode-video-pid nil)(set-encode-audio-pid nil)(psi-invalidate 'psi-enc)(section-close 'pmt-enc))(cancel-partial))(let ((header) (firstlp) (secondlp) (esheader) (esdesclp) (pcrpid)(stype) (service) (espid) (tag) (track) (lang) (type) (info-desc)(auto-start nil) (update nil)(vlist nil) (slist nil) (tlist nil) (mlist nil) (calist nil)(ad-list nil) (level-idc) (pmt-current-ver nil))(setf scramble-p nil)(setf header (first pmt))(setf firstlp (second pmt))(setf secondlp (third pmt))(setf request-pcr (+ (* (logand (nth 8 header) #x1F) #x100)(nth 9 header)))(setf request-pids nil)(setf level-idc 0)(unless (equal (tsl-get-data (get-tuning-tsl-key) 'ntype 'ya_nid)
'(1 #x3b))(set-eit-for-sit-filter #x12 #x4e (get-tuning-svcid))(set-sdt-for-sit-filter #x11 #x42 (get-tuning-tsid)))(setf pmt-current-version (/ (logand (nth 5 header) #x3E) #x2))(unless (eq pmt-version pmt-current-ver)(when pmt-version
(setf update t))(setq pmt-version pmt-current-ver)(send-event SC_RES_PMT_UPDATE 0 nil))(mapcar #'(lambda (desc)(when (eq (+ 2 (second desc)) (length desc))(case (first desc)(#x09
(setf scramble-p t))(#x55
(when with-latin-parental
(detect-rating-country-code "BRA" (nth 1 desc)(nthcdr 2 desc))))(#xC1
(when with-si-copy-control
(setf pmt-rec-ctrl-data (logand (/ (third desc) 64) #x03)))))))
firstlp)(when with-latin-parental
(send-pmt-parental pmt-parental-age pmt-parental-country-code))(mapcar #'(lambda (eslp)(setf esheader   (first eslp))(setf esdesclp (second eslp))(setf stype (first esheader))(setf espid (+ (* (logand (second esheader) #x1F) #x100)(third esheader)))(setf tag -1)(setf lang (copy-string "---"))(setf type 0)(setf info-desc nil)(setf service nil)(mapcar #'(lambda (desc)(when (eq (+ 2 (second desc)) (length desc))(case (first desc)(#x09
(setf scramble-p t))(#x28
(when (eq stype #x1b)(setf level-idc (fifth desc))))(#x38
(when (eq stype #x24)(setf level-idc (nth 13 desc))(unless level-idc
(setf level-idc 0))))(#x52
(setf tag (third desc)))(#x0a
(setf-char lang 0 (nth 2 desc))(setf-char lang 1 (nth 3 desc))(setf-char lang 2 (nth 4 desc))(setf type (nth 5 desc)))((#x52 #x56 #x59 #x66 #x6a #x7a)(setf info-desc desc)))))
esdesclp)(case stype
((#x01 #x02 #x1b #x24)(unless (and (eq stype #x1b) (not with-hd))(setf track (list espid tag stype level-idc))(if vlist
(append-video-track track vlist)(setf vlist (cons track nil)))))((#x03 #x04 #x0f #x11 #x81)(setf service 'audio)(unless (or (and (eq stype #x11) (not with-hd))(and (eq stype #x81) (not with-ac3)))(setf track (list espid tag
(list stype lang type -1 -1)))(if (and with-ad
(eq type 3)(or (eq stype #x03)(eq stype #x04)(eq stype #x11)))(if ad-list
(setf-cdr (last ad-list) (cons track nil))(setf ad-list (cons track nil)))(if audio-track-list
(append-audio-track track audio-track-list)(setf audio-track-list (cons track nil))))))

(#x05
(let ((private nil))(mapcar #'(lambda (desc)(case (first desc)(#x5F
(when (and (eq (nth 1 desc) 4)(eq (nth 2 desc) #x46)(eq (nth 3 desc) #x53)(eq (nth 4 desc) #x41)(eq (nth 5 desc) #x54))(setf private t)))(#xD1
(when (and with-freesat
(eq current-network 3)(eq (+ 2 (nth 1 desc)) (length desc))
private)(when (and (eq (nth 1 desc) 1)(eq (nth 2 desc) #x02))(set-eit-for-sit-filter espid #xd1 (get-tuning-svcid)))

(when (and (eq (nth 1 desc) 2)(eq (nth 2 desc) #x03)(eq (nth 3 desc) #x04))(set-sdt-for-sit-filter espid #x46 (get-tuning-tsid)))))))
esdesclp)))

(#x06
(let ((private nil))(mapcar #'(lambda (desc)(case (first desc)(#x5F
(when (and (eq (nth 1 desc) 4)(eq (nth 2 desc) #x46)(eq (nth 3 desc) #x53)(eq (nth 4 desc) #x41)(eq (nth 5 desc) #x54))(setf private t)))(#xD1
(when (and (eq (+ 2 (nth 1 desc)) (length desc))
private)(case (nth 2 desc)(#x09
(setf is-obfuscate-svc t)(setf track (list espid tag
stype level-idc))(if vlist
(append-video-track track vlist)(setf vlist (cons track nil))))(#x0a
(setf service 'audio)))))

(#x6a
(when with-ac3
(setf track (list espid tag (list #x81 lang stype -1 -1)))(if audio-track-list
(append-audio-track track audio-track-list)(setf audio-track-list (cons track nil)))(setf service 'audio)))

(#x7a
(when with-ac3-plus
(setf track (list espid tag (list #x82 lang stype -1 -1)))(if audio-track-list
(append-audio-track track audio-track-list)(setf audio-track-list (cons track nil)))(setf service 'audio)))

(#x52
(when is-brazil
(when (and (>= tag #x30)(<= tag #x3F))(setf service t))))

(#x56
(setf service t)(when (transcode-transfer-p)(if (>= (second desc) 5)(do ((x 0 (+ x 5))(lp (nthcdr 2 desc) (setf lp (nthcdr 5 lp)))(magazine-number)(page-number))((>= x (second desc)))(setf lang (copy-string "---"))(setf-char lang 0 (nth 0 lp))(setf-char lang 1 (nth 1 lp))(setf-char lang 2 (nth 2 lp))(setf type (/ (logand (nth 3 lp) #xf8) #x8))(setf magazine-number (logand (nth 3 lp) #x07))(setf page-number (nth 4 lp))(setf track (list espid tag (list lang type magazine-number page-number)))(if teletext-track-list
(append-teletext-track track teletext-track-list)(setf teletext-track-list (cons track nil))))(setf track (list espid tag (list (copy-string "---") 0 0 0)))(if teletext-track-list
(append-teletext-track track teletext-track-list)(setf teletext-track-list (cons track nil)))(if tlist
(append-teletext-track track tlist)(setf tlist (cons track nil))))))

(#x59
(setf service t)(when (transcode-transfer-p)(if (>= (second desc) 8)(do ((x 0 (+ x 8))(lp (nthcdr 2 desc) (setf lp (nthcdr 8 lp)))(composition-id)(ancillary-id))((>= x (second desc)))(setf lang (copy-string "---"))(setf-char lang 0 (nth 0 lp))(setf-char lang 1 (nth 1 lp))(setf-char lang 2 (nth 2 lp))(setf type (nth 3 lp))(setf composition-id (+ (* (nth 4 lp) #x100) (nth 5 lp)))(setf ancillary-id (+ (* (nth 6 lp) #x100) (nth 7 lp)))(setf track (list espid tag (list lang type composition-id ancillary-id)))(if subtitle-track-list
(append-subtitle-track track subtitle-track-list)(setf subtitle-track-list (cons track nil))))(setf track (list espid tag (list (copy-string "---")  0 0 0)))(if subtitle-track-list
(append-subtitle-track track subtitle-track-list)(setf subtitle-track-list (cons track nil))))))))
esdesclp))))(if calist
(setf-cdr (last calist) (cons (list espid 0) nil))(setf calist (cons (list espid 0) nil)))(when service
(if request-pids
(setf-cdr (last request-pids) (cons (list espid service) nil))(setf request-pids (cons (list espid service) nil)))))
secondlp)(when (or (not ci-bypass-ctrl) scramble-p)(make-event 'scramble-svc))(setf video-track-list vlist)(when (transcode-transfer-p)(setf track nil)(when audio-track-list
(when liveview-audio-info
(setf track (find-if #'(lambda (x)(eq (get-liveview-pid liveview-audio-info)(get-track-pid x)))
audio-track-list)))(unless track
(setf track (find-if #'(lambda (x)(eq last-audio-pid (get-track-pid x)))
audio-track-list)))(when (= last-audio-pid -1)(setf last-audio-pid (get-track-pid track)))(setf calist-apid (get-track-pid track)))(audio-dualmode 'audio (get-liveview-dualmode liveview-audio-info))(when subtitle-track-list
(subtitle-choice))(when (and (or with-ttx-sttl use-ttx-sttl-digital)
teletext-track-list)(teletext-choice))(when (and with-ttx-sttl
(or dvb-sttl-msg vbi-sttl-msg))(sc-check-launch-sttl)))

(when audio-track-list
(send-audio-choice-list
(create-audio-choice-list 'audio audio-track-list)))(unless vlist
(send-event SC_RES_NO_VIDEO 0 nil))(set-cp-src 'cp 'tuner)(set-cp-dst 'cp "dlna-out")(set-cp-stream-info 'cp 1)(set-cp-ca 'cp 'ca)(when vlist
(setf track nil)(when (device-open-p 'video-mon)(set-video-pid 'video-mon (video-pid 'video-mon))(setf track (find-if #'(lambda (x)(eq (get-video-pid 'video-mon)(get-track-pid x)))
vlist)))(unless track
(setf track (find-if #'(lambda (x)(eq last-video-pid (get-track-pid x)))
vlist)))(unless track
(setf track (car vlist)))(setf last-video-pid (get-track-pid track))(setf calist-vpid (get-track-pid track))(set-video-pcr 'video request-pcr)(when (= request-pcr #x1fff)(setf request-pcr (get-track-pid track))(set-video-pcr 'video (get-track-pid track)))(set-video-codec 'video (get-track-pmt-video-codec track))(set-audio-pcr 'audio (get-video-pcr 'video))(setf cur-calist calist)(when update
(make-event 'ca-update))(when track
(send-video-choice-list (list track)))(if request-pids
(progn
(setf-nthcdr 0 request-pids (cons (nth 0 request-pids)(nthcdr (1+ 0) request-pids)))(setf-nth 0 request-pids (list (get-track-pid track) 'video)))(setf request-pids (cons (list (get-track-pid track) 'video) nil))))(eval-rec-partial-stream 'cp))))


(defun c-program-on-with-limit (onid tsid svcid phy-ch free level)(when (and onid tsid phy-ch)(setf tsl-key (svl-create-key "TSL"
:physical_ch phy-ch
:onid onid
:tsid tsid))

(set-tuning-tsl-key tsl-key)(set-tuning-onid onid)(set-tuning-tsid tsid)(set-tuning-svcid svcid)(set-psi-valid 'psi nil)(set-psi-error 'psi nil)(make-event 'psi-invalid)


(if (tsl-equal (get-tuning-tsl-key) (get-tuner-tsl-key 'tuner))(progn
(search-svcid-in-pat (get-tuning-svcid))(make-event 'service-change))(make-event 'tuner-req))))

(defvar tuning-p nil)(defvar error-status nil)

(setf tuning-timeout 3000)

(defun tuning-start-fun ()(setf tuning-p t))

(defun tuning-end-fun ()(setf tuning-p nil)(when error-status
(send-event SC_RES_TUNE_ERROR 0 nil)(psi-set-error 'psi 'tsport (get-tuning-svcid) (get-psi-error 'psi))(make-event 'psi-error)))

(defun enter-tuning-transition ()(tuning-start-fun)(set-timer (function tuning-end-fun)
'tuning-timeout
nil
1
tuning-timeout))

(register-node 'illegal-channel
#'(lambda ()
t)
#'(lambda ()(setf error-status "illegal-channel"))
#'(lambda ()(setf error-status nil)(unless tuning-p
(enter-tuning-transition))))(register-node 'no-signal
#'(lambda ()
t)
#'(lambda ()(setf error-status "no-signal"))
#'(lambda ()(setf error-status nil)(unless tuning-p
(enter-tuning-transition))))(register-node 'pat-timeout
#'(lambda ()
t)
#'(lambda ()(unless (get-psi-valid 'psi)(setf error-status "pat-timeout")))
#'(lambda ()(unless (get-psi-valid 'psi)(setf error-status nil)(unless tuning-p
(enter-tuning-transition)))))(register-node 'no-pmt
#'(lambda ()
t)
#'(lambda ()(setf error-status "no-pmt"))
#'(lambda ()(setf error-status nil)(unless tuning-p
(enter-tuning-transition))))(register-node 'pmt-timeout
#'(lambda ()
t)
#'(lambda ()(unless (get-psi-valid 'psi)(setf error-status "pmt-timeout")))
#'(lambda ()(unless (get-psi-valid 'psi)(setf error-status nil)(unless tuning-p
(enter-tuning-transition)))))(register-node 'illegal-tsid
#'(lambda ()
t)
#'(lambda ()(setf error-status "illegal-tsid"))
#'(lambda ()(setf error-status nil)(unless tuning-p
(enter-tuning-transition))))


(defun send-no-copy (status)(unless (eq no-copy-status status)(send-event SC_CREC_NO_COPY 4 (list (if status 1 0)))(setf no-copy-status status)))

(defvar av-decode-stat nil)

(register-node 'parental-check
#'(lambda (key)(if with-latin-parental
(not (child-lock-p key))
t))
#'(lambda ()(eval-events (list 'parental-check)))
#'(lambda ()
nil))

(register-node 'setup-channel
#'(lambda ()(get-tuning-tsl-key))
#'(lambda ()(set-tuner-tsl-key 'tuner (get-tuning-tsl-key))(set-tuner-onid 'tuner (get-tuning-onid))(set-tuner-tsid 'tuner (get-tuning-tsid))(eval-events (list 'tuner-req 'tuner-change)))
#'(lambda ()
nil))

(register-device 'tsport-ci1
"tsport"
(get-default-prio)
#'(lambda (sig)(case sig
(SOURCE_CHANGE
(make-event 'tsport-ci1-change)))))(register-device 'tsport-ci2
"tsport"
(get-default-prio)
#'(lambda (sig)(case sig
(SOURCE_CHANGE
(make-event 'tsport-ci2-change)))))(register-device 'ca-sub
"ca"
(get-default-prio)
#'(lambda (sig)(case sig
(CA_SESSION_OPEN
(set-ca-session 'ca-sub t)(make-event 'ca-sub-session-open))(CA_SESSION_CLOSE
(set-ca-session 'ca-sub nil)))))

(register-node 'my-tsport-connect
#'(lambda (key)(get-connected-tsport-dev))
#'(lambda (key)(let ((cur-tsport-dev (get-connected-tsport-dev)))(when (or (not cur-tsport-dev)(eq cur-tsport-dev 'tsport))(when (device-open-p 'tsport-ci1)(tsport-disconnect 'tsport-ci1))(when (device-open-p 'tsport-ci2)(tsport-disconnect 'tsport-ci2))(tsport-connect 'tsport 'tuner)))(eval-events (list 'tsport-available 'tsport-change
'tsport-ci1-change 'tsport-ci2-change)))
#'(lambda (key)(tsport-disconnect 'tsport)))

(register-node 'tsport-ci-connect
#'(lambda ()(eq (get-connected-tsport-dev) (get-tsport-ci-dev)))
#'(lambda ()(let ((cur-tsport-dev (get-connected-tsport-dev))(new-tsport-dev (get-tsport-ci-dev)))(unless (eq cur-tsport-dev new-tsport-dev)(when cur-tsport-dev
(tsport-disconnect cur-tsport-dev)(unless (eq cur-tsport-dev 'tsport)(tsport-disconnect 'tsport))))(when new-tsport-dev
(tsport-connect new-tsport-dev (get-tuning-tuner))(unless (eq new-tsport-dev 'tsport)(tsport-connect 'tsport new-tsport-dev))))(eval-events (list 'tsport-available 'tsport-ci1-available 'tsport-ci2-available
'tsport-change 'tsport-ci1-change 'tsport-ci2-change
'ca-module-extract 'ca-session-open 'ca-session-close
'scramble-svc 'tsport-ci-switch)))
#'(lambda ()(let ((cur-tsport-dev (get-connected-tsport-dev)))(unless (eq cur-tsport-dev 'tsport)(tsport-disconnect cur-tsport-dev)(tsport-disconnect 'tsport))(tsport-connect 'tsport (get-tuning-tuner)))))

(defvar stream-scramble-fixed nil)(defvar stream-scramble-fix-timeout 8000)(register-node 'stream-scramble-fix
#'(lambda ()
stream-scramble-fixed)
#'(lambda ()(cancel-timer 'stream-scramble-fix-timer)(unless stream-scramble-fixed
(set-timer #'(lambda ()(when (and scramble-p)(setf stream-scramble-fixed t)(make-event 'stream-scramble-fixed)))
'stream-scramble-fix-timer
nil
1
stream-scramble-fix-timeout))(eval-events (list 'stream-scramble-fixed)))
#'(lambda ()(setf stream-scramble-fixed nil)(cancel-timer 'stream-scramble-fix-timer)))

(register-node 'tsport-ci-switch
#'(lambda ()
t)
#'(lambda ()(when (and (eq (ca-status 'ca-sub) 'CA_SESSION_OPEN)(not tsport-ci-switch-done))(ca-select-slot (- 1 last-ci-slot-no))(setf tsport-ci-switch-done t)(make-event 'tsport-ci-switch))(eval-events (list 'ca-sub-session-open)))
#'(lambda ()))

(register-node 'tsport-ci-recover
#'(lambda ()
t)
#'(lambda ()(when (or (eq (get-tsport-ci-dev) 'tsport-ci1)(eq (get-tsport-ci-dev) 'tsport-ci2))(when (eq (ca-status 'ca-sub) 'CA_SESSION_OPEN)(progn
(ca-select-slot (- 1 last-ci-slot-no))(setf tsport-ci-switch-done t)(make-event 'tsport-ci-switch))))(eval-events (list 'ca-sub-session-open)))
#'(lambda ()))

(register-node 'my-ca-request
#'(lambda ()
t)
#'(lambda ()(when (or (eq (get-connected-tsport-dev) 'tsport-ci1)(eq (get-connected-tsport-dev) 'tsport-ci2))(if (eq last-sttl-pid -1)(ca-request 'ca 'psi (cut-list (sort-calist cur-calist calist-vpid calist-apid) calist-max))(ca-request 'ca 'psi (cut-list (sort-calist-sttl cur-calist calist-vpid calist-apid cur-sttl-pid) calist-max))))(eval-events (list 'ca-session-open 'ca-update)))
#'(lambda ()(ca-cancel 'ca)))

(register-node 'ciplus-check
#'(lambda ()
t)
#'(lambda ()(when (and (or (eq (get-connected-tsport-dev) 'tsport-ci1)(eq (get-connected-tsport-dev) 'tsport-ci2))(is-ciplus-cam 'ca)
scramble-p)(send-event SC_RES_CAS_CIPLUS 0 nil))(eval-events (list 'ca-session-open 'ciplus-cam-status)))
#'(lambda ()))

(defun get-tsport-ci-dev ()(if (or
(and (not ci-bypass-ctrl)(not (eq (ca-status 'ca) nil)))(and (eq (ca-status 'ca) 'CA_SESSION_OPEN)
scramble-p))(if (and (tuner-info 'tuner 'ci-overspec)(not (is-ciplus-cam 'ca)))
'tsport
(if with-tsport-ci1
'tsport-ci1
(if with-tsport-ci2
'tsport-ci2
'tsport)))
'tsport))

(defun get-connected-tsport-dev ()(if (device-source-p 'tsport 'tuner)
'tsport
(if (and (device-open-p 'tsport-ci1)(device-source-p 'tsport 'tsport-ci1)(device-source-p 'tsport-ci1 'tuner))
'tsport-ci1
(if (and (device-open-p 'tsport-ci2)(device-source-p 'tsport 'tsport-ci2)(device-source-p 'tsport-ci2 'tuner))
'tsport-ci2
nil))))

(register-section 'eit-for-sit
nil)(register-section 'sdt-for-sit
nil)(register-section 'pmt-enc
nil)

(defun set-eit-for-sit-filter (pid tid tid-ex)(set-section-pid 'eit-for-sit pid)(setf (nth 0 (get-section-filter 'eit-for-sit)) (if tid tid #xff))(setf (nth 0 (get-section-mask 'eit-for-sit)) (if tid 0 #xff))(setf (nth 3 (get-section-filter 'eit-for-sit)) (if tid-ex (/ tid-ex #x100) #xff))(setf (nth 3 (get-section-mask 'eit-for-sit)) (if tid-ex 0 #xff))(setf (nth 4 (get-section-filter 'eit-for-sit)) (if tid-ex (logand tid-ex #xFF) #xff))(setf (nth 4 (get-section-mask 'eit-for-sit)) (if tid-ex 0 #xff))(make-event 'eit-for-sit-update))

(register-node 'sdt-for-sit-request
#'(lambda ()
t)
#'(lambda ()(when (get-section-pid 'sdt-for-sit)(section-open 'sdt-for-sit)(section-disable 'sdt-for-sit)(section-filter 'sdt-for-sit
:type "version"
:source 'tsport
:pid (get-section-pid 'sdt-for-sit)
:length (get-section-length 'sdt-for-sit)
:filter (get-section-filter 'sdt-for-sit)
:mask (get-section-mask 'sdt-for-sit)
:elength (get-section-elength 'sdt-for-sit)
:efilter (get-section-efilter 'sdt-for-sit)
:emask (get-section-emask 'sdt-for-sit))(section-enable 'sdt-for-sit))(eval-events (list 'sdt-for-sit-update)))
#'(lambda ()(section-close 'sdt-for-sit)))(defun set-sdt-for-sit-filter (pid tid tid-ex)(set-section-pid 'sdt-for-sit pid)(setf (nth 0 (get-section-filter 'sdt-for-sit)) (if tid tid #xff))(setf (nth 0 (get-section-mask 'sdt-for-sit)) (if tid 0 #xff))(setf (nth 3 (get-section-filter 'sdt-for-sit)) (if tid-ex (/ tid-ex #x100) #xff))(setf (nth 3 (get-section-mask 'sdt-for-sit)) (if tid-ex 0 #xff))(setf (nth 4 (get-section-filter 'sdt-for-sit)) (if tid-ex (logand tid-ex #xFF) #xff))(setf (nth 4 (get-section-mask 'sdt-for-sit)) (if tid-ex 0 #xff))(make-event 'sdt-for-sit-update))

(register-node 'sit-insert
#'(lambda ()
t)
#'(lambda ()(set-timer #'(lambda (x)(partial-insert-sit (if (transcode-transfer-p)
'partial-enc
'partial)
:dst (if req-transcode "limited" nil)
:svcid (get-tuning-svcid)
:eit 'eit-for-sit
:sdt 'sdt-for-sit))
'sit-timer
nil
nil
1000))
#'(lambda ()(cancel-timer 'sit-timer)))

(when with-freesat
(defvar pfeit-pp-pid nil)(unregister-section 'pmt)

(register-section 'pmt
#'(lambda (data)(if (get-section-valid 'pmt)(make-event 'pmt-update)(set-section-valid 'pmt t)(make-event 'pmt-valid))(when (psi-validate 'psi 'pmt)(set-psi-error 'psi nil)(if (get-psi-valid 'psi)(make-event 'psi-update)(set-psi-valid 'psi t)(make-event 'psi-valid)))

(let ((ptr) (len) (stype) (espid) (tag nil)(pid nil) (private))(mapcar
#'(lambda (sec)(setf ptr (nthcdr 12 sec))(setf len (+ (* (logand (nth 10 sec) #xF) #x100)(nth 11 sec)))(setf private nil)(do ((x 0))((>= x len))(case (car ptr)(#x5F
(when (and (eq (nth 1 ptr) 4)(eq (nth 2 ptr) #x46)(eq (nth 3 ptr) #x53)(eq (nth 4 ptr) #x41)(eq (nth 5 ptr) #x54))(setf private t)))(#xD0
(do ((y 0))((or (>= y (nth 1 ptr)) tag))(when (eq (nth (+ 2 y) ptr) 2)(setf tag (nth (+ 3 y) ptr)))(setf y (+ y 2))))(otherwise
))(setf x (+ x 2 (nth 1 ptr)))(setf ptr (nthcdr (+ 2 (nth 1 ptr)) ptr)))(unless private
(setf tag nil))(do ((z 0))((or (>= 4 (length ptr)) pid))(setf stype (nth 0 ptr))(setf espid (+ (* (logand (nth 1 ptr) #x1F) #x100)(nth 2 ptr)))(setf len (+ (* (logand (nth 3 ptr) #xF) #x100)(nth 4 ptr)))(setf ptr (nthcdr 5 ptr))(if (not (eq stype 5))(setf ptr (nthcdr len ptr))(setf private nil)(do ((x 0))((or (>= x len)(and private pid)))(case (car ptr)(#x5F
(when (and (eq (nth 1 ptr) 4)(eq (nth 2 ptr) #x46)(eq (nth 3 ptr) #x53)(eq (nth 4 ptr) #x41)(eq (nth 5 ptr) #x54))(setf private t)))(#xD1
(unless tag
(do ((y 0))((or (>= y (nth 1 ptr)) pid))(when (eq (nth (+ 2 y) ptr) 2)(setf pid espid))(setf y (+ y 1)))))(#x52
(when (and tag (eq tag (nth 2 ptr)))(setf pid espid)(setf private t)))(otherwise))(setf x (+ x 2 (nth 1 ptr)))(setf ptr (nthcdr (+ 2 (nth 1 ptr)) ptr)))(unless private
(setf pid nil)))))
data)(when (and pid (not (eq pid pfeit-pp-pid)))(setf pfeit-pp-pid pid)(send-event SC_RES_EIT_PF_PP_PID
4 (list pfeit-pp-pid)))))))(defvar with-tsport-ci1 nil)(defvar with-tsport-ci2 nil)

(defun sender-with-tuner-local-initialize ()(setf eit-rec-ctrl-data nil)(setf sdt-rec-ctrl-data nil)(setf eit-retention-mode nil)(setf sdt-retention-mode nil)

(init-section-object 'eit-for-sit)(init-section-object 'sdt-for-sit)

(append-t
'pat-request
'eit-for-sit-request)

(append-t
'pat-request
'sdt-for-sit-request)

(append-nil
'tuner-freq-valid
'illegal-channel)

(append-nil
'tuner-connect
'no-signal)

(append-nil
'pat-request
'pat-timeout)

(append-nil
'pmt-pid-valid
'no-pmt)

(append-nil
'pmt-request
'pmt-timeout)

(append-nil
'tsid-check
'illegal-tsid))

(defun sender-with-tuner-local-stop ())(defun dish-setup (sat low high tone-en)(let ((dish-param (nth sat dish-param-list)))(unless (and (eq low (nth 0 dish-param))(eq high (nth 1 dish-param))(eq tone-en (nth 2 dish-param)))(setf (nth sat dish-param-list) (list low high tone-en))(when (with-dvb-sat-p)(tuner-setup 'tuner
:satellite sat
:dish-low low
:dish-high high
:dish-tone-en tone-en)(make-event (list 'tuner-unlock 'tuner))))))

(defun send-dual-audio-choice-list (lst)(unless (equal dual-audio-choice-list lst)(setf dual-audio-choice-list lst)))

(defvar video-choice-list nil)(defvar audio-choice-list nil)(defvar dual-audio-choice-list nil)

(defun decide-audio-dmix-mode (format))

(defun eval-content-partial-stream ()(setf psi-play-sym 'psi)(let ((pids nil) (vpid nil) (vtype nil) (apid nil) (atype nil)(dpid nil) (emi nil) (content-emi 1))(mapcar #'(lambda (z)(if pids
(setf-cdr (last pids) (cons z nil))(setf pids (cons z nil))))
request-pids)(mapcar #'(lambda (x)(unless vpid
(when  (find (get-track-pid x) pids)(setf vpid (get-track-pid x))(setf vtype (get-track-ppmt-video-codec x)))))
video-track-list)(mapcar #'(lambda (x)(unless apid
(when (and (find (get-track-pid x) pids)(= (get-track-pid x) req-audio))(setf apid (get-track-pid x))(setf atype (get-track-audio-format x)))))
audio-track-list)(if (and (not audio-track-list)(not video-track-list))(unless dpid
(setf pids nil)))(request-partial request-pcr vpid vtype apid atype content-emi nil
pids req-transcode-mode)))

(defun ppmt-parser (pmt)(set-video-pcr 'video nil)(set-audio-pcr 'audio nil)(setf video-track-list nil)(setf audio-track-list nil)(setf pmt-dccd-gene -1)(if (not pmt)(progn
(setf pmt-ver nil)(setf pmt-svcid nil)(send-video-choice-list nil)(send-audio-choice-list nil)(send-dual-audio-choice-list nil)(set-video-pid 'video nil)(set-audio-pid 'audio nil)(setf request-pids nil))(let ((header) (firstlp) (secondlp) (esheader)(esdesclp) (pcrpid) (update nil)(stype) (espid) (tag) (track) (lang) (type)(info-desc) (pmt-current-ver nil) (last-audio)(vlist nil) (alist nil) (slist nil) (tlist nil) (ad-list)(sad-lang (copy-string "---")) (sad-mix-type -1)(sad-ed-class -1) (sad-found 0) (sad-lang-present -1)(lang-list nil) (type-list nil)(dualmode nil))(setf header (first pmt))(setf firstlp (second pmt))(setf secondlp (third pmt))(setf pmt-svcid (+ (* (nth 3 header) #x100) (nth 4 header)))(setf pcrpid (+ (* (logand (nth 8 header) #x1F) #x100)(nth 9 header)))(setf request-pcr pcrpid)(setf pmt-current-ver (nth 5 header))(unless (eq pmt-version pmt-current-ver)(setq pmt-version pmt-current-ver)(send-event SC_RES_PMT_UPDATE 0 nil))(mapcar #'(lambda (desc)(when (eq (+ 2 (second desc)) (length desc))(case (first desc)(#xc1
(let ((cct) (drcd))(setf drcd (/ (logand (nth 2 desc) #xc0) #x40))(setf cct (/ (logand (nth 2 desc) #x0c) #x04))(setf pmt-dccd-gene drcd)(when (= drcd #x01)(setf pmt-dccd-gene
(cond ((= cct #x3)
-1)((= cct #x1)
#x3)(t
#x0)))))))))
firstlp)

(mapcar #'(lambda (eslp)(setf esheader   (first eslp))(setf esdesclp (second eslp))(setf stype (first esheader))(setf espid (+ (* (logand (second esheader) #x1F) #x100)(third esheader)))(setf tag -1)(setf aac-type -1)(setf lang (copy-string "---"))(setf type 0)(setf info-desc nil)(setf lang-list nil)(setf type-list nil)(mapcar #'(lambda (desc)(when (eq (+ 2 (second desc)) (length desc))(case (first desc)(#x52
(setf tag (third desc)))(#x0a
(let ((desclen))(setf desclen (- (second desc) 1))(do ((loopcount 0 (+ loopcount 4)))((> loopcount desclen) loopcount)(setf lang (copy-string "---"))(setf-char lang 0 (nth (+ 2 loopcount) desc))(setf-char lang 1 (nth (+ 3 loopcount) desc))(setf-char lang 2 (nth (+ 4 loopcount) desc))(if lang-list
(setf-cdr (last lang-list) (cons lang nil))(setf lang-list (cons lang nil)))(setf type (nth 5 desc))(if type-list
(setf-cdr (last type-list) (cons type nil))(setf type-list (cons type nil))))))((#x66 #x6a #x7a)(setf info-desc desc))((#x7c)(if (= (logand (fourth desc) #x80) #x80)(setf aac-type (fifth desc)))))))
esdesclp)(case stype
((#x01 #x02 #x1b #x24)(unless (and (eq stype #x1b)(not (or with-hd
(not (eq current-network 1)))))(setf track (list espid tag (list stype pcrpid)))(if vlist
(append-track track vlist)(setf vlist (cons track nil)))))((#x03 #x04 #x0f #x11 #x81)(unless lang-list
(setf lang-list (cons lang nil)))(do ((loopcount 0 (+ loopcount 1)))((> loopcount (- (length lang-list) 1)) loopcount)(unless (or (and (eq stype #x11) (not with-he-aac))(and (eq stype #x81) (not with-ac3)))(setf track (list espid
tag
(list stype
(nth loopcount lang-list)(if type-list
(nth loopcount type-list)
-1)
-1
-1
aac-type)(list sad-found
sad-lang-present
sad-lang
sad-mix-type
sad-ed-class)))(if audio-track-list
(setf-cdr (last audio-track-list) (cons track nil))(setf audio-track-list (cons track nil)))(if alist
(append-audio-track track alist)(setf alist (cons track nil))))))(#x06
(when info-desc
(case (first info-desc)((#x6a #x7a)(let ((fmt nil))(when (and with-ac3 (eq (first info-desc) #x6a))(setf fmt #x81))(when (and with-ac3-plus (eq (first info-desc) #x7a))(setf fmt #x82))(when fmt
(unless lang-list
(setf lang-list (cons lang nil)))(do ((loopcount 0 (+ loopcount 1)))((> loopcount (- (length lang-list) 1)) loopcount)(setf track (list espid
tag
(list fmt
(nth loopcount lang-list)(if type-list
(nth loopcount type-list)
-1)
-1
-1
aac-type)(list sad-found
sad-lang-present
sad-lang
sad-mix-type
sad-ed-class)))(if audio-track-list
(setf-cdr (last audio-track-list) (cons track nil))(setf audio-track-list (cons track nil)))(if alist
(append-audio-track track alist)(setf alist (cons track nil)))))))))))(when espid
(if request-pids
(setf-cdr (last request-pids) (cons espid nil))(setf request-pids (cons espid nil)))))
secondlp)

(when is-nz
(set-preferred-common-lang audio-track-list subtitle-track-list)(setf alist nil)(mapcar #'(lambda (x)(if alist
(append-audio-track x alist)(setf alist (cons x nil))))
audio-track-list))


(setf last-video (get-default-video vlist))(set-encode-video-pid (get-track-pid last-video))(if liveview-audio-info
(progn
(audio-dualmode 'audio (get-liveview-dualmode liveview-audio-info))(setf dualmode (get-liveview-dualmode liveview-audio-info))(let ((pid (get-liveview-pid liveview-audio-info))(track))(if (= pid -1)(setf pid (get-track-pid (get-default-audio alist)))(unless (pid2track pid alist)(progn
(setf pid (get-track-pid (get-default-audio alist)))(set-liveview-pid liveview-audio-info -1)(send-event SC_RES_AUDIO_INFO 12 liveview-audio-info))))

(setf last-audio (pid2track pid alist))(set-encode-audio-pid pid)))(setf last-audio (get-default-audio alist))(set-encode-audio-pid (get-track-pid last-audio))(setf dualmode nil))(setf req-video (get-track-pid last-video))(setf req-audio (get-track-pid last-audio))(set-video-pcr 'video (get-track-video-pcr last-video))(set-video-pid 'video (get-track-pid last-video))(audio-attr 'audio (if (eq (get-track-stype last-video) #x1b)
'avc
(if (eq (get-track-stype last-video) #x24)
'hevd
'mpeg2)))

(setf track (assoc (get-audio-pid 'audio) alist))(when (and update track (not (equal track changed-audio-track)))(setf changed-audio-track nil)(setf track nil))(unless track
(unless track
(setf track (car alist))))(setf video-track-list vlist)

(set-audio-pcr 'audio (get-video-pcr 'video))(set-audio-dmix-mode 'audio (decide-audio-dmix-mode (get-track-audio-format last-audio)))(set-audio-pid 'audio (get-track-pid last-audio))

(send-video-choice-list vlist)(send-audio-choice-list (create-audio-choice-list 'audio audio-track-list))(if dualmode
(setf select-dualmode dualmode)(setf select-dualmode
(get-track-audio-dualmode (assoc (get-audio-pid 'audio) audio-choice-list))))(eval-content-partial-stream))))

(defun connect-player-local-initialize ())

(defun disconnect-player-local ())

(defun content-fixed-local ()(setf event-id req-event-id))

(defun ca-select-slot (slot)(when (eq slot 0)(setf with-tsport-ci1 t)(setf with-tsport-ci2 nil))(when (eq slot 1)(setf with-tsport-ci1 nil)(setf with-tsport-ci2 t))(unless (eq last-ci-slot-no slot)(when (device-open-p 'ca)(my-device-close 'ca))(when (device-open-p 'ca-sub)(my-device-close 'ca-sub)))(unless (device-open-p 'ca)(my-device-open 'ca slot)(init-ca-object 'ca))(unless (device-open-p 'ca-sub)(my-device-open 'ca-sub (- 1 slot))(init-ca-object 'ca-sub))(setf last-ci-slot-no slot)(eval-rec-partial-stream 'cp))
