nrdp.gibbon._showSplashScreen = function(show) {
    var splashWidget;
    var splash_queryParams = nrdp.gibbon._parseQueryParams(nrdp.gibbon._splashUrl);
    var animated = splash_queryParams["animated"];
    if(animated === undefined)
        animated = 1;
    else
        animated = parseInt(animated);
    if(!show) {
        splashWidget = nrdp.gibbon._splashWidget;
        if(splashWidget) {
            if(animated && splashWidget.c.background.visible) {
                splashWidget.opaque = false;
                splashWidget.color = undefined;
                splashWidget.c.background.startAnimation("opacity", undefined, 0, 1200, "ease-in-out-quint");
                splashWidget.c.background.addEventListener("animationFinished", function(a) {
                    if(a.data.property == "opacity" && !a.data.value)
                        nrdp.gibbon.scene.overlay = undefined;
                });

                splashWidget.c.spinner.startAnimation("opacity", undefined, 0, 300, "linear");

                splashWidget.c.logo.startAnimation("opacity", undefined, 0, 600, "ease-in-cubic");
                splashWidget.c.logo.startAnimation("scale", undefined, 1.2, 1000, "ease-in-out-cubic");

                splashWidget.c.shadow.startAnimation("opacity", undefined, 0, 600, "ease-in-cubic");
                splashWidget.c.shadow.startAnimation("scale", undefined, 1.2, 1000, "ease-in-out-cubic");
                splashWidget.c.shadow.startAnimation("y", 489, 503, 1000, "ease-in-out-cubic");
            } else {
                nrdp.gibbon.scene.overlay = undefined;
            }
        } else {
            nrdp.gibbon.scene.overlay = undefined;
        }
        nrdp.gibbon._splashWidget = undefined;
    } else if(!nrdp.gibbon._splashWidget) {
        if(nrdp.gibbon.scene.root && nrdp.gibbon.scene.root.visible)
            return;

        splashWidget = nrdp.gibbon._splashWidget = nrdp.gibbon.makeWidget();
        splashWidget.name = "SplashWidget";
        splashWidget.cache = false;
        splashWidget.color = "#050505";
        splashWidget.opaque = true;
        splashWidget.x = 0;
        splashWidget.y = 0;
        splashWidget.width = 1280;
        splashWidget.height = 720;
        splashWidget.c = {};

        var background = splashWidget.c.background = nrdp.gibbon.makeWidget();
        background.pending = 0;
        background.visible = false;
        background.parent = splashWidget;
        background.name = "SplashWidget::Background";
        background.cache = false;
        background.color = "#050505";
        background.x = 0;
        background.y = 0;
        background.width = 1280;
        background.height = 720;
        background.addPending = function() {
            ++background.pending;
            return function() {
                if(nrdp.gibbon._splashWidget && !--background.pending) {
                    background.visible = true;
                    if(animated && nrdp.gibbon.location == nrdp.system.bootURL) {
                        background.startAnimation("opacity", 0, 1, 500, "linear");
                        spinner.startAnimation("opacity", 0, 1, 2000, "linear");
                        //logo.startAnimation("scale", 0.8, 1.0, 2000, "ease-out-quint");
                        //shadow.startAnimation("scale", 0.8, 1.0, 2000, "ease-out-quint");
                        //shadow.startAnimation("y", 461, 475, 2000, "ease-out-quint");
                    }
                }
            };
        };
        {
            var backgroundImage = nrdp.gibbon.makeWidget();
            backgroundImage.cache = false;
            backgroundImage.name = "SplashWidget::Background::Image";
            backgroundImage.x = 0;
            backgroundImage.y = 320;
            backgroundImage.width = 1280;
            backgroundImage.height = 353;
            backgroundImage.image.url = "http://localcontrol.netflix.com/img/Netflix_Background_Splash.jpg";
            backgroundImage.image.addEventListener("imageLoaded", background.addPending());
            backgroundImage.parent = background;
        }

        var logo = splashWidget.c.logo = nrdp.gibbon.makeWidget();
        logo.parent = background;
        logo.name = "SplashWidget::Logo";
        logo.cache = false;
        logo.smoothScale = true;
        logo.transformOriginX = 200;
        logo.transformOriginY = 54;
        logo.x = 440;
        logo.y = 306;
        logo.width = 400;
        logo.height = 108;
        logo.image.halign = logo.image.valign = "center";
        logo.image.url = "http://localcontrol.netflix.com/img/Netflix_Logo_Splash.png";
        logo.image.addEventListener("imageLoaded", background.addPending());

        var shadow = splashWidget.c.shadow = nrdp.gibbon.makeWidget();
        shadow.parent = background;
        shadow.name = "SplashWidget::Shadow";
        shadow.cache = false;
        shadow.smoothScale = true;
        shadow.transformOriginX = 260;
        shadow.transformOriginY = 18;
        shadow.x = 380;
        shadow.y = 489;
        shadow.width = 521;
        shadow.height = 37;
        shadow.image.halign = shadow.image.valign = "center";
        shadow.image.url = "http://localcontrol.netflix.com/img/Netflix_Shadow_Splash.png";
        shadow.image.addEventListener("imageLoaded", background.addPending());

        if(animated) {
            var spinner = splashWidget.c.spinner = nrdp.gibbon.makeWidget();
            spinner.parent = background;
            spinner.name = "SplashWidget::Spinner";
            spinner.cache = false;
            spinner.x = 616;
            spinner.y = 585;
            spinner.width = 48;
            spinner.height = 48;
            spinner.image.halign = spinner.image.valign = "center";
            spinner.image.sourceRect = { x: 0, y: 0, width: 48, height: 48 };
            spinner.image.url = "http://localcontrol.netflix.com/img/Spinner_Splash.mng";
            spinner.image.addEventListener("imageLoaded", background.addPending());
        }

        nrdp.gibbon.scene.overlay = splashWidget;
    }
}
nrdp.addEventListener("init", function() { nrdp.gibbon._showSplashScreen(true); });
nrdp.isReady ? nrdp.gibbon._showSplashScreen(true) : nrdp.init();


