(function(window,dom){
var mystream=window.MYSTREAM=window.MYSTREAM||{},
AREA_TYPE={A:'A',B:'B',C:'C',D:'D'},
MAX_PAGE=20,
LINK={
UP:0,
LEFT:1,
DIAGONAL:2
},
MAX_ROW=3,
getRandomInt,
shuffleList,
fillList,
Area,
GridData,
ContentsData;
getRandomInt=function(min,max){
return Math.floor(Math.random()*(max-min+1))+min;};
shuffleList=function(list){
var i=list.length,j,temp;
while(i){
j=Math.floor(Math.random()*i);
temp=list[--i];
list[i]=list[j];
list[j]=temp;}
};
fillList=function(sortList,viewTable,columnWidth,fourFrame){
var i,column,row,max,columnList,fFlag;
if(columnWidth===1){
columnList=[];
for(i=0;i<MAX_ROW;i+=1){
sortList.push({fourFrame:false});
columnList.push(sortList[i]);}
viewTable.push(columnList);
return;}
if(!fourFrame.exist){
for(i=0,column=0;column<columnWidth;column+=1){
columnList=[];
for(row=0;row<MAX_ROW;row+=1){
sortList.push({fourFrame:false});
columnList.push(sortList[i]);
i+=1;}
viewTable.push(columnList);}
return;}
max=columnWidth*MAX_ROW-3;
for(i=0;i<max;i+=1){
if(fourFrame.row===0&&i===0||
fourFrame.row===1&&i===max-1){
fFlag=true;}else {
fFlag=false;}
sortList.push({fourFrame:fFlag});}
for(column=0;column<columnWidth;column+=1){
columnList=[];
for(row=0;row<MAX_ROW;row+=1){
columnList.push(null);}
viewTable.push(columnList);}
if(fourFrame.row===0){
viewTable[0][fourFrame.row]=sortList[0];
viewTable[0][2]=sortList[1];
viewTable[1][2]=sortList[2];}else {
viewTable[0][0]=sortList[0];
viewTable[1][0]=sortList[1];
viewTable[0][fourFrame.row]=sortList[2];}
viewTable[0][fourFrame.row+1]=LINK.UP;
viewTable[1][fourFrame.row]=LINK.LEFT;
viewTable[1][fourFrame.row+1]=LINK.DIAGONAL;
return;};
Area=function(type,name,fourFrame){
this.type=type;
this.name=name;
this.columnWidth=(type===AREA_TYPE.A)?2:1;
this.fourFrame={exist:fourFrame.exist,row:fourFrame.row};
this.sortList=[];
this.viewTable=[];
fillList(this.sortList,this.viewTable,this.columnWidth,this.fourFrame);};
Area.prototype.destroy=function(){
var i,column,target,columnList;
target=this.sortList.pop();
while(target){
target=this.sortList.pop();}
columnList=this.viewTable.pop();
while(columnList){
target=columnList.pop();
while(target){
target=columnList.pop();}
columnList=this.viewTable.pop();}
return this;};
GridData=function(fourFrameNum,options){
this.areaOrder=[];
this.viewTable=[];
this.area={};
var i,j,max,pageCount=1,
areaOrderBase=[AREA_TYPE.A,AREA_TYPE.B,AREA_TYPE.C,AREA_TYPE.D],
areaOrderBaseLen=areaOrderBase.length,
areaType,
layout=false,
fourFrameRow,
existFF={A:true,B:false,C:false,D:false};
if(options){
if(options.pageCount&&options.pageCount<=MAX_PAGE){
pageCount=options.pageCount;}
if(options.layout){
layout=options.layout;}
if(options.shuffle){
shuffleList(areaOrderBase);}
}
if(layout){
for(i=0,max=layout.length;i<max;i+=1){
this.area[layout[i].name]=new Area(layout[i].type,layout[i].name,
layout[i].fourFrame);
this.areaOrder.push(layout[i].name);}
this.joinViewTable();
return this;}
for(i=0;i<pageCount;i+=1){
for(j=0;j<areaOrderBaseLen;j+=1){
areaType=areaOrderBase[j];
fourFrameRow=0;
if(existFF[areaType]&&options&&options.shuffle){
fourFrameRow=getRandomInt(0,1);}
this.area[areaType+i]=new Area(areaType,areaType+i,
{exist:existFF[areaType],
row:fourFrameRow});}
this.areaOrder.push(areaOrderBase[0]+i,
areaOrderBase[1]+i,
areaOrderBase[2]+i,
areaOrderBase[3]+i);}
this.joinViewTable();
return this;};
GridData.prototype.joinViewTable=function(){
var data,i,j,maxSort,column,max,area,areaName;
while(this.viewTable.pop()){}
for(i=0,max=this.areaOrder.length;i<max;i+=1){
area=this.area[this.areaOrder[i]];
for(column=0;column<area.columnWidth;column+=1){
this.viewTable.push(area.viewTable[column]);}
}
return this;};
GridData.prototype.moveArea=function(direction){
var data,i,j,maxSort,column,max,area,areaName;
while(this.viewTable.pop()){}
if(direction==='last'){
areaName=this.areaOrder.pop();
this.areaOrder.unshift(areaName);}else {
areaName=this.areaOrder.shift();
this.areaOrder.push(areaName);}
for(i=0,max=this.areaOrder.length;i<max;i+=1){
area=this.area[this.areaOrder[i]];
for(column=0;column<area.columnWidth;column+=1){
this.viewTable.push(area.viewTable[column]);}
}
return this;};
GridData.prototype.getFirstArea=function(){
var areaName=this.areaOrder[0];
return this.area[areaName];};
GridData.prototype.getLastArea=function(){
var areaName=this.areaOrder[this.areaOrder.length-1];
return this.area[areaName];};
GridData.prototype.forEachAllArea=function(callback){
var maxArea,max,area,i,j,loopContinue;
for(i=0,maxArea=this.areaOrder.length;i<maxArea;i+=1){
area=this.area[this.areaOrder[i]];
for(j=0,max=area.sortList.length;j<max;j+=1){
loopContinue=callback(area.sortList[j],j,area);
if(loopContinue===false){
return this;}
}
}
return this;};
GridData.prototype.getLayoutData=function(){
var i,max,list=[],obj,area;
for(i=0,max=this.areaOrder.length;i<max;i+=1){
area=this.area[this.areaOrder[i]];
obj={type:area.type,name:area.name,
fourFrame:{exist:area.fourFrame.exist,row:area.fourFrame.row}};
list.push(obj);}
return list;};
GridData.prototype.destroy=function(){
var columnList,obj,areaName,area;
columnList=this.viewTable.pop();
while(columnList){
obj=columnList.pop();
while(obj){
obj=columnList.pop();}
columnList=this.viewTable.pop();}
areaName=this.areaOrder.pop();
while(areaName){
this.area[areaName].destroy();
this.area[areaName]=null;
areaName=this.areaOrder.pop();}
return this;};
GridData.createFixFourFrameLayoutData=function(fourFrameNum,pageCount){
var layout,i,j,max,obj,areaType,areaName,
areaOrderBase=[AREA_TYPE.A,AREA_TYPE.B,AREA_TYPE.C,AREA_TYPE.D],
existFF={A:true,B:false,C:false,D:false};
obj={};
obj.areaOrder=[];
obj.area={};
if(fourFrameNum>1){
existFF.C=true;}
if(pageCount===undefined||pageCount>MAX_PAGE){
pageCount=1;}
for(i=0;i<pageCount;i+=1){
for(j=0,max=areaOrderBase.length;j<max;j+=1){
areaType=areaOrderBase[j];
obj.area[areaType+i]=new Area(areaType,areaType+i,
{exist:existFF[areaType],row:0});}
obj.areaOrder.push(areaOrderBase[0]+i,
areaOrderBase[1]+i,
areaOrderBase[2]+i,
areaOrderBase[3]+i);}
layout=GridData.prototype.getLayoutData.call(obj);
areaName=obj.areaOrder.pop();
while(areaName){
obj.area[areaName].destroy();
obj.area[areaName]=null;
areaName=obj.areaOrder.pop();}
obj=obj.areaOrder=obj.area=null;
return layout;};
GridData.LINK=GridData.prototype.LINK=LINK;
ContentsData=function(){
this.filterId=null;
this.orgList=[];
this.filterList=[];};
ContentsData.prototype.replaceList=function(list){
this.clearFilter();
this.orgList=list;
return this;};
ContentsData.prototype.checkExistingList=function(checkFunc,filterFunc){
var i,oldLength=this.orgList.length;
for(i=oldLength-1;i>=0;i-=1){
if(!checkFunc([this.orgList[i]])){
this.orgList.splice(i,1);}
}
if(oldLength===this.orgList.length||this.filterId===null){
return this;}
this.setFilter(this.filterId,filterFunc);
return this;};
ContentsData.prototype.appendList=function(list,checkValid,filterFunc){
var i,max;
for(i=0,max=list.length;i<max;i+=1){
if(checkValid(list[i])){
this.orgList.push(list[i]);}
if(this.filterId!==null&&filterFunc(list[i],this.filterId)===true){
this.filterList.push(list[i]);}
}
return this;};
ContentsData.prototype.setFilter=function(filterId,filterFunc){
var i,max;
if(this.filterId!==null){
this.clearFilter();}
this.filterId=filterId;
for(i=0,max=this.orgList.length;i<max;i+=1){
if(filterFunc(this.orgList[i],filterId)===true){
this.filterList.push(this.orgList[i]);}
}
return this;};
ContentsData.prototype.clearFilter=function(){
var obj=this.filterList.pop();
while(obj){
obj=this.filterList.pop();}
this.filterId=null;
return this;};
mystream.DATA_MANAGER={
AREA_TYPE:AREA_TYPE,
GridData:GridData,
ContentsData:ContentsData
};}(window));
