const ROMA_INPUT=0;
const KANA_INPUT=1;
const HIRA_TYPE=0;
const KATA_TYPE=1;
function IME_RomKan(init){
this.superClass=container;
this.superClass(init);
this.convert_type=ROMA_INPUT;
this.kana_type=HIRA_TYPE;
this.stack=[];
this.table_roman={

"a":[
"a","あ","ア",
],

"b":[
"ba","ば","バ",
"bb","っb","ッb",
"be","べ","ベ",
"bi","び","ビ",
"bo","ぼ","ボ",
"bu","ぶ","ブ",
"bya","びゃ","ビャ",
"bye","びぇ","ビェ",
"byi","びぃ","ビィ",
"byo","びょ","ビョ",
"byu","びゅ","ビュ",
],

"c":[
"ca","か","カ",
"cc","っc","ッc",
"ce","せ","セ",
"cha","ちゃ","チャ",
"che","ちぇ","チェ",
"chi","ち","チ",
"cho","ちょ","チョ",
"chu","ちゅ","チュ",
"ci","し","シ",
"co","こ","コ",
"cu","く","ク",
"cya","ちゃ","チャ",
"cye","ちぇ","チェ",
"cyi","ちぃ","チィ",
"cyo","ちょ","チョ",
"cyu","ちゅ","チュ",
],

"d":[
"da","だ","ダ",
"dd","っd","ッd",
"de","で","デ",
"dha","でゃ","デャ",
"dhe","でぇ","デェ",
"dhi","でぃ","ディ",
"dho","でょ","デョ",
"dhu","でゅ","デュ",
"di","ぢ","ヂ",
"do","ど","ド",
"du","づ","ヅ",
"dwa","どぁ","ドァ",
"dwe","どぇ","ドェ",
"dwi","どぃ","ドィ",
"dwo","どぉ","ドォ",
"dwu","どぅ","ドゥ",
"dya","ぢゃ","ヂャ",
"dye","ぢぇ","ヂェ",
"dyi","ぢぃ","ヂィ",
"dyo","ぢょ","ヂョ",
"dyu","ぢゅ","ヂュ",
],

"e":[
"e","え","エ",
],

"f":[
"fa","ふぁ","ファ",
"fe","ふぇ","フェ",
"ff","っf","ッf",
"fi","ふぃ","フィ",
"fo","ふぉ","フォ",
"fu","ふ","フ",
"fwa","ふぁ","ファ",
"fwe","ふぇ","フェ",
"fwi","ふぃ","フィ",
"fwo","ふぉ","フォ",
"fwu","ふぅ","フゥ",
"fya","ふゃ","フャ",
"fye","ふぇ","フェ",
"fyi","ふぃ","フィ",
"fyo","ふょ","フョ",
"fyu","ふゅ","フュ",
],

"g":[
"ga","が","ガ",
"ge","げ","ゲ",
"gg","っg","ッg",
"gi","ぎ","ギ",
"go","ご","ゴ",
"gu","ぐ","グ",
"gwa","ぐぁ","グァ",
"gwe","ぐぇ","グェ",
"gwi","ぐぃ","グィ",
"gwo","ぐぉ","グォ",
"gwu","ぐぅ","グゥ",
"gya","ぎゃ","ギャ",
"gye","ぎぇ","ギェ",
"gyi","ぎぃ","ギィ",
"gyo","ぎょ","ギョ",
"gyu","ぎゅ","ギュ",
],

"h":[
"ha","は","ハ",
"he","へ","ヘ",
"hh","っh","ッh",
"hi","ひ","ヒ",
"ho","ほ","ホ",
"hu","ふ","フ",
"hwa","ふぁ","ファ",
"hwe","ふぇ","フェ",
"hwi","ふぃ","フィ",
"hwo","ふぉ","フォ",
"hwu","ふゅ","フュ",
"hwyu","ふゅ","フュ",
"hya","ひゃ","ヒャ",
"hye","ひぇ","ヒェ",
"hyi","ひぃ","ヒィ",
"hyo","ひょ","ヒョ",
"hyu","ひゅ","ヒュ",
],

"i":[
"i","い","イ",
],

"j":[
"ja","じゃ","ジャ",
"je","じぇ","ジェ",
"ji","じ","ジ",
"jj","っj","ッj",
"jo","じょ","ジョ",
"ju","じゅ","ジュ",
"jya","じゃ","ジャ",
"jye","じぇ","ジェ",
"jyi","じぃ","ジィ",
"jyo","じょ","ジョ",
"jyu","じゅ","ジュ",
],

"k":[
"ka","か","カ",
"ke","け","ケ",
"ki","き","キ",
"kk","っk","ッk",
"ko","こ","コ",
"ku","く","ク",
"kwa","くぁ","クァ",
"kwe","くぇ","クェ",
"kwi","くぃ","クィ",
"kwo","くぉ","クォ",
"kwu","くゅ","クゥ",
"kya","きゃ","キャ",
"kye","きぇ","キェ",
"kyi","きぃ","キィ",
"kyo","きょ","キョ",
"kyu","きゅ","キュ",
],

"l":[
"la","ぁ","ァ",
"le","ぇ","ェ",
"li","ぃ","ィ",
"lka","ヵ","ヵ",
"lke","ヶ","ヶ",
"ll","っl","ッl",
"lo","ぉ","ォ",
"ltsu","っ","ッ",
"ltu","っ","ッ",
"lu","ぅ","ゥ",
"lwa","ゎ","ヮ",
"lya","ゃ","ャ",
"lye","ぇ","ェ",
"lyi","ぃ","ィ",
"lyo","ょ","ョ",
"lyu","ゅ","ュ",
],

"m":[
"ma","ま","マ",
"me","め","メ",
"mi","み","ミ",
"mm","っm","ッm",
"mo","も","モ",
"mu","む","ム",
"mya","みゃ","ミャ",
"mye","みぇ","ミェ",
"myi","みぃ","ミィ",
"myo","みょ","ミョ",
"myu","みゅ","ミュ",
],

"n":[
"na","な","ナ",
"nb","んb","ンb",
"nc","んc","ンc",
"nd","んd","ンd",
"ne","ね","ネ",
"nf","んf","ンf",
"ng","んg","ンg",
"nh","んh","ンh",
"ni","に","ニ",
"nj","んj","ンj",
"nk","んk","ンk",
"nl","んl","ンl",
"nm","んm","ンm",
"nn","ん","ン",
"no","の","ノ",
"np","んp","ンp",
"nq","んq","ンq",
"nr","んr","ンr",
"ns","んs","ンs",
"nt","んt","ンt",
"nu","ぬ","ヌ",
"nv","んv","ンv",
"nw","んw","ンw",
"nx","んx","ンx",
"nya","にゃ","ニャ",
"nye","にぇ","ニェ",
"nyi","にぃ","ニィ",
"nyo","にょ","ニョ",
"nyu","にゅ","ニュ",
"nz","んz","ンz",
],

"o":[
"o","お","オ",
],

"p":[
"pa","ぱ","パ",
"pe","ぺ","ペ",
"pi","ぴ","ピ",
"po","ぽ","ポ",
"pp","っp","ッp",
"pu","ぷ","プ",
"pya","ぴゃ","ピャ",
"pye","ぴぇ","ピェ",
"pyi","ぴぃ","ピィ",
"pyo","ぴょ","ピョ",
"pyu","ぴゅ","ピュ",
],

"q":[
"qa","くぁ","クァ",
"qe","くぇ","クェ",
"qi","くぃ","クィ",
"qo","くぉ","クォ",
"qq","っq","ッq",
"qu","く","ク",
"qwa","くぁ","クァ",
"qwe","くぇ","クェ",
"qwi","くぃ","クィ",
"qwo","くぉ","クォ",
"qwu","くぅ","クゥ",
"qya","くゃ","クャ",
"qye","くぇ","クェ",
"qyi","くぃ","クィ",
"qyo","くょ","クョ",
"qyu","くゅ","クュ",
],

"r":[
"ra","ら","ラ",
"re","れ","レ",
"ri","り","リ",
"ro","ろ","ロ",
"rr","っr","ッr",
"ru","る","ル",
"rya","りゃ","リャ",
"rye","りぇ","リェ",
"ryi","りぃ","リィ",
"ryo","りょ","リョ",
"ryu","りゅ","リュ",
],

"s":[
"sa","さ","サ",
"se","せ","セ",
"sha","しゃ","シャ",
"she","しぇ","シェ",
"shi","し","シ",
"sho","しょ","ショ",
"shu","しゅ","シュ",
"si","し","シ",
"ss","っs","ッs",
"so","そ","ソ",
"su","す","ス",
"swa","すぁ","スァ",
"swe","すぇ","スェ",
"swi","すぃ","スィ",
"swo","すぉ","スォ",
"swu","すぅ","スゥ",
"sya","しゃ","シャ",
"sye","しぇ","シェ",
"syi","しぃ","シィ",
"syo","しょ","ショ",
"syu","しゅ","シュ",
],

"t":[
"ta","た","タ",
"te","て","テ",
"tha","てゃ","テャ",
"the","てぇ","テェ",
"thi","てぃ","ティ",
"tho","てょ","テョ",
"thu","てゅ","テュ",
"ti","ち","チ",
"to","と","ト",
"tsa","つぁ","ツァ",
"tse","つぇ","ツェ",
"tsi","つぃ","ツィ",
"tso","つぉ","ツォ",
"tsu","つ","ツ",
"tt","っt","ッt",
"tu","つ","ツ",
"twa","とぁ","トァ",
"twe","とぇ","トェ",
"twi","とぃ","トィ",
"two","とぉ","トォ",
"twu","とぅ","トゥ",
"tya","ちゃ","チャ",
"tye","ちぇ","チェ",
"tyi","ちぃ","チィ",
"tyo","ちょ","チョ",
"tyu","ちゅ","チュ",
],

"u":[
"u","う","ウ",
],

"v":[
"va","ヴぁ","ヴァ",
"ve","ヴぇ","ヴェ",
"vi","ヴぃ","ヴィ",
"vo","ヴぉ","ヴォ",
"vu","ヴ","ヴ",
"vv","っv","ッv",
"vya","ヴゃ","ヴャ",
"vye","ヴぇ","ヴェ",
"vyi","ヴぃ","ヴィ",
"vyo","ヴょ","ヴョ",
"vyu","ヴゅ","ヴュ",
],

"w":[
"wa","わ","ワ",
"we","うぇ","ウェ",
"wha","うぁ","ウァ",
"whe","うぇ","ウェ",
"whi","うぃ","ウィ",
"who","うぉ","ウォ",
"whu","う","ウ",
"wi","うぃ","ウィ",
"wo","を","ヲ",
"wu","う","ウ",
"ww","っw","ッw",
"wyi","ゐ","ヰ",
"wye","ゑ","ヱ",
],

"x":[
"xa","ぁ","ァ",
"xe","ぇ","ェ",
"xi","ぃ","ィ",
"xka","ヵ","ヵ",
"xke","ヶ","ヶ",
"xn","ん","ン",
"xo","ぉ","ォ",
"xtsu","っ","ッ",
"xtu","っ","ッ",
"xu","ぅ","ゥ",
"xwa","ゎ","ヮ",
"xx","っx","ッx",
"xya","ゃ","ャ",
"xye","ぇ","ェ",
"xyi","ぃ","ィ",
"xyo","ょ","ョ",
"xyu","ゅ","ュ",
],

"y":[
"ya","や","ヤ",
"ye","いぇ","イェ",
"yi","い","イ",
"yo","よ","ヨ",
"yu","ゆ","ユ",
"yy","っy","ッy",
],

"z":[
"za","ざ","ザ",
"ze","ぜ","ゼ",
"zi","じ","ジ",
"zo","ぞ","ゾ",
"zu","ず","ズ",
"zya","じゃ","ジャ",
"zye","じぇ","ジェ",
"zyi","じぃ","ジィ",
"zyo","じょ","ジョ",
"zyu","じゅ","ジュ",
"zz","っz","ッz",
],

"misc":[
"0","０","０",
"1","１","１",
"2","２","２",
"3","３","３",
"4","４","４",
"5","５","５",
"6","６","６",
"7","７","７",
"8","８","８",
"9","９","９",
"\"","”","”",
"'","’","’",
":","：","：",
";","；","；",
"\\","￥","￥",
"|","｜","｜",
"~","〜","〜",
"`","｀","｀",
".","。","。",
",","、","、",
"<","＜","＜",
">","＞","＞",
"?","？","？",
"/","・","・",
"-","ー","ー",
"+","＋","＋",
"=","＝","＝",
"!","！","！",
"@","＠","＠",
"#","＃","＃",
"$","＄","＄",
"%","％","％",
"^","＾","＾",
"&","＆","＆",
"*","＊","＊",
"(","（","（",
")","）","）",
"_","＿","＿",
"|","｜","｜",
"[","「","「",
"]","」","」",
"{","｛","｛",
"}","｝","｝",
],
};
this.table_kana={

"normal":[
"!","ぬ","ヌ",
"\"","ふ","フ",
"#","ぁ","ァ",
"$","ぅ","ゥ",
"%","ぇ","ェ",
"&","ぉ","ォ",
"'","ゃ","ャ",
"(","ゅ","ュ",
")","ょ","ョ",
"*","け","ケ",
"+","れ","レ",
",","ね","ネ",
"-","ほ","ホ",
".","る","ル",
"/","め","メ",
"0","わ","ワ",
"1","ぬ","ヌ",
"2","ふ","フ",
"3","あ","ア",
"4","う","ウ",
"5","え","エ",
"6","お","オ",
"7","や","ヤ",
"8","ゆ","ユ",
"9","よ","ヨ",
":","け","ケ",
";","れ","レ",
"<","、","、",
"=","ほ","ホ",
">","。","。",
"?","・","・",
"@","゛","゛",
"A","ち","チ",
"B","こ","コ",
"C","そ","ソ",
"D","し","シ",
"E","ぃ","ィ",
"F","は","ハ",
"G","き","キ",
"H","く","ク",
"I","に","ニ",
"J","ま","マ",
"K","の","ノ",
"L","り","リ",
"M","も","モ",
"N","み","ミ",
"O","ら","ラ",
"P","せ","セ",
"Q","た","タ",
"R","す","ス",
"S","と","ト",
"T","か","カ",
"U","な","ナ",
"V","ひ","ヒ",
"W","て","テ",
"X","さ","サ",
"Y","ん","ン",
"Z","っ","ッ",
",","ね","ネ",
"[","゜","゜",
"\\","ろ","ロ",
"]","む","ム",
"^","へ","ヘ",
"_","ろ","ロ",
"`","゛","゛",
"a","ち","チ",
"b","こ","コ",
"c","そ","ソ",
"d","し","シ",
"e","い","イ",
"f","は","ハ",
"g","き","キ",
"h","く","ク",
"i","に","ニ",
"j","ま","マ",
"k","の","ノ",
"l","り","リ",
"m","も","モ",
"n","み","ミ",
"o","ら","ラ",
"p","せ","セ",
"q","た","タ",
"r","す","ス",
"s","と","ト",
"t","か","カ",
"u","な","ナ",
"v","ひ","ヒ",
"w","て","テ",
"x","さ","サ",
"y","ん","ン",
"z","つ","ツ",
"{","「","「",
"|","ー","ー",
"}","」","」",
"~","へ","ヘ",
],

"voiced":[
"\"","ぶ","ブ",
"*","げ","ゲ",
"-","ぼ","ボ",
"2","ぶ","ブ",
"4","ヴ","ヴ",
":","げ","ゲ",
"=","ぼ","ボ",
"A","ぢ","ヂ",
"B","ご","ゴ",
"C","ぞ","ゾ",
"D","じ","ジ",
"F","ば","バ",
"G","ぎ","ギ",
"H","ぐ","グ",
"P","ぜ","ゼ",
"Q","だ","ダ",
"R","ず","ズ",
"S","ど","ド",
"T","が","ガ",
"V","び","ビ",
"W","で","デ",
"X","ざ","ザ",
"^","べ","ベ",
"a","ぢ","ヂ",
"b","ご","ゴ",
"c","ぞ","ゾ",
"d","じ","ジ",
"f","ば","バ",
"g","ぎ","ギ",
"h","ぐ","グ",
"p","ぜ","ゼ",
"q","だ","ダ",
"r","ず","ズ",
"s","ど","ド",
"t","が","ガ",
"v","び","ビ",
"w","で","デ",
"x","ざ","ザ",
"z","づ","ヅ",
],

"semivoiced":[
"\"","ぷ","プ",
"-","ぽ","ポ",
"=","ぽ","ポ",
"2","ぷ","プ",
"F","ぱ","パ",
"V","ぴ","ピ",
"^","ぺ","ペ",
"f","ぱ","パ",
"v","ぴ","ピ",
],
}
};
IME_RomKan.prototype=new container({});
IME_RomKan.prototype.init=function (){
this.stack=[];}
IME_RomKan.prototype.romkan_conv=function (keysym,conv,mode){
var ret=false;
if(conv!=this.convert_type||
mode!=this.kana_type){
this.convert_type=conv;
this.kana_type=mode;
this.init();}
switch(conv){
case ROMA_INPUT:
ret=this._roman_conv(keysym);
break;
case KANA_INPUT:
ret=this._kana_conv(keysym);
break;
default:
console.log("[ERROR] Invalid convert type.");
break;}
return ret;}
IME_RomKan.prototype._roman_conv=function (keysym){
var c=keysym.code;
var ret={};
var str="";
var tbl=[];
var first="";
var regexp=/[a-z]/;
this.stack.push(c);
while(this.stack!=""){
str=this.stack.join("");
first=str.charAt(0);
if(first.match(regexp)){
tbl=this.table_roman[first];}else {
tbl=this.table_roman["misc"];}
ret=this._table_search(tbl);
if(ret){
if(this._check_sokuon(this.stack)||
this._check_hatuon(this.stack)){
this.stack.shift();}else {
this.init();}
return ret;}
for(var j=0;j<tbl.length;j+=3){
if(tbl[j].indexOf(str)==0){
return false;}
}
this.stack.shift();}
return false;}
IME_RomKan.prototype._check_sokuon=function (array){
if(array.length!=2)
return false;
if(array[0]=="n")
return false;
if(array[0]==array[1]){
return true;}else {
return false;}
}
IME_RomKan.prototype._check_hatuon=function (array){
if(array.length!=2)
return false;
if(array[0]!="n")
return false;
var regexp=/[^aeinouy]/;
if(array[1].match(regexp)){
return true;}else {
return false;}
}
IME_RomKan.prototype._kana_conv=function (keysym){
var c=keysym.code;
var ret={};
if(c=="@"||c=="`"){ret=this._table_search(this.table_kana["voiced"]);
if(!ret){
ret={"kana":"゛","length":1};}
this.init();}else if(c=="["){ret=this._table_search(this.table_kana["semivoiced"]);
if(!ret){
ret={"kana":"゜","length":1};}
this.init();}else {ret=this._exception_conv(keysym);
if(!ret){
this.stack[0]=c;
ret=this._table_search(this.table_kana["normal"]);}
if(!ret){
this.init();}
}
return ret;}
IME_RomKan.prototype._exception_conv=function (keysym){
var ret=false;
var s=keysym.scancode;
var c=keysym.code;
var k="";
if(s==137&&c=="\\"){
ret={"kana":"ー","length":1};}else if(s==39&&c=="~"){
k=(this.kana_type==HIRA_TYPE)?"を":"ヲ";
ret={"kana":k,"length":1};}
return ret;}
IME_RomKan.prototype._table_search=function (tbl){
var ret={};
var kanaSW=(this.kana_type==HIRA_TYPE)?1:2;
var str=this.stack.join("");
for(var i=0;i<tbl.length;i+=3){
if(str==tbl[i]){
ret={"kana":tbl[i+kanaSW],"length":tbl[i].length}
return ret;}
}
return false;}
IME_RomKan.prototype.set_array_left=function (array,form){
this.init();
if(form==ROMA_INPUT){
this.stack=array;}
}
provide("pkg_romkan");
