
function default_system_key_hook(up_down,key)
{
if(up_down!=KEY_PRESS)
return false;

switch(key){
case TXK_HOME:
var home=get_system_home_stage();
if(home){
prepare_stage(home.symbol);
on_stage(home.symbol);}
return true;
case TXK_EXIT:
exit(0);}
return false;}
set_system_key_hook(default_system_key_hook);
system.input_dev.mouse.set_dispatch({destination:system.input_dev.DISPATCH_DEFAULT});
system.input_dev.key.set_dispatch({destination:system.input_dev.DISPATCH_DEFAULT});
system.input_dev.touchpad.set_dispatch({destination:system.input_dev.DISPATCH_DEFAULT});
system.input_dev.touchpen.set_dispatch({destination:system.input_dev.DISPATCH_DEFAULT});
function __kbd_convert_up_down_TXKB_to_TXK(up_down){
switch(up_down){
case KBD_PRESS:return KEY_PRESS;
case KBD_UP:return KEY_UP;
case KBD_DOWN:return KEY_DOWN;
default:
console.log("[ERROR] ebus.kbd up_down error");
return null;}
};
function __kbd_convert_CHAR_to_TXK(c){
switch(c){
case "0":return TXK_D0;
case "1":return TXK_D1;
case "2":return TXK_D2;
case "3":return TXK_D3;
case "4":return TXK_D4;
case "5":return TXK_D5;
case "6":return TXK_D6;
case "7":return TXK_D7;
case "8":return TXK_D8;
case "9":return TXK_D9;
default:return null;}
};
function __kbd_convert_TXKB_to_TXK(keysym){
switch(keysym){
case TXKB_Return:return TXK_ENTER;
case TXKB_Left:return TXK_LEFT;
case TXKB_Up:return TXK_UP;
case TXKB_Right:return TXK_RIGHT;
case TXKB_Down:return TXK_DOWN;
case TXKB_BackSpace:return TXK_RETURN;
case TXKB_HomePage:return TXK_HOME;
case TXKB_Escape:return TXK_EXIT;
case TXKB_F1:return TXK_HOME;
case TXKB_F2:return TXK_APPS;
default:break;}

if(system.mdl_cfg.color_key_order==system.mdl_cfg.COLOR_KEY_B_R_G_Y)
{
switch(keysym){
case TXKB_F9:return TXK_BLUE;
case TXKB_F10:return TXK_RED;
case TXKB_F11:return TXK_GREEN;
case TXKB_F12:return TXK_YELLOW;
default:return null;}
}
else
{
switch(keysym){
case TXKB_F9:return TXK_RED;
case TXKB_F10:return TXK_GREEN;
case TXKB_F11:return TXK_YELLOW;
case TXKB_F12:return TXK_BLUE;
default:return null;}
}
};
function __kbd_call_key_hook(stage,up_down,keysym){
var consumed=false;
if(stage.key_hook instanceof Function){
consumed=stage.key_hook(up_down,keysym);
if(!consumed)
return default_system_key_hook(up_down,keysym);
return true;}else {
return false;}
};
function __kbd_default_ebus_kbd_hook(stage,device,event){
var up_down=0;
var txk_up_down=0;
var keysym=0;
var modifier=0;
var txk_keysym=null;
switch(event){
case ebus.kbd.KEYSYM_EV:
up_down=arguments[3];
keysym=arguments[4];
modifier=arguments[5];
break;
default:
return false;
break;}
if(typeof stage._dead_key=="undefined")
stage._dead_key=TXKB_VoidSymbol;
var ret=ebus.kbd.keysym_to_string(stage._dead_key,keysym);
txk_up_down=__kbd_convert_up_down_TXKB_to_TXK(up_down);

switch(ret){
case KBD_DEADKEY:
stage._dead_key=keysym;
return false;
break;
case KBD_CONTROLKEY:
if(keysym==TXKB_BackSpace)
stage._dead_key=TXKB_VoidSymbol;
txk_keysym=__kbd_convert_TXKB_to_TXK(keysym);
break;
default:
stage._dead_key=TXKB_VoidSymbol;
txk_keysym=__kbd_convert_CHAR_to_TXK(ret);
break;}

if(txk_keysym){
return __kbd_call_key_hook(stage,txk_up_down,txk_keysym);}else {
return false;}
};
add_default_stage_event_hook(ebus.kbd,__kbd_default_ebus_kbd_hook);
var CURSOR_ARROW_INDEX=0;
var CURSOR_HAND_INDEX=1;
var CURSOR_WAIT_INDEX=2;
var CURSOR_BUSY_INDEX=3;
var CURSOR_VSCROLL_INDEX=4;var CURSOR_HSCROLL_INDEX=5;var CURSOR_HVSCROLL_INDEX=6;var CURSOR_IBEAM_INDEX=7;
var CURSOR_GRAB_INDEX=8;
var CURSOR_SCROLL_UP_INDEX=9;
var CURSOR_SCROLL_DOWN_INDEX=10;
var CURSOR_SCROLL_LEFT_INDEX=11;
var CURSOR_SCROLL_RIGHT_INDEX=12;
var CURSOR_CUSTOM0_INDEX=16;
var CURSOR_CUSTOM1_INDEX=17;
var CURSOR_CUSTOM2_INDEX=18;
var CURSOR_CUSTOM3_INDEX=19;
var CURSOR_CUSTOM4_INDEX=20;
var CURSOR_CUSTOM5_INDEX=21;
var CURSOR_CUSTOM6_INDEX=22;
var CURSOR_CUSTOM7_INDEX=23;
var CURSOR_INVISIBLE_INDEX=31;

if(system.cursor_pointer){
system.cursor_pointer.set_image({index:CURSOR_ARROW_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/arrow.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_HAND_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/hand.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_WAIT_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/wait.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_BUSY_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/busy.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_VSCROLL_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/vscroll.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_HSCROLL_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/hscroll.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_HVSCROLL_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/hvscroll.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_IBEAM_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/ibeam.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_GRAB_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/grab.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_SCROLL_UP_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/scroll_up.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_SCROLL_DOWN_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/scroll_down.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_SCROLL_LEFT_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/scroll_left.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_SCROLL_RIGHT_INDEX,
type:system.cursor_pointer.IMG_FMT_CUR_URL,
url:"file:///usr/local/application/home/common/cursors/scroll_right.cur",
draw_width:64,
draw_height:64});
system.cursor_pointer.set_image({index:CURSOR_INVISIBLE_INDEX,
type:system.cursor_pointer.IMG_FMT_BITMAP,
data:sysutil.hex.decode("00000000000000000000000000000000"),
img_width:4,
img_height:1,
draw_width:0,
draw_height:0});
system.cursor_pointer.set_timeout(3000);
var __last_mouse_button=0;
var __last_mouse_diff_x=0;
var __last_mouse_diff_y=0;
var __last_mouse_diff_z=0;
var __last_mouse_stg=null;
var __last_mouse_hit_obj=null;
var __mouse_callback_symbols={
"click":"click",
"mousedown":"mousedown",
"mouseup":"mouseup",
"middle_click":"middle_click",
"middle_mousedown":"middle_mousedown",
"middle_mouseup":"middle_mouseup",
"right_click":"right_click",
"right_mousedown":"right_mousedown",
"right_mouseup":"right_mouseup",
"mouseover":"mouseover",
"mousemove":"mousemove",
"mouseout":"mouseout"
};
ebus.mouse.set_callback_symbol=function (ev_symbol,callback_symbol){
if('string'!=typeof callback_symbol){
return;}
if(ev_symbol!="click"&&
ev_symbol!="mousedown"&&
ev_symbol!="mouseup"&&
ev_symbol!="middle_click"&&
ev_symbol!="middle_mousedown"&&
ev_symbol!="middle_mouseup"&&
ev_symbol!="right_click"&&
ev_symbol!="right_mousedown"&&
ev_symbol!="right_mouseup"&&
ev_symbol!="mouseover"&&
ev_symbol!="mousemove"&&
ev_symbol!="mouseout"){
return;}
if('string'==typeof callback_symbol){
__mouse_callback_symbols[ev_symbol]=callback_symbol;}
};
function __mouse_get_callback_symbol(ev_symbol){
return __mouse_callback_symbols[ev_symbol];};
function __mouse_do_click(obj,button){
var sym=__mouse_get_callback_symbol("click");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_mousedown(obj,button){
var sym=__mouse_get_callback_symbol("mousedown");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_mouseup(obj,button){
var sym=__mouse_get_callback_symbol("mouseup");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_middle_click(obj,button){
var sym=__mouse_get_callback_symbol("middle_click");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_middle_mousedown(obj,button){
var sym=__mouse_get_callback_symbol("middle_mousedown");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_middle_mouseup(obj,button){
var sym=__mouse_get_callback_symbol("middle_mouseup");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_right_click(obj,button){
var sym=__mouse_get_callback_symbol("right_click");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_right_mousedown(obj,button){
var sym=__mouse_get_callback_symbol("right_mousedown");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_right_mouseup(obj,button){
var sym=__mouse_get_callback_symbol("right_mouseup");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_mouseover(obj,button){
var sym=__mouse_get_callback_symbol("mouseover");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_mousemove(obj,button){
var sym=__mouse_get_callback_symbol("mousemove");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_mouseout(obj,button){
var sym=__mouse_get_callback_symbol("mouseout");
if(obj[sym] instanceof Function){
obj[sym](obj);}
}
function __mouse_do_cleanup(obj){
obj.__mouse_last_button=0;
obj.__mouseover_button=0;}
function __mouse_check_button_ev(obj,button,from_mouseover){
var lmsk=ebus.mouse.DOWN_LEFT_BUTTON;
var mmsk=ebus.mouse.DOWN_MIDDLE_BUTTON;
var rmsk=ebus.mouse.DOWN_RIGHT_BUTTON;
if(from_mouseover)
obj.__mouseover_button=button;
else {

if((obj.__mouse_last_button&lmsk)&&(button&lmsk)==0){
__mouse_do_mouseup(obj,button);
if((obj.__mouseover_button&lmsk)==0)
__mouse_do_click(obj,button);
obj.__mouseover_button&=~lmsk;}else if((button&lmsk)&&(obj.__mouse_last_button&lmsk)==0){
__mouse_do_mousedown(obj,button);}

if((obj.__mouse_last_button&mmsk)&&(button&mmsk)==0){
__mouse_do_middle_mouseup(obj,button);
if((obj.__mouseover_button&mmsk)==0)
__mouse_do_middle_click(obj,button);
obj.__mouseover_button&=~mmsk;}else if((button&mmsk)&&(obj.__mouse_last_button&mmsk)==0){
__mouse_do_middle_mousedown(obj,button);}

if((obj.__mouse_last_button&rmsk)&&(button&rmsk)==0){
__mouse_do_right_mouseup(obj,button);
if((obj.__mouseover_button&rmsk)==0)
__mouse_do_right_click(obj,button);
obj.__mouseover_button&=~rmsk;}else if((button&rmsk)&&(obj.__mouse_last_button&rmsk)==0){
__mouse_do_right_mousedown(obj,button);}
}
obj.__mouse_last_button=button;}
function __mouse_low_ev_proc(stg,obj,ev,button,diff_x,diff_y,diff_z){
if(stg!=__last_mouse_stg){
if(__last_mouse_hit_obj){
__mouse_do_cleanup(__last_mouse_hit_obj);
__last_mouse_hit_obj=null;}
}
__last_mouse_stg=stg;
var x=system.cursor_pointer.get_pos_x();
var y=system.cursor_pointer.get_pos_y();
var hit_obj=get_pointer_hit_obj(x,y);
if(hit_obj){
if(!__last_mouse_hit_obj){
__mouse_do_mouseover(hit_obj,button);
__mouse_check_button_ev(hit_obj,button,true);}else if(__last_mouse_hit_obj!=hit_obj){
__mouse_do_mouseout(__last_mouse_hit_obj,button);
__mouse_do_cleanup(__last_mouse_hit_obj);
__last_mouse_hit_obj=null;
__mouse_do_mouseover(hit_obj,button);
__mouse_check_button_ev(hit_obj,button,true);}else if(diff_x!=0||diff_y!=0){
__mouse_do_mousemove(hit_obj,button);
__mouse_check_button_ev(hit_obj,button,false);}else {
__mouse_check_button_ev(hit_obj,button,false);}
__last_mouse_hit_obj=hit_obj;}else {
if(__last_mouse_hit_obj){
__mouse_do_mouseout(__last_mouse_hit_obj,button);
__mouse_do_cleanup(__last_mouse_hit_obj);
__last_mouse_hit_obj=null;}
}
__last_mouse_button=button;
__last_mouse_diff_x=diff_x;
__last_mouse_diff_y=diff_y;
__last_mouse_diff_z=diff_z;};
function __mouse_default_ebus_mouse_hook(stg,obj,ev){
if(ev==obj.LOW_EV)
return __mouse_low_ev_proc(stg,obj,ev,arguments[3],arguments[4],arguments[5],arguments[6]);
else
{
console.log("unknown mouse event");}
};


add_default_stage_event_hook(ebus.mouse,__mouse_default_ebus_mouse_hook);}else{
}
