
var BASE_URL=getDefaultUrl("cloudgadgeturl");
var E_INVALID_PARAMETER=-1;
var E_INTERNAL_ERROR=-2;
var E_ABORTED=-3;
var E_JSON_PARSE_ERROR=-4;
var SUCCESS=0;
var REVISION=1;
var E_TOKEN_UNDEFINED=500;
var CloudGadget=function(applicationID)
{
this._applicationID=applicationID;
this._token_from_gadget=null;
this._requests={};
this._request_count=0;};
CloudGadget.prototype.getApplicationID=function()
{
return this._applicationID;};
CloudGadget.prototype.setAuthorizedToken=function(token)
{
this._token_from_gadget=token;};
CloudGadget.prototype.getAuthorizedToken=function()
{
if(this._token_from_gadget==null){
return system.user_profile.get({mhc:{id:null}}).mhc.mhc_authtoken;}
return this._token_from_gadget;};
CloudGadget.prototype._isValidToken=function(token)
{
if(String(token)=="undefined"){
return false;}
return true;};
CloudGadget.prototype._makeURL=function(command)
{
var token=this.getAuthorizedToken();
if(!this._isValidToken(token)){
return null;}
return BASE_URL+"/"+this.getApplicationID()+"/"+command+"?token="+encodeURIComponent(token)+"&rev="+REVISION;};
CloudGadget.prototype._makeURLWithoutToken=function(command)
{
return BASE_URL+"/"+this.getApplicationID()+"/"+command+"?rev="+REVISION;};
CloudGadget.prototype._log=function(text)
{
console.log(text);};
CloudGadget.prototype._deleteRequest=function(req_id)
{
if(req_id in this._requests){
if(this._requests[req_id] instanceof Array){
for(var req in this._requests[req_id]){

this._requests[req_id][req]=null;
delete this._requests[req_id][req];}
}
this._requests[req_id]=null;
delete this._requests[req_id];}
};
CloudGadget.prototype._jsonEnc=function(obj)
{
return JSON.stringify(obj);};
CloudGadget.prototype._jsonDec=function(json_str)
{
return JSON.parse(json_str);};
CloudGadget.prototype.serverTime=function(hash)
{
if(hash!=null&&'server_time' in hash){
return new Date(Number(hash['server_time']));}
return -1;};
CloudGadget.prototype._executeRequest=function(process_seq,req_id,timeout)
{
var start_time=new Date().getTime();
var _this=this;
var request=null;
try{
if(process_seq.length==0){
if(req_id in _this._requests){
_this._log("delete:"+req_id);
_this._deleteRequest(req_id);}
return this.SUCCESS;}
request=process_seq.shift();
if(request.type=="POST"||
request.type=="PUT"||
request.type=="GET"||
request.type=="DELETE")
{
var method=null;
var mimetype=null;
var url=null;
if(typeof request.type=="function"){
method=request.type();}else {
method=request.type;}
if(typeof request.url=="function"){
url=request.url();}else {
url=request.url;}
if('mimetype' in request){
mimetype=request.mimetype;}else {
mimetype="application/json";}
var req_param={
timeout:(timeout/1000),
url:url,
method:method,
header:[["Content-Type",mimetype]],
onload:function(status,header,body){
var cont=false;
var ret=null;
try{
ret=JSON.parse(body);}catch(e){
ret=null;}
try{
if('cb_raw' in request){
cont=request.cb(body,status);}else if('cb' in request){
if(status>=200&&status<300){
cont=request.cb(ret,status);}else {
if(status<200||status>=300){
cont=request.cb(null,status);}else {
cont=request.cb(null,E_INTERNAL_ERROR);}
}
}
}catch(e){
_this._log("catch exception at callback:"+e.name+":"+e.message+":"+e.stack);
cont=false;}
if(cont==true){
_this._executeRequest(process_seq,req_id,timeout-(new Date().getTime()-start_time));}else {
if(req_id in _this._requests){
_this._deleteRequest(req_id);}
}
}
};
if('body_path' in request){
req_param['body_path']=request.body_path();}else {
req_param['body']=request.body();}
if(url==null){
append_timer({},1,function(obj){delete_timer(obj);request.cb(null,E_TOKEN_UNDEFINED);});
var err=new Error();
err.message="invalid url";
throw err;}else {
var req=http_request(req_param);
_this._requests[req_id].push(req);
req=null;
delete req;}
}
}catch(e){
_this._log("catch exception:"+e.name+":"+e.message+":"+e.stack);
if(req_id in _this._requests){
_this._log("delete:"+req_id);
_this._deleteRequest(req_id);}
return _this.INTERNAL_ERROR;}
return this.SUCCESS;};
CloudGadget.prototype.registerData=function(
application_data_type_id,
text_data,
mhc_userkey_list,
insert_position,
holding_period,
large_data,
large_data_mimetype,
notify_after_update,
is_read,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var share_result={};
var req_body={
application_data_type_id:application_data_type_id,
insert_position:insert_position
};
if(application_data_type_id==null||
insert_position==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
if(text_data!=null){
req_body.text_data=text_data;}
if(mhc_userkey_list!=null){
req_body.mhc_userkey_list=mhc_userkey_list;}
if(holding_period!=null){
req_body.holding_period=holding_period;}
if(notify_after_update!=null){
req_body.notify_after_update=notify_after_update;}
if(is_read!=null){
req_body.is_read=is_read;}
this._requests[req_id]=[];
if(large_data!=null){
request_seq.push(
{
type:'POST',
url:this._makeURL("getstrageurl"),
body:function(){
return "";},
cb:function(recv_data,status){
if(recv_data!=null&&"url" in recv_data&&"application_data_id" in recv_data){
share_result["application_data_id"]=recv_data["application_data_id"];
share_result["url"]=recv_data["url"];
return true;}else {
callback(null,status,-1);
return false;}
}
}
);
var largedata_req=
{
type:'PUT',
url:function(){return share_result["url"];},
mimetype:large_data_mimetype,
body:function(){
return large_data;},
cb:function(recv_data,status){
if(status>=200||status<300){
return true;}else {
callback(null,status,-1);
return false;}
}
};
if(large_data instanceof Binary){
largedata_req['body']=function(){return large_data;};}else if(large_data instanceof String||typeof(large_data)=="string"){
largedata_req['body_path']=function(){return large_data;};}else {
return E_INVALID_PARAMETER;}
request_seq.push(
largedata_req
);}
request_seq.push(
{
type:'POST',
url:this._makeURL("registerdata"),
body:function(){
if("url" in share_result&&"application_data_id" in share_result){
req_body.large_data_url=share_result["url"];
req_body.application_data_id=share_result["application_data_id"];}
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&"data" in recv_data){
for(var k in recv_data.data){
if(k=="create_date"||
k=="last_write_date"||
k=="last_read_date"||
k=="expire_date")
{
if(recv_data.data[k]==null){
recv_data.data[k]=null;}else {
recv_data.data[k]=new Date(Number(recv_data.data[k]));}
}
}
callback(recv_data["data"],status,_this.serverTime(recv_data));}else {
callback(null,status,-1);}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.getDataCount=function(
application_data_type_id,
count_type,
direction,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_type_id==null||
count_type==null||
timeout==null||
callback==null||
!(callback instanceof Function)||
isNaN(count_type)||
count_type<0||
count_type>2){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_type_id:application_data_type_id,
count_type:count_type,
direction:direction
};
request_seq.push(
{
type:'POST',
url:this._makeURL("getdatacount"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&("data_count" in recv_data)&&!isNaN(recv_data["data_count"])){
callback(recv_data["data_count"],status,_this.serverTime(recv_data));}else {
callback(null,status,-1);}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.getDataCountMulti=function(
token_list,
application_data_type_id_list,
count_type,
direction,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(token_list==null||
application_data_type_id_list==null||
count_type==null||
isNaN(count_type)||
count_type<0||
count_type>2||
timeout==null||
callback==null||
!(callback instanceof Function))
{
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
token_list:token_list,
application_data_type_id_list:application_data_type_id_list,
count_type:count_type,
direction:direction
};
request_seq.push(
{
type:'POST',
url:this._makeURLWithoutToken("getdatacountmulti"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&("result" in recv_data)){
callback(recv_data["result"],status,_this.serverTime(recv_data));}else {
callback(null,status,-1);}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.getDataList=function(
application_data_type_id,
need_recipients,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_type_id==null||
need_recipients==null||
timeout==null||
callback==null||
!(callback instanceof Function)||
!(need_recipients instanceof Boolean||typeof need_recipients=="boolean"))
{
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_type_id:application_data_type_id,
need_recipients:need_recipients
};
request_seq.push(
{
type:'POST',
url:this._makeURL("getdatalist"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&("data_list" in recv_data)){
for(var i in recv_data["data_list"]){
for(var k in recv_data["data_list"][i]){
if(k=="create_date"||
k=="last_write_date"||
k=="last_read_date"||
k=="expire_date")
{
if(recv_data["data_list"][i][k]==null){
recv_data["data_list"][i][k]=null;}else {
recv_data["data_list"][i][k]=new Date(Number(recv_data["data_list"][i][k]));}
}
}
}
callback(recv_data["data_list"],status,_this.serverTime(recv_data));}else {
callback(null,status,-1);}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.getData=function(
application_data_id,
need_recipients,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_id==null||
need_recipients==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_id:application_data_id,
need_recipients:need_recipients
};
request_seq.push(
{
type:'POST',
url:this._makeURL("getdata"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&("data" in recv_data)){
for(var k in recv_data["data"]){
if(k=="create_date"||
k=="last_write_date"||
k=="last_read_date"||
k=="expire_date")
{
if(recv_data["data"][k]==null){
recv_data["data"][k]=null;}else {
recv_data["data"][k]=new Date(Number(recv_data["data"][k]));}
}
}
callback(recv_data["data"],status,_this.serverTime(recv_data));}else {
callback(null,status,-1);}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.deleteData=function(
application_data_id,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_id==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_id:application_data_id
};
request_seq.push(
{
type:'POST',
url:this._makeURL("deletedata"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
callback(status,_this.serverTime(recv_data));
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.updateData=function(
application_data_id,
text_data,
large_data,
large_data_mimetype,
holding_period,
modify_target,
notify_after_update,
last_write_date,
allow_override,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var share_result={};
var request_seq=[];
var req_body={};
var MODIFY_TEXT=1;
var MODIFY_BINARY=2;
var MODIFY_LARGEBINARY=4;
var MODIFY_EXPIRETIME=8;
if(application_data_id==null||
modify_target==null||
last_write_date==null||
allow_override==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_id:application_data_id
};
if(text_data!=null){
req_body.text_data=text_data;}
if(holding_period!=null){
req_body.holding_period=holding_period;}
if(modify_target!=null){
req_body.modify_target=modify_target;}
if(notify_after_update!=null){
req_body.notify_after_update=notify_after_update;}
if(last_write_date!=null){
if(last_write_date instanceof Date){
req_body.last_write_date=last_write_date.getTime();}else {
return E_INVALID_PARAMETER;}
}
if(allow_override!=null){
req_body.allow_override=allow_override;}
if(large_data!=null&&(modify_target&MODIFY_LARGEBINARY)){
request_seq.push(
{
type:'POST',
url:this._makeURL("getstrageurl"),
body:function(){
return _this._jsonEnc({application_data_id:application_data_id});},
cb:function(recv_data,status){
if(recv_data!=null&&"url" in recv_data&&"application_data_id" in recv_data){
share_result["application_data_id"]=recv_data["application_data_id"];
share_result["url"]=recv_data["url"];
return true;}else {
callback(null,null,status,-1);
return false;}
}
}
);
request_seq.push(
{
type:'PUT',
url:function(){return share_result["url"];},
mimetype:large_data_mimetype,
body:function(){
return large_data;},
cb:function(recv_data,status){
if(status>=200||status<300){
return true;}else {
callback(null,null,status,-1);
return false;}
}
}
);}
request_seq.push(
{
type:'POST',
url:this._makeURL("updatedata"),
body:function(){
if("small_data_b64" in share_result){
req_body.small_data=share_result["small_data_b64"];
req_body.small_data_mime_type=null;}
if("url" in share_result){
req_body.large_data_url=share_result["url"];
req_body.application_data_id=application_data_id;}
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&"data" in recv_data){
for(var k in recv_data.data){
if(k=="create_date"||
k=="last_write_date"||
k=="last_read_date"||
k=="expire_date")
{
if(recv_data.data[k]==null){
recv_data.data[k]=null;}else {
recv_data.data[k]=new Date(Number(recv_data.data[k]));}
}
}
}
if(recv_data!=null&&"data" in recv_data&&"is_override" in recv_data){
callback(recv_data["data"],recv_data["is_override"],status,_this.serverTime(recv_data));}else {
callback(null,null,status,-1);}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.isUpdated=function(
application_data_id,
last_write_date,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_id==null||
last_write_date==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
if(last_write_date instanceof Date){
last_write_date=last_write_date.getTime();}else {
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_id:application_data_id,
last_write_date:last_write_date
};
request_seq.push(
{
type:'POST',
url:this._makeURL("isupdated"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&("is_updated" in recv_data)){
callback(recv_data["is_updated"],status,_this.serverTime(recv_data));}else {
callback(null,status,_this.serverTime(recv_data));}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.setSortOrder=function(
application_data_id,
up_or_down,
direction,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_id==null||
up_or_down==null||
direction==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_id:application_data_id,
up_or_down:up_or_down,
direction:direction
};
request_seq.push(
{
type:'POST',
url:this._makeURL("setsortorder"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
callback(status,_this.serverTime(recv_data));
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.getRecipients=function(
application_data_id,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_id==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_id:application_data_id
};
request_seq.push(
{
type:'POST',
url:this._makeURL("getrecipients"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&("recipients" in recv_data)){
callback(recv_data["recipients"],status,_this.serverTime(recv_data));}else {
callback(null,status,-1);}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.setRecipients=function(
application_data_id,
mhc_userkey_list,
insert_position,
notify_after_update,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_id==null||
mhc_userkey_list==null||
insert_position==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_id:application_data_id,
mhc_userkey_list:mhc_userkey_list,
insert_position:insert_position,
notify_after_update:notify_after_update
};
request_seq.push(
{
type:'POST',
url:this._makeURL("setrecipients"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&("recipients" in recv_data)){
callback(recv_data["recipients"],status,_this.serverTime(recv_data));}else {
callback(null,status,-1);}
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.setReadStatus=function(
application_data_id,
is_read,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_data_id==null||
is_read==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_data_id:application_data_id,
is_read:is_read
};
request_seq.push(
{
type:'POST',
url:this._makeURL("setreadstatus"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
callback(status,_this.serverTime(recv_data));
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.registerEndpoint=function(
application_id,
endpoint,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_id==null||
endpoint==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_id:application_id,
endpoint:endpoint
};
request_seq.push(
{
type:'POST',
url:this._makeURL("registerendpoint"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
callback(status,_this.serverTime(recv_data));
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.unregisterEndpoint=function(
application_id,
endpoint,
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(application_id==null||
endpoint==null||
timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
application_id:application_id,
endpoint:endpoint
};
request_seq.push(
{
type:'POST',
url:this._makeURL("unregisterendpoint"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
callback(status,_this.serverTime(recv_data));
return false;}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.getStatus=function(
timeout,
callback)
{
this._request_count++;
var current_count=this._request_count;
var req_id="req"+current_count;
var _this=this;
var request_seq=[];
var req_body={};
if(timeout==null||
callback==null||
!(callback instanceof Function)){
return E_INVALID_PARAMETER;}
this._requests[req_id]=[];
req_body={
};
request_seq.push(
{
type:'POST',
url:this._makeURL("getstatus"),
body:function(){
return _this._jsonEnc(req_body);},
cb:function(recv_data,status){
if(recv_data!=null&&("status" in recv_data)){
callback(recv_data["status"],status,_this.serverTime(recv_data));}else {
callback(null,status,-1);}
}
}
);
this._executeRequest(request_seq,req_id,timeout);
return req_id;};
CloudGadget.prototype.cancelRequest=function(req_id)
{
if(req_id in this._requests){
if(this._requests[req_id] instanceof Array){
for(var req in this._requests[req_id]){
this._log(typeof(this._requests[req_id]));
if(this._requests[req_id][req]!=null){
this._log("cancel request");
cancel_http_request(this._requests[req_id][req]);}
this._requests[req_id][req]=null;
delete this._requests[req_id][req];}
}
this._requests[req_id]=null;
delete this._requests[req_id];}
};
