#!/bin/sh
###############################
# HOTPLUG Script
# Only USB automount implement
# Auto Mount Program must be existing in both places which are BOOT partition and RFS
# Version 2.4 (2009-11-01) : suport umount, XFS mount flag modified
# Version 2.4.2 (2009-11-13) : Umont not support for internal HDD
# Version 2.4.4 (2009-11-26) : xfs repaire support when xfs mount failed
# Version 3.0    (2011-10-11) : Do not operate the internal hard disk for EchoB platform. 
###############################
# Setting
# mounted directory : $MOUNTDIR/$PREFIX1 ~ $PREFIX$MAXNUM (ex /usb/usb1 ~ /usb/usb10)
ENABLE=1
DEBUG_MESSAGE=0
MOUNTBASEDIR=/dtv/usb
ACL_PROGRAMDIR=/mtd_boot/usb_mount
RFS_PROGRAMDIR=/sbin/usb_mount
MOUNTPROGRAM=usb_mount
CMDPROGRAM=usb_cmd
DEBUG_MESSAGE_FILE=/dtv/usb_message
DEBUG_MODE_FILE=/dtv/debug_on

CHANGE_IOMODE=0
IOSCHEDULE_MODE=anticipatory
SCSIPATH=/sys/block
IO_MODE_FILE=/dtv/anticipatory_on

LOCKFILE=$MOUNTBASEDIR/lock
ACTION=coldplug
DEVPATH=$1

CHECK_INCLUDE_HDD=/dtv/.internal_hdd

if [ -f $CHECK_INCLUDE_HDD ] ; then
	echo "Excute coldplug for HDD model"
	MOUNTPROGRAM=usb_mount_hdd
	CMDPROGRAM=usb_cmd_hdd
else
	echo "Excute coldplug for Non-internal HDD model"
	MOUNTPROGRAM=usb_mount
	CMDPROGRAM=usb_cmd
fi

# Program Directory setting
if [ -f $ACL_PROGRAMDIR/$MOUNTPROGRAM ]; then
        PROGRAMDIR=$ACL_PROGRAMDIR
else
        PROGRAMDIR=$RFS_PROGRAMDIR
fi

# Debug Mode setting
if [ -f $DEBUG_MODE_FILE ]; then
        DEBUG_MESSAGE=1
fi
# Mode setting for IO Scheduler with usb storage 
if [ -f $IO_MODE_FILE ]; then
        CHANGE_IOMODE=1
fi

# DEBUG MESSAGE
DEBUG_MESSAGE_FILE=/dtv/usb_message

	if [ $DEBUG_MESSAGE -eq 1 ]; then
		echo "<< USB Coldplug Message : \"$ACTION\" \"$DEVPATH\" \"$PRODUCT\" \"$INTERFACE\" \"$TYPE\"" >> $DEBUG_MESSAGE_FILE
	fi

# ENABLE Checking
if [ $ENABLE = "1" ]
then

	DEVICE=`echo $DEVPATH | sed 's/^\/[^\/]*\///g' | sed 's/\/.*//g'`
	PARTITION=`echo $DEVPATH | sed 's/^\/[^\/]*\///g' | sed 's/^[^\/]*\///g'`

	if [ ! -d $SCSIPATH/$DEVPATH ]; then
		echo ">> MSC Hotplug Message : \"$DEVPATH\"  not exist" >> $DEBUG_MESSAGE_FILE
		exit -1
	fi

	if [ $DEBUG_MESSAGE -eq 1 ]; then
		echo "<< USB Coldplug Message : $PROGRAMDIR/$CMDPROGRAM $ACTION cold plug" >> $DEBUG_MESSAGE_FILE
	fi

	$PROGRAMDIR/$CMDPROGRAM $ACTION cold plug

	if [ ! -f $LOCKFILE ]; then									# UNLOCKED
		if [ $DEBUG_MESSAGE -eq 1 ]; then
			echo "<< USB Coldplug Message : file not exist!!" >> $DEBUG_MESSAGE_FILE
		fi
		mkdir -p $MOUNTBASEDIR
		touch $LOCKFILE									# MAKE Lock!! -> LOCKED
		$PROGRAMDIR/$MOUNTPROGRAM						# Run MountProgram
	else
		if [ $DEBUG_MESSAGE -eq 1 ]; then
			echo "<< USB Coldplug Message :file exist!!" >> $DEBUG_MESSAGE_FILE
		fi
	fi

	if [ $CHANGE_IOMODE -eq 1 ]; then
		echo $IOSCHEDULE_MODE > $SCSIPATH/$DEVICE/queue/scheduler
		if [ $DEBUG_MESSAGE -eq 1 ]; then
			echo ">> MSC Hotplug Message : set $IOSCHEDULE_MODE mode with $DEVICE" >> $DEBUG_MESSAGE_FILE
		fi
	fi
fi
