#!/bin/sh

UPDATE_OPTION=$1

# USB insmod & mount
umount /mtd_exe
/etc/Scripts/usb_start.sh

BOARD_INFO=updateNT14M

echo "Start usb update"
echo "Do not power off or remove USB device before update is finished"
echo "BSP(onboot, seret, secos, kernel, rootfs, sign) images must be updated in seret"
echo -n "Image folder name(enter : "$BOARD_INFO") = "
read directory

if [ "$directory" = "" ]
then
	directory=$BOARD_INFO
fi

PART_FLAG=$(cat /proc/cmdline | cut -d'/' -f3 | cut -d' ' -f1)

if [ "$PART_FLAG" = "mmcblk0p7" ]
then
	partition="1"
	echo "Current partition is $partition."
	partition="2" 
	echo "Update partition is $partition."	
else
	partition="2"
	echo "Current partition is $partition."
	partition="1"
	echo "Update partition is $partition."
fi

if [ -e /dtv/usb/sda1 ]
then 
	MDIR=/dtv/usb/sda1
fi
if [ -e /dtv/usb/sda ]
then
	MDIR=/dtv/usb/sda
fi
if [ -e /dtv/usb/sda0 ]
then
	MDIR=/dtv/usb/sda0
fi
if [ -e /dtv/usb/sda2 ]
then
	MDIR=/dtv/usb/sda2
fi
if [ -e /dtv/usb/sdb ]
then
	MDIR=/dtv/usb/sdb
fi
if [ -e /dtv/usb/sdc ]
then
	MDIR=/dtv/usb/sdc
fi
if [ -e /dtv/usb/sdb1 ]
then
	MDIR=/dtv/usb/sdb1
fi
if [ -e /dtv/usb/sdc1 ]
then
	MDIR=/dtv/usb/sdc1
fi

if [ ! -e $MDIR/$directory ]
then
	echo ""
	echo "$MDIR/$directory does not exist"
	exit 1
fi

echo "updating $MDIR/$directory/"
echo ""

echo 1 > /proc/flash_writable

echo "Remove old ld.so.cache file..."
echo ""
rm -rf /mtd_rwarea/ld.so.cache
sync

# kill process
ps > /dtv/ps.tmp
sed '1!G;h;$!d' /dtv/ps.tmp > /dtv/ps.revert.tmp

while read PS_LINE
do
	PID_N=`echo $PS_LINE | awk '{print $1}'`
	PID_UPDATE_SHELL=`echo $PS_LINE | grep "update.sh"`
	PID_SHELL=`echo $PS_LINE | grep "\-\/bin\/sh"`
	if [ "$PID_N" != "PID" ] && [ "$PID_N" != "1" ] && [ "$PID_UPDATE_SHELL" = "" ] && [ "$PID_SHELL" = "" ]
	then
		kill -9 $PID_N
	fi
done < /dtv/ps.revert.tmp
sleep 1

# umount loop device
mount > /dtv/mount.tmp
sed '1!G;h;$!d' /dtv/mount.tmp > /dtv/mount.revert.tmp

UMOUNT_SUCCESS="yes"

while read MOUNT_LINE
do
	MOUNT_DEVICE=`echo $MOUNT_LINE | awk '{print $3}'`
	MOUNT_DEVICE_MTD=`echo ${MOUNT_DEVICE:0:5}`
	if [ "$MOUNT_DEVICE_MTD" = "/mtd_" ]
	then
		echo "umount $MOUNT_DEVICE"
		umount $MOUNT_DEVICE
		if [ $? != 0 ]
		then
			UMOUNT_SUCCESS="no"
		fi
	fi
done < /dtv/mount.revert.tmp

if [ "$UMOUNT_SUCCESS" != "yes" ]
then
	echo "================================================================="
	echo "ps"
	echo "================================================================="
	ps
	echo "================================================================="
	echo "mount"
	echo "================================================================="
	mount
	echo "================================================================="
	echo "Failed to umount partitions................"
	echo "================================================================="
	exit
fi

if [ -e  $MDIR/$directory/unirw.img ]
then
	echo "START update unirw.img"

	dd if=$MDIR/$directory/unirw.img of=${MTD_UNIRW} bs=16384 2> /dev/null

	if [ $? != 0 ]
	then
		echo "Partition update retry"
		dd if=$MDIR/$directory/unirw.img of=${MTD_UNIRW} bs=16384 2> /dev/null
		if [ $? != 0 ]
		then
			echo "[${MTD_UNIRW}] Failed to update mtd_unirw partition..."
			exit
		fi
	fi

	sync
	echo "End update unirw.img"
else
	echo "unirw.img is not found"
fi

echo ""

if [ -e  $MDIR/$directory/uImage ]
then
	echo "START update uImage"

	if [ "$partition" = "1" ]
	then
		echo "update 1st partition"
		dd if=$MDIR/$directory/uImage of=${MTD_KERNEL_0} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "Partition update retry"
			dd if=$MDIR/$directory/uImage of=${MTD_KERNEL_0} 2> /dev/null

			if [ $? != 0 ]
			then
				echo "[${MTD_KERNEL_0}] Failed to update partition..."
				exit
			fi
		fi
	elif [ "$partition" = "2" ]
	then
		echo "update 2nd partition"
		dd if=$MDIR/$directory/uImage of=${MTD_KERNEL_1} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "Partition update retry"
			dd if=$MDIR/$directory/uImage of=${MTD_KERNEL_1} 2> /dev/null

			if [ $? != 0 ]
			then
				echo "[${MTD_KERNEL_1}] Failed to update partition..."
				exit
			fi
		fi
	fi

	sync
	echo "END update uImage"
else
	echo "uImage is not found"
fi

echo ""

if [ -e  $MDIR/$directory/sign0.bin ] && [ "$partition" = "1" ]
then
	echo "START update sign0.bin"
	echo "update 1st partition"
	dd if=$MDIR/$directory/sign0.bin of=${SECUREMAC0} 2> /dev/null

	if [ $? != 0 ]
	then
		echo "Partition update retry"
		dd if=$MDIR/$directory/sign0.bin of=${SECUREMAC0} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "[${SECUREMAC0}] Failed to update partition..."
			exit
		fi
	fi

	sync
	echo "END update sign0.bin"
elif [ -e  $MDIR/$directory/sign1.bin ] && [ "$partition" = "2" ]
then
	echo "START update sign1.bin"
	echo "update 2nd partition"
	dd if=$MDIR/$directory/sign1.bin of=${SECUREMAC1} 2> /dev/null

	if [ $? != 0 ]
	then
		echo "Partition update retry"
		dd if=$MDIR/$directory/sign1.bin of=${SECUREMAC1} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "[${SECUREMAC1}] Failed to update partition..."
			exit
		fi
	fi

	sync
	echo "END update sign1.bin"
else
	echo "sign0.bin or sign1.bin is not found"
fi

echo ""

if [ -e  $MDIR/$directory/rootfs.img ]
then
	echo "START update rootfs.img"

	if [ "$partition" = "1" ]
	then
		echo "update 1st partition"
		dd if=$MDIR/$directory/rootfs.img of=${MTD_ROOTFS_0} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "Partition update retry"
			dd if=$MDIR/$directory/rootfs.img of=${MTD_ROOTFS_0} 2> /dev/null

			if [ $? != 0 ]
			then
				echo "[${MTD_ROOTFS_0}] Failed to update partition..."
				exit
			fi
		fi
	elif [ "$partition" = "2" ]
	then
		echo "update 2nd partition"
		dd if=$MDIR/$directory/rootfs.img of=${MTD_ROOTFS_1} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "Partition update retry"
			dd if=$MDIR/$directory/rootfs.img of=${MTD_ROOTFS_1} 2> /dev/null

			if [ $? != 0 ]
			then
				echo "[${MTD_ROOTFS_1}] Failed to update partition..."
				exit
			fi
		fi
	fi

	sync
	echo "END update rootfs.img"
else
	echo "rootfs.img is not found"
fi

echo ""

if [ -e  $MDIR/$directory/secos.bin ]
then
	echo "START update secos.bin"
	if [ "$partition" = "1" ]
	then
		echo "update 1st partition"
		dd if=$MDIR/$directory/secos.bin of=${MTD_SECOS_0} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "Partition update retry"
			dd if=$MDIR/$directory/secos.bin of=${MTD_SECOS_0} 2> /dev/null

			if [ $? != 0 ]
			then
				echo "[${MTD_SECOS_0}] Failed to update partition..."
				exit
			fi
		fi
	elif [ "$partition" = "2" ]
	then
		echo "update 2nd partition"
		dd if=$MDIR/$directory/secos.bin of=${MTD_SECOS_1} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "Partition update retry"
			dd if=$MDIR/$directory/secos.bin of=${MTD_SECOS_1} 2> /dev/null

			if [ $? != 0 ]
			then
				echo "[${MTD_SECOS_1}] Failed to update partition..."
				exit
			fi
		fi
	fi

	sync
	echo "END update secos.bin"
else
	echo "secos.bin is not found"
fi

echo ""

if [ -e  $MDIR/$directory/seret.bin ]
then
	echo "START update seret.bin"
	if [ "$partition" = "1" ]
	then
		echo "update 1st partition"
		dd if=$MDIR/$directory/seret.bin of=${MTD_SERET_0} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "Partition update retry"
			dd if=$MDIR/$directory/seret.bin of=${MTD_SERET_0} 2> /dev/null

			if [ $? != 0 ]
			then
				echo "[${MTD_SERET_0}] Failed to update partition..."
				exit
			fi
		fi
	elif [ "$partition" = "2" ]
	then
		echo "update 2nd partition"
		dd if=$MDIR/$directory/seret.bin of=${MTD_SERET_1} 2> /dev/null

		if [ $? != 0 ]
		then
			echo "Partition update retry"
			dd if=$MDIR/$directory/seret.bin of=${MTD_SERET_1} 2> /dev/null

			if [ $? != 0 ]
			then
				echo "[${MTD_SERET_1}] Failed to update partition..."
				exit
			fi
		fi
	fi

	sync
	echo "END update seret.bin"
else
	echo "seret.bin is not found"
fi

echo ""

if [ -e  $MDIR/$directory/uniro.img ]
then
	echo "START update uniro data"
	echo ""

	if [ "$(mount | grep mtd_uniro)" = "" ]
	then
		mount -t vdfs -o noatime $MTD_UNIRO /mtd_uniro
		if [ $? != 0 ]
		then
			echo ""
			echo "[${MTD_UNIRO}] Failed to mount mtd_uniro"
			echo ""
			echo "********************************************************************************"
			echo ""
			echo " If $MTD_UNIRO has never been updated by uniro.img or has some problem,"
			echo " you can use seret in order to update $MTD_UNIRO by uniro.img"
			echo ""
			echo "********************************************************************************"
			echo ""
			exit
		fi			
	fi

	TEMP_UNIRO_FOLDER=/tmp/uniro

	if [ -e $TEMP_UNIRO_FOLDER ]
	then
		if [ "$(mount | grep $TEMP_UNIRO_FOLDER)" != "" ]
		then
			umount $TEMP_UNIRO_FOLDER
			if [ $? != 0 ]
			then
				echo "$TEMP_UNIRO_FOLDER umount error"
				exit
			fi
		fi
	else
		mkdir $TEMP_UNIRO_FOLDER
	fi
	
	mount -t vdfs -o noatime,loop,stripped,ro $MDIR/$directory/uniro.img $TEMP_UNIRO_FOLDER
	if [ $? != 0 ]
	then
		echo "[${MTD_UNIRO}] Failed to mount uniro.img..."
		exit
	fi

	##################
	# Update exe.img #
	##################
	echo "exe update"
	if [ ! -e $TEMP_UNIRO_FOLDER/exe1.img ]
	then
		echo "$TEMP_UNIRO_FOLDER/exe1.img is not found"
	else
		if [ "$partition" = "1" ]
		then
			pre_update.sh exe1
			if [ $? != 0 ]
			then
				echo "Fail to uninstall /mtd_uniro/exe1.img"
				exit
			fi

			echo "Start update /mtd_uniro/exe1.img"
			cp -af $TEMP_UNIRO_FOLDER/exe1.img /mtd_uniro/exe1.img
			if [ $? != 0 ]
			then
				echo "Fail to copy /mtd_uniro/exe1.img"
				exit
			fi
			sync

			post_update.sh exe1
			if [ $? != 0 ]
			then
				echo "Fail to install /mtd_uniro/exe1.img"
				exit
			fi
			echo "End update /mtd_uniro/exe1.img"
		else
			pre_update.sh exe2
			if [ $? != 0 ]
			then
				echo "Fail to uninstall /mtd_uniro/exe2.img"
				exit
			fi

			echo "Start update /mtd_uniro/exe2.img"
			cp -af $TEMP_UNIRO_FOLDER/exe1.img /mtd_uniro/exe2.img
			if [ $? != 0 ]
			then
				echo "Fail to copy /mtd_uniro/exe2.img"
				exit
			fi
			sync

			post_update.sh exe2
			if [ $? != 0 ]
			then
				echo "Fail to install /mtd_uniro/exe2.img"
				exit
			fi
			echo "End update /mtd_uniro/exe2.img"
		fi
	fi
	echo ""

	########################
	# Update uncompexe.img #
	########################
	if [ ! -e $TEMP_UNIRO_FOLDER/uncompexe1.img ]
	then
		echo "$TEMP_UNIRO_FOLDER/uncompexe1.img is not found"
	else
		if [ "$partition" = "1" ]
		then
			echo "Start update /mtd_uniro/uncompexe1.img"
			cp -af $TEMP_UNIRO_FOLDER/uncompexe1.img /mtd_uniro/uncompexe1.img
			if [ $? != 0 ]
			then
				echo "Fail to copy /mtd_uniro/uncompexe1.img"
				exit
			fi
			echo "End update /mtd_uniro/uncompexe1.img"
		else
			echo "Start update /mtd_uniro/uncompexe2.img"
			cp -af $TEMP_UNIRO_FOLDER/uncompexe1.img /mtd_uniro/uncompexe2.img
			if [ $? != 0 ]
			then
				echo "Fail to copy /mtd_uniro/uncompexe2.img"
				exit
			fi
			echo "End update /mtd_uniro/uncompexe2.img"
		fi
	fi

	#######################
	# Update rocommon.img #
	#######################
	echo "rocommon update"
	if [ ! -e $TEMP_UNIRO_FOLDER/rocommon1.img ]
	then
		echo "$TEMP_UNIRO_FOLDER/rocommon1.img is not found"
	else
		if [ "$partition" = "1" ]
		then
			CURRENT_ROCOMMON=$(ls -al ${ROCOMMON_LINK_2} | cut -d'>' -f2 | cut -d' ' -f2)
		else
			CURRENT_ROCOMMON=$(ls -al ${ROCOMMON_LINK_1} | cut -d'>' -f2 | cut -d' ' -f2)
		fi
		echo "CURRENT_ROCOMMON=$CURRENT_ROCOMMON"

		if [ "$CURRENT_ROCOMMON" = "/mtd_uniro/rocommon1.img" ]
		then
			echo "Start update /mtd_uniro/rocommon2.img"
			pre_update.sh rocommon2
			if [ $? != 0 ]
			then
				echo "Fail to uninstall /mtd_uniro/rocommon2.img"
				exit
			fi

			cp -af $TEMP_UNIRO_FOLDER/rocommon1.img /mtd_uniro/rocommon2.img
			if [ $? != 0 ]
			then
				echo "Fail to copy /mtd_uniro/rocommon2.img"
				exit
			fi
			sync

			post_update.sh rocommon2
			if [ $? != 0 ]
			then
				echo "Fail to install /mtd_uniro/rocommon2.img"
				exit
			fi

			if [ "$partition" = "1" ]
			then
				if [ -e ${ROCOMMON_LINK_1} ]
				then
					rm ${ROCOMMON_LINK_1}
					if [ $? != 0 ]
					then
						echo "Cannot delete ROCOMMON link"
						exit
					fi
					sync
				fi

				ln -s /mtd_uniro/rocommon2.img ${ROCOMMON_LINK_1}
				if [ $? != 0 ]
				then
					echo "rocommon link failed"
					exit
				fi
				sync
			else
				if [ -e ${ROCOMMON_LINK_2} ]
				then
					rm ${ROCOMMON_LINK_2}
					if [ $? != 0 ]
					then
						echo "Cannot delete ROCOMMON link"
						exit
					fi
					sync
				fi

				ln -s /mtd_uniro/rocommon2.img ${ROCOMMON_LINK_2}
				if [ $? != 0 ]
				then
					echo "rocommon link failed"
					exit
				fi
				sync
			fi
			echo "End update /mtd_uniro/rocommon2.img"
		else
			echo "Start update /mtd_uniro/rocommon1.img"
			pre_update.sh rocommon1
			if [ $? != 0 ]
			then
				echo "Fail to uninstall /mtd_uniro/rocommon1.img"
				exit
			fi
	
			cp -af $TEMP_UNIRO_FOLDER/rocommon1.img /mtd_uniro/rocommon1.img
			if [ $? != 0 ]
			then
				echo "Fail to copy /mtd_uniro/rocommon1.img"
				exit
			fi
			sync
	
			post_update.sh rocommon1
			if [ $? != 0 ]
			then
				echo "Fail to install /mtd_uniro/rocommon1.img"
				exit
			fi
	
			if [ "$partition" = "1" ]
			then
				if [ -e ${ROCOMMON_LINK_1} ]
				then
					rm ${ROCOMMON_LINK_1}
					if [ $? != 0 ]
					then
						echo "Cannot delete ROCOMMON link"
						exit
					fi
					sync
				fi

				ln -s /mtd_uniro/rocommon1.img ${ROCOMMON_LINK_1}
				if [ $? != 0 ]
				then
					echo "rocommon link failed"
					exit
				fi
				sync
			else
				if [ -e ${ROCOMMON_LINK_2} ]
				then
					rm ${ROCOMMON_LINK_2}
					if [ $? != 0 ]
					then
						echo "Cannot delete ROCOMMON link"
						exit
					fi
					sync
				fi

				ln -s /mtd_uniro/rocommon1.img ${ROCOMMON_LINK_2}
				if [ $? != 0 ]
				then
					echo "rocommon link failed"
					exit
				fi
				sync
			fi
			echo "End update /mtd_uniro/rocommon1.img"
		fi
	fi


	##################
	# Update emanual #
	##################
	echo "emanual update"
	if [ ! -e $TEMP_UNIRO_FOLDER/emanual ]
	then
		echo "$TEMP_UNIRO_FOLDER/emanual is not found"
	else
		echo "Start update /mtd_uniro/emanual"
		if [ -e /mtd_uniro/emanual ]
		then
			rm -rf /mtd_uniro/emanual
			if [ $? != 0 ]
			then
				echo "Fail to remove /mtd_uniro/emanual"
				exit
			fi
		fi

		cp -af $TEMP_UNIRO_FOLDER/emanual /mtd_uniro/
		if [ $? != 0 ]
		then
			echo "Fail to copy /mtd_uniro/emanual"
			exit
		fi
		echo "End update /mtd_uniro/emanual"
	fi
	echo ""
	
	umount $TEMP_UNIRO_FOLDER

	sync
	echo "END update uniro data"
else
	echo "uniro.img is not found"
fi

echo "Delete rocommon hash file"
rm /mtd_rwarea/partitionDataHashes.dat
sync
echo ""

if [ "$partition" = "2" ]
then
	echo ""
	echo "toggle to 2nd partition"
	$MICOM_BASE/micom 1 1
	echo ""
elif [ "$partition" = "1" ]
then
	echo ""
	echo "toggle to 1st partition"
	$MICOM_BASE/micom 1 0
	echo ""
fi

echo ""
echo "Update End"
echo "Reboot System"
$MICOM_BASE/micom reboot
sleep 3
