#!/bin/sh

echo 1 > /proc/flash_writable

arg="$1"
if [ -n "$arg" ]
then
	case "$arg" in
		exe1 | exe2 | rocommon1 | rocommon2)
			if [ -e "/mtd_uniro/$arg" ]
			then
				if install.vdfs -u "/mtd_uniro/$arg"
				then
					echo "VDFS uninstallation has successfully done: $arg"
					sync
				else
					echo "VDFS uninstallation has failed: $arg"
					exit 1
				fi
			else
				echo "VDFS image had not installed: $arg"
				if [ -e "/mtd_uniro/$arg.img" ]
				then
					if install.vdfs --force_unset_immutable "/mtd_uniro/$arg.img"
					then
						echo "VDFS unset immutable flag has successfully done: $arg.img"
						sync
					else
						echo "VDFS unset immutable flag has failed: $arg.img"
						exit 1
					fi
				else
					echo "VDFS image is not existed: $arg.img"
				fi
			fi
			;;
		start)
			echo 1 > /proc/flash_writable
			;;
		*)
			# default case
			echo "Invalid VDFS input data: $arg"
			;;
	esac
fi
