#!/bin/sh

arg="$1"

if [ -n "$arg" ]
then
	case "$arg" in
		exe1 | exe2 | rocommon1 | rocommon2)
			if [ ! -e "/mtd_uniro/$arg" ]
			then
				if [ -e "/mtd_uniro/$arg.img" ]
				then
					if install.vdfs -i "/mtd_uniro/$arg.img" "/mtd_uniro/$arg"
					then
						echo "VDFS installation has successfully done: $arg"
						sync
					else
						echo "VDFS installation has failed: $arg"
						exit 1
					fi
				else
					echo "VDFS image is not existed: $arg"
					exit 1
				fi
			else
				echo "VDFS image had already installed: $arg"
			fi
			;;
		end)
			echo 0 > /proc/flash_writable
			;;
		*)
			# default case
			echo "Invalid VDFS input data: $arg"
			;;
	esac
fi
