#!/bin/sh

export WEBKIT_EXEC_PATH=/mtd_exe/Webkit/
export FONTCONFIG_FILE=`grep 'export WE_FONTCONFIG_FILE' /mtd_exe/rc.local | sed 's/export WE_FONTCONFIG_FILE=//'`
export GIO_EXTRA_MODULES=/mtd_exe/Webkit/gio/modules
export XDG_DATA_HOME=/mtd_exe/WebBrowser/.local/share

echo "FONTCONFIG="$FONTCONFIG_FILE

if [ -z $MINI_RESOLUTION ]; then
IS_1080P=`grep -rn 'PreferredMode' /mtd_exe/Runtime/bin/xorg.conf |grep -v '#' |grep '1080'`
IS_720P=`grep -rn 'PreferredMode' /mtd_exe/Runtime/bin/xorg.conf |grep -v '#' |grep '720'`
IS_540P=`grep -rn 'PreferredMode' /mtd_exe/Runtime/bin/xorg.conf |grep -v '#' |grep '540'`

if [ -n "$IS_1080P" ]; then
export MINI_RESOLUTION='1080p'
elif [ -n "$IS_720P" ]; then
export MINI_RESOLUTION='720p'
elif [ -n "$IS_540P" ]; then
export MINI_RESOLUTION='540p'
else
export MINI_RESOLUTION='1080p'
fi
else
echo "RESOLUTION="$MINI_RESOLUTION
fi

if [ -z $1]; then
/mtd_exe/Webkit/MiniBrowser http://www.google.com
else
/mtd_exe/Webkit/MiniBrowser $1
fi

