
var myBrowserHeight;

var PHOTO_LIST=new Array();		//사진 목록
var PHOTO_CURRENT_PAGE=1;				//현재 페이지
var PHOTO_NUM_OF_SOURCE_ON_PAGE=4;	//한번에 보여질 사진 개수
var PHOTO_NUM_OF_FAGE=1;				// 총 페이지 수 ( = 총 그림 개수 / 한번에 보여질 사진 개수 )
var PHOTO_PAGE_MODE = "normal";

//일반,확대,축소 모드 보기에서 상대적 그림 크기를 정하기 위한 기준이 되는 변수들
var PHOTO_HEADER_HEIGHT = 42;
var PHOTO_NAVIGATION_HEIGHT = 34;
var PHOTO_BROWSER_HEIGHT;
var PHOTO_PICTURE_SIZE;

var SELECTED_PICTURE_PATH;
var SELECTED_PICTURE_NAME;

var LAST_CLICKED_VALUE = "";
var isClicked = false;

//페이지 로드시 시작!
$(function() {
	
	$("head").append('<link rel="stylesheet" href="../css/photo.css" type="text/css" title="style" />');
	
	$.ajax({
		type: "GET",
		url: '/ws/sources',
		dataType: 'json',
		data: null,
		async: false,
		success: function(data){
			for(var i=0; i<data.group.length; i++)
			{
				if (data.group[i].id=="storage")	//Storage가 있다면 사진들을 불러오자!
				{
					callStorage();
				}
			}
		},
		error: function(jqXHR, textStatus, errorThrown) {
			normalDrawPhotoPage(PHOTO_CURRENT_PAGE);
			//alert("ws/sources\nErrorType : " + textStatus);
		}
	});

	//첫화면으로 돌아가면 다시 css 정렬
	$(window).hashchange( function(){
		if(location.hash=="")
		{
			$('#index-title h1').html('SamsungTV WEB');
			$('.ui-content').css('padding', '15px 15px 15px 15px');
			$('.ui-li-thumb').attr('height', '80px');
			$('.ui-li-thumb').attr('width', '80px');
			$('.ui-li').css('height','83px');
		}
	});	
});

function setCSS()
{
	PHOTO_BROWSER_HEIGHT = $(window).height();
	if (PHOTO_PAGE_MODE == 'zoomOut')
	{
		PHOTO_PICTURE_SIZE = ( PHOTO_BROWSER_HEIGHT - PHOTO_HEADER_HEIGHT - PHOTO_NAVIGATION_HEIGHT ) / PHOTO_NUM_OF_SOURCE_ON_PAGE * 2;
	}
	else
	{
		PHOTO_PICTURE_SIZE = ( PHOTO_BROWSER_HEIGHT - PHOTO_HEADER_HEIGHT - PHOTO_NAVIGATION_HEIGHT ) / PHOTO_NUM_OF_SOURCE_ON_PAGE;
	}
	
	$('#photo-content .ui-li').css('height', PHOTO_PICTURE_SIZE);
	$('#photo-content .ui-li-thumb').css('max-height', PHOTO_PICTURE_SIZE);
	$('#photo-content .ui-li-thumb').css('max-width', PHOTO_PICTURE_SIZE);
	$('#photo-content .ui-li-thumb').attr('height', PHOTO_PICTURE_SIZE);
	$('#photo-content .ui-li-thumb').attr('width', PHOTO_PICTURE_SIZE);
	$('#photo-content .ui-li-thumb').css('left', '1px');
	$('#photo-content .ui-li-thumb').css('position', 'absolute');
	$('#photo-content .ui-li-thumb').css('top', '0');
	
	if (PHOTO_PAGE_MODE == 'zoomOut')
	{
		$('#photoListview2 a').css('padding', '0px 10px 0px ' + ( PHOTO_PICTURE_SIZE + 10) + 'px');
		$('#photoListview2 a').css('min-height', PHOTO_PICTURE_SIZE);
	}

	$('#photoListview a').css('padding', '0px 10px 0px ' + (PHOTO_PICTURE_SIZE+10) + 'px');
	$('#photoListview a').css('min-height', PHOTO_PICTURE_SIZE);
	
}

function drawSelectedPicture()
{
	$('#photoListview').html("");
	$('#photoListview2').html("");
	$('#forZoomOut1').removeClass("ui-block-a");
	$('#forZoomOut2').removeClass("ui-block-b");
	
	var height = $(window).height() - PHOTO_HEADER_HEIGHT - PHOTO_NAVIGATION_HEIGHT;
	var width = $(window).width();
	var size = height > width ? width : height;
	$('#photoListview').append('<center><img id="photo_big" src="' + SELECTED_PICTURE_PATH + '" width="' + size + '" height="' + size + '"></center>');
	
	$('#photo-title h1').html(SELECTED_PICTURE_NAME);
	$('#photo-footer').html('<h4 class="ui-title" tabindex="0" role="heading" aria-level="1">Close</h4>');
	
}

function cancelDrawSelectedPicture()
{

	$('#photo-footer').html("");
	$('#photo-footer').append('<div class="ui-navbar ui-navbar-noicons" data-role="navbar" role="navigation">'
			+'<ul id="photoNavBar" class="ui-grid-d">'
			+'<li id="normalPhotoPage" class="ui-block-a">'
			+'<a class="ui-btn ui-btn-up-a" href="#" data-theme="a">'
			+'<span class="ui-btn-inner">'
			+'<span class="ui-btn-text">LIST</span>'
			+'</span>'
			+'</a>'
			+'</li>'
			+'<li id="zoomOutPhotoPage" class="ui-block-b">'
			+'<a class="ui-btn ui-btn-up-a" href="#" data-theme="a">'
			+'<span class="ui-btn-inner">'
			+'<span class="ui-btn-text">SMALL</span>'
			+'</span>'
			+'</a>'
			+'</li>'
			+'<li id="zoomInPhotoPage" class="ui-block-c">'
			+'<a class="ui-btn ui-btn-up-a" href="#" data-theme="a">'
			+'<span class="ui-btn-inner">'
			+'<span class="ui-btn-text">LARGE</span>'
			+'</span>'
			+'</a>'
			+'</li>'
			+'<li id="prePhotoPage" class="ui-block-d">'
			+'<a class="ui-btn ui-btn-up-a" href="#" data-theme="a">'
			+'<span class="ui-btn-inner">'
			+'<span class="ui-btn-text">◀</span>'
			+'</span>'
			+'</a>'
			+'</li>'
			+'<li id="nextPhotoPage" class="ui-block-e">'
			+'<a class="ui-btn ui-btn-up-a" href="#" data-theme="a">'
			+'<span class="ui-btn-inner">'
			+'<span class="ui-btn-text">▶</span>'
			+'</span>'
			+'</a>'
			+'</li>'
			+'</ul>'
			+'</div>');
	switch(PHOTO_PAGE_MODE) {
	case "normal":
		normalDrawPhotoPage(PHOTO_CURRENT_PAGE);
		break;
	case "zoomOut":
		zoomOutDrawPhotoPage(PHOTO_CURRENT_PAGE);
		break;
	case "zoomIn":
		zoomInDrawPhotoPage(PHOTO_CURRENT_PAGE);
		break;
	default:
}

}

function callStorage()
{

	$.ajax({
		type: "GET",
		url: '/ws/sources/storage?recursive=true',
		dataType: 'json',
		data: null,
		async: false,
		success: function(data){

			PHOTO_LIST = data.source;
			
			photoFilter();
			
			normalDrawPhotoPage(PHOTO_CURRENT_PAGE);	// 모든 데이터 정보를 수집한 후, 마지막으로 페이지를 그리기 시작
			
			setPageEvents();

			///setCSS();
		},
		error: function(jqXHR, textStatus, errorThrown) {
			alert("ws/sources/storage\nErrorType : " + textStatus);
		}
	});
}

//이미지포맷의 확장자만 추출
function photoFilter()
{
	var tempPhotoList = new Array();
	var photoFormat = ["gif", "ief", "jpeg", "jpg", "jpe", "pcx", "png", "svg", "svgz", "tiff", "tif", "djvu", "djv", "wbmp", "ras", "cdr", "pat", "cdt", "ico", "art", "jng", "bmp", "psd", "pnm", "pbm", "pgm", "ppm", "rgb", "xbm", "xpm", "xwd"];

	var i;
	for (i=0; i<PHOTO_LIST.length; i++)
	{
		var thisFileFormat = PHOTO_LIST[i].name.toLowerCase().split(".")[PHOTO_LIST[i].name.toLowerCase().split(".").length-1];

		var j;
		for (j=0; j<photoFormat.length; j++)
		{
			if (thisFileFormat == photoFormat[j])
			{
				tempPhotoList.push(PHOTO_LIST[i]);
				break;
			}
		}
	}

	PHOTO_LIST = tempPhotoList;
}

//포토페이지 그리기
function normalDrawPhotoPage(currentPage)
{
	$('#zoomInPhotoPage > a').removeClass('ui-btn-active');
	$('#zoomOutPhotoPage > a').removeClass('ui-btn-active');
	$('#normalPhotoPage > a').addClass('ui-btn-active');
	if(PHOTO_LIST.length==0)
	{
		$('#photo-title h1').html('Photo - No Files');
	}
	else
	{
		$('#photo-title h1').html('Photo (' + PHOTO_CURRENT_PAGE + ' / '+ Math.ceil(PHOTO_LIST.length / PHOTO_NUM_OF_SOURCE_ON_PAGE) + ')');
	}
	$('#photoListview').html("");
	$('#photoListview2').html("");
	$('#forZoomOut1').removeClass("ui-block-a");
	$('#forZoomOut2').removeClass("ui-block-b");
	for(var i = (currentPage-1) * PHOTO_NUM_OF_SOURCE_ON_PAGE; i < currentPage * PHOTO_NUM_OF_SOURCE_ON_PAGE; i++)
	{
		if(PHOTO_LIST[i]!=null)
		{
			$('#photoListview').append('<li id="' + 'photo' + i + '" path="' + PHOTO_LIST[i].path + '" name="' + PHOTO_LIST[i].name + '" class="ui-btn ui-btn-icon-right ui-li ui-li-has-thumb ui-btn-up-g" data-theme="g">'
			+'<div class="ui-btn-inner ui-li">'
			+'<div class="ui-btn-text">'
			+'<a class="ui-link-inherit" >'
			+'<img id="photoImg" class="ui-li-thumb" src="' + PHOTO_LIST[i].path + '">'
			+'<h3 class="ui-li-heading">' + PHOTO_LIST[i].name.replace("." + PHOTO_LIST[i].name.split(".")[PHOTO_LIST[i].name.split(".").length-1], "") + '</h3>'
			+'<p class="ui-li-desc">' + PHOTO_LIST[i].path + '</p>'
			+'</a>'
			+'</div>'
			+'</div>'
			+'</a>'
			+'</li>');
			
			$('#' + 'photo' + i).live('tap', function() {				
				if(!isClicked)
				{   
					isClicked=true;
					SELECTED_PICTURE_PATH = $(this).attr('path');
					SELECTED_PICTURE_NAME = $(this).attr('name');
					drawSelectedPicture();
				}
				setTimeout(function(){isClicked=false;},500);
			});
		}
		else
		{
			$('#photoListview').append('<li class="ui-btn ui-btn-icon-right ui-li ui-li-has-thumb ui-btn-up-g" data-theme="g">'
					+'<div class="ui-btn-inner ui-li">'
					+'<div class="ui-btn-text">'
					+'<a class="ui-link-inherit" >'
					//+'<img id="photoImg" class="ui-li-thumb" src="' + PHOTO_LIST[i].path + '">'
					+'<h3 class="ui-li-heading"></h3>'
					+'<p class="ui-li-desc"></p>'
					+'</a>'
					+'</div>'
					+'</div>'
					+'</a>'
					+'</li>');
		}
	}
	setCSS();

}


//축소 모드 페이지 그리기
function zoomOutDrawPhotoPage(currentPage)
{
	$('#zoomInPhotoPage > a').removeClass('ui-btn-active');
	$('#zoomOutPhotoPage > a').addClass('ui-btn-active');
	$('#normalPhotoPage > a').removeClass('ui-btn-active');
	if(PHOTO_LIST.length==0)
	{
		$('#photo-title h1').html('Photo - No Files');
	}
	else
	{
		$('#photo-title h1').html('Photo (' + PHOTO_CURRENT_PAGE + ' / '+ Math.ceil(PHOTO_LIST.length / PHOTO_NUM_OF_SOURCE_ON_PAGE) + ')');
	}
	$('#photoListview').html("");
	$('#photoListview2').html("");
	$('#forZoomOut1').addClass("ui-block-a");
	$('#forZoomOut2').addClass("ui-block-b");
	for(var i = (currentPage-1) * PHOTO_NUM_OF_SOURCE_ON_PAGE; i < currentPage * PHOTO_NUM_OF_SOURCE_ON_PAGE; i++)
	{
		if(PHOTO_LIST[i]!=null)
		{
			if (i%2==0) {
				$('#photoListview').append('<li id="' + 'photo' + i + '" path="' + PHOTO_LIST[i].path + '" name="' + PHOTO_LIST[i].name + '" class="ui-btn ui-btn-icon-right ui-li ui-li-has-thumb ui-btn-up-g" data-theme="g">'
						+'<div class="ui-btn-inner ui-li">'
						+'<div class="ui-btn-text">'
						+'<a class="ui-link-inherit" >'
						+'<img id="photoImg" class="ui-li-thumb" src="' + PHOTO_LIST[i].path + '">'
						+'<h3 class="ui-li-heading">' + PHOTO_LIST[i].name.replace("." + PHOTO_LIST[i].name.split(".")[PHOTO_LIST[i].name.split(".").length-1], "") + '</h3>'
						+'<p class="ui-li-desc"></p>'
						+'</a>'
						+'</div>'
						+'</div>'
						+'</a>'
						+'</li>');
						
						$('#' + 'photo' + i).live('tap', function() {
							if(!isClicked)
							{
								isClicked=true;
								SELECTED_PICTURE_PATH = $(this).attr('path');
								SELECTED_PICTURE_NAME = $(this).attr('name');
								drawSelectedPicture();
							}
							setTimeout(function(){isClicked=false;},500);
						});
			}
			else {
				$('#photoListview2').append('<li id="' + 'photo' + i + '" path="' + PHOTO_LIST[i].path + '" name="' + PHOTO_LIST[i].name + '" class="ui-btn ui-btn-icon-right ui-li ui-li-has-thumb ui-btn-up-g" data-theme="g">'
						+'<div class="ui-btn-inner ui-li">'
						+'<div class="ui-btn-text">'
						+'<a class="ui-link-inherit" >'
						+'<img id="photoImg" class="ui-li-thumb" src="' + PHOTO_LIST[i].path + '">'
						+'<h3 class="ui-li-heading">' + PHOTO_LIST[i].name.replace("." + PHOTO_LIST[i].name.split(".")[PHOTO_LIST[i].name.split(".").length-1], "") + '</h3>'
						+'<p class="ui-li-desc"></p>'
						+'</a>'
						+'</div>'
						+'</div>'
						+'</a>'
						+'</li>');
						
						$('#' + 'photo' + i).live('tap', function() {
							if(!isClicked)
							{
								isClicked=true;
								SELECTED_PICTURE_PATH = $(this).attr('path');
								SELECTED_PICTURE_NAME = $(this).attr('name');
								drawSelectedPicture();
							}
							setTimeout(function(){isClicked=false;},500);
						});
			}
		}
		else
		{
			if (i%2==0) {
				$('#photoListview').append('<li class="ui-btn ui-btn-icon-right ui-li ui-li-has-thumb ui-btn-up-g" data-theme="g">'
						+'<div class="ui-btn-inner ui-li">'
						+'<div class="ui-btn-text">'
						+'<a class="ui-link-inherit" >'
						//+'<img id="photoImg" class="ui-li-thumb">'
						+'<h3 class="ui-li-heading"></h3>'
						+'<p class="ui-li-desc"></p>'
						+'</a>'
						+'</div>'
						+'</div>'
						+'</a>'
						+'</li>');
			}
			else {
				$('#photoListview2').append('<li class="ui-btn ui-btn-icon-right ui-li ui-li-has-thumb ui-btn-up-g" data-theme="g">'
						+'<div class="ui-btn-inner ui-li">'
						+'<div class="ui-btn-text">'
						+'<a class="ui-link-inherit" >'
						//+'<img id="photoImg" class="ui-li-thumb">'
						+'<h3 class="ui-li-heading"></h3>'
						+'<p class="ui-li-desc"></p>'
						+'</a>'
						+'</div>'
						+'</div>'
						+'</a>'
						+'</li>');
			}
		}
	}
	$('#photoListview').append("</div>");
	setCSS();
}
function zoomInDrawPhotoPage(currentPage)
{
	$('#zoomInPhotoPage > a').addClass('ui-btn-active');
	$('#zoomOutPhotoPage > a').removeClass('ui-btn-active');
	$('#normalPhotoPage > a').removeClass('ui-btn-active');
	
	if(PHOTO_LIST.length==0)
	{
		$('#photo-title h1').html('Photo - No Files');
	}
	else
	{
		$('#photo-title h1').html('Photo (' + PHOTO_CURRENT_PAGE + ' / '+ Math.ceil(PHOTO_LIST.length / PHOTO_NUM_OF_SOURCE_ON_PAGE) + ')');
	}
	
	$('#photoListview').html("");
	$('#photoListview2').html("");
	$('#forZoomOut1').removeClass("ui-block-a");
	$('#forZoomOut2').removeClass("ui-block-b");
	for(var i = (currentPage-1) * PHOTO_NUM_OF_SOURCE_ON_PAGE; i < currentPage * PHOTO_NUM_OF_SOURCE_ON_PAGE; i++)
	{
		if(PHOTO_LIST[i]!=null)
		{
			$('#photoListview').append('<li id="' + 'photo' + i + '" path="' + PHOTO_LIST[i].path + '" name="' + PHOTO_LIST[i].name + '" class="ui-btn ui-btn-icon-right ui-li ui-li-has-thumb ui-btn-up-g" data-theme="g">'
					+'<div class="ui-btn-inner ui-li">'
					+'<div class="ui-btn-text">'
					+'<a class="ui-link-inherit" >'
					+'<img id="photoImg" class="ui-li-thumb" src="' + PHOTO_LIST[i].path + '">'
					+'<h3 class="ui-li-heading">' + PHOTO_LIST[i].name.replace("." + PHOTO_LIST[i].name.split(".")[PHOTO_LIST[i].name.split.length-1], "") + '</h3>'
					+'<p class="ui-li-desc">' + PHOTO_LIST[i].path + '</p>'
					+'</a>'
					+'</div>'
					+'</div>'
					+'</a>'
					+'</li>');
					
					$('#' + 'photo' + i).live('tap', function() {
						if(!isClicked)
						{
							isClicked=true;
							SELECTED_PICTURE_PATH = $(this).attr('path');
							SELECTED_PICTURE_NAME = $(this).attr('name');
							drawSelectedPicture();
						}
						setTimeout(function(){isClicked=false;},500);
					});
		}
		else
		{
			$('#photoListview').append('<li class="ui-btn ui-btn-icon-right ui-li ui-li-has-thumb ui-btn-up-g" data-theme="g">'
					+'<div class="ui-btn-inner ui-li">'
					+'<div class="ui-btn-text">'
					+'<a class="ui-link-inherit" >'
					//+'<img id="photoImg" class="ui-li-thumb" src="' + PHOTO_LIST[i].path + '">'
					+'<h3 class="ui-li-heading"></h3>'
					+'<p class="ui-li-desc"></p>'
					+'</a>'
					+'</div>'
					+'</div>'
					+'</a>'
					+'</li>');
		}
	}
	setCSS();
}


function setPageEvents()
{
	NUM_OF_PAGE = Math.ceil(PHOTO_LIST.length / PHOTO_NUM_OF_SOURCE_ON_PAGE);
	$('#normalPhotoPage').live('tap', function() {
		if (!isClicked)
		{
			isClicked=true;
			PHOTO_CURRENT_PAGE = 1;
			PHOTO_NUM_OF_SOURCE_ON_PAGE = 4;
			NUM_OF_PAGE = Math.ceil(PHOTO_LIST.length / PHOTO_NUM_OF_SOURCE_ON_PAGE);
			PHOTO_PAGE_MODE="normal";
			normalDrawPhotoPage(PHOTO_CURRENT_PAGE);
		}
		setTimeout(function(){isClicked=false;},300);
	});
	
	$('#zoomOutPhotoPage').live('tap', function() {
		if (!isClicked)
		{
			isClicked=true;
			PHOTO_CURRENT_PAGE = 1;
			PHOTO_NUM_OF_SOURCE_ON_PAGE = 12;
			NUM_OF_PAGE = Math.ceil(PHOTO_LIST.length / PHOTO_NUM_OF_SOURCE_ON_PAGE);
			PHOTO_PAGE_MODE = "zoomOut";
			zoomOutDrawPhotoPage(PHOTO_CURRENT_PAGE);
		}
		setTimeout(function(){isClicked=false;},300);
	});
	
	$('#zoomInPhotoPage').live('tap', function() {
		if (!isClicked)
		{
			isClicked=true;
			PHOTO_CURRENT_PAGE = 1;
			PHOTO_NUM_OF_SOURCE_ON_PAGE = 3;
			NUM_OF_PAGE = Math.ceil(PHOTO_LIST.length / PHOTO_NUM_OF_SOURCE_ON_PAGE);
			PHOTO_PAGE_MODE = "zoomIn";
			zoomInDrawPhotoPage(PHOTO_CURRENT_PAGE);
		}
		setTimeout(function(){isClicked=false;},300);
	});
	
	$('#prePhotoPage').live('tap', function(event) {
		$('#prePhotoPage > a').removeClass('ui-btn-active');
			switch(PHOTO_PAGE_MODE){
			case "normal":
				$('#normalPhotoPage > a').addClass('ui-btn-active');
				break;
			case "zoomOut":
				$('#zoomOutPhotoPage > a').addClass('ui-btn-active');
				break;
			case "zoomIn":
				$('#zoomInPhotoPage > a').addClass('ui-btn-active');
				break;
			default:
		}
			
		if(!isMobile())
		{
			if(PHOTO_CURRENT_PAGE!=1)
			{
				LAST_CLICKED_VALUE = curClickPoint;
				PHOTO_CURRENT_PAGE--;
				switch(PHOTO_PAGE_MODE){
					case "normal":
						normalDrawPhotoPage(PHOTO_CURRENT_PAGE);
						break;
					case "zoomOut":
						zoomOutDrawPhotoPage(PHOTO_CURRENT_PAGE);
						break;
					case "zoomIn":
						zoomInDrawPhotoPage(PHOTO_CURRENT_PAGE);
						break;
					default:
				}
			}
		}
		else	
		{
			var lastClickPoint = LAST_CLICKED_VALUE;
		    var curClickPoint = event.clientX+'x'+event.clientY;
		    if (lastClickPoint == curClickPoint) 
		    {
		    	return false;
		    }
		    else
		    {
				if(PHOTO_CURRENT_PAGE!=1)
				{
					LAST_CLICKED_VALUE = curClickPoint;
					PHOTO_CURRENT_PAGE--;
					switch(PHOTO_PAGE_MODE){
						case "normal":
							normalDrawPhotoPage(PHOTO_CURRENT_PAGE);
							break;
						case "zoomOut":
							zoomOutDrawPhotoPage(PHOTO_CURRENT_PAGE);
							break;
						case "zoomIn":
							zoomInDrawPhotoPage(PHOTO_CURRENT_PAGE);
							break;
						default:
					}
				}
		    }
		}
		
	});
	
	
	
	$('#nextPhotoPage').live('tap', function(event) {
		$('#nextPhotoPage > a').removeClass('ui-btn-active');
		switch(PHOTO_PAGE_MODE){
			case "normal":
				$('#normalPhotoPage > a').addClass('ui-btn-active');
				break;
			case "zoomOut":
				$('#zoomOutPhotoPage > a').addClass('ui-btn-active');
				break;
			case "zoomIn":
				$('#zoomInPhotoPage > a').addClass('ui-btn-active');
				break;
			default:
		}
		if (!isMobile())
		{
			if(PHOTO_CURRENT_PAGE < NUM_OF_PAGE)
			{
				LAST_CLICKED_VALUE = curClickPoint;
				PHOTO_CURRENT_PAGE++;
				switch(PHOTO_PAGE_MODE) {
					case "normal":
						normalDrawPhotoPage(PHOTO_CURRENT_PAGE);
						break;
					case "zoomOut":
						zoomOutDrawPhotoPage(PHOTO_CURRENT_PAGE);
						break;
					case "zoomIn":
						zoomInDrawPhotoPage(PHOTO_CURRENT_PAGE);
						break;
					default:
				}
			}
		}
		else {
			var lastClickPoint = LAST_CLICKED_VALUE;
		    var curClickPoint = event.clientX+'x'+event.clientY;
		    if (lastClickPoint == curClickPoint) 
		    {
		    	return false;
		    }
		    else
		    {
				if(PHOTO_CURRENT_PAGE < NUM_OF_PAGE)
				{
					LAST_CLICKED_VALUE = curClickPoint;
					PHOTO_CURRENT_PAGE++;
					switch(PHOTO_PAGE_MODE) {
						case "normal":
							normalDrawPhotoPage(PHOTO_CURRENT_PAGE);
							break;
						case "zoomOut":
							zoomOutDrawPhotoPage(PHOTO_CURRENT_PAGE);
							break;
						case "zoomIn":
							zoomInDrawPhotoPage(PHOTO_CURRENT_PAGE);
							break;
						default:
					}
				}
		    }
		}
	});
	
	$('#photo-footer').live('tap', function(event) {
		if (!isClicked && $('#photo-footer > h4').html()=="Close")
		{
			isClicked=true;
			cancelDrawSelectedPicture();
		}
		setTimeout(function(){isClicked=false;},500);
	});
}

//모바일에서 접속했는지 체크
function isMobile() {
	if(navigator.userAgent.match(/iPhone|iPod|iPad|Android|Windows CE|BlackBerry|Symbian|Windows Phone|webOS|Opera Mini|Opera Mobi|POLARIS|IEMobile|lgtelecom|nokia|SonyEricsson/i) != null || 
			navigator.userAgent.match(/LG|SAMSUNG|Samsung/) != null) {
		return true;
	} else {
		return false;
	}
}
