#!/bin/bash
#set -x

CONVERT="DOWN" #Convert UP/DOWN, UP is 1280 to 1920 conversion

rm com
if [ "$CONVERT" = "UP" ]
then
	echo "%s/Images_1280/Images_1920/g" > com
else
	echo "%s/Images_1920/Images_1280/g" > com
fi
echo "wq" >>com

if [ $# -lt 1 ]
then
	echo "Argument less than 1"
	echo "USAGE <INPUT_FILE> or"
	echo "USAGE <INPUT_FILE> <OUTPUT_FILE>"
	exit 0;
fi

INPUT_FILE=$1

if [ $# -gt 1 ]
then
	OUTPUT_FILE="$2"
else
	OUTPUT_FILE="$1_OUT"
fi

echo "Processing file $INPUT_FILE, Generating Output file $OUTPUT_FILE"
rm -rf $OUTPUT_FILE

#cat Unified.glade | cut -d'>' -f2 | cut -d'<' -f1

TOT_LINE=`wc -l $INPUT_FILE | cut -d' ' -f1`
echo "Total lines in file are $TOT_LINE"

VAR="1"

while [ $VAR -le $TOT_LINE ]
do
	LINE=`head -$VAR $INPUT_FILE | tail -1`
#	echo $LINE
        LINE_CHECK=`echo $LINE | egrep 'request|\"x\"|\"y\"|xpad|ypad'`
        if [ "$LINE_CHECK" != "" ]
        then
	        DIGIT=`echo $LINE | cut -d'>' -f2 | cut -d'<' -f1`

       	 	if [ "$DIGIT" -eq "$DIGIT" ] 2>/dev/null; 
		then
			FACTOR="2"
			if [ "$CONVERT" = "UP" ]
			then
				NEW_VAL=`echo $DIGIT \* $FACTOR | bc`
			else
				NEW_VAL=`echo $DIGIT/$FACTOR | bc`
			fi
			echo "converting Line "$LINE" for value=$DIGIT New Val=$NEW_VAL"
			SPACE=`echo "$LINE" | cut -d'<' -f1`
			F1=`echo $LINE | cut -d'>' -f1`
	        	F2=`echo $LINE | cut -d'>' -f2 | cut -d'<' -f2`
			echo "$SPACE"$F1\>$NEW_VAL\<$F2\> >> $OUTPUT_FILE
		else
			echo "$LINE" >> $OUTPUT_FILE
		fi
	else
		echo "$LINE" >> $OUTPUT_FILE
	fi
	VAR=`expr $VAR + 1`
done

vim -es $OUTPUT_FILE < com
