require("SDL_error")

-- Transparency definitions: These define alpha as the opacity of a surface
SDL_ALPHA_OPAQUE = libLuaSDL.SDL_ALPHA_OPAQUE
SDL_ALPHA_TRANSPARENT = libLuaSDL.SDL_ALPHA_TRANSPARENT

-- These are the currently supported flags for the SDL_surface
-- Available for SDL_CreateRGBSurface() or SDL_SetVideoMode()

SDL_SWSURFACE =	0x00000000
SDL_HWSURFACE =	0x00000001
SDL_ASYNCBLIT =	0x00000004

SDL_ANYFORMAT	= 0x10000000
SDL_HWPALETTE	= 0x20000000
SDL_DOUBLEBUF	= 0x40000000
SDL_FULLSCREEN	= 0x80000000
SDL_OPENGL      = 0x00000002
SDL_OPENGLBLIT	= 0x0000000A
SDL_RESIZABLE	= 0x00000010
SDL_NOFRAME		= 0x00000020

SDL_HWACCEL		= 0x00000100
SDL_SRCCOLORKEY	= 0x00001000
SDL_RLEACCELOK	= 0x00002000
SDL_RLEACCEL	= 0x00004000
SDL_SRCALPHA	= 0x00010000
SDL_PREALLOC	= 0x01000000

function SDL_MUSTLOCK(surface)
	if surface ~= nil then
		libLuaSDL.SDL_MUSTLOCK(surface)
	end
end


SDL_YV12_OVERLAY = libLuaSDL.SDL_YV12_OVERLAY 	--  Planar mode: Y + V + U  (3 planes)
SDL_IYUV_OVERLAY = libLuaSDL.SDL_IYUV_OVERLAY 	--  Planar mode: Y + U + V  (3 planes)
SDL_YUY2_OVERLAY = libLuaSDL.SDL_YUY2_OVERLAY 	--  Packed mode: Y0+U0+Y1+V0 (1 plane)
SDL_UYVY_OVERLAY = libLuaSDL.SDL_UYVY_OVERLAY 	--  Packed mode: U0+Y0+V0+Y1 (1 plane)
SDL_YVYU_OVERLAY = libLuaSDL.SDL_YVYU_OVERLAY 	--  Packed mode: Y0+V0+Y1+U0 (1 plane)

SDL_GL_RED_SIZE 			= libLuaSDL.SDL_GL_RED_SIZE
SDL_GL_GREEN_SIZE 			= libLuaSDL.SDL_GL_GREEN_SIZE
SDL_GL_BLUE_SIZE 			= libLuaSDL.SDL_GL_BLUE_SIZE
SDL_GL_ALPHA_SIZE 			= libLuaSDL.SDL_GL_ALPHA_SIZE
SDL_GL_BUFFER_SIZE  		= libLuaSDL.SDL_GL_BUFFER_SIZE
SDL_GL_DOUBLEBUFFER			= libLuaSDL.SDL_GL_DOUBLEBUFFER
SDL_GL_DEPTH_SIZE			= libLuaSDL.SDL_GL_DEPTH_SIZE
SDL_GL_STENCIL_SIZE			= libLuaSDL.SDL_GL_STENCIL_SIZE
SDL_GL_ACCUM_RED_SIZE		= libLuaSDL.SDL_GL_ACCUM_RED_SIZE
SDL_GL_ACCUM_GREEN_SIZE 	= libLuaSDL.SDL_GL_ACCUM_GREEN_SIZE
SDL_GL_ACCUM_BLUE_SIZE		= libLuaSDL.SDL_GL_ACCUM_BLUE_SIZE
SDL_GL_ACCUM_ALPHA_SIZE		= libLuaSDL.SDL_GL_ACCUM_ALPHA_SIZE
SDL_GL_STEREO				= libLuaSDL.SDL_GL_STEREO
SDL_GL_MULTISAMPLEBUFFERS	= libLuaSDL.SDL_GL_MULTISAMPLEBUFFERS
SDL_GL_MULTISAMPLESAMPLES	= libLuaSDL.SDL_GL_MULTISAMPLESAMPLES
SDL_GL_ACCELERATED_VISUAL	= libLuaSDL.SDL_GL_ACCELERATED_VISUAL
SDL_GL_SWAP_CONTROL			= libLuaSDL.SDL_GL_SWAP_CONTROL

-- flags for SDL_SetPalette()
SDL_LOGPAL = libLuaSDL.SDL_LOGPAL		--0x01
SDL_PHYSPAL = libLuaSDL.SDL_PHYSPAL		--0x02


SDL_GRAB_QUERY =  libLuaSDL.SDL_GRAB_QUERY
SDL_GRAB_OFF =  libLuaSDL.SDL_GRAB_OFF
SDL_GRAB_ON =  libLuaSDL.SDL_GRAB_ON
SDL_GRAB_FULLSCREEN  = libLuaSDL.SDL_GRAB_FULLSCREEN


function SDL_Overlay_new()
   return libLuaSDL.SDL_Overlay_new()
end

function SDL_Overlay_delete(overlay)
   if overlay ~= nil then
	libLuaSDL.SDL_Overlay_delete(overlay)
   end
end

function SDL_Rect_new()
   return libLuaSDL.SDL_Rect_new()
end

function SDL_Rect_delete(rect)
   if rect ~= nil then
       libLuaSDL.SDL_Rect_delete(rect)
   end
end

function SDL_Color_new()
   return libLuaSDL.SDL_Color_new()
end

function SDL_Color_delete(color)
   if color ~= nil then
      libLuaSDL.SDL_Color_delete(color)
   end
end

function SDL_Palette_new()
   return libLuaSDL.SDL_Palette_new()
end

function SDL_Palette_delete(palette)
   if palette ~= nil then
       libLuaSDL.SDL_Palette_delete(palette)
   end
end

function SDL_VideoInit(driver_name, flags)
    return libLuaSDL.SDL_VideoInit(driver_name,flags)
end

function SDL_VideoQuit()
   libLuaSDL.SDL_VideoQuit()
end

function SDL_VideoDriverName(namebuf, maxlen)
   maxlen = tonumber(maxlen)
   return libLuaSDL.SDL_VideoDriverName(namebuf, maxlen)
end

function SDL_GetVideoSurface()
   return libLuaSDL.SDL_GetVideoSurface()
end

function SDL_GetVideoInfo()
   return libLuaSDL.SDL_GetVideoInfo()
end

function SDL_VideoModeOK(width, height, bpp, flags)
   return libLuaSDL.SDL_VideoModeOK(width, height, bpp, flags)
end

function SDL_ListModes(format, flags)
	local modes = libLuaSDL.SDL_ListModes(format, flags)
	local errRet = libLuaSDL.GetListModes(modes)
	if errRet == 0 then
		return nil
	elseif errRet == -1 then
		return -1
	else
		return modes
	end
end

function SDL_SetVideoMode(width, height, bpp, flags)
   return libLuaSDL.SDL_SetVideoMode(width, height, bpp, flags)
end

function SDL_UpdateRects(screen, numrects, rects)
   libLuaSDL.SDL_UpdateRects(screen, numrects, rects)
end

function SDL_UpdateRect(screen, x, y, w, h)
   libLuaSDL.SDL_UpdateRect(screen, x, y, w, h)
end

function SDL_Flip(screen)
   return libLuaSDL.SDL_Flip(screen)
end

function SDL_SetGamma(red, green, blue)
   return libLuaSDL.SDL_SetGamma(red, green, blue)
end

function SDL_SetGammaRamp(red, green, blue)
   return libLuaSDL.SDL_SetGammaRamp(red, green, blue)
end

function SDL_GetGammaRamp(red, green, blue)
   return libLuaSDL.SDL_GetGammaRamp(red, green, blue)
end

function SDL_SetColors(surface, colors, firstcolor, ncolors)
   return libLuaSDL.SDL_SetColors(surface, colors, firstcolor, ncolors)
end

function SDL_SetPalette(surface, flags, colors, firstcolor, ncolors)
   return libLuaSDL.SDL_SetPalette(surface, flags, colors, firstcolor, ncolors)
end

function SDL_MapRGB(format, r, g, b)
   return libLuaSDL.SDL_MapRGB(format, r, g, b)
end

function SDL_MapRGBA(format, r, g, b, a)
   return libLuaSDL.SDL_MapRGBA(format, r, g, b, a)
end

function SDL_GetRGB(pixel, fmt, r, g, b)
   libLuaSDL.SDL_GetRGB(pixel, fmt, r, g, b)
end

function SDL_GetRGBA(pixel, fmt, r, g, b, a)
   libLuaSDL.SDL_GetRGBA(pixel, fmt, r, g, b, a)
end

function SDL_AllocSurface(flags, width, height, depth, Rmask, Gmask, Bmask, Amask)
   return libLuaSDL.SDL_AllocSurface(flags, width, height, depth, Rmask, Gmask, Bmask, Amask)
end

function SDL_CreateRGBSurface(flags, width, height, depth, Rmask, Gmask, Bmask, Amask)
   return libLuaSDL.SDL_CreateRGBSurface(flags, width, height, depth, Rmask, Gmask, Bmask, Amask)
end

function SDL_CreateRGBSurfaceFrom(pixels, width, height, depth, pitch, Rmask, Gmask, Bmask, Amask)
   return libLuaSDL.SDL_CreateRGBSurfaceFrom(pixels, width, height, depth, pitch, Rmask, Gmask, Bmask, Amask)
end

function SDL_FreeSurface(surface)
    if surface ~= nil then
		libLuaSDL.SDL_FreeSurface(surface)
    end
end

function SDL_LockSurface(surface)
   return libLuaSDL.SDL_LockSurface(surface)
end

function SDL_UnlockSurface(surface)
   if surface ~= nil then
       libLuaSDL.SDL_UnlockSurface(surface)
   end
end

function SDL_LoadBMP_RW(src, freesrc)
    return libLuaSDL.SDL_LoadBMP_RW(src, freesrc)
end

function SDL_LoadBMP(file)
   if type(file)~="string" or file == nil then
		return nil
   else
		return libLuaSDL.SDL_LoadBMP(file)
   end
end

function SDL_SaveBMP_RW(surface, dst, freedst)
   return libLuaSDL.SDL_SaveBMP_RW(surface, dst, freedst)
end

function SDL_SaveBMP(surface, file)
   return libLuaSDL.SDL_SaveBMP(surface, file)
end

function SDL_SetColorKey(surface, flag, key)
   return libLuaSDL.SDL_SetColorKey(surface, flag, key)
end

function SDL_SetAlpha(surface, flag, alpha)
   return libLuaSDL.SDL_SetAlpha(surface, flag, alpha)
end

function SDL_SetClipRect(surface, rect)
   return libLuaSDL.SDL_SetClipRect(surface, rect)
end

function SDL_GetClipRect(surface, rect)
   libLuaSDL.SDL_GetClipRect(surface, rect)
end

function SDL_ConvertSurface(src, fmt, flags)
   return libLuaSDL.SDL_ConvertSurface(src, fmt, flags)
end




function SDL_UpperBlit(src, srcrect, dst, dstrect)
   return libLuaSDL.SDL_UpperBlit(src, srcrect, dst, dstrect)
end

function SDL_LowerBlit(src, srcrect, dst, dstrect)
   return libLuaSDL.SDL_LowerBlit(src, srcrect, dst, dstrect)
end

function SDL_FillRect(dst, dstrect, color)
   return libLuaSDL.SDL_FillRect(dst, dstrect, color)
end

function SDL_DisplayFormat(surface)
   return libLuaSDL.SDL_DisplayFormat(surface)
end

function SDL_DisplayFormatAlpha(surface)
   return libLuaSDL.SDL_DisplayFormatAlpha(surface)
end

function SDL_CreateYUVOverlay(width, height, format, display)
   return libLuaSDL.SDL_CreateYUVOverlay(width, height, format, display)
end

function SDL_LockYUVOverlay(overlay)
   return libLuaSDL.SDL_LockYUVOverlay(overlay)
end

function SDL_UnlockYUVOverlay(overlay)
   return libLuaSDL.SDL_UnlockYUVOverlay(overlay)
end

function SDL_DisplayYUVOverlay(overlay, dstrect)
   return libLuaSDL.SDL_DisplayYUVOverlay(overlay, dstrect)
end

function SDL_FreeYUVOverlay(overlay)
   libLuaSDL.SDL_FreeYUVOverlay(overlay)
end

function SDL_GL_LoadLibrary(path)
    return libLuaSDL.SDL_GL_LoadLibrary(path)
end

function SDL_GL_GetProcAddress(proc)
    return libLuaSDL.SDL_GL_GetProcAddress(proc)
end

function SDL_GL_SetAttribute(attr, value)
   return libLuaSDL.SDL_GL_SetAttribute(attr, value)
end

function SDL_GL_GetAttribute(attr, value)
   return libLuaSDL.SDL_GL_GetAttribute(attr, value)
end

function SDL_GL_SwapBuffers()
   libLuaSDL.SDL_GL_SwapBuffers()
end

function SDL_GL_UpdateRects(numrects, rects)
   libLuaSDL.SDL_GL_UpdateRects(numrects, rects)
end

function SDL_GL_Lock()
   libLuaSDL.SDL_GL_Lock()
end

function SDL_GL_Unlock()
   libLuaSDL.SDL_GL_Unlock()
end


function SDL_WM_SetCaption(title, icon)
   libLuaSDL.SDL_WM_SetCaption(title, icon)
end

function SDL_WM_GetCaption(title, icon)
   libLuaSDL.SDL_WM_GetCaption(title, icon)
end

function SDL_WM_SetIcon(icon, mask)
   libLuaSDL.SDL_WM_SetIcon(icon, mask)
end

function SDL_WM_IconifyWindow()
    return libLuaSDL.SDL_WM_IconifyWindow()
end

function SDL_WM_ToggleFullScreen(surface)
    return libLuaSDL.SDL_WM_ToggleFullScreen(surface)
end

function SDL_WM_GrabInput(mode)
    return libLuaSDL.SDL_WM_GrabInput(mode)
end

