require('libLuaSDL_net')

SDL_NET_MAJOR_VERSION = libLuaSDL_net.SDL_NET_MAJOR_VERSION
SDL_NET_MINOR_VERSION = libLuaSDL_net.SDL_NET_MINOR_VERSION
SDL_NET_PATCHLEVEL    = libLuaSDL_net.SDL_NET_PATCHLEVEL

INADDR_ANY =  0x00000000
INADDR_NONE = 0xFFFFFFFF
INADDR_BROADCAST = 0xFFFFFFFF

function SDL_NET_VERSION(X)
   libLuaSDL_net.SDL_NET_VERSION(X)
end

function SDLNet_Linked_Version()
   return libLuaSDL_net.SDLNet_Linked_Version()
end

function SDLNet_Init()
   return libLuaSDL_net.SDLNet_Init()
end

function SDLNet_Quit()
   libLuaSDL_net.SDLNet_Quit()
end

function IPaddress_new()
   return libLuaSDL_net.IPaddress_new()
end

function IPaddress_delete(ip)
   if ip ~= nil then
       libLuaSDL_net.IPaddress_delete(ip)
   end
end

function SDLNet_ResolveHost(address, host, port)
   return libLuaSDL_net.SDLNet_ResolveHost(address, host, port)
end

function SDLNet_ResolveIP(ip)
   return libLuaSDL_net.SDLNet_ResolveIP(ip)
end

function SDLNet_TCP_Open(ip)
   return libLuaSDL_net.SDLNet_TCP_Open(ip)
end

function SDLNet_TCP_Accept(server)
   return libLuaSDL_net.SDLNet_TCP_Accept(server)
end

function SDLNet_TCP_GetPeerAddress(sock)
   return libLuaSDL_net.SDLNet_TCP_GetPeerAddress(sock)
end

function SDLNet_TCP_Send(sock, data, len)
   return libLuaSDL_net.SDLNet_TCP_Send(sock, data, len)
end

function SDLNet_TCP_Recv(sock, data, maxlen)
   return libLuaSDL_net.SDLNet_TCP_Recv(sock, data, maxlen)
end

function SDLNet_TCP_Close(sock)
   libLuaSDL_net.SDLNet_TCP_Close(sock)
end

SDLNET_MAX_UDPCHANNELS  = libLuaSDL_net.SDLNET_MAX_UDPCHANNELS
SDLNET_MAX_UDPADDRESSES = libLuaSDL_net.SDLNET_MAX_UDPADDRESSES

function SDLNet_AllocPacket(size)
   return libLuaSDL_net.SDLNet_AllocPacket(size)
end
function SDLNet_ResizePacket(packet, newsize)
   return libLuaSDL_net.SDLNet_ResizePacket(packet, newsize)
end

function SDLNet_FreePacket(packet)
   libLuaSDL_net.SDLNet_FreePacket(packet)
end

function SDLNet_AllocPacketV(howmany, size)
   return libLuaSDL_net.SDLNet_AllocPacketV(howmany, size)
end

function SDLNet_FreePacketV(packetV)
   libLuaSDL_net.SDLNet_FreePacketV(packetV)
end

function SDLNet_UDP_Open(port)
   return libLuaSDL_net.SDLNet_UDP_Open(port)
end

function SDLNet_UDP_Bind(sock, channel, address)
   return libLuaSDL_net.SDLNet_UDP_Bind(sock, channel, address)
end

function SDLNet_UDP_Unbind(sock, channel)
   libLuaSDL_net.SDLNet_UDP_Unbind(sock, channel)
end

function SDLNet_UDP_GetPeerAddress(sock, channel)
   return libLuaSDL_net.SDLNet_UDP_GetPeerAddress(sock, channel)
end

function SDLNet_UDP_SendV(sock, packets, npackets)
   return libLuaSDL_net.SDLNet_UDP_SendV(sock, packets, npackets)
end

function SDLNet_UDP_Send(sock, channel, packet)
   return libLuaSDL_net.SDLNet_UDP_Send(sock, channel, packet)
end


function SDLNet_UDP_RecvV(sock, packets)
	return libLuaSDL_net.SDLNet_UDP_RecvV(sock, packets)
end

function SDLNet_UDP_Recv(sock, packet)
   return libLuaSDL_net.SDLNet_UDP_Recv(sock, packet)
end

function SDLNet_UDP_Close(sock)
   libLuaSDL_net.SDLNet_UDP_Close(sock)
end


function _SDLNet_GenericSocket_new()
	return libLuaSDL_net._SDLNet_GenericSocket_new
end

function _SDLNet_GenericSocket_delete(sock)
	if sock ~= nil then
		libLuaSDL_net._SDLNet_GenericSocket_delete(sock)
	end
end


function SDLNet_AllocSocketSet(maxsockets)
   return libLuaSDL_net.SDLNet_AllocSocketSet(maxsockets)
end

function SDLNet_TCP_AddSocket(set, sock)
	return libLuaSDL_net.SDLNet_TCP_AddSocket(set, sock)
end
function  SDLNet_UDP_AddSocket(set, sock)
	return libLuaSDL_net.SDLNet_UDP_AddSocket(set, sock)
end

function SDLNet_AddSocket(set, sock)
	return libLuaSDL_net.SDLNet_AddSocket(set, sock)
end

function SDLNet_TCP_DelSocket(set, sock)
	return libLuaSDL_net.SDLNet_TCP_DelSocket(set, sock)
end

function SDLNet_UDP_DelSocket(set, sock)
	return libLuaSDL_net.SDLNet_UDP_DelSocket(set, sock)
end

function  SDLNet_DelSocket(set, sock)
	return libLuaSDL_net.SDLNet_DelSocket(set, sock)
end

function SDLNet_CheckSockets(set, timeout)
   return libLuaSDL_net.SDLNet_CheckSockets(set, timeout)
end

function SDLNet_FreeSocketSet(set)
   libLuaSDL_net.SDLNet_FreeSocketSet(set)
end

function SDLNet_Write16(value, area)
   libLuaSDL_net.SDLNet_Write16(value, area)
end

function SDLNet_Write32(value, area)
   libLuaSDL_net.SDLNet_Write32(value, area)
end

function SDLNet_Read16(area)
   return libLuaSDL_net.SDLNet_Read16(area)
end

function SDLNet_Read32(area)
   return libLuaSDL_net.SDLNet_Read32(area)
end

function SDLNet_SetError(fmt)
   libLuaSDL_net.SDLNet_SetError(fmt)
end

function SDLNet_GetError()
   return libLuaSDL_net.SDLNet_GetError()
end

function SDLNet_UDP_SocketReady(sock)
	return libLuaSDL_net.SDLNet_UDP_SocketReady(sock)
end

function SDLNet_TCP_SocketReady(sock)
	return libLuaSDL_net.SDLNet_TCP_SocketReady(sock)
end


function SetUDPPacketV(packets, idx, pkt)
	libLuaSDL_net.SetUDPPacketV(packets, idx, pkt)
end


function GetUDPpacket(packets, idx)
	return libLuaSDL_net.GetUDPpacket(packets, idx)
end

