require('libLuaSDL')

--[[
 This function dynamically loads a shared object and returns a pointer
 to the object handle (or NULL if there was an error).
 The 'sofile' parameter is a system dependent name of the object file.
]]
function SDL_LoadObject(sofile)
   if type(sofile) == "string" then
	return libLuaSDL.SDL_LoadObject(sofile)
   end
   return nil
end
 
--[[
  Given an object handle, this function looks up the address of the
  named function in the shared object and returns it.  This address
  is no longer valid after calling SDL_UnloadObject().
]]
function SDL_LoadFunction(handle, name)
    if type(name) == "string" then
	return libLuaSDL.SDL_LoadFunction(handle, name)
    end
    return nil
end

-- Unload a shared object from memory 
function SDL_UnloadObject(handle) 
    libLuaSDL.SDL_UnloadObject(handle)
end


