require("SDL_keyboard")
require("SDL_mouse")
require("SDL_util")

SDL_PRESSED = libLuaSDL.SDL_PRESSED
SDL_RELEASED = libLuaSDL.SDL_RELEASED

--Event enumerations

SDL_NOEVENT		=	libLuaSDL.SDL_NOEVENT
SDL_ACTIVEEVENT		=	libLuaSDL.SDL_ACTIVEEVENT
SDL_KEYDOWN		=	libLuaSDL.SDL_KEYDOWN
SDL_KEYUP		=	libLuaSDL.SDL_KEYUP
SDL_MOUSEMOTION		=	libLuaSDL.SDL_MOUSEMOTION
SDL_MOUSEBUTTONDOWN 	=	libLuaSDL.SDL_MOUSEBUTTONDOWN
SDL_MOUSEBUTTONUP	=	libLuaSDL.SDL_MOUSEBUTTONUP
SDL_JOYAXISMOTION	=	libLuaSDL.SDL_JOYAXISMOTION
SDL_JOYBALLMOTION	=	libLuaSDL.SDL_JOYBALLMOTION
SDL_JOYHATMOTION	=	libLuaSDL.SDL_JOYHATMOTION
SDL_JOYBUTTONDOWN	=	libLuaSDL.SDL_JOYBUTTONDOWN
SDL_JOYBUTTONUP		=	libLuaSDL.SDL_JOYBUTTONUP
SDL_QUIT		=	libLuaSDL.SDL_QUIT
SDL_SYSWMEVENT		=	libLuaSDL.SDL_SYSWMEVENT
SDL_EVENT_RESERVEDA	=	libLuaSDL.SDL_EVENT_RESERVEDA
SDL_EVENT_RESERVEDB	=	libLuaSDL.SDL_EVENT_RESERVEDB
SDL_VIDEORESIZE		=	libLuaSDL.SDL_VIDEORESIZE
SDL_VIDEOEXPOSE		=	libLuaSDL.SDL_VIDEOEXPOSE
SDL_ACCELOMETER =       libLuaSDL.SDL_ACCELOMETER
SDL_EVENT_RESERVED3	=	libLuaSDL.SDL_EVENT_RESERVED3
SDL_EVENT_RESERVED4	=	libLuaSDL.SDL_EVENT_RESERVED4
SDL_EVENT_RESERVED5	=	libLuaSDL.SDL_EVENT_RESERVED5
SDL_EVENT_RESERVED6	=	libLuaSDL.SDL_EVENT_RESERVED6
SDL_EVENT_RESERVED7 	=   	libLuaSDL.SDL_EVENT_RESERVED7
SDL_USEREVENT 		= 	libLuaSDL.SDL_USEREVENT

SDL_NUMEVENTS 		= 	libLuaSDL.SDL_NUMEVENTS

function SDL_EVENTMASK(x)
   return bit_lshift(1, x)
end

--Predefine Event Mask
SDL_ACTIVEEVENTMASK = SDL_EVENTMASK(SDL_ACTIVEEVENT)
SDL_KEYDOWNMASK	    = SDL_EVENTMASK(SDL_KEYDOWN)
SDL_KEYUPMASK		= SDL_EVENTMASK(SDL_KEYUP)
SDL_KEYEVENTMASK	= bit_or(SDL_EVENTMASK(SDL_KEYDOWN), SDL_EVENTMASK(SDL_KEYUP))
SDL_MOUSEMOTIONMASK	= SDL_EVENTMASK(SDL_MOUSEMOTION)
SDL_MOUSEBUTTONDOWNMASK	= SDL_EVENTMASK(SDL_MOUSEBUTTONDOWN)
SDL_MOUSEBUTTONUPMASK	= SDL_EVENTMASK(SDL_MOUSEBUTTONUP)
SDL_MOUSEEVENTMASK      =  bit_or(bit_or(SDL_EVENTMASK(SDL_MOUSEMOTION), SDL_EVENTMASK(SDL_MOUSEBUTTONDOWN)), SDL_EVENTMASK(SDL_MOUSEBUTTONUP))
SDL_JOYAXISMOTIONMASK	= SDL_EVENTMASK(SDL_JOYAXISMOTION)
SDL_JOYBALLMOTIONMASK	= SDL_EVENTMASK(SDL_JOYBALLMOTION)
SDL_JOYHATMOTIONMASK	= SDL_EVENTMASK(SDL_JOYHATMOTION)
SDL_JOYBUTTONDOWNMASK	= SDL_EVENTMASK(SDL_JOYBUTTONDOWN)
SDL_JOYBUTTONUPMASK	= SDL_EVENTMASK(SDL_JOYBUTTONUP)

SDL_JOYEVENTMASK	= bit_or(SDL_EVENTMASK(SDL_JOYAXISMOTION), SDL_EVENTMASK(SDL_JOYBALLMOTION)),
			  bit_or(bit_or(SDL_EVENTMASK(SDL_JOYHATMOTION), SDL_EVENTMASK(SDL_JOYBUTTONDOWN)), SDL_EVENTMASK(SDL_JOYBUTTONUP))
SDL_VIDEORESIZEMASK     = SDL_EVENTMASK(SDL_VIDEORESIZE)
SDL_VIDEOEXPOSEMASK     = SDL_EVENTMASK(SDL_VIDEOEXPOSE)
SDL_QUITMASK            = SDL_EVENTMASK(SDL_QUIT)
SDL_SYSWMEVENTMASK      = SDL_EVENTMASK(SDL_SYSWMEVENT)

SDL_ALLEVENTS = 0xFFFFFFFF --libLuaSDL.SDL_ALLEVENTS

SDL_ADDEVENT = libLuaSDL.SDL_ADDEVENT
SDL_PEEKEVENT = libLuaSDL.SDL_PEEKEVENT
SDL_GETEVENT  = libLuaSDL.SDL_GETEVENT

SDL_QUERY   =    libLuaSDL.SDL_QUERY
SDL_IGNORE  =    libLuaSDL.SDL_IGNORE
SDL_DISABLE =    libLuaSDL.SDL_DISABLE
SDL_ENABLE  =    libLuaSDL.SDL_ENABLE

SDL_ALPHA_OPAQUE = libLuaSDL.SDL_ALPHA_OPAQUE255
SDL_ALPHA_TRANSPARENT = libLuaSDL.SDL_ALPHA_TRANSPARENT

function SDL_Event_new()
   return libLuaSDL.SDL_Event_new()
end

function SDL_Event_delete(event)
   if event ~= nil then
      libLuaSDL.SDL_Event_delete(event)
   end
end

function SDL_ActiveEvent_new()
   return libLuaSDL.SDL_ActiveEvent_new()
end

function SDL_ActiveEvent_delete(event)
   if event ~= nil then
       libLuaSDL.SDL_ActiveEvent_delete(event)
   end
end

function SDL_KeyboardEvent_new()
   return libLuaSDL.SDL_KeyboardEvent_new()
end

function SDL_KeyboardEvent_delete(event)
    if event ~= nil then
       libLuaSDL. SDL_KeyboardEvent_delete(event)
    end
end

function SDL_MouseMotionEvent_new()
   return libLuaSDL.SDL_MouseMotionEvent_new()
end
function SDL_MouseMotionEvent_delete(event)
   if event ~= nil then
       libLuaSDL.SDL_MouseMotionEvent_delete(event)
   end
end

function SDL_MouseButtonEvent_new()
   return libLuaSDL.SDL_MouseButtonEvent_new()
end
function SDL_MouseButtonEvent_delete(event)
    if event ~= nil then
 	libLuaSDL.SDL_MouseButtonEvent_delete(event)
    end
end

function SDL_PumpEvents()
   libLuaSDL.SDL_PumpEvents()
end

function SDL_PeepEvents(events, numevents, action, mask)
   return libLuaSDL.SDL_PeepEvents(events, numevents, action, mask)
end

function SDL_PollEvent(event)
   return libLuaSDL.SDL_PollEvent(event)
end

function SDL_WaitEvent(event)
   return libLuaSDL.SDL_WaitEvent(event)
end

function SDL_PushEvent(event)
   return libLuaSDL.SDL_PushEvent(event)
end


--EventFilter Callback as string
function SDL_SetEventFilter(FilterEvents)
    FilterEvents = tostring(FilterEvents)
    if FilterEvents ~= nil then
		libLuaSDL.SetEventFilter(FilterEvents)
    else
		return
	end
end


function SDL_GetEventFilter()
   return libLuaSDL.SDL_GetEventFilter()
end

function SDL_EventState(type, state)
   return libLuaSDL.SDL_EventState(type, state)
end

