require('libLuaSDL')

require("SDL_error")
require("SDL_util")
require("SDL_events")
require("SDL_active")
require("SDL_audio")
require("SDL_version")
require("SDL_thread")
require("SDL_video")
require("SDL_rwops")
require("SDL_timer")
require("SDL_syswm")
require("SDL_endian")

SDL = {}

SDL_FALSE = libLuaSDL.SDL_FALSE
SDL_TRUE = libLuaSDL.SDL_TRUE

--[[
   These are the flags which may be passed to SDL_Init() -- you should
   specify the subsystems which you will be using in your application.
]]--
SDL_INIT_TIMER = libLuaSDL.SDL_INIT_TIMER
SDL_INIT_AUDIO = libLuaSDL.SDL_INIT_AUDIO
SDL_INIT_VIDEO = libLuaSDL.SDL_INIT_VIDEO
SDL_INIT_CDROM = libLuaSDL.SDL_INIT_CDROM
SDL_INIT_JOYSTICK = libLuaSDL.SDL_INIT_JOYSTICK
SDL_INIT_NOPARACHUTE = libLuaSDL.SDL_INIT_NOPARACHUTE
SDL_INIT_EVENTTHREAD = libLuaSDL.SDL_INIT_EVENTTHREAD
SDL_INIT_EVERYTHING = libLuaSDL.SDL_INIT_EVERYTHING

--[[
/* This function loads the SDL dynamically linked library and initializes
 * the subsystems specified by 'flags' (and those satisfying dependencies)
 * Unless the SDL_INIT_NOPARACHUTE flag is set, it will install cleanup
 * signal handlers for some commonly ignored fatal signals (like SIGSEGV)
 */
]]
function SDL_Init(flag)
  if(type(flag) == "number") then
     return libLuaSDL.SDL_Init(flag)
  end
     return (-1)
end

-- This function initializes specific SDL subsystems
function SDL_InitSubSystem(flag)
  if(type(flag) == "number") then
    return libLuaSDL.SDL_InitSubSystem(flag)
  end
    return (-1)
end

--This function cleans up specific SDL subsystems
function SDL_QuitSubSystem(flag)
  if(type(flag) == "number") then
    libLuaSDL.SDL_QuitSubSystem(flag)
  end
    return
end

--[[
-- This function returns mask of the specified subsystems which have
   been initialized.
   If 'flags' is 0, it returns a mask of all initialized subsystems.
]]
function SDL_WasInit(flag)
  if(type(flag) == "number") then
    return libLuaSDL.SDL_WasInit(flag)
  end
    return (-1)
end

--[[
 This function cleans up all initialized subsystems and unloads the
 dynamically linked library.  You should call it upon all exit conditions.
]]
function SDL_Quit()
  libLuaSDL.SDL_Quit()
end
