/**
 * @author Kime(hyejin33.kim@samsung.com)
 */
function USBLoader() {
    alert("[USBLoader.js] "+"USBLoader() start");

    this.init = function() {
        alert("[USBLoader.js] "+"init()");
        
        fs = new FileSystem();
		storagePlugin = $.sf.plugin("Storage");
    }();

    var UsbInfo = function (usbObjID) {
        this.deviceID = usbObjID;
        this.partitionNum=storagePlugin.GetUSBPartitionNum(usbObjID);
        this.mountPath=null;
        for(var idx=0; idx < this.partitionNum; idx++) {
            this.mountPath=storagePlugin.GetUSBMountPath(usbObjID,idx);
        }
    }

    getUSBDIR = function(deviceID) {
        
        var tmpObj = new UsbInfo(deviceID);
        return "/dtv/usb/" + tmpObj.mountPath; //"$usb_DIR/" + usbList[0].mountPath; //sda1
    }
    
	/**
	 * 해당 DeviceID에 대한 file의 filepath를 리턴
	 * @param {Object} deviceID
	 * @param {Object} filename
	 */
    this.getFilePath = function(deviceID, filename) {
        
        return getUSBDIR(deviceID)+"/"+filename;
    }    
    
	/**
	 * USB 에 해당 file이 있으면 file size 리턴한다. 없으면 -1(USB x), null(file x)
	 * @param {number} deviceID
	 * @param {string} filename
	 */
	this.isFileExisted = function(deviceID, filename) {
		alert("[USBLoader.js] isFileExisted("+deviceID+", "+filename+")");
        storagePlugin = $.sf.plugin("Storage"); // 얘 없음 USB 못찾음;;
        var size = storagePlugin.GetUSBListSize();  
        if (size == -1) 	// ERROR(-1) : usb가 꽂혀있지 않을 경우.
			return -1;
            
        if(deviceID == null) {
            deviceID = GetUSBDeviceID();
        }
 
        // find a file
        var usbDir = getUSBDIR(deviceID);
        var child = fs.readDir(usbDir);

        for (var i = 0; i < child.length; i++) {
        
            if (child[i].name == "." || child[i].name == "..") 
                continue;
        
            // 파일 찾음!!!!!!!!!!!!!
            if (child[i].name == filename) {
                alert("a '"+child[i].name+"' file is found!!");
                return (child[i].size); 
            }
        }
        return null;    // ERROR(-1) : usb가 꽂혀있지 않을 경우.
    }
    
	/**
	 * 모든 USB를 검색하여 해당 file이 있으면 file size 리턴한다. 없으면 -1(USB x), null(file x)
	 * @param {number} deviceID
	 * @param {string} filename
	 */
    this.isFileExistedToAllDevice = function(deviceID, filename) {
        
        var filesize = 0;
        var size = storagePlugin.GetUSBListSize();
        if (size == -1) 	// ERROR(-1) : usb가 꽂혀있지 않을 경우.
			return -1;
            
        for(var usbIdx=0; usbIdx<size; usbIdx++) {
            
            if(usbIdx != deviceID) {
            
                var tmpDevID = GetUSBDeviceID(usbIdx);
                filesize = isFileExisted(tmpDevID, filename);// find a file
                if(filesize > 0)
                    return {
                        deviceID:tmpDevID,
                        size:filesize
                    };
            }
        }
        return null;
    }

	/**
	 * get the ID number of the USB object
	 * @param {string|number|etc} param ; a file name or the number of USB
	 */
	this.GetUSBDeviceID = function(param) {
		alert("[USBLoader.js] GetUSBDeviceID("+param+")");

        var deviceID = null;
        
        var size = storagePlugin.GetUSBListSize();        
        if (size == -1) 	// ERROR(-1) : usb가 꽂혀있지 않을 경우.
			return -1;

        // find a USB device       
		if(typeof param == "string")
            deviceID = GetUSBDeviceIDToFile(size, param);
            
        else if(typeof param == "number")
            deviceID = GetUSBDeviceIDToNumber(size, param);
            
        else
            deviceID = GetUSBDeviceIDToNumber(size, 0);
        
        return deviceID; // null, [num]
	}
    
    
    /* 해당 파일명이 들어있는 USB 객체ID를 얻는다. */
    GetUSBDeviceIDToFile = function(size, filename) {
        alert("[USBLoader.js] GetUSBDeviceIDToFile("+size+", "+filename+")");
        
    for (var usbIdx = 0; usbIdx < size; usbIdx++) {

        var tmpdevID = parseInt(storagePlugin.GetUSBDeviceID(usbIdx), 10); // get the info Object of usb
        var tmpUSBObj = new UsbInfo(tmpdevID); // the unique ID on the USB
        var tmpPath = "/dtv/usb/" + tmpUSBObj.mountPath; // set the default-path
        
        var child = fs.readDir(tmpPath);// find a file
        
        for (var i = 0; i < child.length; i++) {
            if (child[i].name == "." || child[i].name == "..") 
                continue;
                
            if (child[i].name == filename)
                return tmpdevID;
        }
    }
        return null; // do not find
    }
    
    /* 해당 번호의 USB 객체ID를 얻는다. */
    GetUSBDeviceIDToNumber = function(size, theNumOfDev) {
        alert("[USBLoader.js] GetUSBDeviceIDToNumber("+size+", "+theNumOfDev+")");
        
        if(theNumOfDev < size) {
            var tmpdevID = parseInt(storagePlugin.GetUSBDeviceID(theNumOfDev), 10); // get the info Object of usb
            return tmpdevID;
        }
        return null;
    }
    
}