/**
 * @author Kime(hyejin33.kim@samsung.com)
 */
function SceneMain(options) {
	alert("SceneMain()");
	
    USB_DISCONNECT = 0;
    USB_NO_EXIST = -1;
    USB_NO_FILE = null;

	// Initialization
	$this = this;
	$EastEgg = "";
	UsbLoader = null;   // USB object
	deviceID = null;    // deviceID number
	curFocusPos = 0;    // focus number 
	pCallback = null;
    // timer
	pTimer = null;      
    gTimer = null;      
    gTimerFocus = null;
	// popup, smartTV icon is there/
	bPopup = false;     
    bSmartTV = false;
	bAnimateFocus = false;
	opacityCount = 0;
	opacityArray = new Array(".95", ".90", ".85", ".80", ".75", ".70", ".65", ".60", ".60", ".65", ".70", ".75", ".80", ".85", ".90", ".95", "1.", "1.", "1.", "1.");
	
	menuListPos = {};		// 스크린에 보일 메뉴의 left 픽셀값
	menuListIdxs = [];  	// 스크린에 보일 메뉴의 menuLists-index 저장
	menuLists = [{
		id:"SmartTV",
		title:"SmartTV.tp"
	},
	{
		id:"ThreeDSound",
		title:"3D_SxS_SmartTV.tp" //"3D_SxS_SmartTV.AVI"//"3D_SmartTV.tp"
	}, 
	{	
        id:"SmartHub", 
		title:"Hub_SmartTV.swf"
    }, 
	{	
        id:"SmartHub", 
		title:"Hub_SmartTV.mp4" //"Hub_SmartTV.tp"
    }, 
	{	
        id:"Design", 
		title:"Design_SmartTV.tp"
    }, 
	{	
        id:"AllShare", 
		title:"All_SmartTV.tp"
	}];
}


/**
 * initialize the scene and set the timeout
 */
SceneMain.prototype.initialize = function () {
	alert("SceneMain.initialize()");
	$this.showLoading(SID_RECEIVING_DATA);
    
	if (gTimer != null)
        clearTimeout(gTimer);
    gTimer = setTimeout("$this.searchingForUSBFile();", 500);
}

/**
 * get the usb devices and searching for the movie clips
 */
SceneMain.prototype.searchingForUSBFile = function () {

    alert("SceneMain() searchingForUSBFile()");
    $.sf.plugin('TVMW').SetWatchDog($.sf.define.PLR_TRUE);
    
    // USB 아직 미인식 상태에서 Timer 이상 시간 돌면 데드락상태에 빠지지 않도록 하기위해. 
    if (gTimer != null)
        clearTimeout(gTimer);
    gTimer = setTimeout("$this.handleError(USB_NO_FILE);", 29000);

    // USB 로더
    UsbLoader = new USBLoader();
    deviceID = UsbLoader.GetUSBDeviceID("SmartTV_Intro.tp"); // 파일이름("SmartTV_Intro.tp")/ null()
    if(deviceID == USB_NO_EXIST) 
        return $this.handleError(USB_NO_EXIST);
    if(deviceID == USB_NO_FILE) 
        return $this.handleError(USB_NO_FILE);
        
    for(var idx in menuLists) {
		var title = menuLists[idx].title;
		var size = UsbLoader.isFileExisted(deviceID, title);//var file = UsbLoader.getFilePath(title);
             
        // file exists.	
		if(size > 0) {
			menuListIdxs[menuListIdxs.length] = idx;
            if(idx == 0)
                bSmartTV = true;        
            continue;
        }
                    
        // (null)not find it.
        if(size == USB_NO_FILE)	
            continue;
            
        // (-1)check the USB and retry.
        if(size == USB_NO_EXIST)
            return $this.handleError(USB_NO_EXIST);
	}
       
    // 로딩창 꺼진다.
	$this.hideLoading();
    clearTimeout(gTimer);

	if (menuListIdxs.length == 0)
		return $this.handleError(USB_NO_FILE);// 어떤 파일도 발견 못했을 경우 리턴

	menuListPos = _g_left.init(menuListIdxs.length);// 각 메뉴별 left저장
	if(!menuListPos)
		return $this.handleError(USB_NO_EXIST);

    $this.displayScreen();
    $.sf.plugin('TVMW').SetWatchDog($.sf.define.PLR_FALSE);
}

/**
 * update the screen
 */
SceneMain.prototype.updateScreen = function(){
	alert("SceneMain.updateMainScreen()");
    
	// initialize
	bSmartTV = false;
	curFocusPos = 0;
	menuListIdxs = [];  // 스크린에 보일 메뉴의 menuLists-index 저장
	
	document.getElementById("SmartTV").style.top = "89px";
	for(var idx in menuLists) 
		document.getElementById(menuLists[idx].id).style.visibility = "hidden";
	document.getElementById("MainFocus").style.visibility = "hidden";
	document.getElementById("ArrowImg").style.visibility = "hidden";

	$this.initialize();
}

/**
 * draw the menu and image on the screen
 */
SceneMain.prototype.displayScreen = function(){
	
	document.getElementById("CloseBtn").style.visibility = "visible";
    for(var listIdx in menuListIdxs) 
	{
        var idx = menuListIdxs[listIdx];
		$("#"+menuLists[idx].id).css({
			left:menuListPos.left[listIdx], 
			top:menuListPos.top[listIdx],
			visibility: "visible"
		});
		
		if(idx == 1) { // 3D
			var areaCode = (new TVCommon()).GetTVAreaCode();
			var imgUrl = (areaCode == "EU")? "3d_eu":((areaCode == "CH")? "3d_china":"3d_global");
			document.getElementById("ThreeDSoundimg").style.backgroundImage = "url(images/"+imgUrl+".png)";
		}
	}
		
	if(bSmartTV) {
		if(menuListIdxs.length == 1) {
			document.getElementById("SmartTV").style.top = "239px";
		}
		else {
			document.getElementById("ArrowImg").style.visibility = "visible";
		}
	}	
	else {
		document.getElementById("SmartTV").style.visibility = "visible";
	}
	curFocusPos = 0;
	$this.drawFocus();
	clearTimeout(gTimerFocus);
	gTimerFocus = setTimeout("$this.preAnimateFocus()", 1000);
}

SceneMain.prototype.preAnimateFocus = function () {
	alert("SceneMain.preAnimateFocus()");
	
	bAnimateFocus = true;
	opacityCount = 0;
	clearTimeout(gTimerFocus);
	gTimerFocus = setTimeout("$this.onAnimateFocus()", 100);
}

/**
 * effect on an animation to the focus
 */
SceneMain.prototype.onAnimateFocus = function () {
	
	if(bAnimateFocus == false)
		return ;
	
	if(opacityCount > opacityArray.length)
		opacityCount = 0;

	var objectId = (menuListIdxs[curFocusPos]==0)? "SmartTVFocus" : ((curFocusPos==menuListIdxs.length)? "CloseBtnFocus":"MainFocus");
	$("#"+objectId).css({opacity: opacityArray[opacityCount]});
	opacityCount++;
	
	clearTimeout(gTimerFocus);
	gTimerFocus = setTimeout("$this.onAnimateFocus()", 100);
}

SceneMain.prototype.handleShow = function () {
	alert("SceneMain.handleShow()");
	// this function will be called when the scene manager show this scene
}

SceneMain.prototype.handleHide = function () {
	alert("SceneMain.handleHide()");
	// this function will be called when the scene manager hide this scene  
}

SceneMain.prototype.handleFocus = function () {
	alert("SceneMain.handleFocus()");
	// this function will be called when the scene manager focus this scene    
}

SceneMain.prototype.handleBlur = function () {
	alert("SceneMain.handleBlur()");
	// this function will be called when the scene manager move focus to another scene from this scene
}

/**
 * draw the focus image
 */
SceneMain.prototype.drawFocus = function () {
    
	bAnimateFocus = false;
	
	var closeBtnIdx = menuListIdxs.length;
	var smartFocusDiv = document.getElementById("SmartTVFocus");
	var mainFocusDiv = document.getElementById("MainFocus");
	var closeFocusDiv = document.getElementById("CloseBtnFocus");
	var curIdx = curFocusPos;
	
	if(menuListIdxs[curFocusPos] == 0) {	// to SmartTV Button
		closeFocusDiv.style.visibility = "hidden";
		mainFocusDiv.style.visibility = "hidden";
		smartFocusDiv.style.visibility = "visible";
		smartFocusDiv.style.opacity = 1;
	}
	else if(curFocusPos == closeBtnIdx){ 	// to Close Button
		smartFocusDiv.style.visibility = "hidden";
		mainFocusDiv.style.visibility = "hidden";
		closeFocusDiv.style.visibility = "visible";
		closeFocusDiv.style.opacity = 1;
	}
	else {
		closeFocusDiv.style.visibility = "hidden";
		smartFocusDiv.style.visibility = "hidden";
		mainFocusDiv.style.visibility = "visible";
		mainFocusDiv.style.left = (parseInt(menuListPos.left[curFocusPos],10)-144)+"px";
		mainFocusDiv.style.top = (parseInt(menuListPos.top[curFocusPos],10)+30)+"px";
		mainFocusDiv.style.opacity = 1;
	}
	clearTimeout(gTimerFocus);
	gTimerFocus = setTimeout("$this.preAnimateFocus()", 1000);
}

/**
 * handle a key event
 * @param {Object} keyCode  	key event number
 */
SceneMain.prototype.handleKeyDown = function (keyCode) {
	alert("SceneMain.handleKeyDown(" + keyCode + ")");
	// TODO : write an key event handler when this scene get focued

    var menuListsLen = menuListIdxs.length;
	switch (keyCode) {
    
        case $.sfKey.UP:   
			if(bPopup == true) break;
            if(bSmartTV) {         
                if (curFocusPos == 0) 
                    curFocusPos = menuListsLen; // to Close Button
                else if (curFocusPos > 0 && curFocusPos < menuListsLen)
                    curFocusPos = 0; 
            } else {   
                if (curFocusPos < menuListsLen)
                    curFocusPos = menuListsLen; // to Close Button "X"!!!!
            }
			$this.drawFocus();
            break;
			
        case $.sfKey.DOWN:   
			if(bPopup == true) break;
            if(bSmartTV) {      
                if (curFocusPos == 0)
                    curFocusPos = parseInt(menuListsLen/2, 10);
                else if (curFocusPos == menuListsLen)	// from Close Button
                    curFocusPos = 0; 
            } else { 
                if (curFocusPos == menuListsLen) 		// from Close Button
                    curFocusPos--; 
            }
			$this.drawFocus();
            break;

		case $.sfKey.LEFT:   
			if(bPopup == true) break;
            if(bSmartTV) {        
                if (curFocusPos == 0 && menuListsLen > 2)
                    curFocusPos = 1;
                else if (curFocusPos > 1 && curFocusPos < menuListsLen)
                    curFocusPos--; 
                else if (curFocusPos == menuListsLen)	// from Close Button
                    curFocusPos = 0;
            } 
            else {
                if (curFocusPos > 0 && curFocusPos < menuListsLen+1)
                    curFocusPos--; 
            }
			$this.drawFocus();
			break;
				
		case $.sfKey.RIGHT:  
			if(bPopup == true) break;
            if(curFocusPos != menuListsLen) {
                if(bSmartTV) {     
                    if (curFocusPos == 0 && menuListsLen > 2) {
                        curFocusPos = menuListsLen-1;
                    } 
                    else if (curFocusPos > 0 && curFocusPos < menuListsLen-1) {
                        curFocusPos++; 
                    }
                } else {
                    if (curFocusPos < menuListsLen-1)
                        curFocusPos++; 
                }
                $this.drawFocus();
			}
			break;


		// 동영상 재생
		case $.sfKey.ENTER: 
			if(bPopup == true) {
				$this.hideAlert();
				$.sf.returnFocus();
				if (typeof pCallback == 'function') {
					pCallback();
				}
				break;
			}
            if(curFocusPos == menuListsLen)
                return $.sf.exit(1);
						
            var index = menuListIdxs[curFocusPos];
            var title = menuLists[index].title;
			var size = UsbLoader.isFileExisted(deviceID, title);

            if(size == USB_NO_EXIST)	// -1
                return $this.handleError(USB_DISCONNECT);

            if(size == USB_NO_FILE)		// null // USB update
                $this.updateScreen();
			/*
	        if(size == USB_NO_FILE)		// null
	            return $this.handleError(USB_NO_FILE);
			*/
            if(size > 0) {
                var path = UsbLoader.getFilePath(deviceID, title);
				var player = new MediaPlay();
				player.play(path, title, size, deviceID);
			} 
			break;
            
        case $.sfKey.RETURN:// return, exit키 안먹히게
        case $.sfKey.EXIT:
            $.sfKey.block();
			break;
			
		case 17: $EastEgg += '0'; break;
		case 101: $EastEgg += '1'; break;
		case 10: $EastEgg += '6'; break;
		case 9: $EastEgg += '5'; break;
		case 13: $EastEgg += '8'; break;
		case 14: $EastEgg += '9'; break;
		case 98: $EastEgg += '2'; break;
		case 12: $EastEgg += '7'; 
			var i = $EastEgg.length;
			if($EastEgg.substring(i-11, i) == ("01067809627")) {
				$this.showAlert(USB_FIGHTING, "$.sf.exit");
			}
			break;
	}
}

/**
 * deal with an error situation and popup a alert window
 * @param {Object} Error 	error message
 */
SceneMain.prototype.handleError = function(Error) {
	alert("SceneMain.handleError()");
	
	var errMsg = null;
	var callbackfn = null;
	$this.hideLoading();
	menuListIdxs = [];
	
	switch(Error) {
		
		case USB_NO_EXIST:
			errMsg = TV_SID_MENU_FOR_STORE_DEMO_ONLY_MSG;
			callbackfn = $.sf.exit;
			break;
			
		case USB_DISCONNECT:
			errMsg = TV_SID_THE_USB_IS_DISCONNECTED;
			callbackfn = $.sf.exit;
			break;
		
		default: //(case USB_NO_FILE:)
			errMsg = TV_SID_NO_FILE_TO_PLAY;
			callbackfn = (menuListIdxs.length==0)? $.sf.exit:$this.updateScreen;
			break;
	}

	$this.showAlert(errMsg, callbackfn);
}


/**
 * show a Loading window
 * @param {Object} loadingtext 	the string of text on the window
 */
SceneMain.prototype.showLoading = function(loadingtext) {
	bPopup = true;
	$("#Loading-text").html(loadingtext);
	document.getElementById("Loading").style.visibility = "visible";
}

/**
 * hide a Loading window
 */
SceneMain.prototype.hideLoading = function() {
	bPopup = false;
	document.getElementById("Loading").style.visibility = "hidden";
}

/**
 * show a Alert window
 * @param {Object} alerttext 	the string of text on aa window
 * @param {Object} callback 	callback function after destroying the window
 */
SceneMain.prototype.showAlert = function(alerttext, callback) {
	alert("SceneMain.showAlert("+alerttext+")");
	bPopup = true;
	pCallback = callback;
	alert(pCallback);
	$("#AlertBox-text").html(alerttext);
	$("#AlertBox-button-text").html(SID_OK);
	document.getElementById("AlertBox").style.visibility = "visible";

	// timer
	clearTimeout(pTimer);
	pTimer = setTimeout(function(){
		$this.hideAlert();
		$.sf.returnFocus();
		if (typeof callback == 'function') {
			pCallback();
		}
	}, 10000);
}

/**
 * hide a Alert window
 */
SceneMain.prototype.hideAlert = function() {
	bPopup = false;
	document.getElementById("AlertBox").style.visibility = "hidden";
}

var _g_left = {
    /**
	 * initialize the positions of images according to the number of those
	 * @param {Object} num
	 */
	init: function(num){
		
		alert("SceneMain() _g_left.init("+num+")");

		var position = { // position[bSmartTV][num]["left"/"top"][0~num]
			"true":{
				1:{	
					left:[455],
					top:[89]
				},
				2:{
					left:[455, 820],
					top:[85, 720]
				},
				3:{
					left:[455, 589, 1031],
					top:[85, 720, 720]
				},
				4:{
					left:[455, 377, 820, 1263],
					top:[85, 720, 720, 720]
				},
				5:{
					left:[455, 146, 589, 1031, 1474],
					top:[85, 720, 720, 720, 720]
				}
			},
			"false":{
				1:{
					left:[820],
					top:[720]
				},
				2:{
					left:[589, 1031],
					top:[720, 720]
				},
				3:{
					left:[377, 820, 1263],
					top:[720, 720, 720]
				},
				4:{
					left:[146, 589, 1031, 1474],
					top:[720, 720, 720, 720]
				}
			}
		};

		if((num < 1) || ((bSmartTV==true)&&(num > 5)) ||((bSmartTV==false)&&(num > 4)))
			return null;

		return (position[bSmartTV][num]);
	}
}


