#!/bin/sh
##########################################################################
# HOTPLUG Script
# Only USB automount implement
# Auto Mount Program must be existing in both places which are BOOT partition and RFS
# Version 2.4    (2009-11-01) : suport umount, XFS mount flag modified
# Version 2.4.2 (2009-11-13) : Umont not support for internal HDD
# Version 2.4.4 (2009-11-26) : xfs repaire support when xfs mount failed
# Version 2.4.6 (2009-12-04) : unknown device support(for USB2.0 certification)
# Version 2.4.8 (2009-12-16) : exception handling add when detect invalid block or partitions in kernel 
# Version 2.5    (2009-12-22) : exception handling for mount error when device resource busy case
# Version 2.5.2 (2009-12-24) : default device name & vendor added
# Version 2.5.4 (2009-12-31) : device connection check at log creating time
# Version 2.6    (2010-07-17) : refactoring v1
# Version 2.7    (2010-09-30) : refactoring v2 & delete ext3 mount
# Version 2.8    (2010-11-18) : Emergency log support 
# Version 2.8.1 (2010-11-19) : Do not retry mount & recovery for the xfs filesystem
# Version 2.8.2 (2010-11-25) : 1. change recovery algorithm of crashed xfs, 2. compatible patch for MobiBlue
# Version 2.8.4 (2010-12-20) : emergency log delete.
# Version 2.9    (2010-12-23) : compatible patch for mount fail.
# Version 3.0.1 (2011-01-10) : stop cmd add (/sbin/usb_mount/usb_cmd stop_automount).
# Version 3.0.2 (2011-01-17) : rm mtd_rwarea path.
# Version 3.0.3 (2011-01-28) : disable xfs_repair.
###########################################################################
# Setting
# mounted directory : $MOUNTDIR/$PREFIX1 ~ $PREFIX$MAXNUM (ex /usb/usb1 ~ /usb/usb15)
ENABLE=1
DEBUG_MESSAGE=0
MOUNTBASEDIR=/dtv/usb
RFS_PROGRAMDIR=/sbin/usb_mount
MOUNTPROGRAM=usb_mount
CMDPROGRAM=usb_cmd
MOIPCMDPROGRAM=usb_moip_cmd
UNKNOWNDEVPROGRAM=unknownDev_cmd
LOCKFILE=$MOUNTBASEDIR/lock
DEBUG_MESSAGE_FILE=/dtv/usb_message
DEBUG_MODE_FILE=/dtv/debug_on

CHANGE_IOMODE=0
IOSCHEDULE_MODE=anticipatory
SCSIPATH=/sys/block
IO_MODE_FILE=/dtv/anticipatory_on

# Input argument
ACTION=$1
DEVPATH=$2
PRODUCT=$3
INTERFACE=$4
TYPE=$5

# Program Directory setting
PROGRAMDIR=$RFS_PROGRAMDIR

# Debug Mode setting
if [ -f $DEBUG_MODE_FILE ]; then
        DEBUG_MESSAGE=1
fi
# Mode setting for IO Scheduler with usb storage 
if [ -f $IO_MODE_FILE ]; then
        CHANGE_IOMODE=1
fi

if [ "$ENABLE" -eq 1 ]
then
# RUN
	CLASS=`echo $DEVPATH | sed 's/^\///g' | sed 's/\/.*//g'`

	if [ "$CLASS" = "block" ]
	then
		DEVICE=`echo $DEVPATH | sed 's/^\/[^\/]*\///g' | sed 's/\/.*//g'`
		PARTITION=`echo $DEVPATH | sed 's/^\/[^\/]*\///g' | sed 's/^[^\/]*\///g'`

		$PROGRAMDIR/$CMDPROGRAM $ACTION $DEVICE $PARTITION

		if [ $DEBUG_MESSAGE -eq 1 ]; then
			echo ">> MSC Hotplug Message : \"$ACTION\" \"$DEVPATH\" \"$PRODUCT\" \"$INTERFACE\" \"$TYPE\"" >> $DEBUG_MESSAGE_FILE
			echo ">> MSC Hotplug Message : $PROGRAMDIR/$CMDPROGRAM $ACTION $DEVICE $PARTITION" >> $DEBUG_MESSAGE_FILE
		fi				

		if [ ! -f $LOCKFILE ]; then
			mkdir -p $MOUNTBASEDIR
			touch $LOCKFILE
			$PROGRAMDIR/$MOUNTPROGRAM
		fi
		
		if [ $CHANGE_IOMODE -eq 1 ]; then
			echo $IOSCHEDULE_MODE > $SCSIPATH/$DEVICE/queue/scheduler
			if [ $DEBUG_MESSAGE -eq 1 ]; then
				echo ">> MSC Hotplug Message : set $IOSCHEDULE_MODE mode with $DEVICE" >> $DEBUG_MESSAGE_FILE
			fi
		fi
		
	else
		if [ $DEBUG_MESSAGE -eq 1 ]; then
			echo ">> Hotplug Message : \"$ACTION\" \"$DEVPATH\" \"$PRODUCT\" \"$INTERFACE\" \"$TYPE\"" >> $DEBUG_MESSAGE_FILE
		fi
		
		if [ "$ACTION" = "moip_add" ]; then
			if [ $DEBUG_MESSAGE -eq 1 ]; then
				echo ">> Hotplug Message : $PROGRAMDIR/$MOIPCMDPROGRAM $ACTION $DEVPATH" >> $DEBUG_MESSAGE_FILE
			fi
			PARTITION=$PRODUCT
			mkdir -p $MOUNTBASEDIR
			$PROGRAMDIR/$MOIPCMDPROGRAM $ACTION $DEVPATH $PARTITION
		elif [ "$ACTION" = "moip_remove" ]; then
			if [ $DEBUG_MESSAGE -eq 1 ]; then
				echo ">>Hotplug Message : $PROGRAMDIR/$MOIPCMDPROGRAM $ACTION $DEVICE" >> $DEBUG_MESSAGE_FILE
			fi
			mkdir -p $MOUNTBASEDIR
			$PROGRAMDIR/$MOIPCMDPROGRAM $ACTION $DEVPATH
		elif [ "$ACTION" = "unknown_dev_add" ]; then
			if [ $DEBUG_MESSAGE -eq 1 ]; then
				echo ">> Hotplug Message : $PROGRAMDIR/$UNKNOWNDEVPROGRAM $ACTION $DEVPATH" >> $DEBUG_MESSAGE_FILE
			fi
			PARTITION=$PRODUCT
			mkdir -p $MOUNTBASEDIR
			$PROGRAMDIR/$UNKNOWNDEVPROGRAM $ACTION $DEVPATH $PARTITION
		elif [ "$ACTION" = "unknown_dev_remove" ]; then
			if [ $DEBUG_MESSAGE -eq 1 ]; then
				echo ">> Hotplug Message : $PROGRAMDIR/$UNKNOWNDEVPROGRAM $ACTION $DEVPATH" >> $DEBUG_MESSAGE_FILE
			fi
			mkdir -p $MOUNTBASEDIR
			$PROGRAMDIR/$UNKNOWNDEVPROGRAM $ACTION $DEVPATH
		fi

	fi
fi
