#!/bin/sh

EXE_PATH=/mtd_swu/standalone
FLAG_PATH=/mtd_rwarea
EXE_STANDALONE=$EXE_PATH/StandAloneUpgrade

debug()
{
	echo "[USB Stand-alone upgrade] $1"
}

print_flags()
{
	echo "---- FLAG FILES:"
	if [ -f $FLAG_PATH/UPGRADE_START ]; then
		echo "UPGRADE_START-$(cat $FLAG_PATH/UPGRADE_START)"
	fi
	echo "$(ls $FLAG_PATH/UPGRADE_*)"
	echo "---- option: $1"
}

#for debug
print_flags

if [ -n "$1" ]; then
	case "$1" in
		"-rollback" | "-copyfail")
			if [ -e $FLAG_PATH/UPGRADE_ROLLBACK ]; then
				# run stand-alone upgrade rollback operation
				debug "rollback is starting"
				$EXE_STANDALONE -r
				RC=$?
				print_flags
				
				if [ $RC -ne 0 ]; then
					debug "rollback failure. error code=$RC --> reboot"
					exit 1
				else
					debug "rollback is done."
				fi
			fi

			if [ ! -e $FLAG_PATH/UPGRADE_FACTORY ]; then
				debug "delete $FLAG_PATH/UPGRADE_START"
				$EXE_STANDALONE -d $FLAG_PATH/UPGRADE_START
				sync
			fi
			;;
		"-reboot")
			debug "reboot system"
			$EXE_STANDALONE -x
			;;
		*)
			debug "undefined option in script: $1"
			exit 1
			;;
	esac
else
	SW_UPGRADE_OPERATION="$(cat $FLAG_PATH/UPGRADE_START)"

	case "$SW_UPGRADE_OPERATION" in
		"upgrade")
			debug "USB stand-alone upgrade is starting."
			$EXE_STANDALONE -u
			RC=$?
			print_flags
			;;
		"change partition")
			debug "changing partition is starting."
			$EXE_STANDALONE -c
			RC=$?
			print_flags
			;;
		*)
			debug "error: invalid text in UPGRADE_START=\"$SW_UPGRADE_OPERATION\""
			debug "delete $FLAG_PATH/UPGRADE_START"
			$EXE_STANDALONE -d $FLAG_PATH/UPGRADE_START
			sync
			debug "reboot!!!"
			exit 1
			;;
	esac

	if [ $RC -ne 0 ] || [ -e $FLAG_PATH/UPGRADE_FAIL ]; then
		debug "$SW_UPGRADE_OPERATION is faild. error_code=$RC"

		if [ -e $FLAG_PATH/UPGRADE_ROLLBACK ]; then
			debug "Rollback is needed. --> reboot"
			exit 1
		else
			if [ ! -e $FLAG_PATH/UPGRADE_FACTORY ]; then
				debug "delete $FLAG_PATH/UPGRADE_START"
				$EXE_STANDALONE -d $FLAG_PATH/UPGRADE_START
				sync
			fi
		fi
	else
		# successfully done
		debug "$SW_UPGRADE_OPERATION is done."

		debug "delete $FLAG_PATH/UPGRADE_START"
		$EXE_STANDALONE -d $FLAG_PATH/UPGRADE_START
		sync

		debug "successfully done. --> reboot"
	fi
fi

debug "END --> reboot"
exit 0

