require('libLuaSDL')

function SDL_putenv(variable)
   return libLuaSDL.SDL_putenv(variable)
end

function SDL_getenv(name)
   return libLuaSDL.SDL_getenv(name)
end

function bit_or(a, b)
   if type(a) == "number" and type(b) == "number" then
	return tonumber(libLuaSDL.bit_or(a, b))
   end
   return nil
end

function bit_and(a, b)
   if type(a) == "number" and type(b) == "number" then
        return tonumber(libLuaSDL.bit_and(a, b))
   end
   return nil
end

function bit_not(a, b)
   if type(a) == "number" then
        return tonumber(libLuaSDL.bit_not(a))
   end
   return nil
end

function bit_xor(a, b)
   if type(a) == "number" and type(b) == "number" then
        return tonumber(libLuaSDL.bit_xor(a, b))
   end
   return nil
end

function bit_lshift(a, shift)
   if type(a) == "number" and type(shift) == "number" then
        return tonumber(libLuaSDL.bit_lshift(a, shift))
   end
   return nil
end

function bit_rshift(a, shift)
   if type(a) == "number" and type(shift) == "number" then
        return tonumber(libLuaSDL.bit_rshift(a, shift))
   end
   return nil
end

--int array
function new_int(nelements)
   if type(nelements) == "number" then
      return libLuaSDL.new_int(nelements)
   end
   return nil
end

function delete_int(ary)
   libLuaSDL.delete_int(ary)
end

function int_getitem(ary, index)
   return libLuaSDL.int_getitem(ary, index)
end

function int_setitem(ary, index, value)
   libLuaSDL.int_setitem(ary, index, value)
end
--end int array

--Uint8 Array
function new_Uint8(nelements)
   return libLuaSDL.new_Uint8(nelements)
end

function delete_Uint8(ary)
   libLuaSDL.delete_Uint8(ary)
end

function Uint8_getitem(ary, index)
   return libLuaSDL.Uint8_getitem(ary, index)
end

function Uint8_setitem(ary, index, value)
   libLuaSDL.Uint8_setitem(ary, index, value)
end
--end Uint8 Array


--Unit16 Array
function new_Uint16(nelements)
   return libLuaSDL.new_Uint16(nelements)
end

function delete_Uint16(ary)
   libLuaSDL.delete_Uint16(ary)
end

function Uint16_getitem(ary, index)
   return libLuaSDL.Uint16_getitem(ary, index)
end

function Uint16_setitem(ary, index, value)
   libLuaSDL.Uint16_setitem(ary, index, value)
end
--end Unit16 Array

--Unit32 Array
function new_Uint32(nelements)
   return libLuaSDL.new_Uint32(nelements)
end

function delete_Uint32(ary)
   libLuaSDL.delete_Uint32(ary)
end

function Uint32_getitem(ary, index)
   return libLuaSDL.Uint32_getitem(ary, index)
end

function Uint32_setitem(ary, index, value)
   libLuaSDL.Uint32_setitem(ary, index, value)
end
--end Unit32 Array

--bool Array
function new_bool(nelements)
   return libLuaSDL.new_bool(nelements)
end

function delete_bool(ary)
   libLuaSDL.delete_bool(ary)
end

function bool_getitem(ary, index)
   return libLuaSDL.bool_getitem(ary, index)
end

function bool_setitem(ary, index, value)
   libLuaSDL.bool_setitem(ary, index, value)
end
--end bool Array

--Uint8 * (pointer)
function new_Uint8p()
   return libLuaSDL.new_Uint8p()
end

--[[
function copy_Uint8p(value)
   return libLuaSDL.copy_Uint8p(value)
end
]]

function delete_Uint8p(self)
   libLuaSDL.delete_Uint8p(self)
end

function Uint8p_assign(self, value)
   libLuaSDL.Uint8p_assign(self, value)
end

function Uint8p_value(self)
   return libLuaSDL.Uint8p_value(self)
end
--end Unit8*

--char*
function charp_value(self)
    return libLuaSDL.charp_value(self)
end
--end char*

--int*
function new_intp()
   return libLuaSDL.new_intp()
end

--[[
function copy_intp(value)
   return libLuaSDL.copy_intp(value)
end
]]

function delete_intp(self)
   libLuaSDL.delete_intp(self)
end

function intp_assign(self, value)
   libLuaSDL.intp_assign(self, value)
end

function intp_value(self)
   return libLuaSDL.intp_value(self)
end
--end int*

--Unit16*
function new_Uint16p()
   return libLuaSDL.new_Uint16p()
end

--[[
function copy_Uint16p(value)
   return libLuaSDL.copy_Uint16p(value)
end
]]

function delete_Uint16p(self)
   libLuaSDL.delete_Uint16p(self)
end

function Uint16p_assign(self, value)
   libLuaSDL.Uint16p_assign(self, value)
end

function Uint16p_value(self)
   return libLuaSDL.Uint16p_value(self)
end
--end Unit16*

--Unit32*
function new_Uint32p()
   return libLuaSDL.new_Uint32p()
end

--[[
function copy_Uint32p(value)
   return libLuaSDL.copy_Uint32p(value)
end
]]

function delete_Uint32p(self)
   libLuaSDL.delete_Uint32p(self)
end

function Uint32p_assign(self, value)
   libLuaSDL.Uint32p_assign(self, value)
end

function Uint32p_value(self)
   return libLuaSDL.Uint32p_value(self)
end
--end Unit32*

--char**
function new_chardp()
   return libLuaSDL.new_chardp()
end

--[[
function copy_chardp(value)
   return libLuaSDL.copy_chardp(value)
end
]]
function delete_chardp(self)
   return libLuaSDL.delete_chardp(self)
end

function chardp_assign(self, value)
   libLuaSDL.chardp_assign(self, value)
end

function chardp_value(self)
   return libLuaSDL.chardp_value(self)
end
--end char**

--Uint8**
function new_Uint8dp()
   return libLuaSDL.new_Uint8dp()
end

--[[
function copy_Uint8dp(value)
   return libLuaSDL.copy_Uint8dp(value)
end
]]

function delete_Uint8dp(self)
   return libLuaSDL.delete_Uint8dp(self)
end

function Uint8dp_assign(self, value)
   libLuaSDL.Uint8dp_assign(self, value)
end

function Uint8dp_value(self)
   return libLuaSDL.Uint8dp_value(self)
end
--end Uint8**

--double**
function new_ptrDouble()
   return libLuaSDL.new_ptrDouble()
end

--[[
function copy_ptrDouble(value)
   return libLuaSDL.copy_ptrDouble(value)
end
]]

function delete_ptrDouble(self)
   return libLuaSDL.delete_ptrDouble(self)
end

--[[
function ptrDouble_assign(self, value)
   libLuaSDL.ptrDouble_assign(self, value)
end

function ptrDouble_value(self)
   return libLuaSDL.ptrDouble_value(self)
end
]]
--end double**

function SDL_malloc(size)
   return libLuaSDL.SDL_malloc(size)
end

--~ function fopen(file, mode)
--~     return libLuaSDL.fopen(file, mode)
--~ end

--~ function fclose(file)
--~     return libLuaSDL.fclose(file)
--~ end

--~ function fread(ptr, size, nobj, file)
--~     return libLuaSDL.fread(ptr, size, nobj, file)
--~ end

--~ function fwrite(ptr, size, nobj, file)
--~     return libLuaSDL.fwrite(ptr, size, nobj, file)
--~ end

function Unit8_to_char(x)
   return libLuaSDL.Unit8_to_char(x)
end

function char_to_Uint8(x)
   return libLuaSDL.char_to_Uint8(x)
end

function Uint32_to_Uint16(x)
   return libLuaSDL.Uint32_to_Uint16(x)
end

function Uint16_to_Uint32(x)
   return libLuaSDL.Uint16_to_Uint32(x)
end

function Unit8p_to_charp(x)
   return libLuaSDL.Unit8p_to_charp(x)
end

function charp_to_Uint8p(x)
   return libLuaSDL.charp_to_Uint8p(x)
end

function charp_to_voidp(x)
   return libLuaSDL.charp_to_voidp(x)
end

function voidp_to_charp(x)
    return libLuaSDL.voidp_to_charp(x)
end

function voidp_to_Uint8p(x)
   return libLuaSDL.voidp_to_Uint8p(x)
end

function Uint8p_to_voidp(x)
    return libLuaSDL.Uint8p_to_voidp(x)
end

function float_to_int(x)
   return libLuaSDL.float_to_int(x)
end

function int_to_Uint8(x)
   return libLuaSDL.int_to_Uint8(x)
end

function Uint8_to_int(x)
   return libLuaSDL.Uint8_to_int(x)
end

function intp_to_Uint8p(x)
   return libLuaSDL.intp_to_Uint8p(x)
end

function voidp_to_Uint16p(x)
   return libLuaSDL.voidp_to_Uint16p(x)
end

function Uint16p_to_voidp(x)
   return libLuaSDL.Uint16p_to_voidp(x)
end

function voidp_to_Uint32p(x)
   return libLuaSDL.voidp_to_Uint32p(x)
end

function Uint32p_to_voidp(x)
   return libLuaSDL.Uint32p_to_voidp(x)
end

function voidp_to_intp(x)
   return libLuaSDL.voidp_to_intp(x)
end

function intp_to_voidp(x)
   return libLuaSDL.intp_to_voidp(x)
end

--[[
function boolp_to_voidp(x)
   return libLuaSDL.boolp_to_voidp(x)
end

function voidp_to_boolp(x)
   return libLuaSDL.voidp_to_boolp(x)
end
]]

--SDL_Rect Array
function new_SDL_RectAr(nelements)
	return libLuaSDL.new_SDL_RectAr(nelements)
end

function delete_SDL_RectAr(ary)
	libLuaSDL.delete_SDL_RectAr(ary)
end

function SDL_RectAr_getitem(ary, index)
    return libLuaSDL.SDL_RectAr_getitem(ary, index)
end

function SDL_RectAr_setitem(ary, index, value)
    libLuaSDL.SDL_RectAr_setitem(ary, index, value)
end

--SDL_Rect* Array
function SDL_RectpAr_getitem(ary, index)
    return libLuaSDL.SDL_RectpAr_getitem(ary, index)
end

function tovoid(typeName, sizei)
	return libLuaSDL.tovoid(typeName, sizei)
end

function deletemem(pdata)
	if pdata ~= nil then
		libLuaSDL.deletemem(pdata)
		pdata = nil
	end
end

function addToUserdata(stream, x)
	return libLuaSDL.addToUserdata(stream, x)
end

function addToUserdataUint32(data, x)
	return libLuaSDL.addToUserdataUint32(data, x)
end

--Added new Utility function
--SISC Add 10/07/2010
function SDL_free(mem)
	if mem ~= nil then
		libLuaSDL.SDL_free(mem)
		mem = nil
	end
end

function SDL_calloc(nmemb, isize)
	return libLuaSDL.SDL_calloc(nmemb, isize)
end

function SDL_realloc(nmemb, isize)
	return libLuaSDL.SDL_realloc(nmemb, isize)
end

function SDL_memset(dst, c, len)
	return libLuaSDL.SDL_memset(dst, c, len)
end

function SDL_memcpy(dst, src, len)
	return libLuaSDL.SDL_memcpy(dst, src, len)
end

--[[
function SDL_revcpy(dst, src, len)
	return libLuaSDL.SDL_revcpy(dst, src, len)
end
]]

function SDL_memmove(destination, source, num)
	return libLuaSDL.SDL_memmove(destination, source, num)
end

function SDL_memcmp(s1, s2, len)
	return libLuaSDL.SDL_memcmp(s1, s2, len)
end

function SDL_strlen(str)
	return libLuaSDL.SDL_strlen(str)
end

function SDL_strlcpy(dst, src, maxlen)
	return libLuaSDL.SDL_strlcpy(dst, src, maxlen)
end

function SDL_strlcat(dst, src, maxlen)
	return libLuaSDL.SDL_strlcat(dst, src, maxlen)
end

function SDL_strdup(str)
	return libLuaSDL.SDL_strdup(str)
end

function SDL_strrev(str)
	return libLuaSDL.SDL_strrev(str)
end

function SDL_strupr(str)
	return libLuaSDL.SDL_strupr(str)
end

function SDL_strlwr(str)
	return libLuaSDL.SDL_strlwr(str)
end

function SDL_strchr(str, c)
	return libLuaSDL.SDL_strchr(str, c)
end

function SDL_strrchr(str, c)
	return libLuaSDL.SDL_strrchr(str, c)
end

function SDL_strstr(haystack, needle)
	return libLuaSDL.SDL_strstr(haystack, needle)
end

function SDL_itoa(value, str, base)
	return libLuaSDL.SDL_itoa(value, str, base)
end

function SDL_ltoa(value, str, radix)
	return libLuaSDL.SDL_ltoa(value, str, radix)
end

function SDL_strcmp(str1, str2)
	return libLuaSDL.SDL_strcmp(str1, str2)
end

function SDL_strncmp(str1, str2, maxlen)
	return libLuaSDL.SDL_strncmp(str1, str2, maxlen)
end

function SDL_strcasecmp(str1, str2)
	return libLuaSDL.SDL_strcasecmp(str1, str2)
end

function SDL_strncasecmp(str1, str2, maxlen)
	return libLuaSDL.SDL_strncasecmp(str1, str2, maxlen)
end

function GetIndexColor(colors, idx)
	return libLuaSDL.GetIndexColor(colors, idx)
end

function SDL_memset4(dst, c, len)
	libLuaSDL.SDL_GLUE_memset4(dst, c, len)
end
