require('SDL_error')

SDL_TIMESLICE = libLuaSDL.SDL_TIMESLICE;
TIMER_RESOLUTION = libLuaSDL.TIMER_RESOLUTION;

--[[
  Get the number of milliseconds since the SDL library initialization.
  Note that this value wraps if the program runs for more than ~49 days.
]]
function SDL_GetTicks()
   local retTicks = libLuaSDL.SDL_GetTicks()
   if type(retTicks) == "number" then
      return (tonumber(retTicks))
   end 
   return nil
end

-- Wait a specified number of milliseconds before returning 
function SDL_Delay(ms)
   if type(ms) == "number" then
      libLuaSDL.SDL_Delay(ms)
   end
end

--callback function as string 
function SDL_SetTimer(interval, callback)
   callback = tostring(callback)
   return libLuaSDL.SetTimer(interval, callback)
end

--callback function as string
function SDL_AddTimer(interval, NewCallback, param)
	NewCallback = tostring(NewCallback)
	return libLuaSDL.AddTimer(interval, NewCallback, param)
end

function SDL_RemoveTimer(t)
   return libLuaSDL.SDL_RemoveTimer(t)
end

