require("SDL_error")
require("SDL_util")

function SDL_BUTTON(X)
   return bit_lshift(1, (X-1))
end

SDL_BUTTON_LEFT       = libLuaSDL.SDL_BUTTON_LEFT
SDL_BUTTON_MIDDLE     = libLuaSDL.SDL_BUTTON_MIDDLE
SDL_BUTTON_RIGHT      = libLuaSDL.SDL_BUTTON_RIGHT
SDL_BUTTON_WHEELUP    = libLuaSDL.SDL_BUTTON_WHEELUP
SDL_BUTTON_WHEELDOWN  = libLuaSDL.SDL_BUTTON_WHEELDOWN
SDL_BUTTON_X1         = libLuaSDL.SDL_BUTTON_X1
SDL_BUTTON_X2         = libLuaSDL.SDL_BUTTON_X2

SDL_BUTTON_LMASK   =     SDL_BUTTON(SDL_BUTTON_LEFT)
SDL_BUTTON_MMASK   =     SDL_BUTTON(SDL_BUTTON_MIDDLE)
SDL_BUTTON_RMASK   =     SDL_BUTTON(SDL_BUTTON_RIGHT)
SDL_BUTTON_X1MASK  =     SDL_BUTTON(SDL_BUTTON_X1)
SDL_BUTTON_X2MASK  =     SDL_BUTTON(SDL_BUTTON_X2)

function SDL_GetMouseState(x, y)
   return libLuaSDL.SDL_GetMouseState(x, y)
end

function SDL_GetRelativeMouseState(x, y)
   return libLuaSDL.SDL_GetRelativeMouseState(x, y)
end

function SDL_WarpMouse(x, y)
   libLuaSDL.SDL_WarpMouse(x, y)
end

function SDL_CreateCursor(data, mask, w, h, hot_x, hot_y)
   return libLuaSDL.SDL_CreateCursor(data, mask, w, h, hot_x, hot_y)
end

function SDL_SetCursor(cursor)
   libLuaSDL.SDL_SetCursor(cursor)
end

function SDL_GetCursor()
   return libLuaSDL.SDL_GetCursor()
end

function SDL_FreeCursor(cursor)
   libLuaSDL.SDL_FreeCursor(cursor)
end

function SDL_ShowCursor(toggle)
   return libLuaSDL.SDL_ShowCursor(toggle)
end

