require("SDL_rwops")


AUDIO_U8 = libLuaSDL.AUDIO_U8 --       0x0008  /* Unsigned 8-bit samples */
AUDIO_S8  = libLuaSDL.AUDIO_S8 --      0x8008  /* Signed 8-bit samples */
AUDIO_U16LSB = libLuaSDL.AUDIO_U16LSB   --0x0010  /* Unsigned 16-bit samples */
AUDIO_S16LSB = libLuaSDL.AUDIO_S16LSB   --   0x8010  /* Signed 16-bit samples */
AUDIO_U16MSB = libLuaSDL.AUDIO_U16MSB   --    0x1010  /* As above, but big-endian byte order */
AUDIO_S16MSB = libLuaSDL.AUDIO_S16MSB   --    0x9010  /* As above, but big-endian byte order */

AUDIO_U16 = libLuaSDL.AUDIO_U16LSB
AUDIO_S16 = libLuaSDL.AUDIO_S16LSB

AUDIO_U16SYS = libLuaSDL.AUDIO_U16MSB
AUDIO_S16SYS = libLuaSDL.AUDIO_S16MSB

SDL_MIX_MAXVOLUME = libLuaSDL.SDL_MIX_MAXVOLUME

SDL_AUDIO_STOPPED = libLuaSDL.SDL_AUDIO_STOPPED
SDL_AUDIO_PLAYING = libLuaSDL.SDL_AUDIO_PLAYING
SDL_AUDIO_PAUSED = libLuaSDL.SDL_AUDIO_PAUSED

function SDL_AudioSpec_new()
    return libLuaSDL.SDL_AudioSpec_new()
end

function SDL_AudioSpec_delete(audioSpec)
    if audioSpec ~= nil then
		libLuaSDL.SDL_AudioSpec_delete(audioSpec)
    end
end

function SDL_AudioCVT_new()
    return libLuaSDL.SDL_AudioCVT_new()
end

function SDL_AudioCVT_delete(audioCVT)
    if audioCVT ~= nil then
	libLuaSDL.SDL_AudioCVT_delete(audioCVT)
    end
end

function SDL_AudioInit(driver_name)
    return libLuaSDL.SDL_AudioInit(driver_name)
end

function SDL_AudioQuit()
   libLuaSDL.SDL_AudioQuit()
end

function SDL_AudioDriverName(namebuf, maxlen)
    return libLuaSDL.SDL_AudioDriverName(namebuf, maxlen)
end

function SDL_OpenAudio(desired, obtained)
   return libLuaSDL.SDL_OpenAudio(desired, obtained)
end

function SDL_GetAudioStatus()
   return libLuaSDL.SDL_GetAudioStatus()
end

function SDL_PauseAudio(pause_on)
    libLuaSDL.SDL_PauseAudio(pause_on)
end

--audio buffer is output parameter do not pass it
function SDL_LoadWAV_RW(src, freesrc, spec, audio_len)
   local audioSpec = nil
   local audio_buf = nil
   audioSpec, audio_buf = libLuaSDL.SDL_LoadWAV_RW(src, freesrc, spec, audio_len)
   return audioSpec, audio_buf
end

--audio buffer is output parameter do not pass it
function SDL_LoadWAV(file, spec, audio_len)
   local audioSpec = nil
   local audio_buf = nil
   audioSpec, audio_buf = libLuaSDL.SDL_LoadWAV(file, spec, audio_len)
   return audioSpec, audio_buf
end

function SDL_FreeWAV(audio_buf)
    libLuaSDL.SDL_FreeWAV(audio_buf)
end

function SDL_BuildAudioCVT(cvt, src_format, src_channels, src_rate, dst_format, dst_channels, dst_rate)
    return libLuaSDL.SDL_BuildAudioCVT(cvt, src_format, src_channels, src_rate, dst_format, dst_channels, dst_rate)
end

function SDL_ConvertAudio(cvt)
     return libLuaSDL.SDL_ConvertAudio(cvt)
end

function SDL_MixAudio(dst, src, len, volume)
    libLuaSDL.SDL_MixAudio(dst, src, len, volume)
end

function SDL_LockAudio()
    libLuaSDL.SDL_LockAudio()
end

function SDL_UnlockAudio()
    libLuaSDL.SDL_UnlockAudio()
end

function SDL_CloseAudio()
    libLuaSDL.SDL_CloseAudio()
end

function SDL_SetKeepAudioBuffer(percent)
    libLuaSDL.SDL_SetKeepAudioBuffer(percent)
end

function SDL_GetKeepAudioBuffer()
    return libLuaSDL.SDL_GetKeepAudioBuffer()
end