require("libLuaMUG")

--enum MUG_DeviceStatus
MUG_DEVICE_ONLINE = libLuaMUG.MUG_DEVICE_ONLINE          -- online but not connected
MUG_DEVICE_CONNECTED = libLuaMUG.MUG_DEVICE_CONNECTED	 --           // online and connected
MUG_DEVICE_LOST = libLuaMUG.MUG_DEVICE_LOST		 --           // not online
MUG_DEVICE_DISABLED = libLuaMUG.MUG_DEVICE_DISABLED

--enum MUG_SubSystem
MUG_SUB_DISCOVERY       = libLuaMUG.MUG_SUB_DISCOVERY
MUG_SUB_COMMAND         = libLuaMUG.MUG_SUB_COMMAND
MUG_SUB_DATA            = libLuaMUG.MUG_SUB_DATA
MUG_SUB_ASSET           = libLuaMUG.MUG_SUB_ASSET
MUG_SUB_ALL             = 0xFFFF

-- enum MUG_EventType
MUG_EVENT_ONDATA = libLuaMUG.MUG_EVENT_ONDATA
MUG_EVENT_COMMAND = libLuaMUG.MUG_EVENT_COMMAND
MUG_EVENT_DEVICE = libLuaMUG.MUG_EVENT_DEVICE
MUG_EVENT_SYSTEM = libLuaMUG.MUG_EVENT_SYSTEM

-- enum MUG_CommandEventType
MUG_CMD_ERROR = libLuaMUG.MUG_CMD_ERROR
MUG_CMD_INCOMING = libLuaMUG.MUG_CMD_INCOMING
MUG_CMD_REPLY = libLuaMUG.MUG_CMD_REPLY
MUG_CMD_MAX = libLuaMUG.MUG_CMD_MAX

-- enum MUG_DeviceEventType
MUG_DEV_FOUND = libLuaMUG.MUG_DEV_FOUND
MUG_DEV_JOIN = libLuaMUG.MUG_DEV_JOIN
MUG_DEV_LEFT = libLuaMUG.MUG_DEV_LEFT
MUG_DEV_LOST = libLuaMUG.MUG_DEV_LOST

--enum MUG_OnDataEventType
MUG_DATA_ONDATA = libLuaMUG.MUG_DATA_ONDATA
MUG_DATA_ERROR = libLuaMUG.MUG_DATA_ERROR

--   enum MUG_SystemEventType
MUG_SYS_STATUS = libLuaMUG.MUG_SYS_STATUS
MUG_SYS_ERROR = libLuaMUG.MUG_SYS_ERROR

function MUG_Init(flags)
   return libLuaMUG.MUG_Init(flags)
end
function MUG_Close(flags)
   return libLuaMUG.MUG_Close(flags)
end

function MUG_Is_Init(flags)
   return libLuaMUG.MUG_Is_Init(flags)
end

function MUG_GetInstanceId()
   return libLuaMUG.MUG_GetInstanceId()
end

function MUG_SetActiveGameName(name)
   return libLuaMUG.MUG_SetActiveGameName(name)
end

function MUG_SetTVName(name)
   return libLuaMUG.MUG_SetTVName(name)
end

function MUG_SendCommand(typie, message, targetID)
   return libLuaMUG.MUG_SendCommand(typie, message, targetID)
end

function MUG_SendCommandObject(command)
   return libLuaMUG.MUG_SendCommandObject(command)
end

function MUG_ReplyCommand(command, message)
   return libLuaMUG.MUG_ReplyCommand(command, message)
end

function MUG_SubscribeForCommand(typie)
   return libLuaMUG.MUG_SubscribeForCommand(typie)
end

function MUG_UnsubscribeForCommand(tid)
   libLuaMUG.MUG_UnsubscribeForCommand(tid)
end

function MUG_PollEvent()
   return libLuaMUG.MUG_PollEvent()
end
function MUG_SeekEvent(evtype)
   return libLuaMUG.MUG_SeekEvent(evtype)
end

--        enum MUG_NetType
MUG_NET_ETHN  = libLuaMUG.MUG_NET_ETHN
MUG_NET_WLAN = libLuaMUG.MUG_NET_WLAN
MUG_NET_UNAVIL = libLuaMUG.MUG_NET_UNAVIL

function MUG_NetIsAvail()
   return libLuaMUG.MUG_NetIsAvail()
end

function MUG_NetIsConnected()
   return libLuaMUG.MUG_NetIsConnected()
end

function MUG_NetIsReady()
  return libLuaMUG.MUG_NetIsReady()
end

--[[
function MUG_GetNetType(typie)
   libLuaMUG.MUG_GetNetType(typie)
end
]]
--API modified for Lua
function MUG_GetNetType()
   return libLuaMUG.GetNetType()
end


function MUG_SubscribeData(XPath, context)
   return libLuaMUG.MUG_SubscribeData(XPath, context)
end

function _MUG_UnsubscribeData(XPath)
   return libLuaMUG._MUG_UnsubscribeData(XPath)
end

function MUG_UnsubscribeData(tid)
   return libLuaMUG.MUG_UnsubscribeData(tid)
end

function MUG_SetData(XPath, data)
   return libLuaMUG.MUG_SetData(XPath, data)
end

function MUG_GetData(XPath, context)
   return libLuaMUG.MUG_GetData(XPath, context)
end

function MUG_PutData(XPath, data)
   return libLuaMUG.MUG_PutData(XPath, data)
end

function MUG_LoadStore(store, persist)
   return libLuaMUG.MUG_LoadStore(store, persist)
end

function MUG_UnloadStore(store)
   return libLuaMUG.MUG_UnloadStore(store)
end

function MUG_DisableDevice(devID)
   return libLuaMUG.MUG_DisableDevice(devID)
end

function MUG_EnableDevice(devID)
   return libLuaMUG.MUG_EnableDevice(devID)
end

function MUG_ForceRemoteGameEnd(devID)
   return libLuaMUG.MUG_ForceRemoteGameEnd(devID)
end

function MUG_GetDeviceData(devID, pData)
   return libLuaMUG.MUG_GetDeviceData(devID, pData)
end

function MUG_LoadAssetPackage(aAssetFile, aAssetDirectoryPath, aDefaultAsset)
   return libLuaMUG.MUG_LoadAssetPackage(aAssetFile, aAssetDirectoryPath, aDefaultAsset)
end

function MUG_UnloadAssetPackage(aAssetListName)
   return libLuaMUG.MUG_UnloadAssetPackage(aAssetListName)
end

function MUG_PushAsset(assetId, packageId, devID)
   return libLuaMUG.MUG_PushAsset(assetId, packageId, devID)
end

function dynamic_cast_to_DataEvent(pEvent)
   return libLuaMUG.dynamic_cast_to_DataEvent(pEvent)
end

function dynamic_cast_to_CommandEvent(pEvent)
   return libLuaMUG.dynamic_cast_to_CommandEvent(pEvent)
end

function dynamic_cast_to_DeviceEvent(pEvent)
   return libLuaMUG.dynamic_cast_to_DeviceEvent(pEvent)
end

function dynamic_cast_to_SystemEvent(pEvent)
    return libLuaMUG.dynamic_cast_to_SystemEvent(pEvent)
end

function GetCommndType(pEvent)
    return libLuaMUG.GetCommndType(pEvent)
end

--MUG_Device pointer new
function MUG_Device_new()
    return libLuaMUG.MUG_Device_new()
end

--MUG_Device pointer delete
function MUG_Device_delete(pdevice)
	if pdevice == nil then
		libLuaMUG.MUG_Device_delete(pdevice)
	end
end

