
//-------------------------------------------------------------------------

var DEBUG = 
{
    // THESE SHOULD ALL BE true IN THE REAL WORLD
    
    launch: true,
    gallery: true,
    hideUI: true,
    doFirst: true
};

//-------------------------------------------------------------------------

var Settings = 
{
    oobeWidgetId		: null,
    postWidgetId		: null,
    galleryInterval		: 0,
    secondGalleryInterval	: 0
};

//-------------------------------------------------------------------------

var UI = 
{
  enabled: true,
  text: null,
  spinner: null,
	lastShowText: null,
	lastShowArgs: null,
	
	prepare: function()
	{
	  function doubleDimensions( o )
	  {
	    for( var i = 0; i < o.length; i++ )
	    {
	      if ( o[ i ] )
	      {
	        o[i].hOffset *= 2;
	        o[i].vOffset *= 2;
	        
	        if ( "src" in o[i] )
	        {
	          o[i].src = o[i].src.replace( "960x540" , "1920x1080" );
	        }
	        else
	        {
	          o[i].width   *= 2;
	          o[i].height  *= 2;
	        }
	      }
	    }
	  }
	  
	  if ( screen.height == 1080 )
	  {
	    doubleDimensions( [ bsWindow , bsBackground , bsSpinnerFrame , bsProgressWell , 
	      bsProgressLeft , bsProgressRight , bsProgressMiddle , bsStatus , bsLogoYahoo ] );

	    bsStatus.style.fontSize = "40px";	     	      
	  }
	  
	  bsWindow.visible = true;
	},
	
	reShow: function()
	{
		if ( bsWindow.visible && this.lastShowText )
		{
	        var text = widget.getLocalizedString(this.lastShowText);
	        
	        if (this.lastShowArgs) 
	        {
	            for (var i = 0; i < this.lastShowArgs.length; i++) 
	                text = text.replace("%" + String(i), String(this.lastShowArgs[i]));
	        }
			
            bsStatus.text = text;
			
			updateNow();
		}
	},
    
    show: function(msg, args)
    {
		this.lastShowText = null;
		this.lastShowArgs = null;
		
        if (!this.enabled) 
            return;
        
        if (!this.spinner) 
        {
            // Spinner coordinates are screen coordinates
            
            this.spinner = new WaitIndicator();
            this.spinner.hOffset = bsWindow.hOffset + bsSpinnerFrame.hOffset;
            this.spinner.vOffset = bsWindow.vOffset + bsSpinnerFrame.vOffset;
            if ( screen.height == 1080 )
            {
              this.spinner.src = "1920x1080/spinner.mng";
              this.spinner.hOffset += 3;
              this.spinner.vOffset += 3;
            }
            else
            {
              this.spinner.src = "960x540/spinner.mng";
            }
            this.spinner.visible = true;
        }
        
        bsWindow.visible = true;
        bsWindow.focus();

        this.lastShowText = msg;
		this.lastShowArgs = args;
		
		this.reShow();		
    },
    
    hide: function()
    {
        if (!DEBUG.hideUI) 
            return;
        
        try 
        {
            if (this.spinner) 
            {
                this.spinner.visible = false;
                this.spinner = null;
            }
            
            bsWindow.visible = false;
        } 
        catch (e) 
        {
        }
    },
    
    focus: function()
    {
        if (!this.enabled) 
            return;
        
        bsWindow.focus();
    },
    
    attachKeyHandler: function(handler)
    {
        if (!this.enabled) 
            return;
        
        bsWindow.onKeyDown = handler;
    },
    
    hideSpinner: function()
    {
        if (!this.enabled) 
            return;
        
        try 
        {
            if (typeof bsSpinnerWell !== 'undefined') 
                bsSpinnerWell.visible = false;
            if (this.spinner) 
            {
                this.spinner.visible = false;
                this.spinner = null;
            }
        } 
        catch (e) 
        {
        }
        
        updateNow();
    },
    
    showProgress: function(current, total)
    {
        if (!this.enabled) 
            return;
        
        bsProgressWell.visible = true;
        
        bsProgressLeft.hOffset = bsProgressWell.hOffset + 1;
        bsProgressLeft.vOffset = bsProgressWell.vOffset + 1;
        bsProgressMiddle.vOffset = bsProgressWell.vOffset + 1;
        bsProgressRight.vOffset = bsProgressWell.vOffset + 1;
        
        
        var totalWidth = bsProgressWell.width - (bsProgressLeft.width + bsProgressRight.width) - 2;
        
        var percent = 1;
        
        if (total > 0) 
            percent = (current) / (total);
        
        var middles = percent * totalWidth;
        
        bsProgressRight.hOffset = bsProgressLeft.hOffset + bsProgressLeft.width + middles;
        
        bsProgressMiddle.hOffset = bsProgressLeft.hOffset + bsProgressLeft.width;
        bsProgressMiddle.width = middles;
        
        
        bsProgressLeft.visible = true;
        bsProgressMiddle.visible = true;
        bsProgressRight.visible = true;
        
        updateNow();
    },
    
    hideProgress: function()
    {
        if (!this.enabled) 
            return;
        
        bsProgressLeft.visible = false;
        bsProgressMiddle.visible = false;
        bsProgressRight.visible = false;
        bsProgressWell.visible = false;
        
        updateNow();
    },    
};

//-------------------------------------------------------------------------

var Boot = 
{
    firstRun: false,
    
    oobeCompleted: false,
    
    futureUpdate: false,
    
    isDev: false,
    
    childWidget: null,
    
    postWidget: null,
    
    inOOBE: false,
    
    inPost: false,
    
    OOBEHidden: false,
    
    galleryTimer: null,
	
    afterMenuLanguageChanged : null,
    
    self: null,
    
    builtinsOK: true,
    
    galleryErrors: [],

    lastTVState: null,
    
    shutdownTimer : null,
    
    offlineMode	 : false,
    
    installerSet : "",
	
	newEngineVersion : null,
    
    
    simulatedError: getenv("KF_BS_SIMULATE_ERROR"),
	
    TV_STATE_LOADING       : 0x100,
    TV_STATE_INSTALLING    : 0x200,
    TV_STATE_OOBE          : 0x001,
    TV_STATE_POST          : 0x001,
    TV_STATE_HIDE          : 0x081,
    
		contactOnStartUp: false,

		determineContactOnStartUp: function()
		{
			if( this.installerSet === "OFFLINE" )
			{
				this.contactOnStartUp = false;
			}
			else if( parseInt(configSetting.getValue("bootstrap.contact-on-startup")) === 1 )
			{
				this.contactOnStartUp = true;
			}
		},

    //---------------------------------------------------------------------
    // This determines if we are in a first run
    
    determineFirstRun: function()
    {
        // TODO : If the device ships with pre-installed widgets, we will
        //          need to ask a different question here. This checks
        //          the widget database.
        
        this.firstRun = (widgets.getInstalledWidgetCount() === 0);
        
        // This one tells us whether we have completed a first run
        // with success. 
        
        if (currentAppConfig.get("first-run-completed") !== "true") 
            this.firstRun = true;
        
        // Whether we finished with the OOBE
        
        this.oobeCompleted = (currentAppConfig.get("oobe-completed") === "true");
    },
    
    
    //---------------------------------------------------------------------
    // Load configurable stuff from config.xml
    
    loadSettings: function()
    {
        Settings.oobeWidgetId = configSetting.getValue("bootstrap.oobe-widget-id") || "";
        
        Settings.postWidgetId = configSetting.getValue("bootstrap.post-widget-id") || "";
        
        // Just so we don't get them confused later
        
        if (Settings.oobeWidgeId == Settings.postWidgetId) 
            Settings.oobeWidgetId = "";
        
        // How often to talk to the gallery
        
        try 
        {
            Settings.galleryInterval = parseInt(configSetting.getValue("bootstrap.gallery-interval-sec"));
            
            // We want to decrease the default 4 minute interval down to 2 minutes
            // without changing config.xml (and requiring a firmware update)
            
            if ( Settings.galleryInterval === 240 )
            {
                Settings.galleryInterval = 120;
            }
        } 
        catch (e) 
        {
            Settings.galleryInterval = 0;
        }

        try 
        {
            Settings.secondGalleryInterval = parseInt(configSetting.getValue("bootstrap.second-gallery-interval-sec"));
        } 
        catch (e) 
        {
            Settings.secondGalleryInterval = 0;
        }

    },
    
    //---------------------------------------------------------------------

    storeTVSystemInformation : function()
    {
        try
        {
            // If it is already populated, bail
            
            var oem = null;
            
            try
            {
                oem = tv.system.OEM;
            }
            catch( e )
            {
            }
            
            if ( ( oem !== "Toshiba" ) && ( yahooSettings.get( "countryCode" ) ) )
                return;
                
            var country = "US";
            
            try
            {
                country = tv.system.country;
                log( "COUNTRY FROM TV API IS " + country );
            }
            catch( e )
            {
                log( "FAILED TO GET COUNTRY FROM TV.SYSTEM.COUNTRY - DEFAULTING TO US" );
                country = "US";
            }
            
            yahooSettings.set( "countryCode" , country );
            specialSettings.set( "countryCode" , country );
        }
        catch( e )
        {
            log( "PROBLEM STORING TV SYSTEM INFORMATION : " + e.toString() );
        }   
    },    
    
    //---------------------------------------------------------------------
    
    determineOfflineMode : function()
    {
		// This comes from config.xml (but it can be set through FB)
		
		this.installerSet = configSetting.getValue( "bootstrap.installer-set" ) || "DEFAULT";
		
		this.offlineMode = this.installerSet === "OFFLINE";
		
		// Figure out the set of widgets we installed last time
		
		var previousInstallerSet = currentAppConfig.get( "installer-set" ) || "DEFAULT";
		
		log( "SHOULD BE OFFLINE =" , this.offlineMode , "INSTALLER SET =" , this.installerSet , "LAST INSTALLER SET =" , previousInstallerSet );
		
			
		if ( previousInstallerSet != this.installerSet )
		{
			log( "INSTALLER SET HAS CHANGED, SO WE WILL BE SWAPPING WIDGETS" );
			
			// The mode has changed, so we need to un-install all the widgets
			// from the old mode
			
			var installed = widgets.getAllWidgets();
			
			for( var i = 0; i < installed.length; ++i )
			{
			widgets.uninstallWidgetLater( installed[ i ].id );	
			}
			
			this.firstRun = true;

			currentAppConfig.delete("first-run-completed");
		}
		
		currentAppConfig.set( "installer-set" , this.installerSet );
    },
    
    //---------------------------------------------------------------------
	
	determineNewEngineVersion : function()
	{
		// Check to see if during this run we are using a new version of the
		// engine than the last time.
		
		var previousEngineVersion = currentAppConfig.get( "last-engine-version" );
		
		var currentEngineVersion = String( konfabulatorVersion() );
		
		log( "THIS ENGINE IS" , currentEngineVersion , "LAST ENGINE WAS" , previousEngineVersion );
				
		
		if ( currentEngineVersion !== previousEngineVersion )
		{
			// We store the new version in this.newEngineVersion - which is
			// otherwise null
			
			log( "DETECTED NEW ENGINE VERSION" );
			
			this.newEngineVersion = currentEngineVersion;
			
			// We save it regardless. I'm not sure whether it is a good idea to do
			// this here or not - simply because we'll have one shot at the new
			// version logic. If something goes wrong during this run, we won't
			// know that we have a new version in the next run.

			currentAppConfig.set( "last-engine-version" , currentEngineVersion );
		}
	},
	
	
    //---------------------------------------------------------------------
    
    restart : function()
    {
		// Note that this can't be called from a host event sent by a child
		// widget since they will be shutdown
		
		if ( this.childWidget )
		{
			this.childWidget.shutdown();
			this.childWidget = null;
		}
		
		if ( this.postWidget )
		{
			this.postWidget.shutdown();
			this.postWidget = null;
		}
		
		if ( this.galleryTimer )
		{
			this.galleryTimer.ticking = false;
			this.galleryTimer = null;
		}
		
		if ( this.shutdownTimer )
		{
			this.shutdownTimer.ticking = false;
			this.shutdownTimer = null;
		}
		
		this.firstRun = false;
		this.oobeCompleted = false;
		this.futureUpdate = false;
		this.isDev = false;
		this.inOOBE = false;
		this.OOBEHidden = false;
		this.inPost = false;
		this.afterMenuLanguageChanged = null;
		this.builtinsOK = true;
		this.galleryErrors = [];
		this.lastTVState = null;
		this.offlineMode = false;
		this.installerSet = "";
		this.newEngineVersion = null;
		
		this.start();
    },
    
    //---------------------------------------------------------------------
    // This moves all built-in widgets into pending installs and performs
    // an update from the gallery
    
    start: function()
    {
        log(" ")
        log("BOOTSTRAP");
        log("---------");
    
        self = this;
        
        UI.prepare();
        
        UI.show("loading");
		
        //.....................................................................
        // Let them know to turn off their loading indicator
        // We still need system.tvState for the TVs that do not support 
        // system.sendHostMessage. DO NOT DELETE THE ELSE BELOW. 
        // 

        if ( typeof system.sendHostMessage != "undefined" )
             system.sendHostMessage( System.TV_LOADING );
        else	 
             system.tvState = Boot.TV_STATE_LOADING;
        
	//.....................................................................

        this.loadSettings();
        
        this.determineFirstRun();

        this.storeTVSystemInformation();
		
        widget.onVisibilityChanged = self.onVisibilityChanged;
		
		this.determineOfflineMode();
		
        this.determineContactOnStartUp();
        
		this.determineNewEngineVersion();
                                    
        if (this.firstRun || this.newEngineVersion ) 
        {
			if ( this.firstRun )
			{
				log("THIS IS A FIRST RUN");
			}

            //.................................................................
            // Tell them that we are installing
            // We still need system.tvState for the TVs that do not support 
            // system.sendHostMessage. DO NOT DELETE THE ELSE BELOW. 
            // 
           if ( typeof system.sendHostMessage != "undefined" )
                system.sendHostMessage( System.TV_INSTALLING );
           else			
                system.tvState = Boot.TV_STATE_INSTALLING;
			            
            //.................................................................

            // Show the UI	 	    
            
            UI.show("installing_builtin_widgets");
            
            // Now, install all built-in widgets (those that were shipped with the device)
            // They are not actually installed right here - they are marked for installation
            
            if ( this.installerSet === "" || this.installerSet === "DEFAULT" )
            {
                self.builtinsOK = widgets.installBuiltInWidgets( );
            }
            else
            {            
                self.builtinsOK = widgets.installBuiltInWidgets( this.installerSet );
            }
            
            if (!self.builtinsOK) 
            {
                // Instead of halting here, we are going to let it go...maybe when we talk to
                // the gallery the problem will go away.
            
                // The worst thing that could happen here is that something that was shipped
                // with the device is not queued up for installation - something critical 
                // like the OOBE. If that's the case, we may get a new OOBE in the gallery step
                // or not...
                /*
                 UI.show("There was a problem installing built-in widgets. This is bad.");
                 UI.hideSpinner();
                 return;
                 */
                
            }
            
            //*********************************************************
            // THIS ONLY TAKES EFFECT ON DEV SYSTEMS 
            // When no widgets have been installed and it is a first run.
            // It only looks for directory widgets.
            //*********************************************************
            
            if (!_PRODUCTION) 
            {
                if (widgets.getPendingInstallCount() == 0 &&
                widgets.getInstalledWidgetCount() == 0 &&
                Settings.galleryInterval == 0) 
                {
                    try 
                    {
                        widgets.updateDatabase();
                        
                        this.isDev = true;
                    } 
                    catch (e) 
                    {
                    }
                }
            }
            //*********************************************************
            
            // Get updates from the gallery	    
            
            if (DEBUG.doFirst && Settings.galleryInterval && ! this.offlineMode ) 
            {
				if ( this.newEngineVersion && ! this.firstRun )
				{
					// This setting determines the last time we talked to the gallery
					// If it is set, we pass it to the gallery and it
					// is free to dismiss our call as being too recent.
					// By deleting the stored value, we don't pass the parameter
					// to the gallery therefore "forcing" it to respond.
					
					currentAppConfig.delete( "last-gallery-time" );
				}
				
                this.downloadUpdatesFromGallery( this.firstRun , this.performPendingInstalls );
            }
            else 
            {
                this.performPendingInstalls();
            }
        }
				else if( this.contactOnStartUp )
				{
					this.downloadUpdatesFromGallery( this.firstRun , this.performPendingInstalls );
				}
        else 
        {
			this.performPendingInstalls();
        }
    },
    
    keyDown: function(event)
    {
        log("BOOTSTRAP GOT KEY DOWN EVENT : " + event.keyCode);
        
        if (!self.oobeCompleted && !self.inOOBE && (event.keyCode == 403 || event.keyCode == 36 || event.keyCode == 112 || event.keyCode == 462 )) 
        {
            // AN June 5 2009
            // Commented out the UI.show and self.loadOOBE lines below
            // Added widget.visible = true
            // This fix was required for the following scenario
            // Bring up OOBE. Select 'Exit Setup'. Press Widget to show OOBE again.
            // Run through OOBE. The dock does not show up. The 'Loading' message would also not show up.
	    widget.visible = true;
            //UI.show("loading");
            //self.loadOOBE("start");
        }
    },
    
    onVisibilityChanged: function(event)
    {
        // Fires when the widget becomes visible
        
        log("VISIBILITY CHANGED : " + widget.visible);

        
        if (!widget.visible) 
        {
            if (self.inPost && self.postWidget )
            {
				self.postWidget.dispatchHostEvent("hide-all", "");
            }
        }
        else 
        {
			if (self.afterMenuLanguageChanged)
			{
				self.attachOnMenuLanguageChanged( null );        
				
				var what = self.afterMenuLanguageChanged;
				
                self.afterMenuLanguageChanged = null;
				
				widget.dropLocalizedStrings();
				
                if (what === "post" )  
                {
                    UI.show("loading");
					self.loadPostWidget();
				}                
				else if (what === "child" )
				{
					UI.show("loading");
					self.loadOOBE("start");
				} 
				else
				{
				    UI.reShow();	
				}
			}
			else if (self.inPost && self.postWidget )
            {
				self.postWidget.dispatchHostEvent("show-dock", "");
            }
            else if (self.OOBEHidden) 
            {
                UI.show("loading");
                self.loadOOBE("start");
            }
		}
    },

    // Fires when the menu language is changed on the TV
		
    onMenuLanguageChanged: function()
    {
       log( "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tMENU LANGUAGE CHANGED : " + tv.system.menuLanguage );
       
       // We hide ourselves - this will let us become visible when the
       // user is finished changing the menu language.
        
       if (widget.visible)
           widget.visible = false;      
	   
	   
	   if (self.postWidget)
	   {
           if (!self.afterMenuLanguageChanged )
	           self.afterMenuLanguageChanged = "post";
		   
           UI.show("loading");

		   self.postWidget.shutdown();
		   
		   self.postWidget = null;	
		   
	   }
	   
	   if (self.childWidget)
	   {
	   	   if (!self.afterMenuLanguageChanged )
	           self.afterMenuLanguageChanged = "child";
		   
           UI.show("loading");

		   self.childWidget.shutdown();
		   
		   self.childWidget = null;	
	   }
	   
       if (!self.afterMenuLanguageChanged )
           self.afterMenuLanguageChanged = "me";


       log( "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAMLC = " + self.afterMenuLanguageChanged ); 
	   
	   // Set the new language
	   
	   system.locale = tv.system.menuLanguage;
	  
    },
	
    
    downloadUpdatesFromGallery: function(firstOne, a_callback)
    {
        UI.show("searching");
        
        // Let's talk to the gallery
        
        self.galleryErrors = [];
        
        // get the list of required updates
        // download all those updates
        // set them up as pending installs using 'widgets.installWidgetLater( widgetID , localURI , md5 )'
        
        if (DEBUG.gallery) 
        {
            GalleryUpdate.getWidgetUpdates(firstOne, 
            {
                onError: function(galleryError, widgetID, updateType)
                {
                    // This is what happens when a gallery update has a problem
                    // Some of the errors are hard errors - some are related to
                    // individual updates.
                    
                    // We just collect the errors here and wait for the whole gallery 
                    // process to be done.                     
                    
                    galleryError.widgetID = widgetID ? widgetID : null;
                    galleryError.updateType = updateType ? updateType : null;
                    
                    self.galleryErrors.push(galleryError);
                },
                
                onFinished: function()
                {
                    log(" ");
                    
                    if (self.galleryErrors.length == 0) 
                    {
                        log("FINISHED WITH GALLERY");
                    }
                    else 
                    {
                        log("FINISHED WITH GALLERY BUT THERE WERE ERRORS:");
                        
                        for (var i = 0; i < self.galleryErrors.length; i++) 
                        {
                            var ge = self.galleryErrors[i];
                            
                            log("\t" + (ge.updateType ? "(" + ge.updateType + ") " : "") + (ge.widgetID ? ge.widgetID + " : " : "") + ge.toString());
                        }
                    }
                    
                    log(" ");
                    
                    UI.hideProgress();
                    
                    a_callback();
                },
                
                onProgress: function(type, current, total)
                {
                    UI.show("gallery_update", [String(current < total ? current + 1 : current), String(total)]);
                    
                    UI.showProgress(current, total);
                }
            });
        }
        else 
        {
            a_callback();
        }
    },
    
    pendingProgress: function(current, total)
    {
        // Error simulation
        
        if (!_PRODUCTION && self.simulatedError && current < total) 
        {
            for (var p in Widgets) 
            {
                if (p == self.simulatedError) 
                {
                    current = -1;
                    total = Widgets[p];
                    break;
                }
            }
        }
        
        
        if (current === -1) 
        {
            // This is very ugly, but if current === -1 here, then this is an error signal
            // and total is the error code
            
            var errorCode = total;
            
            var errorName = errorCode;
            
            // Match the integer to its property name in the Widgets constants
            
            for (var p in Widgets) 
            {
                if (Widgets[p] === errorCode) 
                {
                    errorName = p;
                    break;
                }
            }
            
            log("PENDING INSTALL ERROR : " + errorName);
            
            // If we return false, the whole pending update process will grind to
            // a halt, so we must be very careful.
            
            var result = true;
            
            // If it is not a first run, we ignore errors. I believe this is better for
            // the user - he/she will at least be able to use the device. 
            
            // If this is a first run, any error will screw us up. We don't know what 
            // state we are in. In theory, we could check to see if bare minimum widgets
            // are installed ok. 
            
            if (self.firstRun) 
            {
                var message = null;
                var args = null;
                
                switch (errorCode)
                {
                    case Widgets.INSTALL_NOT_ENOUGH_SPACE:
                        
                        result = false;
                        message = "no_space";
                        break;
                }
                
                if (!result) 
                {
                    // Make sure there is at least a generic message
                    
                    if (message == null) 
                    {
                        message = "initial_failed";
                        args = [errorName];
                    }
                    
                    UI.hideProgress();
                    UI.show(message, args);
                }
            }
            
            // Since we are calling it quits, let's stop spinning
            
            if (!result) 
                UI.hideSpinner();
            
            return result;
        }
        else 
        {
            // It is a real progress update
            
            if (current < total) 
            {
                UI.show("installing_update", [String(current + 1), String(total)]);
                
                UI.showProgress(current, total);
            }
            else 
            {
                // We are done
                
                UI.showProgress(1, 1);
                
                UI.hideProgress();
                
                self.finish();
            }
            
            return true;
        }
    },
    
    performPendingInstalls: function()
    {
        // This one gets called back by the gallery code, so "this" may not be this.
        
        if (self.firstRun || self.newEngineVersion ) 
        {
            // We are going to take a look at the gallery errors. If any of them
            // are "serious" enough, we will rollback the pending install list
            // to its original state before we called the gallery. This means
            // that we will only install stuff that came with the device.
            //
            // This prevents us from possibly installing stuff that is incompatible.
            
            if (self.galleryErrors.length > 0) 
            {
                log("THERE WERE SOME GALLERY ERRORS");
                
                var rollback = false;
                
                for (var i = 0; i < self.galleryErrors.length && !rollback; i++) 
                {
                    switch (self.galleryErrors[i].updateType)
                    {
                        case GalleryUpdate.WIDGET_TYPE_TV_PACKAGE:
                        case GalleryUpdate.WIDGET_TYPE_TV_SYSTEMWIDGET:
                            rollback = true;
                            break;
                    }
                }
                
                if (rollback) 
                {
                    try 
                    {
                        log("ROLLING BACK TO BUILT-IN PENDING INSTALLS");
                        
                        widgets.restoreBuiltinPendingInstalls();
                        
                        // This will get rid of anything the gallery may have downloaded
                        
                        GalleryUpdate.deleteOldJobs();
                    } 
                    catch (e) 
                    {
                        log("FAILED TO ROLLBACK : " + e.toString());
                    }
                }
                
                // We're done with the gallery errors
                
                self.galleryErrors = [];
            }
        }
        
        var pendingInstallCount = widgets.getPendingInstallCount();
        
        log("THERE ARE " + String(pendingInstallCount) + " PENDING INSTALLS");
        
        if (pendingInstallCount > 0) 
        {
            // We still need system.tvState for the TVs that do not support 
            // system.sendHostMessage. DO NOT DELETE THE ELSE BELOW. 
            // 
            if ( typeof system.sendHostMessage != "undefined" )
                system.sendHostMessage( System.TV_INSTALLING )
            else
                system.tvState = Boot.TV_STATE_INSTALLING;

            UI.show("installing_updates");
            
            // This one is asynchronous - we'll deal with errors and completion
            // in the pendingProgress callback.
            
            widgets.performPendingInstalls(self.pendingProgress);
        }
        else 
        {
            self.finish();
        }
    },
    
    checkWidgetID: function(widgetID)
    {
        var result = widgets.isWidgetInstalled(widgetID);
        
        if (!result) 
        {
            log("WE NEED TO LAUNCH " + widgetID + " AND IT IS NOT INSTALLED");
            
            UI.hideProgress();
            UI.show("failed_to_launch", [widgetID]);
            UI.hideSpinner();
        }
        
        return result;
    },
    
    finish: function()
    {
        // We need to signal that we finished our first run
        
        currentAppConfig.set("first-run-completed", "true");
        
        // Deal with the profile default widgets list 
        
        if (self.firstRun) 
        {
            log("RESETTING WIDGETS IN CURRENT PROFILE");
            
            if (!self.isDev) 
            {
                // Everything that we have just installed will now 
                // become a default widget. The engine will ensure that
                // any "undesirable" widgets are filtered out.
                
                var installedWidgets = widgets.getAllWidgets();
                
                var defaultWidgets = [];
                
                for (var i = 0; i < installedWidgets.length; i++) 
                    defaultWidgets.push(installedWidgets[i].id);
                
                widgets.setProfileDefaultWidgets(true, defaultWidgets);
            }
            
            // And now, we ensure that all of those widgets are
            // present in the current profile.
            
            widgets.resetWidgetsInProfile(profile.getCurrentProfile().id);
        }
        else if ( self.newEngineVersion )
        {
            // If this is a firmware update, we need to check for newly installed
            // widgets that should be forcibly added to all profiles.
            try
            {
                var wids = configSetting.getValue( "bootstrap.firmware-update-add-to-all-profiles" );
                            
                if ( wids )
                {
                    wids = wids.split( "," );
                    
                    var profiles = profile.getIDs();
                    
                    for( var i = 0; i < wids.length; ++i )
                    {
                        var wid = wids[ i ];
                        
                        if ( widgets.isWidgetInstalled( wid ) )
                        {
                            log( "ADDING" , wid , "TO ALL PROFILES" );
                            
                            for( var j = 0; j < profiles.length; ++j )
                            {
                                widgets.addWidgetToProfile( wid , profiles[ j ] );
                            }
                        }
                    }
                }
            }
            catch( e )
            {
                log( "EXCEPTION WHILE TRYING TO ADD WIDGETS TO PROFILES :" , e.toString() );
            }
        }
        
        
        log("ALL DONE");
        log("---------");
        log(" ");

        
        //---------------------------------------------------------
        // Launch another widget
        
        if (DEBUG.launch) 
        {
            widget.onChildEvent = self.onChildWidgetEvent;
            
            // Under these conditions, we launch the OOBE
            
            if ( ( ! self.offlineMode ) && ( self.firstRun || ! self.oobeCompleted ) && ( Settings.oobeWidgetId != "" ) ) 
            {
                log("LOADING OOBE [" + Settings.oobeWidgetId + "]");
                
                UI.show("loading");
                
                if (!self.checkWidgetID(Settings.oobeWidgetId)) 
                    return;
                
                self.loadOOBE("start");
            }
            
            // Otherwise, we launch the "post" widget
            
            else 
            {
                self.loadPostWidget();
            }
        }
        else 
        {
            UI.hide();
        }
    },
    
    loadOOBE: function(message)
    {
        self.inOOBE = true;
        self.OOBEHidden = false;
        UI.attachKeyHandler(null);
        
        if (!self.childWidget) 
        {
            self.childWidget = new HostedWidget();
            
            self.childWidget.onWidgetLoaded = function()
            {
                log("FINISHED LOADING OOBE");
                
 		if ( typeof system.sendHostMessage != "undefined" )
             		system.sendHostMessage( System.TV_OOBE_WIDGET );

                system.tvState = Boot.TV_STATE_OOBE;
                
                self.childWidget.dispatchHostEvent(message, "");
                
                UI.hide();
				
                self.attachOnMenuLanguageChanged( self.onMenuLanguageChanged );            
            };
            
            self.childWidget.src = Settings.oobeWidgetId;
        }
        else 
        {

            if ( typeof system.sendHostMessage != "undefined" )
            	system.sendHostMessage( System.TV_OOBE_WIDGET );

            system.tvState = Boot.TV_STATE_OOBE;
            
            self.childWidget.dispatchHostEvent(message, "");
            
            UI.hide();
        }
    },
	
	attachOnMenuLanguageChanged : function( callback )
	{
        
        if (typeof tv === "undefined" || !("system" in tv)) 
        {
            log("TV SYSTEM DOES NOT EXIST - WILL NOT HANDLE MENU LANGUAGE CHANGES");
        }
        else 
        {
            tv.system.onMenuLanguageChanged = callback;
        }
	},
    
    loadPostWidget: function( callback )
    {
        // Show something while we load the post widget
        
        UI.show("loading");
        
        if (!self.checkWidgetID(Settings.postWidgetId)) 
            return;
        
        self.postWidget = new HostedWidget();
        
        self.postWidget.onWidgetLoaded = function()
        {
            log("FINISHED LOADING POST WIDGET");
            
            if ( typeof system.sendHostMessage != "undefined" )
            	system.sendHostMessage( System.TV_POST_WIDGET );

            system.tvState = Boot.TV_STATE_POST;

			// If we are not visible, we tell the post widget to hide itself
			// too - that way when it comes back, it does it all nice and
			// pretty-like with welcome screens and animations
			
            if ( ! widget.visible )                                
            {                                                      
                self.postWidget.dispatchHostEvent("hide-all", ""); 
            }                                       
                
            UI.hide();
            
            // After the dock is loaded, we kick off a timer
            // to do gallery updates
            
            self.startFutureGalleryUpdate();
            
            self.inPost = true;
            
			if (callback)
			    callback();

            self.attachOnMenuLanguageChanged( self.onMenuLanguageChanged );        
        };
        
        self.postWidget.src = Settings.postWidgetId;		
    },
    
    shutdownChildWidget : function( now )
    {
	   	if ( ! self.childWidget )
	   		return;
    	
    	if ( ! now )
    	{
    		if ( self.shutdownTimer )
    			return;
    			
			self.shutdownTimer = new Timer( );
			self.shutdownTimer.interval = 0.01;
			self.shutdownTimer.onTimerFired = function( ) 
				{ 
					self.shutdownChildWidget( true ); 
					self.shutdownTimer.ticking = false;
					self.shutdownTimer = null;
				};
			self.shutdownTimer.ticking = true; 
		}
		else
		{
    		self.childWidget.shutdown();
    		self.childWidget = null;
    	}
    },
	
    onChildWidgetEvent: function(event)
    {
        log("GOT CHILD WIDGET EVENT : " + event.subject + " FROM " + event.id);
        
        // It came from the OOBE
        
        if (event.id == Settings.oobeWidgetId) 
        {
            // The OOBE is finished, let's launch post widget
            
            if (event.subject == "done") 
            {
                // The OOBE lets us know if TOS and privacy were accepted
                
                log("OOBE RETURNED : " + event.data);
                
                self.inOOBE = false;
                
                self.OOBEHidden = false;
                
				UI.attachKeyHandler(null);
				
                var result = JSON.parse(event.data);
                
                // if "replay" is TRUE, this is the end of a guided setup
                
                if (result.replay) 
                {
                    // We tell the post widget to show itself again
                    
                    self.postWidget.dispatchHostEvent("show-dock", "");
                    
                    // Disable our UI
                    
                    UI.hide();
                    
                    self.inPost = true;
                    
                    self.shutdownChildWidget( false );
                }
                
                // Otherwise, it is the end of the first run of the OOBE
                
                else 
                {
                    // No TOS, no more
                    
                    if (!result.tos || !result.privacy) 
                    {
                        log("WAITING TO LAUNCH OOBE AGAIN");
                        UI.focus();
                        UI.hide();
                        UI.attachKeyHandler(self.keyDown);
                        self.OOBEHidden = true;
                        widget.onVisibilityChanged = self.onVisibilityChanged;
                        
                        system.tvState = Boot.TV_STATE_HIDE;
                        
                        widget.visible = false;
                        
                        return;
                    }
                    
                    
                    // Set the variable that tells us the oobe is done. This keeps us
                    // from showing it again next time.
                    
                    currentAppConfig.set("oobe-completed", "true");
                    
                    self.oobeCompleted = true;
	
					self.shutdownChildWidget( false );
					                    
                    self.loadPostWidget();
                }
            }
        }
        
        // It came from our post widget
        
        else if (event.id == Settings.postWidgetId) 
        {
            if (event.subject == "guidedSetup" || event.subject == "guided-setup") 
            {
                // Load the OOBE in replay mode
                //                UI.enabled = true;
                
                self.inPost = false;
                
                self.loadOOBE("replay");
                
                // Tell the post widget to hide itself
                
                self.postWidget.dispatchHostEvent("hide-all", JSON.stringify( true ) );
            }
            else if ( event.subject == "disablelanguagechange" )
            {
                // The post widget wants us to disable language change handling
 
                log( "DISABLING MENU LANGUAGE CHANGE EVENTS" );
                   
                self.attachOnMenuLanguageChanged( null );
                
            }
        }
    },
    
    startFutureGalleryUpdate: function()
    {
        if (Settings.galleryInterval == 0) 
        {
            log("GALLERY UPDATES ARE DISABLED [bootstrap.gallery-interval-sec=0]");
            return;
        }
	
        if ( self.offlineMode )
        {
            log( "WE ARE IN OFFLINE MODE, NO GALLERY UPDATES" );
            return;
        }
        
        // Kick off a gallery update to take place in the future
        
        var interval = Settings.galleryInterval;
        
        if (!self.galleryTimer) 
        {
            self.galleryTimer = new Timer();
            self.galleryTimer.onTimerFired = self.onFutureGalleryUpdate;
        }
        else
        {
            // We only use the second interval when we have not had a chat
            // with the gallery. Otherwise, we keep using the first interval
            
            if ( currentAppConfig.get( "last-gallery-time" ) != null )
            {
                interval = Settings.secondGalleryInterval;
            }
        }

		if (!self.galleryTimer.ticking) 
		{
            self.galleryTimer.interval = interval;
        
			log("NEXT GALLERY UPDATE WILL HAPPEN IN " + String(interval / 60) + " MINUTES");
			
			self.galleryTimer.ticking = true;
		}
    },
    
    onFutureGalleryUpdate: function()
    {
        log("STARTING GALLERY UPDATE");
        
        // Stop the timer
        
        self.galleryTimer.ticking = false;
        
        // Make sure the UI is disabled
        
        UI.enabled = false;
        
        // Make sure first run is off
        
        self.firstRun = false;
        
        // Make sure we set future updates
        
        self.futureUpdate = true;
        
        // And we clear the builtins flag
        
        self.builtinsOK = true;
        
        // Now, do it
        
        self.downloadUpdatesFromGallery(false, self.afterFutureGalleryUpdate);
    },
    
    afterFutureGalleryUpdate: function()
    {
        log("FINISHED GALLERY UPDATE");
        log("THERE ARE " + String(widgets.getPendingInstallCount()) + " PENDING INSTALLS");
        
        self.startFutureGalleryUpdate();
        
        UI.enabled = true;
    },
};


//-------------------------------------------------------------------------
// GO!


try 
{
    Boot.start();
} 
catch (e) 
{
	log( "Unexpected exception!", e.toString() );
    // TODO : What should we do?
}
