/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertificateFactory;
import java.util.Date;
import javax.security.cert.Certificate;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509CertBridge;

public abstract class X509Certificate
extends Certificate {
    public static final X509Certificate getInstance(byte[] encoded) throws CertificateException {
        if (encoded == null) {
            throw new CertificateException("empty encoded value");
        }
        return X509Certificate.getInstance(new ByteArrayInputStream(encoded));
    }

    public static final X509Certificate getInstance(InputStream encoded) throws CertificateException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return new X509CertBridge((java.security.cert.X509Certificate)cf.generateCertificate(encoded));
        }
        catch (java.security.cert.CertificateException ce) {
            throw new CertificateException(ce.getMessage());
        }
    }

    public abstract void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract void checkValidity(Date var1) throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract int getVersion();

    public abstract BigInteger getSerialNumber();

    public abstract Principal getIssuerDN();

    public abstract Principal getSubjectDN();

    public abstract Date getNotBefore();

    public abstract Date getNotAfter();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();
}

