/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.Context;
import btworks.jsse.provider.Trace;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLSocketFactory
extends SocketFactory {
    static final boolean dev = BtworksJSSE.DEBUG_JAVAX;
    private static SSLContext context;

    public static synchronized SocketFactory getDefault() {
        block23: {
            try {
                String s;
                if (dev) {
                    Trace.a("SocketFactory()", "INIT_COUNT");
                }
                if ((s = Security.getProperty("ssl.SocketFactory.provider")) != null) {
                    if (dev) {
                        Trace.a("SocketFactory().getDefault", "try to load " + s);
                    }
                    ClassLoader cl = ClassLoader.getSystemClassLoader();
                    if (s != null && cl != null) {
                        if (dev) {
                            Trace.a("SocketFactory().getDefault", "load 'btworks.jsse.provider.SSLSocketFactory' ok");
                        }
                        return (SocketFactory)cl.loadClass(s).newInstance();
                    }
                }
            }
            catch (Exception e) {
                if (!dev) break block23;
                Trace.a("SocketFactory().getDefault", "load 'btworks.jsse.provider.SSLSocketFactory' fail: " + e);
            }
        }
        if (context == null) {
            TrustManager[] tm;
            KeyManager[] km;
            block25: {
                String tmAlg;
                block24: {
                    if (dev) {
                        Trace.a("SocketFactory().getDefault", "context is null..");
                    }
                    km = null;
                    tm = null;
                    String kmAlg = KeyManagerFactory.getDefaultAlgorithm();
                    tmAlg = TrustManagerFactory.getDefaultAlgorithm();
                    if (dev) {
                        Trace.a("SocketFactory().getDefault", "kmAlg[" + kmAlg + "] tmAlg[" + tmAlg + "]");
                    }
                    try {
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(kmAlg);
                        kmf.init(null, null);
                        km = kmf.getKeyManagers();
                    }
                    catch (Exception ex) {
                        if (!dev) break block24;
                        Trace.a("SocketFactory().getDefault", "getKeyManager fail: " + ex);
                    }
                }
                try {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmAlg);
                    tmf.init((KeyStore)null);
                    tm = tmf.getTrustManagers();
                }
                catch (Exception ex) {
                    if (!dev) break block25;
                    Trace.a("SocketFactory().getDefault", "getTrustManager fail: " + ex);
                }
            }
            try {
                if (dev) {
                    Trace.a("SocketFactory().getDefault", "trying to int context..");
                }
                context = new SSLContext(new Context(), Security.getProvider("BtworksJSSE"), "TLSv1");
                if (dev) {
                    Trace.a("SocketFactory().getDefault", context.getClass().toString());
                }
                context.init(km, tm, null);
                if (dev) {
                    Trace.a("SocketFactory().getDefault", "context init ok");
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("error instantiating default socket factory: " + ex.toString());
            }
        }
        try {
            SSLSocketFactory sf = context.getSocketFactory();
            if (dev) {
                Trace.a("SocketFactory().getDefault", "SSLSocketFactory instance: " + sf);
                String[] temp = sf.getSupportedCipherSuites();
                int i = 0;
                while (i < temp.length) {
                    Trace.a("SocketFactory().getDefault", "suported cipher suite[" + i + "]: " + temp[i]);
                    ++i;
                }
            }
            return sf;
        }
        catch (Exception exception) {
            throw new RuntimeException("no SSLSocketFactory implementation available");
        }
    }

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();
}

