/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.cert.Certificate;
import java.util.EventObject;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;

public class HandshakeCompletedEvent
extends EventObject {
    private static final long serialVersionUID = 7914963744257769778L;
    private final transient SSLSession session;

    public HandshakeCompletedEvent(SSLSocket socket, SSLSession session) {
        super(socket);
        if (session == null) {
            throw new NullPointerException();
        }
        this.session = session;
    }

    public String getCipherSuite() {
        if (this.session != null) {
            return this.session.getCipherSuite();
        }
        return null;
    }

    public Certificate[] getLocalCertificates() {
        if (this.session != null) {
            return this.session.getLocalCertificates();
        }
        return null;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.session != null) {
            return this.session.getPeerCertificates();
        }
        return null;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.session != null) {
            return this.session.getPeerCertificateChain();
        }
        return null;
    }

    public SSLSession getSession() {
        return this.session;
    }

    public SSLSocket getSocket() {
        return (SSLSocket)this.getSource();
    }
}

