/*
 * Decompiled with CFR 0.152.
 */
package javax.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Security;
import javax.net.VanillaSocketFactory;

public abstract class SocketFactory {
    protected SocketFactory() {
    }

    public static synchronized SocketFactory getDefault() {
        try {
            String s = Security.getProperty("gnu.defaultSocketFactory");
            if (s != null) {
                Class<?> c = Class.forName(s);
                return (SocketFactory)c.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new VanillaSocketFactory();
    }

    public Socket createSocket() throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract Socket createSocket(String var1, int var2) throws IOException, UnknownHostException;

    public abstract Socket createSocket(String var1, int var2, InetAddress var3, int var4) throws IOException, UnknownHostException;

    public abstract Socket createSocket(InetAddress var1, int var2) throws IOException;

    public abstract Socket createSocket(InetAddress var1, int var2, InetAddress var3, int var4) throws IOException;
}

