/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.crypto.hash.BtwMessageDigest;
import btworks.crypto.hash.HashFactory;
import btworks.crypto.sig.rsa.RSA;
import btworks.jsse.NullManagerParameters;
import btworks.jsse.StaticTrustAnchors;
import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.RSAPublicKeyImpl;
import btworks.jsse.provider.Trace;
import btworks.jsse.provider.Util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

public class X509TrustManagerFactory
extends TrustManagerFactorySpi {
    private static final String JSSE_CERTS = String.valueOf(Util.getProperty("java.home")) + Util.getProperty("file.separator") + "lib" + Util.getProperty("file.separator") + "security" + Util.getProperty("file.separator") + "cacerts";
    private Manager current;
    static final boolean dev = BtworksJSSE.DEBUG_X509TrustManagerFactory;

    protected TrustManager[] engineGetTrustManagers() {
        if (this.current == null) {
            throw new IllegalStateException("not initialized");
        }
        return new TrustManager[]{this.current};
    }

    protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        if (params instanceof StaticTrustAnchors) {
            if (dev) {
                Trace.a("TrustManager.init", "Static Trust Anchors");
            }
            this.current = new Manager(((StaticTrustAnchors)params).getCertificates());
            try {
                LinkedList<Certificate> l = new LinkedList<Certificate>();
                KeyStore certStore = null;
                Enumeration<String> aliases = certStore.aliases();
                if (certStore != null) {
                    aliases = certStore.aliases();
                    if (dev) {
                        Trace.a("TrustManager.init()", "INIT_COUNT");
                    }
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        Certificate c = certStore.getCertificate(alias);
                        if (!(c instanceof X509Certificate)) {
                            if (!dev) continue;
                            Trace.a("TrustManager.init()", "alias." + alias + " skipped");
                            continue;
                        }
                        l.add(c);
                        if (!dev) continue;
                        Trace.a("TrustManager.init()", "alias." + alias + " added");
                    }
                }
                X509TrustManagerFactory x509TrustManagerFactory = this;
                x509TrustManagerFactory.getClass();
                this.current = x509TrustManagerFactory.new Manager(l.toArray(new X509Certificate[l.size()]));
            }
            catch (Exception e) {
                this.current = new Manager(((StaticTrustAnchors)params).getCertificates());
            }
        } else if (params instanceof NullManagerParameters) {
            this.current = new Manager(new X509Certificate[0]);
        } else {
            throw new InvalidAlgorithmParameterException();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void engineInit(KeyStore store) throws KeyStoreException {
        l = new LinkedList<Certificate>();
        certStore = null;
        aliases = null;
        if (store == null) {
            if (X509TrustManagerFactory.dev) {
                Trace.a("TrustManager.init", "store param is null");
            }
            if ((s = Util.getProperty("javax.net.ssl.trustStoreType")) == null) {
                s = KeyStore.getDefaultType();
            }
            store = KeyStore.getInstance(s);
            try {
                s = Util.getProperty("javax.net.ssl.trustStore");
                if (X509TrustManagerFactory.dev) {
                    Trace.a("TrustManager.init", "trustStore: " + s);
                }
                in = null;
                if (s != null) {
                    ss = s;
                    in = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws FileNotFoundException {
                            return new FileInputStream(ss);
                        }
                    });
                    p = Util.getProperty("javax.net.ssl.trustStorePassword");
                    store.load(in, p != null ? p.toCharArray() : null);
                    if (!X509TrustManagerFactory.dev) ** GOTO lbl46
                    Trace.a("TrustManager.init", "trustStore load success..");
                }
                store.load(null, null);
                if (!X509TrustManagerFactory.dev) ** GOTO lbl46
                Trace.a("TrustManager.init", "prepare empty trustStore..");
            }
            catch (PrivilegedActionException pae) {
                throw new KeyStoreException(pae.toString());
            }
            catch (IOException ioe) {
                throw new KeyStoreException(ioe.toString());
            }
            catch (CertificateException ce) {
                throw new KeyStoreException(ce.toString());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new KeyStoreException(nsae.toString());
            }
        } else {
            try {
                store.load(null, null);
                if (X509TrustManagerFactory.dev) {
                    Trace.a("TrustManager.init", "initialize store ..");
                }
            }
            catch (IOException ioe) {
                throw new KeyStoreException(ioe.toString());
            }
            catch (CertificateException ce) {
                throw new KeyStoreException(ce.toString());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new KeyStoreException(nsae.toString());
            }
        }
lbl46:
        // 5 sources

        if (store != null) {
            aliases = store.aliases();
            if (X509TrustManagerFactory.dev) {
                Trace.a("TrustManager.init()", "INIT_COUNT");
            }
            while (aliases.hasMoreElements()) {
                alias = aliases.nextElement();
                c = store.getCertificate(alias);
                if (!(c instanceof X509Certificate)) {
                    if (!X509TrustManagerFactory.dev) continue;
                    Trace.a("TrustManager.init()", "alias." + alias + " skipped");
                    continue;
                }
                l.add(c);
                if (!X509TrustManagerFactory.dev) continue;
                Trace.a("TrustManager.init()", "alias." + alias + " added");
            }
        }
        v0 = this;
        v0.getClass();
        this.current = v0.new Manager(l.toArray(new X509Certificate[l.size()]));
        if (X509TrustManagerFactory.dev) {
            Trace.a("TrustManager.init()", String.valueOf(l.size()) + " certs loaded");
        }
    }

    public void doVerify(BtwMessageDigest md, byte[] tbs, PublicKey pubkey, byte[] signature) {
        md.update(tbs, 0, tbs.length);
        byte[] d1 = md.digest();
        BigInteger EM = new BigInteger(1, signature);
        BigInteger EB = RSA.verify(pubkey, EM);
        int i = 0;
        byte[] eb = EB.toByteArray();
        if (eb[0] == 0) {
            i = 1;
            while (i < eb.length && eb[i] == 0) {
                ++i;
            }
        } else if (eb[0] == 1) {
            i = 1;
            while (i < eb.length && eb[i] != 0) {
                if (eb[i] != -1) {
                    throw new IllegalArgumentException("[TrustManger.doVerify] bad padding");
                }
                ++i;
            }
            ++i;
        } else {
            throw new IllegalArgumentException("[TrustManger.doVerify] decryption failed");
        }
        byte[] d2 = new byte[md.hashSize()];
        System.arraycopy(eb, eb.length - d2.length, d2, 0, d2.length);
        if (!Arrays.equals(d1, d2)) {
            throw new IllegalArgumentException("[TrustManger.doVerify] signature verification failed");
        }
    }

    private class Manager
    implements X509TrustManager {
        private X509Certificate[] trusted;
        private X509Certificate[] initialTrusted;

        Manager(X509Certificate[] trusted) {
            this.initialTrusted = trusted;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrusted(chain, authType);
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.checkTrusted(chain, authType);
        }

        public X509Certificate[] getAcceptedIssuers() {
            if (this.trusted == null) {
                this.trusted = this.initialTrusted;
            }
            if (this.trusted == null) {
                return new X509Certificate[0];
            }
            return (X509Certificate[])this.trusted.clone();
        }

        private void checkTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            String sigAlg;
            PublicKey pubkey;
            block68: {
                if (dev) {
                    Trace.a("TrustManager.checkTrusted()", "INIT_COUNT");
                }
                this.trusted = this.initialTrusted;
                boolean certAuth = true;
                String mwIFClassName = Util.getProperty("JSSE.TLSTrustManager");
                try {
                    Class<?> tlsManager = null;
                    if (mwIFClassName != null) {
                        tlsManager = Class.forName(mwIFClassName);
                        Method casa = tlsManager.getDeclaredMethod("getServerCertTrustFlag", null);
                        certAuth = (Boolean)casa.invoke(null, null);
                        if (certAuth) {
                            if (dev) {
                                Trace.a("TrustManager.checkTrusted()", " ----- re-initialize Trusted Certificates List " + certAuth);
                            }
                            LinkedList<Certificate> l = new LinkedList<Certificate>();
                            KeyStore certStore = null;
                            casa = tlsManager.getDeclaredMethod("getTrustedCertificates", null);
                            certStore = (KeyStore)casa.invoke(null, null);
                            Enumeration<String> aliases = null;
                            if (certStore != null) {
                                aliases = certStore.aliases();
                                while (aliases.hasMoreElements()) {
                                    String alias = aliases.nextElement();
                                    Certificate c = certStore.getCertificate(alias);
                                    if (!(c instanceof X509Certificate)) {
                                        if (!dev) continue;
                                        Trace.a("TrustManager.checkTrusted()", "alias." + alias + " skipped");
                                        continue;
                                    }
                                    l.add(c);
                                    if (!dev) continue;
                                    Trace.a("TrustManager.checkTrusted()", "alias." + alias + " added");
                                }
                            }
                            if (this.initialTrusted != null) {
                                int i = 0;
                                while (i < this.initialTrusted.length) {
                                    if (dev) {
                                        Trace.a("TrustManager.checkTrusted()", "initial trusted alias." + this.initialTrusted[i].getSubjectDN().toString() + " added");
                                    }
                                    l.add(this.initialTrusted[i]);
                                    ++i;
                                }
                            }
                            this.trusted = l.toArray(new X509Certificate[l.size()]);
                        } else {
                            if (dev) {
                                Trace.a("TrustManager.checkTrusted()", " ----- [checkTrusted] " + certAuth);
                            }
                            if (!certAuth) {
                                return;
                            }
                        }
                    }
                }
                catch (Exception e1) {
                    if (!dev) break block68;
                    Trace.a("TrustManager.checkTrusted()", "Fail to fetch " + mwIFClassName + ".getTrustedCertificated: " + e1.getMessage());
                }
            }
            if (chain == null) {
                throw new CertificateException("chain is null");
            }
            if (chain.length == 0) {
                throw new CertificateException("chain's length is 0");
            }
            if (dev) {
                Trace.a("TrustManager.check()", "INIT_COUNT");
            }
            if (dev) {
                Trace.a("TrustManager.check()", "checkTrusted start.. (" + authType + ")");
            }
            if (dev) {
                Trace.a("TrustManager.check()", "chain[0] : " + chain[0].getSubjectDN());
            }
            chain[0].checkValidity();
            if (dev) {
                Trace.a("TrustManager.check()", "chain[0] check validity.. ok");
            }
            int i = 1;
            while (i < chain.length) {
                if (dev) {
                    Trace.a("TrustManager.check()", "chain[" + i + "] : " + chain[i].getSubjectDN());
                }
                chain[i].checkValidity();
                if (dev) {
                    Trace.a("TrustManager.check()", "chain[" + i + "] check validity.. ok");
                }
                try {
                    block69: {
                        PublicKey pKey = chain[i].getPublicKey();
                        if (dev) {
                            Trace.a("TrustManager.check()", "get chain[" + i + "] pubkey : " + pKey.getClass().getName());
                        }
                        if (dev) {
                            Trace.a("TrustManager.check()", "chain[" + (i - 1) + "] sigAlg : " + chain[i - 1].getSigAlgName());
                        }
                        PublicKey prePubkey = chain[i].getPublicKey();
                        pubkey = null;
                        try {
                            pubkey = (RSAPublicKey)pKey;
                        }
                        catch (Exception e) {
                            if (dev) {
                                Trace.a("TrustManager.check()", "chain[" + i + "].pubkey not instanceof RSAPublicKey !!");
                            }
                            pubkey = new RSAPublicKeyImpl(pKey);
                            if (!dev) break block69;
                            Trace.a("TrustManager.check()", "impl RSAPublicKey.. ok");
                        }
                    }
                    sigAlg = chain[i - 1].getSigAlgName();
                    sigAlg = sigAlg.toUpperCase();
                    if (sigAlg.equals("MD5WITHRSA")) {
                        X509TrustManagerFactory.this.doVerify(HashFactory.getInstance("MD5"), chain[i - 1].getTBSCertificate(), pubkey, chain[i - 1].getSignature());
                    } else if (sigAlg.equals("SHA1WITHRSA")) {
                        X509TrustManagerFactory.this.doVerify(HashFactory.getInstance("SHA1"), chain[i - 1].getTBSCertificate(), pubkey, chain[i - 1].getSignature());
                    } else if (sigAlg.equals("MD2WITHRSA")) {
                        X509TrustManagerFactory.this.doVerify(HashFactory.getInstance("MD2"), chain[i - 1].getTBSCertificate(), pubkey, chain[i - 1].getSignature());
                    } else {
                        chain[i - 1].verify(pubkey);
                    }
                    if (dev) {
                        Trace.a("TrustManager.check()", "chain[" + (i - 1) + "] verify.. ok");
                    }
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new CertificateException(nsae.toString());
                }
                catch (NoSuchProviderException nspe) {
                    throw new CertificateException(nspe.toString());
                }
                catch (InvalidKeyException ike) {
                    throw new CertificateException(ike.toString());
                }
                catch (SignatureException se) {
                    throw new CertificateException(se.toString());
                }
                ++i;
            }
            if (this.trusted == null || this.trusted.length == 0) {
                throw new CertificateException("no trust anchors");
            }
            Principal pc = chain[chain.length - 1].getIssuerDN();
            if (dev) {
                Trace.a("TrustManager.check()", "pc issuer: " + pc.toString());
            }
            boolean findTrust = false;
            int i2 = 0;
            while (i2 < this.trusted.length) {
                block70: {
                    if (dev) {
                        Trace.a("TrustManager.check()", "trusted[" + i2 + "] dn: " + this.trusted[i2].getSubjectDN());
                    }
                    try {
                        if (pc.equals(this.trusted[i2].getSubjectDN())) {
                            findTrust = true;
                            if (dev) {
                                Trace.a("TrustManager.check()", "trusted[" + i2 + "] searched : " + this.trusted[i2].getSubjectDN());
                            }
                            if (dev) {
                                Trace.a("TrustManager.check()", "chain[" + (chain.length - 1) + "] sigAlg : " + chain[chain.length - 1].getSigAlgName());
                            }
                            if (!((pubkey = this.trusted[i2].getPublicKey()) instanceof RSAPublicKey)) {
                                if (dev) {
                                    Trace.a("TrustManager.check()", "trusted[" + i2 + "].pubkey not instanceof RSAPublicKey !");
                                }
                                pubkey = new RSAPublicKeyImpl(pubkey);
                                if (dev) {
                                    Trace.a("TrustManager.check()", "impl RSAPublicKey.. ok");
                                }
                            }
                            sigAlg = chain[chain.length - 1].getSigAlgName();
                            if (dev) {
                                Trace.a("TrustManager.check()", " pubkey: " + btworks.crypto.util.Util.dumpString(pubkey.getEncoded()));
                            }
                            if (dev) {
                                Trace.a("TrustManager.check()", " pubkey modulus: " + btworks.crypto.util.Util.dumpString(((RSAPublicKey)pubkey).getModulus().toByteArray()));
                            }
                            if (dev) {
                                Trace.a("TrustManager.check()", " signature: " + btworks.crypto.util.Util.dumpString(chain[chain.length - 1].getSignature()));
                            }
                            if (dev) {
                                Trace.a("TrustManager.check()", " trusted root -------------------------------");
                            }
                            if (dev) {
                                Trace.a("TrustManager.check()", this.trusted[i2].toString());
                            }
                            if (dev) {
                                Trace.a("TrustManager.check()", " chain root -------------------------------");
                            }
                            if (dev) {
                                Trace.a("TrustManager.check()", chain[chain.length - 1].toString());
                            }
                            if ((sigAlg = sigAlg.toUpperCase()).equals("MD5WITHRSA")) {
                                X509TrustManagerFactory.this.doVerify(HashFactory.getInstance("MD5"), chain[chain.length - 1].getTBSCertificate(), pubkey, chain[chain.length - 1].getSignature());
                            } else if (sigAlg.equals("SHA1WITHRSA")) {
                                X509TrustManagerFactory.this.doVerify(HashFactory.getInstance("SHA1"), chain[chain.length - 1].getTBSCertificate(), pubkey, chain[chain.length - 1].getSignature());
                            } else if (sigAlg.equals("MD2WITHRSA")) {
                                X509TrustManagerFactory.this.doVerify(HashFactory.getInstance("MD2"), chain[chain.length - 1].getTBSCertificate(), pubkey, chain[chain.length - 1].getSignature());
                            } else {
                                chain[chain.length - 1].verify(pubkey);
                            }
                            if (dev) {
                                Trace.a("TrustManager.check()", "chain[" + (chain.length - 1) + "] verify.. ok");
                            }
                            return;
                        }
                    }
                    catch (Exception e) {
                        if (!dev) break block70;
                        e.printStackTrace();
                    }
                }
                ++i2;
            }
            if (dev && !findTrust) {
                Trace.a("TrustManager.check()", "trusted search.. failed");
            }
            throw new CertificateException();
        }
    }
}

