/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.NullManagerParameters;
import btworks.jsse.PrivateCredentials;
import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.Trace;
import btworks.jsse.provider.Util;
import btworks.jsse.provider.X500Principal;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;

public class X509KeyManagerFactory
extends KeyManagerFactorySpi {
    private static final boolean dev = BtworksJSSE.DEBUG_X509KeyManagerFactory;
    private Manager current;

    protected KeyManager[] engineGetKeyManagers() {
        return new KeyManager[]{this.current};
    }

    protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        if (params instanceof NullManagerParameters) {
            try {
                this.engineInit(null, null);
            }
            catch (Exception e) {
                this.current = new Manager(Collections.EMPTY_MAP, Collections.EMPTY_MAP);
            }
        } else if (params instanceof PrivateCredentials) {
            List chains = ((PrivateCredentials)params).getCertChains();
            List keys = ((PrivateCredentials)params).getPrivateKeys();
            int i = 0;
            HashMap certMap = new HashMap();
            HashMap keyMap = new HashMap();
            Iterator c = chains.iterator();
            Iterator k = keys.iterator();
            while (c.hasNext() && k.hasNext()) {
                certMap.put(String.valueOf(i), c.next());
                keyMap.put(String.valueOf(i), k.next());
                ++i;
            }
            this.current = new Manager(keyMap, certMap);
        } else {
            throw new InvalidAlgorithmParameterException();
        }
    }

    protected void engineInit(KeyStore store, char[] passwd) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (store == null) {
            String s;
            if (passwd == null) {
                this.current = new Manager(Collections.EMPTY_MAP, Collections.EMPTY_MAP);
            }
            if ((s = Util.getProperty("javax.net.ssl.keyStoreType")) == null) {
                s = KeyStore.getDefaultType();
            }
            store = KeyStore.getInstance(s);
            s = Util.getProperty("javax.net.ssl.keyStore");
            if (dev) {
                Trace.a("X509KeyManagerFactory.engineInit()", "javax.net.ssl.keyStore:" + s);
            }
            if (s == null) {
                return;
            }
            String p = Util.getProperty("javax.net.ssl.keyStorePassword");
            if (dev) {
                Trace.a("X509KeyManagerFactory.engineInit()", "javax.net.ssl.keyStorePassword:" + p);
            }
            passwd = p.toCharArray();
            try {
                store.load(new FileInputStream(s), p != null ? p.toCharArray() : null);
            }
            catch (IOException ioe) {
                throw new KeyStoreException(ioe.toString());
            }
            catch (CertificateException ce) {
                throw new KeyStoreException(ce.toString());
            }
        }
        HashMap<String, PrivateKey> p = new HashMap<String, PrivateKey>();
        HashMap<String, X509Certificate[]> c = new HashMap<String, X509Certificate[]>();
        Enumeration<String> aliases = store.aliases();
        String alias = null;
        boolean i = false;
        while (aliases.hasMoreElements()) {
            PrivateKey key;
            alias = aliases.nextElement();
            if (!store.isKeyEntry(alias)) continue;
            X509Certificate[] chain = new X509Certificate[]{};
            if (store.getCertificateChain(alias).length > 0 && store.getCertificateChain(alias)[0] instanceof X509Certificate) {
                chain = X509KeyManagerFactory.toX509Chain(store.getCertificateChain(alias));
            }
            if ((key = (PrivateKey)store.getKey(alias, passwd)) == null) {
                System.out.println("[X509KeyManagerFactory.engineInit] pri key is null");
            }
            p.put(alias, key);
            c.put(alias, chain);
        }
        X509KeyManagerFactory x509KeyManagerFactory = this;
        x509KeyManagerFactory.getClass();
        this.current = x509KeyManagerFactory.new Manager(p, c);
    }

    private static X509Certificate[] toX509Chain(Certificate[] chain) {
        X509Certificate[] _chain = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            _chain[i] = (X509Certificate)chain[i];
            ++i;
        }
        return _chain;
    }

    private class Manager
    implements X509KeyManager {
        private final Map privateKeys;
        private final Map certChains;

        Manager(Map privateKeys, Map certChains) {
            this.privateKeys = privateKeys;
            this.certChains = certChains;
        }

        public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
            if (keyTypes == null) {
                return null;
            }
            int i = 0;
            while (i < keyTypes.length) {
                String[] s = this.getClientAliases(keyTypes[i], issuers);
                if (s != null && s.length > 0) {
                    return s[0];
                }
                ++i;
            }
            return null;
        }

        public String[] getClientAliases(String keyType, Principal[] issuers) {
            if (keyType == null) {
                return null;
            }
            String[] s = this.getAliases(keyType, issuers);
            if (s.length == 0) {
                return null;
            }
            return s;
        }

        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            if (keyType == null) {
                return null;
            }
            String[] s = this.getServerAliases(keyType, issuers);
            if (s != null && s.length > 0) {
                return s[0];
            }
            return null;
        }

        public String[] getServerAliases(String keyType, Principal[] issuers) {
            if (keyType == null) {
                return null;
            }
            String[] s = this.getAliases(keyType, issuers);
            if (s.length == 0) {
                return null;
            }
            return s;
        }

        private String[] getAliases(String keyType, Principal[] issuers) {
            LinkedList<String> l = new LinkedList<String>();
            Iterator i = this.privateKeys.keySet().iterator();
            block6: while (i.hasNext()) {
                X509Certificate[] chain;
                String alias;
                block25: {
                    PrivateKey privKey;
                    alias = (String)i.next();
                    if (dev) {
                        Trace.a("X509KeyManagerFactory.getAlias()", "alias: " + alias);
                    }
                    chain = this.getCertificateChain(alias);
                    if (dev) {
                        Trace.a("X509KeyManagerFactory.getAlias()", "chain.length: " + chain.length);
                    }
                    if (chain.length == 0 || (privKey = this.getPrivateKey(alias)) == null) continue;
                    PublicKey pubKey = chain[0].getPublicKey();
                    if (dev) {
                        Trace.a("X509KeyManagerFactory.getAlias()", "keyType: " + keyType + "!");
                    }
                    if (dev) {
                        Trace.a("X509KeyManagerFactory.getAlias()", "pri key: " + privKey.getClass().getName());
                    }
                    if (dev) {
                        Trace.a("X509KeyManagerFactory.getAlias()", "pubkey: " + pubKey.getClass().getName());
                    }
                    if (keyType.equals("RSA") || keyType.equals("DHE_RSA") || keyType.equals("SRP_RSA") || keyType.equals("rsa_sign")) {
                        if (!privKey.getAlgorithm().equals("RSA") || !pubKey.getAlgorithm().equals("RSA")) {
                            if (!dev) continue;
                            Trace.a("X509KeyManagerFactory.getAlias()", "privKey or pubKey is not RSAKey.let's continue...");
                            continue;
                        }
                    } else {
                        PublicKey puk;
                        if (keyType.equals("DHE_DSS") || keyType.equals("dss_sign") || keyType.equals("SRP_DSS")) {
                            try {
                                DSAPrivateKey prk = (DSAPrivateKey)privKey;
                                puk = (DSAPublicKey)pubKey;
                                break block25;
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        if (keyType.equals("DH_RSA") || keyType.equals("rsa_fixed_dh")) {
                            try {
                                DHPrivateKey prk = (DHPrivateKey)privKey;
                                puk = (DHPublicKey)pubKey;
                            }
                            catch (Exception e) {
                                continue;
                            }
                            if (!chain[0].getSigAlgName().equalsIgnoreCase("RSA")) {
                                continue;
                            }
                        } else {
                            if (!keyType.equals("DH_DSS") && !keyType.equals("dss_fixed_dh")) continue;
                            try {
                                DHPrivateKey prk = (DHPrivateKey)privKey;
                                puk = (DHPublicKey)pubKey;
                            }
                            catch (Exception e) {
                                continue;
                            }
                            if (!chain[0].getSigAlgName().equalsIgnoreCase("DSA")) continue;
                        }
                    }
                }
                if (issuers == null || issuers.length == 0) {
                    l.add(alias);
                    continue;
                }
                int j = 0;
                while (j < issuers.length) {
                    if (dev) {
                        Trace.a("X509KeyManagerFactory.getAlias()", "issuers[" + j + "]: " + issuers[j].getName());
                    }
                    if (dev) {
                        Trace.a("X509KeyManagerFactory.getAlias()", "chain[0].getIssuerDN(): " + chain[0].getIssuerDN().getName());
                    }
                    X500Principal tmp = new X500Principal(chain[0].getIssuerDN().getName());
                    X500Principal tmp2 = new X500Principal(issuers[j].getName());
                    if (dev) {
                        Trace.a("X509KeyManagerFactory.getAlias()", "X500Principal parshing ok");
                    }
                    if (tmp.getName().equals(tmp2.getName())) {
                        l.add(alias);
                        if (!dev) continue block6;
                        Trace.a("X509KeyManagerFactory.getAlias()", "add cert: " + alias);
                        continue block6;
                    }
                    ++j;
                }
            }
            return l.toArray(new String[l.size()]);
        }

        public X509Certificate[] getCertificateChain(String alias) {
            X509Certificate[] c = (X509Certificate[])this.certChains.get(alias);
            return c != null ? (X509Certificate[])c.clone() : null;
        }

        public PrivateKey getPrivateKey(String alias) {
            return (PrivateKey)this.privateKeys.get(alias);
        }
    }
}

