/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.X500DistinguishedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;

public final class X500Principal
implements Principal,
Serializable {
    private static final long serialVersionUID = -500463348111345721L;
    public static final String CANONICAL = "CANONICAL";
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    private transient X500DistinguishedName name;

    public X500Principal(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = new X500DistinguishedName(name);
    }

    public X500Principal(byte[] encoded) {
        try {
            this.name = new X500DistinguishedName(encoded);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.toString());
        }
    }

    public X500Principal(InputStream encoded) {
        try {
            this.name = new X500DistinguishedName(encoded);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.toString());
        }
    }

    public boolean equals(Object o) {
        return ((X500Principal)o).name.equals(this.name);
    }

    public byte[] getEncoded() {
        return this.name.getEncoded();
    }

    public String getName() {
        return this.getName(RFC2253);
    }

    public String getName(String format) {
        if (format.equalsIgnoreCase(RFC2253)) {
            return this.name.toRFC2253();
        }
        if (format.equalsIgnoreCase(RFC1779)) {
            return this.name.toRFC1779();
        }
        if (format.equalsIgnoreCase(CANONICAL)) {
            return this.name.toCanonical();
        }
        throw new IllegalArgumentException("unsupported format " + format);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.name.getEncoded());
    }

    private void readObject(ObjectInputStream in) throws IOException, NotActiveException, ClassNotFoundException {
        byte[] buf = (byte[])in.readObject();
        this.name = new X500DistinguishedName(buf);
    }
}

