/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.Constructed;
import btworks.jsse.provider.DERReader;
import btworks.jsse.provider.DERValue;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Arrays;

class Signature
implements Constructed {
    private static final boolean dev = false;
    private final Object sigValue;
    private final String sigAlg;

    Signature(Object sigValue, String sigAlg) {
        this.sigValue = sigValue;
        this.sigAlg = sigAlg;
    }

    static Signature read(InputStream in, CipherSuite suite) throws IOException {
        Object[] sigValue = null;
        DataInputStream din = new DataInputStream(in);
        int len = din.readUnsignedShort();
        sigValue = new byte[len];
        din.readFully((byte[])sigValue);
        if (suite.getSignature() == "DSS") {
            DERReader der = new DERReader(new ByteArrayInputStream((byte[])sigValue));
            if (der.read().getTag() != 16) {
                throw new IOException("expecting DER SEQUENCE");
            }
            BigInteger r = (BigInteger)der.read().getValue();
            BigInteger s = (BigInteger)der.read().getValue();
            sigValue = new BigInteger[]{r, s};
        }
        return new Signature(sigValue, suite.getSignature());
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, ProtocolVersion.TLS_1);
    }

    public void write(OutputStream out, ProtocolVersion version) throws IOException {
        byte[] result = null;
        if (this.sigValue instanceof byte[]) {
            result = (byte[])this.sigValue;
        } else {
            DERValue r = new DERValue(2, ((BigInteger[])this.sigValue)[0]);
            DERValue s = new DERValue(2, ((BigInteger[])this.sigValue)[1]);
            DERValue sig = new DERValue(48, Arrays.asList(r, s));
            result = sig.getEncoded();
        }
        out.write(result.length >>> 8 & 0xFF);
        out.write(result.length & 0xFF);
        out.write(result);
    }

    Object getSigValue() {
        return this.sigValue;
    }

    String getSigAlg() {
        return this.sigAlg;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        if (this.sigAlg.equals("RSA")) {
            out.print(Util.hexDump((byte[])this.sigValue, "  "));
        } else {
            out.println("  r = " + ((BigInteger[])this.sigValue)[0].toString(16) + ";");
            out.println("  s = " + ((BigInteger[])this.sigValue)[1].toString(16) + ";");
        }
        out.println("} Signature;");
        return str.toString();
    }
}

