/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Session;
import btworks.jsse.provider.Util;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;

class SessionContext
implements SSLSessionContext {
    protected final HashMap sessions = new HashMap();
    protected int cacheSize = 0;
    protected int timeout;

    SessionContext() {
        try {
            this.timeout = Integer.parseInt(Util.getSecurityProperty("btworks.session.timeout"));
        }
        catch (Exception x) {
            this.timeout = 3600;
        }
    }

    public synchronized Enumeration getIds() {
        Vector<byte[]> ids = new Vector<byte[]>();
        Iterator i = this.sessions.keySet().iterator();
        while (i.hasNext()) {
            Session.ID id = (Session.ID)i.next();
            ids.add(id.getId());
        }
        return ids.elements();
    }

    public synchronized SSLSession getSession(byte[] sessionId) {
        Session session = (Session)this.sessions.get(new Session.ID(sessionId));
        if (session == null) {
            return null;
        }
        long elapsed = System.currentTimeMillis() - session.getLastAccessedTime();
        if ((int)(elapsed / 1000L) > this.timeout) {
            this.removeSession(session.sessionId);
            session.invalidate();
            return null;
        }
        if (!session.valid) {
            this.removeSession(session.sessionId);
            session.invalidate();
            return null;
        }
        return session;
    }

    public int getSessionCacheSize() {
        return this.cacheSize;
    }

    public void setSessionCacheSize(int cacheSize) {
        if (cacheSize < 0) {
            throw new IllegalArgumentException();
        }
        this.cacheSize = cacheSize;
    }

    public int getSessionTimeout() {
        return this.timeout;
    }

    public void setSessionTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = timeout;
    }

    public String toString() {
        return this.sessions.keySet().toString();
    }

    synchronized boolean addSession(Session.ID sessionId, Session session) {
        if (this.sessions.containsKey(sessionId)) {
            return false;
        }
        if (this.cacheSize > 0 && this.sessions.size() > this.cacheSize) {
            boolean removed = false;
            Iterator i = this.sessions.values().iterator();
            while (i.hasNext()) {
                Session s = (Session)i.next();
                long elapsed = System.currentTimeMillis() - s.getCreationTime();
                if (!s.valid) {
                    this.removeSession(session.sessionId);
                    removed = true;
                    continue;
                }
                if ((int)(elapsed / 1000L) <= this.timeout) continue;
                this.removeSession(session.sessionId);
                removed = true;
            }
            if (removed) {
                this.sessions.put(sessionId, session);
                session.context = this;
                session.sessionId = sessionId;
                return true;
            }
            return false;
        }
        this.sessions.put(sessionId, session);
        session.context = this;
        session.sessionId = sessionId;
        return true;
    }

    synchronized boolean containsSessionID(Session.ID sessionId) {
        Session s = (Session)this.sessions.get(sessionId);
        if (s == null) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - s.getCreationTime();
        if (!s.valid || (int)(elapsed / 1000L) > this.timeout) {
            this.removeSession(sessionId);
            return false;
        }
        return true;
    }

    synchronized boolean removeSession(Session.ID sessionId) {
        return this.sessions.remove(sessionId) != null;
    }

    void notifyAccess(Session session) {
    }
}

