/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.BtwRSAPublicKey;
import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.Handshake;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.Signature;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.net.ssl.SSLProtocolException;

class ServerKeyExchange
implements Handshake.Body {
    private PublicKey publicKey;
    private Signature signature;
    private byte[] srpSalt;

    ServerKeyExchange(PublicKey publicKey, Signature signature) {
        this(publicKey, signature, null);
    }

    ServerKeyExchange(PublicKey publicKey, Signature signature, byte[] srpSalt) {
        this.publicKey = publicKey;
        this.signature = signature;
        this.srpSalt = srpSalt;
    }

    static ServerKeyExchange read(InputStream in, CipherSuite suite) throws IOException {
        DataInputStream din = new DataInputStream(in);
        BtwRSAPublicKey key = null;
        byte[] salt = null;
        String kex = suite.getKeyExchange();
        if (!kex.equals("RSA")) {
            throw new SSLProtocolException("invalid kex algorithm");
        }
        byte[] buf = new byte[din.readUnsignedShort()];
        din.readFully(buf);
        BigInteger n = new BigInteger(1, buf);
        buf = new byte[din.readUnsignedShort()];
        din.readFully(buf);
        BigInteger e = new BigInteger(1, buf);
        key = new BtwRSAPublicKey(n, e);
        Signature sig = null;
        if (!suite.getSignature().equals("anon")) {
            sig = Signature.read(in, suite);
        }
        return new ServerKeyExchange(key, sig, salt);
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, ProtocolVersion.TLS_1);
    }

    public void write(OutputStream out, ProtocolVersion version) throws IOException {
        if (this.publicKey instanceof RSAPublicKey) {
            this.writeBigint(out, ((RSAPublicKey)this.publicKey).getModulus());
            this.writeBigint(out, ((RSAPublicKey)this.publicKey).getPublicExponent());
        }
        if (this.signature != null) {
            this.signature.write(out, version);
        }
    }

    PublicKey getPublicKey() {
        return this.publicKey;
    }

    Signature getSignature() {
        return this.signature;
    }

    byte[] getSRPSalt() {
        return this.srpSalt;
    }

    public String toString() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        out.println("  publicKey = struct {");
        if (this.publicKey instanceof RSAPublicKey) {
            out.println("    modulus = " + ((RSAPublicKey)this.publicKey).getModulus().toString(16) + ";");
            out.println("    exponent = " + ((RSAPublicKey)this.publicKey).getPublicExponent().toString(16) + ";");
            out.println("  } RSAPublicKey;");
        }
        if (this.signature != null) {
            out.println("  signature =");
            BufferedReader r = new BufferedReader(new StringReader(this.signature.toString()));
            try {
                String s;
                while ((s = r.readLine()) != null) {
                    out.print("    ");
                    out.println(s);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        out.println("} ServerKeyExchange;");
        return str.toString();
    }

    private void writeBigint(OutputStream out, BigInteger bigint) throws IOException {
        byte[] b = bigint.toByteArray();
        if (b[0] == 0) {
            out.write(b.length - 1 >>> 8 & 0xFF);
            out.write(b.length - 1 & 0xFF);
            out.write(b, 1, b.length - 1);
        } else {
            out.write(b.length >>> 8 & 0xFF);
            out.write(b.length & 0xFF);
            out.write(b);
        }
    }
}

