/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.CompressionMethod;
import btworks.jsse.provider.Extension;
import btworks.jsse.provider.Handshake;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.Random;
import btworks.jsse.provider.Util;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class ServerHello
implements Handshake.Body {
    private final ProtocolVersion version;
    private final Random random;
    private final byte[] sessionId;
    private final CipherSuite suite;
    private final CompressionMethod comp;
    private final List extensions;

    ServerHello(ProtocolVersion version, Random random, byte[] sessionId, CipherSuite suite, CompressionMethod comp) {
        this(version, random, sessionId, suite, comp, null);
    }

    ServerHello(ProtocolVersion version, Random random, byte[] sessionId, CipherSuite suite, CompressionMethod comp, List extensions) {
        this.version = version;
        this.random = random;
        this.sessionId = sessionId;
        this.suite = suite;
        this.comp = comp;
        this.extensions = extensions;
    }

    static ServerHello read(InputStream in) throws IOException {
        ProtocolVersion vers = ProtocolVersion.read(in);
        Random rand = Random.read(in);
        byte[] id = new byte[in.read() & 0xFF];
        in.read(id);
        CipherSuite suite = CipherSuite.read(in).resolve(vers);
        CompressionMethod comp = CompressionMethod.read(in);
        LinkedList<Extension> ext = null;
        if (in.available() > 0) {
            ext = new LinkedList<Extension>();
            int len = in.read() >>> 8 & 0xFF | in.read() & 0xFF;
            int count = 0;
            while (count < len) {
                Extension e = Extension.read(in);
                ext.add(e);
                count += e.getValue().length + 4;
            }
        }
        return new ServerHello(vers, rand, id, suite, comp, ext);
    }

    public void write(OutputStream out) throws IOException {
        this.version.write(out);
        this.random.write(out);
        out.write(this.sessionId.length);
        out.write(this.sessionId);
        this.suite.write(out);
        out.write(this.comp.getValue());
        if (this.extensions != null) {
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            Iterator i = this.extensions.iterator();
            while (i.hasNext()) {
                ((Extension)i.next()).write(out2);
            }
            out.write(out2.size() >>> 8 & 0xFF);
            out.write(out2.size() & 0xFF);
            out2.writeTo(out);
        }
    }

    ProtocolVersion getVersion() {
        return this.version;
    }

    Random getRandom() {
        return this.random;
    }

    byte[] getSessionId() {
        return (byte[])this.sessionId.clone();
    }

    CipherSuite getCipherSuite() {
        return this.suite;
    }

    CompressionMethod getCompressionMethod() {
        return this.comp;
    }

    List getExtensions() {
        return this.extensions;
    }

    public String toString() {
        String s;
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println("struct {");
        out.println("  version = " + this.version + ";");
        BufferedReader r = new BufferedReader(new StringReader(this.random.toString()));
        try {
            while ((s = r.readLine()) != null) {
                out.print("  ");
                out.println(s);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out.println("  sessionId = " + Util.toHexString(this.sessionId, ':') + ";");
        out.println("  cipherSuite = " + this.suite + ";");
        out.println("  compressionMethod = " + this.comp + ";");
        if (this.extensions != null) {
            out.println("  extensions = {");
            Iterator i = this.extensions.iterator();
            while (i.hasNext()) {
                r = new BufferedReader(new StringReader(i.next().toString()));
                try {
                    while ((s = r.readLine()) != null) {
                        out.print("    ");
                        out.println(s);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            out.println("  };");
        }
        out.println("} ServerHello;");
        return str.toString();
    }
}

