/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.Alert;
import btworks.jsse.provider.AlertException;
import btworks.jsse.provider.SSLSocket;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class SSLSocketInputStream
extends FilterInputStream {
    private static final boolean dev = false;
    private final SSLSocket socket;
    private final boolean checkHandshake;
    boolean closeNotified = false;

    SSLSocketInputStream(InputStream in, SSLSocket socket) {
        this(in, socket, true);
    }

    SSLSocketInputStream(InputStream in, SSLSocket socket, boolean checkHandshake) {
        super(in);
        this.socket = socket;
        this.checkHandshake = checkHandshake;
    }

    public int available() throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        int ret = 0;
        try {
            ret = super.available();
        }
        catch (AlertException ae) {
            Alert alert = ae.getAlert();
            if (alert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
                return -1;
            }
            throw ae;
        }
        return ret;
    }

    public int available2() throws IOException {
        return super.available();
    }

    public int read() throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        int ret = 0;
        try {
            ret = this.in.read();
        }
        catch (AlertException ae) {
            Alert alert = ae.getAlert();
            if (alert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
                return -1;
            }
            throw ae;
        }
        return ret;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.closeNotified) {
            return -1;
        }
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        if (buf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ret = 0;
        try {
            ret = this.in.read(buf, off, len);
        }
        catch (AlertException ae) {
            Alert alert = ae.getAlert();
            if (alert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
                this.closeNotified = true;
                return -1;
            }
            throw ae;
        }
        catch (EOFException e) {
            System.err.println("Can't read CLOSE_NOTIFY !");
            this.closeNotified = true;
            return -1;
        }
        return ret;
    }

    private boolean checkAlert() throws IOException {
        Alert alert = this.socket.checkAlert();
        if (alert == null) {
            return false;
        }
        if (alert.getLevel().equals(Alert.Level.FATAL)) {
            throw new AlertException(alert, false);
        }
        if (alert.getDescription().equals(Alert.Description.CLOSE_NOTIFY)) {
            try {
                return this.in.available() <= 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

