/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.SSLSocket;
import btworks.jsse.provider.SessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SSLSocketFactory
extends javax.net.ssl.SSLSocketFactory {
    private final X509TrustManager trustManager;
    private final X509KeyManager keyManager;
    private final SecureRandom random;
    private final SessionContext sessionContext;

    SSLSocketFactory(X509TrustManager trustManager, X509KeyManager keyManager, SecureRandom random, SessionContext sessionContext) {
        this.trustManager = trustManager;
        this.keyManager = keyManager;
        this.random = random;
        this.sessionContext = sessionContext;
    }

    public String[] getDefaultCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public String[] getSupportedCipherSuites() {
        return this.getDefaultCipherSuites();
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        if (!socket.isConnected()) {
            throw new SocketException("Underlying socket is not connected");
        }
        return this.setup(new SSLSocket(socket, host, port, autoClose));
    }

    public Socket createSocket() throws IOException {
        return this.setup(new SSLSocket());
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.setup(new SSLSocket(host, port));
    }

    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException, UnknownHostException {
        return this.setup(new SSLSocket(host, port, localAddr, localPort));
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return this.setup(new SSLSocket(address, port));
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        return this.setup(new SSLSocket(address, port, localAddr, localPort));
    }

    private SSLSocket setup(SSLSocket s) {
        s.setTrustManager(this.trustManager);
        s.setKeyManager(this.keyManager);
        s.setRandom(this.random);
        s.setSessionContext(this.sessionContext);
        s.setUseClientMode(true);
        return s;
    }
}

