/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.CipherSuite;
import btworks.jsse.provider.ProtocolVersion;
import btworks.jsse.provider.SSLSocket;
import btworks.jsse.provider.SessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class SSLServerSocket
extends javax.net.ssl.SSLServerSocket {
    private SessionContext sessions;
    private SortedSet enabledProtocols = new TreeSet(SSLSocket.supportedProtocols);
    private List enabledSuites = new ArrayList(SSLSocket.supportedSuites);
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;
    private boolean createSessions = true;
    private X509TrustManager trustManager;
    private X509KeyManager keyManager;
    private SecureRandom random;

    SSLServerSocket() throws IOException {
    }

    SSLServerSocket(int port) throws IOException {
        super(port);
    }

    SSLServerSocket(int port, int backlog) throws IOException {
        super(port, backlog);
    }

    SSLServerSocket(int port, int backlog, InetAddress address) throws IOException {
        super(port, backlog, address);
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEnabledCipherSuites() {
        List list = this.enabledSuites;
        synchronized (list) {
            String[] s = new String[this.enabledSuites.size()];
            int i = 0;
            Iterator it = this.enabledSuites.iterator();
            while (it.hasNext()) {
                s[i++] = it.next().toString();
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabledCipherSuites(String[] suites) {
        if (suites == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < suites.length) {
            if (CipherSuite.forName(suites[i]) == null) {
                throw new IllegalArgumentException("unsupported suite: " + suites[i]);
            }
            ++i;
        }
        List list = this.enabledSuites;
        synchronized (list) {
            this.enabledSuites.clear();
            int i2 = 0;
            while (i2 < suites.length) {
                CipherSuite suite = CipherSuite.forName(suites[i2]);
                if (!this.enabledSuites.contains(suite)) {
                    this.enabledSuites.add(suite);
                }
                ++i2;
            }
        }
    }

    public String[] getSupportedProtocols() {
        return new String[]{"SSLv3", "TLSv1"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEnabledProtocols() {
        SortedSet sortedSet = this.enabledProtocols;
        synchronized (sortedSet) {
            String[] s = new String[this.enabledProtocols.size()];
            int i = 0;
            Iterator it = this.enabledProtocols.iterator();
            while (it.hasNext()) {
                s[i++] = it.next().toString();
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < protocols.length) {
            if (!(protocols[i] == null || protocols[i].equalsIgnoreCase("SSLv3") || protocols[i].equalsIgnoreCase("TLSv1") || protocols[i].equalsIgnoreCase("TLSv1.1"))) {
                throw new IllegalArgumentException("unsupported protocol: " + protocols[i]);
            }
            ++i;
        }
        SortedSet sortedSet = this.enabledProtocols;
        synchronized (sortedSet) {
            this.enabledProtocols.clear();
            int i2 = 0;
            while (i2 < protocols.length) {
                if (protocols[i2].equalsIgnoreCase("SSLv3")) {
                    this.enabledProtocols.add(ProtocolVersion.SSL_3);
                } else if (protocols[i2].equalsIgnoreCase("TLSv1")) {
                    this.enabledProtocols.add(ProtocolVersion.TLS_1);
                } else {
                    this.enabledProtocols.add(ProtocolVersion.TLS_1_1);
                }
                ++i2;
            }
        }
    }

    public void setUseClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean getUseClientMode() {
        return this.clientMode;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setEnableSessionCreation(boolean createSessions) {
        this.createSessions = createSessions;
    }

    public boolean getEnableSessionCreation() {
        return this.createSessions;
    }

    public Socket accept() throws IOException {
        SSLSocket socket = new SSLSocket();
        this.implAccept(socket);
        socket.setUseClientMode(this.clientMode);
        socket.setNeedClientAuth(this.needClientAuth);
        socket.setWantClientAuth(this.wantClientAuth);
        socket.setEnableSessionCreation(this.createSessions);
        socket.setSessionContext(this.sessions);
        socket.setEnabledCipherSuites(new ArrayList(this.enabledSuites));
        socket.setEnabledProtocols(new TreeSet(this.enabledProtocols));
        socket.setTrustManager(this.trustManager);
        socket.setKeyManager(this.keyManager);
        socket.setRandom(this.random);
        return socket;
    }

    void setSessionContext(SessionContext sessions) {
        this.sessions = sessions;
    }

    void setKeyManager(X509KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    void setTrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    void setRandom(SecureRandom random) {
        this.random = random;
    }
}

