/*
 * Decompiled with CFR 0.152.
 */
package btworks.jsse.provider;

import btworks.jsse.provider.BtworksJSSE;
import btworks.jsse.provider.ContentType;
import btworks.jsse.provider.SecurityParameters;
import btworks.jsse.provider.Util;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

class RecordOutputStream
extends FilterOutputStream {
    private static final boolean DEBUG_RECORD_LAYER = BtworksJSSE.DEBUG_RecordOutputStream_record;
    private static final boolean dev = BtworksJSSE.DEBUG_RecordOutputStream;
    private static final PrintWriter debug = new PrintWriter(System.err, true);
    private final ContentType type;
    private final SecurityParameters params;
    private static final boolean emitEmpty = false;
    private static final byte[] ZERO = new byte[0];

    RecordOutputStream(OutputStream out, ContentType type, SecurityParameters params) {
        super(out);
        this.type = type;
        this.params = params;
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException("size=" + buf.length + " off=" + off + " len=" + len);
        }
        int count = 0;
        int len2 = 0;
        do {
            len2 = Math.min(len - count, this.params.fragmentLength);
            if (DEBUG_RECORD_LAYER) {
                debug.println("writing chunk size=" + len2);
            }
            OutputStream outputStream = this.out;
            synchronized (outputStream) {
                byte[] fragment = this.params.encrypt(buf, off + count, len2, this.type);
                if (DEBUG_RECORD_LAYER) {
                    debug.println(">> WRITING RECORD <<");
                    debug.println("struct {");
                    debug.println("  type = " + this.type);
                    debug.println("  version = " + this.params.version);
                    debug.println("  length = " + fragment.length);
                    debug.print(Util.hexDump(fragment, "  "));
                    debug.println("} TLSCiphertext;");
                }
                byte[] header = new byte[5 + fragment.length];
                header[0] = (byte)this.type.getValue();
                header[1] = (byte)this.params.version.getMajor();
                header[2] = (byte)this.params.version.getMinor();
                if (dev) {
                    System.out.println("fragment.length: " + fragment.length);
                }
                header[3] = (byte)(fragment.length >>> 8);
                header[4] = (byte)((byte)fragment.length & 0xFF);
                System.arraycopy(fragment, 0, header, 5, fragment.length);
                if (dev) {
                    System.out.println("Networks Output: \n" + Util.hexDump(header, " "));
                }
                this.out.write(header);
                if (dev) {
                    System.out.println("out class: " + this.out.getClass().getName());
                }
            }
        } while ((count += len2) < len);
    }
}

